;****************************************************************************************
;*   This file is the firmware to implement 
;*	2 timers, which on expiration can trigger 16 different single event routines
;*      furthermore the possibility of insertion of code into periodic routines 
;*	which occur every 64 microseconds, 8 milliseconds, 2 seconds and 16 seconds
;*
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    MICROCHIP OS                               		                *
;*    Date:         December, 2015                                   			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:                                  			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   m0-4.asm (macros)                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=10F206	; list directive to define processor
	#include  ..\m0-4.asm
	config_
 	
#define	OPTIONinit	b'11001111'	; no wakup, no pullup, Clock 1:1
#define TRISIOinit 	b'00001001'	; 0 input, 1,2 output	
#define GPIOinit 	b'00000000'	; GPIO  all LOW 
;****************************************************************************************

	init_			; reasonable initiation of special function registers 


	cblock	_MINRAM			; start of variables
	 SyS1,AlarmCount
	endc
#define STACK		_MAXRAM
#define	Lo_Side		SyS1,1
#define	TMR07Bit	SyS1,7
	

;PWRUP	
		eq	SyS1,0
	    eq_ AlarmCount,=,.1,lit8

TC0used = 3							; use 3 bytes of timer for TC0
	cblock
	 TC0:TC0used
	 NmbrEvent0
	endc	 
START
		EVENT0in	.5000,msec,0xFF  ; set time @ 500 milliseconds
		eq_			NmbrEvent0,=,.4,lit8	; set execution  for EVENT0
TC1used = 2
	if TC1used > 0
	cblock
	 TC1:TC1used,NmbrEvent1
	endc
		EVENT1in	.1500,msec,.15	;EVENT15 in 1.5 sec, goto MLOOP	 
	endif
JMPTable	andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0	
		 goto	EVENT1
		 goto	EVENT2	
		 goto	EVENT3
		 goto	EVENT4
		 goto	EVENT5
		 goto	EVENT6
		 goto	EVENT7
		 goto	EVENT8
		 goto	EVENT9
		 goto	EVENT10
		 goto	EVENT11
		 goto	EVENT12
		 goto	EVENT13
		 goto	EVENT14
		 goto	EVENT15

;	org	0x100
	
MLOOP	clrwdt

	
	if_bit	TMR0,7			; software emulation of
	 goto	set7			; timer 0 overflow
	if_not	TMR07Bit		;
	 goto	set7+1
		bcf		TMR07Bit
		;	if_not	INTCON,T0IF		; wait for timer TMR0 to time out
		;	 goto	MLOOP
		;	bcf	INTCON,T0IF			
	goto	PERIODIC8		; which is 256*4 us =1 milliseconds
exitPERIODIC8
	decfsz	TC0,F
	 goto	endMLOOP0
;	goto	PERIODIC2048		; after first TC0 expired, 2048 milliseconds 
;exitPERIODIC2048			; have passed
	if TC0used > 1
;	movlw	0x07			;example for very long periodic events
;	andwf	TC0+1,W
;	movwf	STACK
;	movlw	-7
;	addwf	STACK,W
;	skpnZ
;	 goto	PERIODIC16sec		; every 16 seconds (Event0 must be later!)
;exitPERIODIC16sec
	decfsz	TC0+1,F
	 goto	endMLOOP0
	endif
					; after TC0+1 expired, 8 minutes 44 seconds
	if TC0used > 2			; have passed
	decfsz	TC0+2,F
	 goto	endMLOOP0
	endif 
	movfw	NmbrEvent0		; after TC0+2 expired, 37 hours 17 minutes
	goto	JMPTable 		; now jump to loaded Event
	 
endMLOOP0				; and continue execution here	 
end0MLOOP0
	if TC1used > 0
	decfsz	TC1,F			; analogous as TC0
	 goto	endMLOOP1
	endif
	if TC1used > 1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	endif
	if TC1used > 2
	decfsz	TC1+2,F
	 goto	endMLOOP1
	endif 
	if TC1used > 0
	movfw	NmbrEvent1
	goto	JMPTable 
	endif

	goto	endMLOOP1 
	 
	 
set7	bsf	TMR07Bit	
endMLOOP1	goto	MLOOP

;	org	0x200
;PERIODIC64usec			
;		goto	exitPERIODIC64usec
;
PERIODIC8							; check fuse tripped for 255 times
	movf	AlarmCount,f
	skpNZ
	 goto    exitPERIODIC8			; signal gen is in shutdown
	if_m	GPIO,3,is_on,1
 		incfsz	AlarmCount,F
	      goto	increasedAlarm
		bcf	GPIO,2
		bcf	GPIO,1					; Alarm = 0
		EVENT0in	.3,sec,.4		; shut down! wait 30 sec
	end_m
	goto    exitPERIODIC8			; signal gen is running, with Alarm >= 1
increasedAlarm
	EVENT1in	.60,msec,0xFF
	eq_			NmbrEvent1,=,.14,lit8
	goto    exitPERIODIC8			; signal gen is running, but waiting to collect
									; more Alarm, else decrease it in 60msec			
;;
;PERIODIC2048	
;		goto	exitPERIODIC2048
;		
;PERIODIC16sec	
;		goto	exitPERIODIC16sec	
;0000000000
;   0.392   0.392 msec
;11   0.078 msec
;000000000
;   0.824   0.353 msec
;11   0.078 msec
;00000000
;   1.216   0.314 msec
;1111   0.157 msec
;0000000
;   1.647   0.275 msec
;11111   0.196 msec
;00000
;   2.039   0.196 msec
;111111   0.235 msec
;00000
;   2.471   0.196 msec
;1111111   0.275 msec
;000
;   2.863   0.118 msec
;11111111   0.314 msec
;000
;   3.294   0.118 msec
;111111111   0.353 msec
;0
;   3.686   0.039 msec
;1111111111   0.392 msec
;0
;   4.118   0.039 msec
;1111111111   0.392 msec
;0
;   4.549   0.039 msec
;1111111111   0.392 msec
;0
;   4.980   0.039 msec
;1111111111   0.392 msec
;0
;   5.412   0.039 msec
;1111111111   0.392 msec
;0
;   5.843   0.039 msec
;1111111111   0.392 msec
;0
;   6.275   0.039 msec
;111111111   0.353 msec
;000
;   6.745   0.118 msec
;11111111   0.314 msec
;000
;   7.176   0.118 msec
;11111111   0.314 msec
;0000
;   7.647   0.157 msec
;111111   0.235 msec
;00000
;   8.078   0.196 msec
;111111   0.235 msec
;000000
;   8.549   0.235 msec
;1111   0.157 msec
;0000000
;   8.980   0.275 msec
;111   0.118 msec
;000000000
;   9.451   0.353 msec
;11   0.078 msec
;0000000000000
				 
EVENT0		
	if_	Lo_Side,is_on,1
	bsf	GPIO,1
	if_	Lo_Side,is_off,1
	bsf	GPIO,2
	EVENT0in	.1000,usec,.1	
EVENT1	
	do_ GPIO,=,GPIO,AND,b'11111001',lit8

	EVENT0in	.1500,usec,.2	
EVENT2			
	if_	Lo_Side,is_on,1
	bsf	GPIO,1
	if_	Lo_Side,is_off,1
	bsf	GPIO,2		
	EVENT0in	.3500,usec,.3

EVENT3
	do_ GPIO,=,GPIO,AND,b'11111001',lit8
	EVENT0in	.1500,usec,.7		 
EVENT4							; coming after shut down
	if_m	GPIO,3,is_off,1
	 eq_ AlarmCount,=,.1,lit8
     EVENT0in	.300,msec,.5
	end_m
	EVENT0in	.3,sec,.4		; 
EVENT5		
	if_m	GPIO,3,is_on,1
	  EVENT0in	.300,msec,.6
	end_m
	EVENT0in	.100,msec,.5
EVENT6	
	if_	GPIO,3,is_off,1
	  goto	EVENT0
	EVENT0in	.100,msec,.6
EVENT7		
	if_	Lo_Side,is_on,1
	bsf	GPIO,1
	if_	Lo_Side,is_off,1
	bsf	GPIO,2
	EVENT0in	.1000,usec,.8	
EVENT8	
	do_ GPIO,=,GPIO,AND,b'11111001',lit8
	if_m	Lo_Side,is_on,.1
      bcf	Lo_Side
	else_m
      bsf	Lo_Side
	end_m
	EVENT0in	.1500,usec,.0			

EVENT9		

EVENT10		

EVENT11		


EVENT12	
	

EVENT13
	

EVENT14 
	if_	GPIO,3,is_off,1			
	 decfsz	AlarmCount,F
    goto EVENT14A			; if no signal and Alarm>1
	incf	AlarmCount,F
	goto	EVENT15
EVENT14A
    EVENT1in .60,msec,.14	;come backin 60 msec

EVENT15 

	EVENT1in	6,sec,.15	;loop, Alarm=1


	
		end