;********************************************************************************
;*   This file is the firmware to implement 									*
;*	 1 timer, which on expiration can trigger 16 different single event routines*
;*       																		*
;*	 This program displays 1-wirestyle data @GP3 on a RGB LED GP0,1,2   		*
;*																				*
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;********************************************************************************	
;*                                                                 				*
;*    Filename:	    MICROCHIP OS for 10F200  .asm  (MCOS10F.asm)                *
;*    Date:         June 2015                                   				*
;*    File Version: A, this is a new file                                    	*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  sole inventor and coder                     				*
;*    Company:                                     								*
;********************************************************************************
;*                                			                     	           	*
;*    Files required:   m0-4.asm (macros)                                       *
;*                      NATURAL ASSEMBLER CODE                                  *
;*    Author:       G Michael Drygas                                      		*
;*                  sole inventor and coder                     				*                                                                  			*
;*                                                                     			*
;********************************************************************************
;*                                                                     			*
;*    Notes:        hardware 	2015/f48C.brd          							*
;*		         																*
;*                                                                     			*
;********************************************************************************
	list      p=10F200	; list directive to define processor
	#include  ..\m0-4.asm
	config200
 	
#define	OPTIONinit	b'11000101'	; no wakeup, no pullup, Clock 1:64
#define TRISIOinit 	b'00001000'	; all ports output bar GP3	
#define GPIOinit 	b'00000111'	; GPIO  all HI
;********************************************************************************


	init2xx			; reasonable initiation of special function registers 


	cblock	_MINRAM			; start of variables
	 SyS1       ;,SyS2
     dir,rgb
	endc
	cblock
	  deadtime
	endc

#define STACK		_MAXRAM

#define	Mi_Nus		SyS1,0
#define	Low_Detect	SyS1,1
#define	LED_On		SyS1,2
#define	Safety_G	SyS1,3
#define	TMR07Bit	SyS1,7
	

;PWRUP	
		eq_ SyS1,=,b'00000000',   	lit8	; 
        
		eq_ rgb,=,0,        		lit8
        eq_ deadtime,=,.255,        lit8	;256*64=16 msec

	;	do_	GPIO,=,GPIO,OR,b'00001111',lit8 ;SIM only


TC0used = 2					; use 2 bytes of timer for TC0
	cblock
	 TC0:TC0used
	 NmbrEvent0
	endc	 
		EVENT0in	.10,msec,.13  ; set time 10 sec



;		clrf	NmbrEvent0		; set execution  for EVENT0

;TC1used = 2
;	cblock
;	 TC1:TC1used,NmbrEvent1
;	endc
;		EVENT1in	1,msec,.15	;EVENT15 in 1 msec, goto MLOOP	 

JMPTable	andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0	
		 goto	EVENT1
		 goto	EVENT2	
		 goto	EVENT3
		 goto	EVENT4
		 goto	EVENT5
		 goto	EVENT6
		 goto	EVENT7
		 goto	EVENT8
		 goto	EVENT9
		 goto	EVENT10
		 goto	EVENT11
		 goto	EVENT12
		 goto	EVENT13
		 goto	EVENT14
		 goto	EVENT15


tabca   addwf PCL,f  
    
	dt  .127 ,  .0,  .0     ;0
    dt  .150 , .20 , .0     ;1
    dt  .175 , .61,  .0     ;2
	dt  .209 ,.105,  .0     ;3
	dt  .199 ,.155,  .0     ;4
    dt  .173 ,.205,  .0     ;5
 	dt  .133 ,.220,  .0     ;6

    dt   .70 ,.235, .16     ;7
    dt   .38 ,.245, .38     ;8 128
    dt   .1  ,.250, .68     ;9 144

    dt   .40 ,.180,.180     ;10
    dt   .60 ,.100,.200     ;11
    dt   .80 , .10,.220     ;12

    dt  .135 , .20,.250     ;13
    dt  .255 , .35,.245     ;14
    dt  .255 ,.255,.245     ;15
    dt  .255 ,.255,.255     ;15


	cblock
	 oldtmr0,RedPoint,GreenPoint,BluePoint,oldrgb,pollrgb
	endc
;
onepoint   
        movwf   STACK			; STACK = W (0,1,2)
        swapf   rgb,w			
        andlw   0x0F			; high nibble rgb
        addwf   STACK,F			; *3
        addwf   STACK,F
        addwf   STACK,F
        movfw   STACK			
        call tabca
        movwf  	INDF			; ...point = table

        swapf   rgb,w
        andlw   0xF0
        movwf   STACK-1
        movlw	.3
	    addwf   STACK,W
        call 	tabca
        subwf 	INDF,W
        movwf   STACK			;subtract next point
        if_Z
         goto   clerC
        if_C
         bsf Mi_Nus
        if_NC
clerC     bcf Mi_Nus
        comf    STACK,F
        incf    STACK,F
rlfstack
       rrf     SyS1,W     		; load Carry with Mi_Nus
       rrf     STACK,f
       movfw   STACK
       clrC
       rlf     STACK-1,f
       if_C
         addwf INDF,f
       movf    STACK-1,f
       if_NZ 
         goto rlfstack


        retlw 0


colortable
        eq_  FSR,=,RedPoint,lit8
        movlw  0
        call   onepoint
        eq_  FSR,=,GreenPoint,lit8
        movlw  1
        call   onepoint        
        eq_  FSR,=,BluePoint,lit8
        movlw  2
        call   onepoint

        goto returnpoint       
;

;	org	0x100


#define Red_LED GPIO,0
#define Green_LED GPIO,2
#define Blue_LED GPIO,1
;#define	TMR00Bit	SyS1,0	
MLOOP	
		clrwdt
	
        if_ TMR0,==,oldtmr0,        byte
         goto   noTMRchange

        eq_     oldtmr0,=,TMR0,     byte
        movf    oldtmr0,F
		if_m LED_On,is_on, singlebit
         if_Z_m
		   do_	GPIO,=,GPIO,AND,b'11111000',lit8         ; all LEDs on
         end_m                                           ;        
         if_ oldtmr0,==,RedPoint,byte  
               bsf Red_LED        
         if_ oldtmr0,==,GreenPoint,byte  
               bsf Green_LED
         if_ oldtmr0,==,BluePoint,byte  
               bsf Blue_LED
      	end_m                          ;

         if_m rgb,!=, oldrgb,        byte
           eq_ oldrgb,=,rgb,        byte
           goto colortable
returnpoint
         end_m
    
;       if_m LoW_Detect             ; single port capacitor charge over resistor, 
                                    ; 1bit at xxxus total 256x256us=64ms
;       if_m GPIO,3,is_on, singlebit
;store     eq_  rgb,=, pollrgb, byte
;        negate pollrgb,f
;        bcf Low_Detect
;      else_m
;        incfsz pollrgb,f
;           goto $+2
;         goto store
;      end_m

;
       if_m   Low_Detect,is_on,1           ;1- wire style serial input 1 start bit, 
		   
;		     bcf	GPIO,0
;			goto $-1
;

		eq__	STATUS,C,=,GPIO,3
											; 8 data bit @ 256us MSB first    	  								
	     rlf    pollrgb,F
          if_C_m 							; pushed bit detected

           eq_ rgb, = ,pollrgb,   	byte
		   eq_	deadtime,=,.100,	lit8	; 100*64=6msec
		   movlw	OPTIONinit
		   OPTION 
           bcf  Low_Detect 
		   goto	EVENT14
          end_m
         else_m
		   if_	Safety_G,is_off,1
			 goto noTMRchange
		   decfsz	deadtime,F
			 goto noTMRchange
 		   incf	deadtime,F
;
;		  bcf	GPIO,2						; safety off
          if_m GPIO,3,is_off, 1				; 256us start bit
;

;			goto	EVENT14
;
;
			movlw	b'11000111'	; no wakeup, no pullup, Clock 1:256
			OPTION 
		    eq_ TMR0,=,oldtmr0,      byte	; clr prescaler
		    eq_	pollrgb,=,.1,lit8			; push bit
            bsf Low_Detect
        	bcf LED_On 
;;		    eq_	deadtime,=,.3,lit8
;;			eq_	samples,=,.0,lit8
          end_m
        end_m
;                                           
;
noTMRchange	
	if_ 	TMR0,7,is_on,1			; software emulation of
	 goto	set7			        ; timer 0 overflow of any bit
	if_  	TMR07Bit,is_off,1		;
	 goto	set7+1
	bcf		TMR07Bit
;	goto	PERIODIC8		        ; which is 256*64 us =8 milliseconds
exitPERIODIC8

	decfsz	TC0,F
	 goto	endMLOOP0
;	goto	PERIODIC2048		    ; after first TC0 expired, 2048 milliseconds 
exitPERIODIC2048			        ; have passed
	if TC0used > 1
exitPERIODIC16sec
	decfsz	TC0+1,F
	 goto	endMLOOP0
	endif
					                ; after TC0+1 expired, 8 minutes 44 seconds
	if TC0used > 2			        ; have passed
	decfsz	TC0+2,F
	 goto	endMLOOP0
	endif 
	movfw	NmbrEvent0		        ; after TC0+2 expired, 37 hours 17 minutes
	goto	JMPTable 		        ; now jump to loaded Event
	 
endMLOOP0				        	; and continue execution here	 
end0MLOOP0
    if TC1used>0
	decfsz	TC1,F			        ; analogous as TC0
	 goto	endMLOOP1
    endif
	if TC1used > 1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	endif
	if TC1used > 2
	decfsz	TC1+2,F
	 goto	endMLOOP1
	endif
    if TC1used > 0 
	movfw	NmbrEvent1
	goto	JMPTable 
	endif 


	goto	endMLOOP1 

set7		bsf	TMR07Bit	
endMLOOP1	goto	MLOOP

;	org	0x200
;PERIODIC64usec			
;       

;		goto	exitPERIODIC64usec
;
;PERIODIC8
;		goto	exitPERIODIC8			
;
;PERIODIC2048	
;		goto	exitPERIODIC2048
;		
;PERIODIC16sec	
;		goto	exitPERIODIC16sec	
				 
EVENT0		
		
EVENT1	

EVENT2			
		
EVENT3
		 
EVENT4		

EVENT5		
		
EVENT6	

EVENT7		

EVENT8		

EVENT9		

EVENT10		

EVENT11		


EVENT12	
		
EVENT13
		if_m	GPIO,3,is_off,1
		 do_	GPIO,=,GPIO,XOR,b'00000100',lit8
		EVENT0in .500,msec,.13	
		end_m
		bsf	GPIO,2
		bsf	Safety_G						;first signal high detected
		goto	EVENT15
EVENT14 

		bsf		LED_On
		EVENT0in .200,msec,.15				;loop

   
EVENT15 
        bcf		LED_On

		do_	GPIO,=,GPIO,OR,b'00000111',lit8  ; all off
		EVENT0in .10000,msec,.14	



		end
;********************************************************************************
;*   compiled and tested June 14, 2015  	  									*
;*	 compiled program: 254 ($FE) bytes			all data bytes used exept $1D   *
;*       																		*
;*	 This program displays 1-wirestyle data @GP3 on a RGB LED GP0,1,2   		*
;*																				*
;********************************************************************************
  