;*                                			                                         *
;*    Files required:   m0-4.asm (macros) for NATURAL assembler User Interface       *               
;*************************************************************************************
;*                                                                     			     *
;*    Notes:        hardware PCB 2016/switcher300ss2.brd						     *
;*                                                                     		         *
;*************************************************************************************
		list      p=12F683	; list directive to define processor
		#include  ..\m0-4.asm
		config_

#define	E1	0x1000
;#define	TMR07Bit	SystemStatus,7


#define GPIOinit	b'00001000'	; 4,5 OUTPUT initiate as LOW,2 low
#define TRISIOinit	b'11001011'	; configure 2,4,5 as OUTPUT, 0,1 as INPUT 
#define	OPTIONinit	b'11001000'	; no wakeup, no pullup, clock 1:1
#define ANSELinit 	B'01110001' ; ADC Frc clock, AN0 as analog
#define	ADCON0init	b'00000000'	; left justified , ADC off

#define VRCONinit   b'10100001' ; CREF = 0.23V of 5V 
#define CMCON0init  b'00011100' ; IF GP0 >Vref ,COUT=1

#define INTCONinit	b'01100000' ; periph interrupt enable,TMR0 overflow enable
#define PIE1init	b'00001000' ; comp int en
#define PIR1init	b'00000000' ; int flags clear

;#define PR2init		.40
;#define CCPR1Linit  .0
;;#define CCP1CONinit	b'00000000'	; disable pwm, pwmbits 00
;;#define T2CONinit   b'00000000'	; switch off TMR2

	cblock	_MINRAM			; start of variables
	 SyS1,CcDelay:2,CcPulse:2,Counter:2
	endc

#define STACK		_MAXRAM	
#define	hiSide		SyS1,2		
#define	hiSidebit  	b'00000100'
#define	check_on	SyS1,3
#define	check_off	SyS1,4
#define	hiFETbit  	b'00100000'
#define	nhiFETbit  	b'11011111'
#define	nloFETbit  	b'11101111'
#define	loFETbit  	b'00010000'
#define	beepbit  	b'00000100'
#define	beepport  	2
;******************************code***************************************************
	org	0x00
	nop
	goto	pinterupt
	nop
	nop
	org 0x04		;interrupt service routine
    RETURN 
	if_	PIR1,CMIF,is_on,1
	 goto alarm
	if_	INTCON,T0IF,is_on,1
     return
	bcf	PIR1,CMIF
	movfw CMCON0
	 
alarm
	do_	GPIO,=,GPIO,AND,b'11001111',lit8
;	decfsz	Counter,f
;	 goto $+2
;	EVENT0nmbr,=,.14
;	

	bsf GPIO,beepport
;	 goto $
	retfie

pinterupt
	
	init_
	
;PWRUP	
		
		eq	SyS1,0
		eq	GPIO,GPIOinit
	
TC0used = 3							; use 3 bytes of timer for TC0
	cblock
	 TC0:TC0used
	 NmbrEvent0
	endc	 


		EVENT0in	.5000,msec,0xFF ; set time @ 5000 milliseconds
		eq_	Counter,=,.5,lit8
		eq_ NmbrEvent0,=,.4,lit8	; set execution  for EVENT0



TC1used = 2
	cblock
	 TC1:TC1used,NmbrEvent1
	endc

		bsf	INTCON,GIE
		EVENT1in	1,sec,.11		; MLOOP	 


JMPTable	andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0	
		 goto	EVENT1
		 goto	EVENT2	
		 goto	EVENT3
		 goto	EVENT4
		 goto	EVENT5
		 goto	EVENT6
		 goto	EVENT7
		 goto	EVENT8
		 goto	EVENT9
		 goto	EVENT10
		 goto	EVENT11
		 goto	EVENT12
		 goto	EVENT13
		 goto	EVENT14
		 goto	EVENT15

;	org	0x100
	
MLOOP	clrwdt

;*******************non standard****code****************************************
;
;	if__	GPIO,3,not_but,check_on
;        bcf check_on
;	if__	GPIO,3,and,check_off
;        bcf check_off
;


;	if_not	TMR0,0			;example for very short periodic events
;	 goto	n64MLO
;	goto	PERIODIC64usec
;exitPERIODIC64usec		
;	if_bit	TMR0,0			; avoid multiple P64u's, wait until bit0 is set
;	 goto	exitPERIODIC64usec
;
;n64MLO	
;	if_bit	TMR0,7			; software emulation of
;	 goto	set7			; timer 0 overflow
;	if_not	TMR07Bit		; PIC 10Fxxx only
;	 goto	set7+1
;
	eq__	GPIO,2,=,CMCON0,COUT
goto MLOOP
	if_not	INTCON,T0IF		; wait for timer TMR0 to time out
	 goto	MLOOP
	bcf	INTCON,T0IF
	bsf	INTCON,GIE			
	goto	PERIODIC8		; which is 256us 
exitPERIODIC8
	decfsz	TC0,F
	 goto	endMLOOP0
;	goto	PERIODIC2048	; after first TC0 expired, 65 milliseconds 
;exitPERIODIC2048			; have passed
	if TC0used > 1

	decfsz	TC0+1,F
	 goto	endMLOOP0
	endif
							; after TC0+1 expired, 16.77sec
	if TC0used > 2			; have passed
	decfsz	TC0+2,F
	 goto	endMLOOP0
	endif


;*******************non standard****code****************************************

;    if_ check_on,is_on,1 
;      goto EVENT14ante
;    if_ check_off,is_on,1
;      goto EVENT15ante
;


	movfw	NmbrEvent0		; after TC0+2 expired, 71min 34sec
	goto	JMPTable 		; now jump to loaded Event
	 
endMLOOP0					; and continue execution here	 
end0MLOOP0
	if TC1used > 0
	decfsz	TC1,F			; analogous as TC0
	 goto	endMLOOP1
	endif
	if TC1used > 1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	endif
	if TC1used > 2
	decfsz	TC1+2,F
	 goto	endMLOOP1
	endif 
	if TC1used > 0
	movfw	NmbrEvent1
	goto	JMPTable 
	endif

	goto	endMLOOP1 
	 
	 
set7						;bsf	TMR07Bit	
endMLOOP1	goto	MLOOP

;	org	0x200
;PERIODIC64usec			
;		goto	exitPERIODIC64usec
;
PERIODIC8							; check fuse tripped for 255 times
;	movf	AlarmCount,f
;	skpNZ
;	 goto    exitPERIODIC8			; signal gen is in shutdown
;	if_m	GPIO,3,is_on,1
; 		incfsz	AlarmCount,F
;	      goto	increasedAlarm
;		bcf	GPIO,2
;		bcf	GPIO,1					; Alarm = 0
;		EVENT0in	.3,sec,.4		; shut down! wait 30 sec
;	end_m
;	goto    exitPERIODIC8			; signal gen is running, with Alarm >= 1
;increasedAlarm
;	EVENT1in	.60,msec,0xFF
;	eq_			NmbrEvent1,=,.14,lit8
	goto    exitPERIODIC8			; signal gen is running, but waiting to collect
									; more Alarm, else decrease it in 60msec	
PERIODIC2048	
;		goto	exitPERIODIC2048
		
PERIODIC16sec	
;		goto	exitPERIODIC16sec	





flflop
	do_	GPIO,=,GPIO,AND,b'11001111',lit8
	;delay .9
	do_	SyS1,=,SyS1,XOR,hiSidebit,lit8
    if_m hiSide,is_on,1
	  do_	GPIO,=,GPIO,OR,hiFETbit,lit8
	else_m
	  do_	GPIO,=,GPIO,OR,loFETbit,lit8
	end_m
	retlw 0
				 
EVENT0		
	call	flflop					;run with check on GP3
	bsf check_on
	EVENT0in	.7000,usec,2
    
EVENT1	
	do_	GPIO,=,GPIO,AND,b'11001111',lit8
	EVENT0in .3000,usec,3
	
EVENT2	
	do_	GPIO,=,GPIO,AND,b'11001111',lit8
	bsf	check_off
	EVENT0in	.3000,usec,0

EVENT3
   	call	flflop					;run with comp int check
	EVENT0in	.7000,usec,1



EVENT4	

	delay	.12						; coming after shut down
;	if_m	GPIO,3,is_off,1			; wait for pushbutton
;     EVENT0in	.300,msec,.5
;	end_m	
	decfsz	TC0,F
	 goto	EVENT4
	decfsz	TC0+1,F	
     goto	EVENT4																			
	bsf GPIO,beepport
    delay .10000
    bcf GPIO,beepport
	delay .100000
    bsf GPIO,beepport
    delay .30000
    bcf GPIO,beepport

 	decfsz	Counter,F
	 goto	EVENT4		;
    goto EVENT1 
EVENT5		
	if_m	GPIO,3,is_on,1
	  goto EVENT0
	end_m

    decfsz	Counter,f
	goto	$+2
     goto	EVENT1
	EVENT0in	.100,msec,.5
EVENT6	
	
EVENT7		

EVENT8		

EVENT9		

EVENT10		
	bcf GPIO,beepport
	decfsz	Counter+1,f
	goto $+2
	  goto	EVENT4

	EVENT0in 1,sec,.15
EVENT11		
	EVENT1in .10,sec,.11

EVENT12	
	bcf GPIO,beepport
	
	EVENT0in .300,msec,.15	

EVENT13
	bcf GPIO,beepport
	EVENT0in 1,sec,.14	

EVENT14ante	
  	eq_	Counter,=,.30,lit8
	bcf	check_on
EVENT14 
	do_	GPIO,=,GPIO,OR,b'11111000',lit8
	decfsz	Counter,f
	 goto $+2
	goto EVENT4
	
	bsf GPIO,beepport
	EVENT0in .600, msec,.13

EVENT15ante
	eq_	Counter,=,0x0F03,lit16
	bcf	check_off
	bcf	check_on
EVENT15 

	do_	GPIO,=,GPIO,OR,b'11111000',lit8
	bsf GPIO,beepport
	
	decfsz	Counter,F
     goto	E15x
	eq_		Counter,=,.3,lit8
	EVENT0in	.300,msec,.10

E15x
	EVENT0in .300, msec,.12
	end