;*                                			                                         *
;*    Files required:   m0-4.asm (macros) for NATURAL assembler User Interface       *               
;*************************************************************************************
;*                                                                     			     *
;*    Notes:        hardware PCB 2015/f48C.brd						     *
;*                                                                     		         *
;*************************************************************************************
		list      p=12F683	; list directive to define processor
		#include  ..\m0-4.asm
		config_
#define	E1	0x1000
#define	TMR07Bit	SystemStatus,7
#define STACK	_MAXRAM

#define GPIOinit	b'00000000'	; 0,1,2 OUTPUT initiate as LOW
#define TRISIOinit	b'11011000'	; configure 0,2,5 as OUTPUT, 1,3,4 as INPUT 
#define	OPTIONinit	b'11000101'	; no wakeup, no pullup, clock 1:64
#define ANSELinit 	B'01111000' ; ADC Frc clock, AN3(GP4) as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on
#define PR2init		.40
#define CCPR1Linit  .0
#define CCP1CONinit	b'00000000'	; disable pwm, pwmbits 00
#define T2CONinit   b'00000100'	; switch on TMR2

	cblock	_MINRAM			; start of variables
	 SyS1,SyS2
	endc	




	nointr683
	init_
TC0used = 3					; use 3 bytes of timer for TC0
	cblock
	 TC0:TC0used
	 NmbrEvent0
	endc	 
		EVENT0in	.500,msec,0xFF  ; set time @ 500 milliseconds
		clrf	NmbrEvent0		; set execution  for EVENT0
TC1used = 2
	cblock
	 TC1:TC1used,NmbrEvent1
	endc
		EVENT1in	1,msec,.15	;EVENT15 in 1 msec, goto MLOOP	 

JMPTable	andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0	
		 goto	EVENT1
		 goto	EVENT2	
		 goto	EVENT3
		 goto	EVENT4
		 goto	EVENT5
		 goto	EVENT6
		 goto	EVENT7
		 goto	EVENT8
		 goto	EVENT9
		 goto	EVENT10
		 goto	EVENT11
		 goto	EVENT12
		 goto	EVENT13
		 goto	EVENT14
		 goto	EVENT15

;	org	0x100
	
MLOOP	clrwdt
	if_not	TMR0,0			;example for very short periodic events
	 goto	n64MLO
	goto	PERIODIC64usec
exitPERIODIC64usec		
	if_bit	TMR0,0			; avoid multiple P64u's, wait until bit0 is set
	 goto	exitPERIODIC64usec

n64MLO	
;	if_bit	TMR0,7			; software emulation of
;	 goto	set7			; timer 0 overflow
;	if_not	TMR07Bit		;
;	 goto	set7+1
;
	if_not	INTCON,T0IF		; wait for timer TMR0 to time out
	 goto	MLOOP
	bcf	INTCON,T0IF			
	goto	PERIODIC8		; which is 256*64 us =8 milliseconds
exitPERIODIC8
	decfsz	TC0,F
	 goto	endMLOOP0
	goto	PERIODIC2048		; after first TC0 expired, 2048 milliseconds 
exitPERIODIC2048			; have passed
	if TC0used > 1
	movlw	0x07			;example for very long periodic events
	andwf	TC0+1,W
	movwf	STACK
	movlw	-7
	addwf	STACK,W
	skpnZ
	 goto	PERIODIC16sec		; every 16 seconds (Event0 must be later!)
exitPERIODIC16sec
	decfsz	TC0+1,F
	 goto	endMLOOP0
	endif
					; after TC0+1 expired, 8 minutes 44 seconds
	if TC0used > 2			; have passed
	decfsz	TC0+2,F
	 goto	endMLOOP0
	endif 
	movfw	NmbrEvent0		; after TC0+2 expired, 37 hours 17 minutes
	goto	JMPTable 		; now jump to loaded Event
	 
endMLOOP0				; and continue execution here	 
end0MLOOP0
	if TC1used > 0
	decfsz	TC1,F			; analogous as TC0
	 goto	endMLOOP1
	endif
	if TC1used > 1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	endif
	if TC1used > 2
	decfsz	TC1+2,F
	 goto	endMLOOP1
	endif 
	if TC1used > 0
	movfw	NmbrEvent1
	goto	JMPTable 
	endif

	goto	endMLOOP1 
	 
	 
set7				;bsf	TMR07Bit	
endMLOOP1	goto	MLOOP

;	org	0x200
PERIODIC64usec			
		goto	exitPERIODIC64usec

PERIODIC8
		goto	exitPERIODIC8			

PERIODIC2048	
		goto	exitPERIODIC2048
		
PERIODIC16sec	
		goto	exitPERIODIC16sec	
				 
EVENT0		
	bcf GPIO,1
	EVENT0in .2,sec,.1	
EVENT1	
	bsf	GPIO,0
	EVENT0in .10,sec,.2
EVENT2			
	bcf	GPIO,0
	EVENT0in .2,sec,.3	
EVENT3
	bsf	GPIO,1
	EVENT0in .10,sec,.0	 
EVENT4		

EVENT5		
		
EVENT6	

EVENT7		

EVENT8		

EVENT9		

EVENT10		

EVENT11		


EVENT12	
		EVENT0in .1,sec,0	;loop

EVENT13
	
		EVENT1in .1,sec,.14

		
EVENT14 
		bsf	GPIO,0
		EVENT1in .10,sec,.15


EVENT15 
		EVENT1in .1,sec,.15	



	

	end