;*                                			                                         *
;*    Files required:   m0-4.asm (macros) for NATURAL assembler User Interface       *               
;*************************************************************************************
;*                                                                     			     *
;*    Notes:        hardware PCB 2015/f48C.brd						     *
;*                                                                     		         *
;*************************************************************************************
		list      p=12F683	; list directive to define processor
		#include  ..\m0-4.asm
		config_
#define	E1	0x1000
#define	TMR07Bit	SystemStatus,7
#define STACK	_MAXRAM

#define GPIOinit	b'00000000'	; 0,1,2 OUTPUT initiate as LOW
#define TRISIOinit	b'11001011'	; configure 2,4,5 as OUTPUT, 0,1,3 as INPUT 
#define	OPTIONinit	b'11000101'	; no wakeup, no pullup, clock 1:64
#define ANSELinit 	B'01110001' ; ADC Frc clock, AN0(GP0) as analog
#define	ADCON0init	b'00000001'	; left justified ,VDD, AN0, on
#define PR2init		.40
#define CCPR1Linit  .0
#define CCP1CONinit	b'00000000'	; disable pwm, pwmbits 00
#define T2CONinit   b'00000000'	; switch off TMR2

#define Triac_Port		GPIO,2	; active high triac drive
#define Z_Detect_Port	GPIO,3

	cblock	_MINRAM			; start of variables
	 SyS1,SyS2,MaxTmr:2,count
	 Fir255ing:2,F_angle:2,Fire_at:2
	endc	

#define Z_Port_Status 	SyS1,3

	nointr683
	init_
TC0used = 3					; use 3 bytes of timer for TC0
	cblock
	 TC0:TC0used
	 NmbrEvent0
	endc	 
		EVENT0in	.500,msec,0xFF  ; set time @ 500 milliseconds
		clrf	NmbrEvent0		; set execution  for EVENT0
TC1used = 2
	cblock
	 TC1:TC1used,NmbrEvent1
	endc
	
	eq_	MaxTmr,=,.156,lit16
	goto skip

wait8cycles 
	clrwdt
	eq_		MaxTmr,=,0,lit16
	eq_		count,=,.8,lit8
	btfss	Z_Detect_Port			; test frequency
	 goto	$-1
	clrwdt
	btfsc	Z_Detect_Port			; test frequency
	 goto	$-1
	btfsc	Z_Detect_Port
	 goto 	$-4


	clrf	TMR0
	bcf	INTCON,T0IF
	clrwdt		; 18ms time to go up (9/10ms expected)

setloop	
	if_m	INTCON,T0IF,is_on,1
 	 incf	MaxTmr+1,f
	 bcf	INTCON,T0IF
	end_m
	btfss	Z_Detect_Port
	 goto	setloop
	btfss	Z_Detect_Port
	 goto	setloop
	clrwdt
clrloop
	if_m	INTCON,T0IF,is_on,1
 	 incf	MaxTmr+1,f
	 bcf	INTCON,T0IF
	end_m
	btfsc	Z_Detect_Port			; test frequency
	 goto	clrloop
	btfsc	Z_Detect_Port
	 goto   clrloop	
	clrwdt		; 18ms time to go up (9/10ms expected)
	decfsz	count,f
	 goto setloop
	eq_		MaxTmr,=,TMR0,byte

	bcf		Z_Port_Status
	eq_		count,=,.4,lit8
rr	
	clrc
	rrf	MaxTmr+1,f
	rrf	MaxTmr,f
	decfsz	count,f
	 goto	rr
skip
	do_		MaxTmr,=,MaxTmr,-,2,lit8
	eq_		Fir255ing,=,MaxTmr,byte
	do_		Fire_at,=,MaxTmr,-,5,lit16
		
	EVENT1in	1,msec,.15	;EVENT15 in 1 msec, goto MLOOP	 

JMPTable	andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0	
		 goto	EVENT1
		 goto	EVENT2	
		 goto	EVENT3
		 goto	EVENT4
		 goto	EVENT5
		 goto	EVENT6
		 goto	EVENT7
		 goto	EVENT8
		 goto	EVENT9
		 goto	EVENT10
		 goto	EVENT11
		 goto	EVENT12
		 goto	EVENT13
		 goto	EVENT14
		 goto	EVENT15

;	org	0x100
	
MLOOP
	clrwdt
	if_m		Z_Port_Status,is_on,1   ; Block_fire not_but
		if__m	Z_Detect_Port,nor,Z_Detect_Port
           do_	Fire_at,=,Fir255ing,+,TMR0,byte
	       eq_	Fire_at+1,=,.1,lit8
		   ;bsf  Block_fire
		   bcf	Z_Port_Status
		end_m
	end_m
	if_m		Z_Port_Status,is_off,1;nor Block_fire
		if__m	Z_Detect_Port,and,Z_Detect_Port
           	do_	Fire_at,=,Fir255ing,+,TMR0,byte
			eq_	Fire_at+1,=,.1,lit8
			;bsf  Block_fire
		   bsf	Z_Port_Status
		end_m
	end_m

	if_m	TMR0,==,Fire_at,byte
	 decfsz	Fire_at+1,f
		goto	clrwd
	 ;bcf Block_fire	
	 bsf	Triac_Port
	 goto	PERIODIC64usec
	end_m
clrwd
	

exitPERIODIC64usec		

	bcf		Triac_Port
n64MLO	
;	if_bit	TMR0,7			; software emulation of
;	 goto	set7			; timer 0 overflow
;	if_not	TMR07Bit		;
;	 goto	set7+1
;
	if_not	INTCON,T0IF		; wait for timer TMR0 to time out
	 goto	MLOOP
	bcf	INTCON,T0IF			
	goto	PERIODIC8		; which is 256*64 us =8 milliseconds
exitPERIODIC8
	decfsz	TC0,F
	 goto	endMLOOP0
	goto	PERIODIC2048		; after first TC0 expired, 2048 milliseconds 
exitPERIODIC2048			; have passed
	if TC0used > 1
;	movlw	0x07			;example for very long periodic events
;	andwf	TC0+1,W
;	movwf	STACK
;	movlw	-7
;	addwf	STACK,W
;	skpnZ
;	 goto	PERIODIC16sec		; every 16 seconds (Event0 must be later!)
exitPERIODIC16sec
	decfsz	TC0+1,F
	 goto	endMLOOP0
	endif
					; after TC0+1 expired, 8 minutes 44 seconds
	if TC0used > 2			; have passed
	decfsz	TC0+2,F
	 goto	endMLOOP0
	endif 
	movfw	NmbrEvent0		; after TC0+2 expired, 37 hours 17 minutes
	goto	JMPTable 		; now jump to loaded Event
	 
endMLOOP0				; and continue execution here	 
end0MLOOP0
	if TC1used > 0
	decfsz	TC1,F			; analogous as TC0
	 goto	endMLOOP1
	endif
	if TC1used > 1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	endif
	if TC1used > 2
	decfsz	TC1+2,F
	 goto	endMLOOP1
	endif 
	if TC1used > 0
	movfw	NmbrEvent1
	goto	JMPTable 
	endif

	goto	endMLOOP1 
	 
	 
set7				;bsf	TMR07Bit	
endMLOOP1	goto	MLOOP

;	org	0x200
PERIODIC64usec	
		delay	.62		
		goto	exitPERIODIC64usec

PERIODIC8
		goto	exitPERIODIC8			

PERIODIC2048
		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		eq_		F_angle,=,ADRESH,byte
		do_		Fir255ing,=,MaxTmr,*,F_angle,byte
		eq_		Fir255ing,=,STACK,byte
		if_m	Fir255ing,<,2,lit8
			eq_	Fir255ing,=,2,lit8
		end_m
		goto	exitPERIODIC2048
		
PERIODIC16sec	
		goto	exitPERIODIC16sec	
				 
EVENT0		
	bcf GPIO,5
	EVENT0in .5,sec,.1	
EVENT1	
	bsf	GPIO,4
	EVENT0in .15,sec,.2
EVENT2			
	bcf	GPIO,4
	EVENT0in .5,sec,.3	
EVENT3
	bsf	GPIO,5
	EVENT0in .15,sec,.0	 

EVENT4		

EVENT5		
		
EVENT6	

EVENT7		

EVENT8		

EVENT9		

EVENT10		

EVENT11		


EVENT12	


EVENT13
	


		
EVENT14 
	


EVENT15 
		EVENT1in .1,sec,.15	



	

	end