;****************************************************************************************
;*   This file is the firmware to implement 3 NFET gate drivers, based on 		*
;*   the PIC12F629.
;*		
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    629.3.1.asm                              		                *
;*    Date:         December, 2009                                    			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael Drygas                                      		*
;*                  Applications Engineer                    				*
;*    Company:      MICHAELS Unternehmergesellschaft(haftungsbeschrnkt)                *
;*                                                                     			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   macros3c.asm                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                    					*
;*                                                                     			*
;****************************************************************************************
	list      p=12F675	; list directive to define processor
	#include  ..\macros3c.asm
	config675
 	ORG 0x00
	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	goto PWRUP
	ORG	0x004		;interrupts code
	return			; disable interrupts

	
#define OPTIONinit	B'11000110';	; clock 1:128 , WDT 1:1 ,	
#define TRISIOinit 	b'00011000'	; GPIO0,1,2 as OUTPUT, GPIO 0,3,4,5 as INPUT
#define GPIOinit 	b'00000000'	; GPIO  all LOW 

PWRUP	init629
	
	goto MAIN


;****************************************************************************************


	cblock	_MINRAM			; start of variables
;	if	(_MIMRAM & 0x01) == 0x01
;	 x
;	endif
	StarT0,StoP0,StarT1,StoP1,StarT2,StoP2
	Tmr0Cach,PortBit
	endc
#define	STACK	_MAXRAM	

switchport
	if_bit	FSR,0
	 goto	offswitch
	do_	GPIO,=,GPIO,OR,PortBit,	byte
	retlw	0
offswitch
	movlw	0x0FF
	andwf	PortBit,W
	andwf	GPIO,F
	retlw 0


afterwdt


MAIN	eq_	Tmr0Cach,=,TMR0,	byte
	eq_	PortBit,=,0x01,		lit8
	eq_	FSR,=,StarT0,		lit8

portloop
	if_	Tmr0Cach,==,INDF,	byte
	 call	switchport	
	clrC
	if_bit	FSR,0
	 rlf	PortBit,F	
	incf	FSR,F
	btfss	PortBit,3
         goto	portloop 

	if_	Tmr0Cach,==,TMR0,	byte
	 goto	$-1
	goto	MAIN
	end