;***********************************************************************
;*   This file is the firmware to implement a                          *
;*                                                                     *
;*    binary display of a register as short low (0)                    *
;*                                and long high (1) pulses             *
;*                       while omitting leading zeros                 *
;*                                                                     *
;*   at GPIO 2 Transistor output driver                                *
;*                                                                     *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G MICHAEL DRYGAS                                   *
;*                                    				       *
;*    Company:    MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)*
;*                 reg DE                                             *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F222	; list directive to define processor
	#include  ..\macros3b.asm
	config222
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************


	cblock _MINRAM
	 SystemStatus,TimerVector,TimeCounter:2
	 x	 

	endc

#define	TMR07Bit	SystemStatus,7
#define STACK	_MAXRAM

#define GPIOinit	b'00000110'	; all OUTPUT initiate as HIGH
#define TRISIOinit	b'11111001'	; configure GP1,2 as output 
#define	OPTIONinit	b'11000001'	; no wakup, no pullup, Clock 1:4
#define	ADCON0init	b'01000001'	; gP0 analog, chanel 00,enable
;#define	ADCON0init	b'10000101'	; gP1 analog, chanel 01,enable



black	macro port
	movlw	TRISIOinit | (1 << port)	; port  input = black
	TRIS	TRISGPIO
	endm
red	macro port
	bcf	GPIO,port
	movlw	TRISIOinit & (0xFF -(1<<port))	; port  output,LOW = red
	TRIS	TRISGPIO
	endm
blue	macro port
	bsf	GPIO,port
	movlw	TRISIOinit & (0xFF -(1<<port))	; port  output,HIGH = blue
	TRIS	TRISGPIO
	endm
	

	init206					

afterwdt 
	
MAIN	
	
cycle	black 2
	settrap206B .6,sec,ADC,TimeCounter,TimerVector


ploop					; loop code every 5 us


	if_bit	TMR0,7			; software emulation of
	 goto	set7			; timer 0 overflow
	if_not	TMR07Bit		;
	 goto	clred
	bcf	TMR07Bit		; timer 0 has overflown within
					;	127 timerticks

					; loop code every 256*OPTION us

	decfsz	TimeCounter,F		
	 goto	clred
	decfsz	TimeCounter+1,F
	 goto    clred			
				
	 
	movfw	TimerVector		; timer trap has sprung
	movwf	PCL			; jump to destination

set7	bsf	TMR07Bit


clred					; timer loop
	goto	ploop			; code max for 127 timerticks


ADC	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1
	
	eq_	FSR,=,ADRES,lit8	; set pointer to ANALOG result
	eq_	x,=,b'10000000', lit8	; bit 7

frstbit	movfw	x			; omit leading zeros
	andwf	INDF,W
	bNZ	strtdis			; its a 1, start display
	rrf	x,F
	skpC				; underflow ?
	 goto	frstbit
	rlf	x,F			; send bit 0 anyway
	
strtdis	movfw	x
	andwf	INDF,W
	skpZ	
	 goto	long
	settrap206B .200,msec,pause,TimeCounter,TimerVector
	red 2
 	goto ploop

long	settrap206B .800,msec,pause,TimeCounter,TimerVector
 	blue 2
 	goto ploop	

pause	settrap206B .200,msec,rsmedis,TimeCounter,TimerVector
	black 2
 	goto ploop
 	
rsmedis	rrf	x,F	;	next bit?
	bC	cycle	;	done, wait for next measurement
	goto	strtdis	

	
	

	end