;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..5 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros2c                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F222	; list directive to define processor
	#include  ..\macros3b.asm
	config222
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************

	IFDEF __10F222
	cblock 0x09				; var starting at  0x09

	endc
	ENDIF

	cblock 0x10
	 PR2,TimeCounter:3,TimerVector,PeriodCounter
	endc


#define GPIOinit	b'00000000'	; all io initiate as LOW
#define TRISIOinit	b'11111011'	; configure NFET_Gate_Port as output 
#define	OPTIONinit	b'11000000'	; no wakup, no pullup, Clock 1:2
;#define	ADCON0init	b'01000001'	; gP0 analog, chanel 00,enable
#define	ADCON0init	b'10000101'	; gP1 analog, chanel 01,enable


	init206
	goto	MAIN

resetT	movlw	.1
	movwf	TimeCounter
	movwf	TimeCounter+1
	clrf	TimeCounter+2		; 255*255*256*795us =1,07e10 =10770sec=179min=2h59min
	movlw	MAIN
	movwf	TimerVector
	retlw	0

#define Lo_Intensity	.240
#define Hi_Intensity	.4
#define	NFET_Gate_Port	GPIO,2


afterwdt
MAIN	eq_	PR2,=, Lo_Intensity,lit8	;start with intensity
	call 	resetT			; Timer := 0 (triple1)

cycle	incf	PR2,W 			; 5 .. 255=off
	skpnz
	 goto	nopulse

	bsf	NFET_Gate_Port		; NFET or Transistor on
	movwf	PeriodCounter
	movfw	TimerVector
	nop				; 4 us
	bcf	NFET_Gate_Port		; and off

nopulse	decfsz	TimeCounter,F
	 goto	nil
	decfsz	TimeCounter+1,F
	 goto	tstport			; 7msec to 158ms check input
	decfsz	TimeCounter+2,F
	 goto	nil-2
	movwf	PCL
tstport	

	decf	PeriodCounter,F
	decf	PeriodCounter,F
	decf	PeriodCounter,F
	decf	PeriodCounter,F
nil	decfsz	PeriodCounter,F			;1
	 goto	$-1			;2,3 cycles
	clrwdt
	goto	cycle

	end