;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..5 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros2c                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F222	; list directive to define processor
	#include  ..\macros3b.asm
	config222
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************

	IFDEF __10F222
	cblock 0x09				; var starting at  0x09
	InputBuffer,HiPulse,LoPulse,PulsE

	endc
	ENDIF

	cblock 0x10
	shdw_TRISIO,SystemStatus,FlipDuty,Duty
	MaxTmr:2,TmrVector
	AL,DH
	NoCounter,VoltMem

	endc
#define	STACK	0x1F

					; 
#define Dutyinit	.127
#define	NFET_Gate	2
#define TMR0IF	SystemStatus,0
#define pwm_on  SystemStatus,1
;		2 reserved for GPIO2 shadow
#define shdwGP3   SystemStatus,3
#define Runn_inG  SystemStatus,4

#define nega_bit SystemStatus,5
#define go_dwn	SystemStatus,6



#define GPIOinit	b'00000000'	; all io initiate as LOW
#define TRISIOinit	b'11111011'	; configure NFET_Gate_Port as output 
#define	OPTIONinit	b'11000000'	; no wakup, no pullup, Clock 1:2
;#define	ADCON0init	b'01000001'	; gP0 analog, chanel 00,enable
#define	ADCON0init	b'10000101'	; gP1 analog, chanel 01,enable


	init206
	goto	start



;******************************************************************************
;Subroutines
;******************************************************************************

;******************************************************************************
;Subroutines
;******************************************************************************

#define	V11.0	b'01000000'
#define	V12.0	b'01100000'
#define V12.6	b'01110101'
#define	V13.7	b'10011110'
#define	V14.7	b'10101011'

vtable		addwf	PCL,F
		 dt	5  *(1+1) -1

		 dt	V11.0, 0xFA

		 dt	V12.0, 0xF0

		 retlw	V12.6
		 retlw	0x30

		 retlw  V13.7
		 retlw	0x10

		 retlw  V14.7
		 retlw	0x04
	
;******************************************************************************
;Subroutines
;******************************************************************************

calltrap	if_not	TMR0IF
		 retlw	0
		bcf	TMR0IF

;		mov_bit	GPIO,3,shdwGP3		;Status,5
;		if_bit	shdwGP3
;		 goto	incbuffer
;		decfsz	InputBuffer,F		; increment/decrement
;		 goto	cntdwn			; InputBuffer
;		goto	incpulse
;incbuffer	incfsz	InputBuffer,F
;		 goto	cntdwn
;						; if more than 128 calls
;						; result in the same GPIO
;						; LoPulse or HiPulse are incremented
;						; if a button was pressed, one value 
;						; will e 255 and one not.
;
;incpulse	if__	Runn_inG,either_or,shdwGP3
;		 goto	chngbuffer
;		incfsz	PulsE,F
;		 goto	cntdwn
;		decf	PulsE,F
;		 goto	cntdwn
;
;chngbuffer	if_not	Runn_inG
;		 goto	lopulse
;		mov	PulsE,HiPulse		; leave LoPulse
;rstpulse					; and HiPulse
;		inv_bit	Runn_inG		; with time values
;		eq	InputBuffer,0x80	
;		clrf	PulsE
;		goto	cntdwn
;
;lopulse		mov	PulsE,LoPulse
;		goto	rstpulse			
;

cntdwn		decfsz	MaxTmr,F
		 retlw	0
		decfsz	MaxTmr+1,F
		 retlw	0
		movfw	TmrVector		; jump to 
		movwf	PCL			; requires retlw there

;******************************************************************************
;Subroutines
;******************************************************************************

		
case0		;ADCON206B 0

		bsf	ADCON0,GO
		btfsc	ADCON0,GO
		 goto	$-1
		eq_	AL,=,ADRES,byte
		settrap206B	.500,usec,displaybits 

		retlw	0
;******************************************************************************
;Subroutines
;******************************************************************************



;#define		AH	STACK-1


case1		
		GOTO	basesearch


;******************************************************************************
;Subroutines
;******************************************************************************

	


displaybits	bcf	GPIO,NFET_Gate
		bcf	pwm_on
		settrap206B	.5,sec, ff
		retlw	0

ff		eq	DH,.7

;		bsf	pwm_on
;		settrap206B	.5,sec, displaybits
;		retlw	0



;		clrC
;xox		if_bit AL, 7
;		 goto	trap
;		rlf	AL,F
;		decfsz	DH,F
;	         goto	xox
;trap		incf	DH,F
	
		goto firstbit

offlight	bcf	GPIO,NFET_Gate
		bcf	pwm_on

		eq 	MaxTmr+1,((.200* .477 ) >> .16) +1
		if_	DH,not_eql,.5,	(byteconst)
		 goto	settmr
		 eq	MaxTmr+1,((.600* .477 ) >> .16) +1
settmr		movlw	morebits
		movwf	TmrVector
		retlw	0

morebits	decfsz	DH,F
		 goto nextbit
		settrap206B	1,msec,case0
		retlw	0


;******************************************************************************
;Subroutine: control voltage of battery
;******************************************************************************


cntrlV
	if_	AL,lss,V11.0,		(byteconst);undervoltage
	 goto	slpy
	if_	AL,lss,.255,		(byteconst); overvoltage
	 goto	ok_V

	settrap206B	2,msec,cntrlV
cincDty	if_	Duty,grtr,.127,		(byteconst)
          retlw	0

incDuty	bcf 	STATUS,C
	if_	Duty,not_eql,FlipDuty,	(byte)
	 bsf	STATUS,C

	incf	Duty,F
	if_NC	
	 incf	FlipDuty,F
	if_C	
	 decf	FlipDuty,F
	retlw	0			

deccDuty	bcf 	STATUS,C
	if_	Duty,not_eql,FlipDuty,	(byte)
	 bsf	STATUS,C

	decf	Duty,F
	if_C	
	 incf	FlipDuty,F
	if_NC	
	 decf	FlipDuty,F
	retlw	0	



slpy	if_not	GPIO,NFET_Gate
	 sleep
	bcf	GPIO,NFET_Gate
	mov	Duty,FlipDuty
	sleep

afterwdt	call	case0	;ADC0
;	clrf	AH
;	call displaybits
	if_	AL,lss,V12.0,		(byteconst)
	 goto	slpy
	goto	cntrlV
					;emergency stop


ok_V	;if_	AL,lss,(V12.0+V13.7 )/2, (byteconst)
	; clrf	Vcase
	;if_bit	Lamp_on		; lamp on?
	; goto	case1


Vcharge	
	settrap206B	.16,sec,Vcharge
	if_	AL,lss,V14.7,	(byteconst)
	 goto	moreadc
	if_	AL,grtr,VoltMem,(byte)
	 goto	moreadc
	decfsz	NoCounter,F
	 goto	try10	

	eq	NoCounter,.2
	eq	Duty,.3
	movwf	FlipDuty
	settrap206B	.5,msec,Vhold

moreadc	mov	AL,VoltMem
	eq	NoCounter,.10
try10	
	retlw	0


Vhold   settrap206B	.500,msec,Vhold

	if_	AL,lss,V13.7-.2,	(byteconst)
	 goto	Vrecharge

	if_ 	AL,grtr_eql,VoltMem,	(byte)
	 goto	cincDty
	mov	AL,VoltMem
	retlw 0


	
Vrecharge 
	settrap206B	.500,msec,Vrecharge
	if_	AL,grtr,VoltMem	,	(byte)
	 goto	risingV
	if_	Duty,lss,.1,		(byteconst)
	 goto	risingV

risingV	mov	AL,VoltMem
	if_	AL,lss,V13.7+3,		(byteconst)
	 goto	moreadc	

	goto	Vhold


		
start	eq	Duty,Dutyinit
	mov	Duty,FlipDuty
	clrf	SystemStatus
	bcf	GPIO,NFET_Gate
	mov_bit	GPIO,3,Runn_inG
	eq	InputBuffer,0x80
	settrap206B	1,msec,case0

MAIN	btfsc	TMR0,7
	 goto	$-1
flip	movlw	1<<NFET_Gate			; duty cycle
	if_bit	pwm_on
	 xorwf	GPIO,F
	xorwf	SystemStatus,F
	if__	TMR0IF,not_but, SystemStatus,NFET_Gate
	 bsf	TMR0IF
	clrwdt
	comf	FlipDuty,F
	movfw	FlipDuty
	movwf	TMR0

	btfsc	FlipDuty,7	; smaller cycle
	 goto	MAIN		

	call	calltrap	; now is time for 256cycles


;
;
;updown
;	bcf nega_bit
;	if_	Duty,not_eql,FlipDuty,	(byte)
;	 bsf	nega_bit
;
;	if_bit	go_dwn
;	 goto	neg	
;	incf	Duty,F
;	if_not	nega_bit	
;	 incf	FlipDuty,F
;	if_bit	nega_bit	
;	 decf	FlipDuty,F
;	if_	Duty,grtr,.252,		(byteconst)
;	 bsf	go_dwn
;	 goto	enupdn
;neg	decf	Duty,F
;	if_not	nega_bit	
;	 decf	FlipDuty,F
;	if_bit	nega_bit	
;	 incf	FlipDuty,F
;	if_	Duty,lss,.4,		(byteconst)
;	 bcf	go_dwn
;enupdn
;
;
	btfss	TMR0,7		
	 goto	$-1
	 goto	MAIN



firstbit	movf	DH,F
		if_any AL, 7, STATUS, Z		;AH,7
		 goto nextbit-1
		clrC
		rlf	AL,F
;		rlf	AH,F
		decf	DH,F
		goto	firstbit

		incf	DH,F
nextbit		clrC				;restore AL
		rlf	AL,F
;		rlf	AH,F
;
;		bcf	GPIO,disport		;red LED on
		movlw	((.200* .477 ) >> .16) +1
		skpC
		 goto	wdelay
		movlw	((.1000  * .477 ) >>.16) +1

;		bsf	pwm_on
;		settrap206B	.5,sec, displaybits
;		retlw	0

		bsf	AL,0			;restore AL
;		bsf	GPIO,disport		;green LED on

wdelay		movwf	MaxTmr+1
	
		mov_bit	SystemStatus,NFET_Gate,GPIO,NFET_Gate
		bsf	pwm_on
		movlw	offlight
		movwf	TmrVector
		retlw	0





linearze


#define MdB	STACK-0
#define LoB	STACK-1
#define HiB	STACK-2

#define MdD	STACK-3
#define LoD	STACK-4
#define HiD	STACK-5
  
 		eq_	MdB,=,.1,	lit8
		call	vtable
		movwf	LoB
		if_	AL,>,LoB,	byte
		 goto	bases
exbdry		do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	MdD
		goto done

bases		movlw	0
		call	vtable
		movwf	MdB
		call	vtable
		movwf	HiB
		if_	AL,>=,HiB,	byte
		 goto exbdry

basesearch	do_	MdB,=,MdB,-,(1+1),lit8 
		movfw	MdB
		call	vtable
		movwf	LoB
		if_	AL,>=,LoB,	byte
		 goto 	binsearch
		eq_	HiB,=,LoB,	byte
		goto	basesearch

binsearch	do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	LoD
		do_	MdB,=,MdB,+,(1+1),	lit8
		movfw	MdB
		call	vtable
		movwf	HiD

binloop		do_	MdB,=,LoB,+,HiB,	(byte)
		rrf	MdB,F
		do_	MdD,=,LoD,+,HiD,	(byte)
		rrf	MdD,F
		
		if_	AL,>,MdB,		(byte)
		 goto	higher

		skpNZ				; AL equal MdB
		 goto	done

		eq_	HiB,=,MdB,	byte
		eq_	HiD,=, MdD,	byte
		goto	binloop
higher		eq_	LoB,=,MdB,	byte
		eq_	LoD,=,MdD,	byte
		goto	binloop

done		
		if_	Duty,not_eql,FlipDuty	,	(byte)
		 goto	negative
		mov	MdD,Duty
		mov	MdD,FlipDuty
	        goto	xitcase1
negative	mov	MdD,Duty
		comf	Duty,W
		movwf	FlipDuty
		

xitcase1
		settrap206B	.500,usec,displaybits		
		retlw	0



	end