;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..5 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F222	; list directive to define processor
	#include  ..\macros3c.asm
	config222
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************

;	IFDEF __10F222
;	cblock 0x09				; var starting at  0x09
;	 x
;	endc
;	ENDIF
;
	cblock _MINRAM
	 SystemStatus,TimerVector,TimeCounter:2
	 x,ADCAvr:2,ADCDif,WestCounter

	endc

#define STACK	_MAXRAM

#define	TMR07Bit	SystemStatus,7
#define	Move_Neutral	SystemStatus,6


#define GPIOinit	b'00000110'	; all OUTPUT initiate as HIGH
#define TRISIOinit	b'11111001'	; configure GP1,2 as output 
#define	OPTIONinit	b'11000011'	; no wakup, no pullup, Clock 1:16
#define	ADCON0init	b'01000001'	; gP0 analog, chanel 00,enable
;#define	ADCON0init	b'10000101'	; gP1 analog, chanel 01,enable


	init2xx

t_used = 2
afterwdt 

	eq_	SystemStatus,=,0,lit8
	eq_	x,=,.200,lit8
	settrap .3000,msec,eastsweep,TimeCounter,TimerVector
	goto	ploop
;
sendbyte
	setC
	clrf	x
#define port 2
baudnextbit	
		
	movfw	GPIO
	movwf	STACK
	movfw	x
	andwf	INDF,W
	if_Z			;or load GPIO,and mask,ior mask, save
	 bcf	STACK,port
	if_NZ
	 bsf	STACK,port
	movfw	STACK
	movwf	GPIO			; electrical change occurs now
;
;	btfss	x,3			; adjust timing 57600baud = 17.36us
;	 goto	noextradelay			; call	zerocall
;	goto	$+1			; bit 3 is 3 cycles longer
;	goto	$+1
;noextradelay
#define	looptime .14
	delay 	.17-looptime		; delay to adjust for other baud rates
	
	rlf	x,F
	if_NC
	 goto   baudnextbit
	delay	.17-.7			; last data bit

	bsf	GPIO,port		; start of stop bit
	retlw	0



#define	AL	ADRES	

ADC	


	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1

;	eq_	FSR,=,AL,		lit8
;	call	sendbyte

	do_	ADCDif,=,ADCDif,-,ADCAvr,	byte
	eq_	ADCDif,=,ADCAvr,		byte	



	eq_	ADCAvr+1,=,0,		lit8
	eq_	ADCAvr,=,AL,		byte
	eq_	x,=,.3,			lit8

moreadc
	delay	.500
	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1

	do_	ADCAvr,=,ADCAvr,+,AL,	byte
	if_C
	 incf	ADCAvr+1,F

	decfsz	x,F
	 goto moreadc

	shr_	ADCAvr,			word
	shr_	ADCAvr,			word


	eq_	FSR,=,ADCAvr,		lit8
	call	sendbyte

	do_	ADCDif,=,ADCDif,-,ADCAvr,	byte
	eq_	ADCDif,=,ADCAvr,		byte	

	retlw	0



	
MAIN	
	


ploop	if_bit	TMR0,7
	 goto	set7
	if_not	TMR07Bit
	 goto	clred
	bcf	TMR07Bit
	decfsz	TimeCounter,F
	 goto	clred
	decfsz	TimeCounter+1,F
	 goto    clred
	movfw	TimerVector
	movwf	PCL

set7	bsf	TMR07Bit


clred					; fast loop
	goto	ploop


neutralcycle
	call ADC

	settrap .3800,msec,neutralcycle,TimeCounter,TimerVector

	if_	ADCAvr,>,0x70, lit8
	 goto	gowest					;come back in 3 sec
	 
	decfsz	x,F
	 goto	ploop

gowest	
	settrap .1,sec,endgowest,TimeCounter,TimerVector
	if_	WestCounter,>,.200,lit8
	 goto	ploop
	incf	WestCounter,F
	bcf	GPIO,2
	goto	ploop
endgowest
	
	bsf	GPIO,2
	settrap 3,sec,neutralcycle,TimeCounter,TimerVector
	eq_	x,=,.60,lit8				; if not neutral
	goto	ploop				; come back in 180sec


eastsweep
	bcf	GPIO,1
	settrap	1,sec,eastsw2,TimeCounter,TimerVector
	goto	ploop

eastsw2	bsf	GPIO,1
	settrap	1,sec,eastsw3,TimeCounter,TimerVector
	goto	ploop
	
eastsw3	call	ADC
	settrap	1,sec,eastsweep,TimeCounter,TimerVector
	
;	goto	eastsw2		test
	clrf	WestCounter
	if_	ADCAvr,>, 0x81, lit8
         goto	neutralcycle
	decfsz	x,F
	 goto	ploop		
	goto	neutralcycle

	end