
;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..5 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  ..\macros3b.asm
	config683
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************

	IFDEF __10F222
	cblock 0x09				; var starting at  0x09

	endc
	ENDIF

	cblock 0x20
	 SystemStatus,TimerVector
	 TimerTick,TimeCounter:2,AsyncCounter:2
	 x
	endc
#define	E1	0x1000
#define	TMR07Bit	SystemStatus,7
#define STACK	0x2F

#define Lo_Intensity	.8
#define Hi_Intensity	.18


#define GPIOinit	b'00000000'	; 0,1,2 OUTPUT initiate as LOW
#define TRISIOinit	b'11111000'	; configure 0,1,2 as       OUTPUT 
#define	OPTIONinit	b'11000000'	; no wakeup, no pullup, clock 1:2
#define ANSELinit 	B'01111000' 	; ADC Frc clock, AN3(GP4) as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on
#define PR2init		.40
#define CCPR1Linit      .10
#define CCP1CONinit	b'00001100'	; enable pwm
#define T2CONinit       b'00000100'	; switch on TMR2

	org 0x00
	init683
	goto	MAIN


#define	NFET_Gate_Port	GPIO,2


afterwdt 
	
MAIN			;start with Lo_intensity
	
cycle	settrap206B .500,msec,ADC,TimeCounter,TimerVector


ploop
;	if_not	PIR1,TMR2IF
;	 goto	t0	
;	bcf	PIR1,TMR2IF
;	eq	STACK,=,
;	bsf	GPIO,2
;	
;	bCf	GPIO,2
;	clrf	TMR2
;
t0	if_not	INTCON,T0IF
	 goto	ploop
	bcf	INTCON,T0IF
	decfsz	TimeCounter,F
	 goto	ploop
	decfsz	TimeCounter+1,F
	 goto   ploop
 	eq	CCP1CON,	b'00000000'	; disable pwm
	bcf	GPIO,2
	dlay	.20

	movfw	TimerVector
	movwf	PCL


clred
;	movfw	TimerTick
;	subwf	TMR0,W
;	andlw	B'11110000'
;	skpZ

	 goto	ploop




async	decfsz	AsyncCounter,F
	 goto	ploop
	decfsz	AsyncCounter+1,F
	 goto	ploop			; 7msec to 158ms check input

	goto 	cycle

ADC	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1

			;		eq	x,.0
			;testloop		incfsz  x,F
	goto linearze

	goto $		; loop
	
vtable	addwf	PCL,F
	dt	2* (1+1)-1
	dt .32,	Lo_Intensity
	dt .240,Hi_Intensity

#define MdB	STACK-0
#define LoB	STACK-1
#define HiB	STACK-2

#define MdD	STACK-3
#define LoD	STACK-4
#define HiD	STACK-5
  
#define	AL	ADRESH
;#define AL	x	;test
 
linearze	eq_	MdB,=,.1,	lit8
		call	vtable
		movwf	LoB
		if_	AL,>,LoB,	byte
		 goto	bases
exbdry		do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	MdD
		goto done

bases		movlw	0
		call	vtable
		movwf	MdB
		call	vtable
		movwf	HiB
		if_	AL,>=,HiB,	byte
		 goto exbdry

basesearch	do_	MdB,=,MdB,-,(1+1),lit8 
		movfw	MdB
		call	vtable
		movwf	LoB
		if_	AL,>=,LoB,	byte
		 goto 	binsearch
		eq_	HiB,=,LoB,	byte
		goto	basesearch

binsearch	do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	LoD
		do_	MdB,=,MdB,+,(1+1),	lit8
		movfw	MdB
		call	vtable
		movwf	HiD

binloop		do_	MdB,=,LoB,+,HiB,	(byte)
		rrf	MdB,F
		do_	MdD,=,LoD,+,HiD,	(byte)
		rrf	MdD,F
		
		if_	AL,>,MdB,		(byte)
		 goto	higher

		skpNZ				; AL equal MdB
		 goto	done

		eq_	HiB,=,MdB,	byte
		eq_	HiD,=, MdD,	byte
		goto	binloop
higher		eq_	LoB,=,MdB,	byte
		eq_	LoD,=,MdD,	byte
		goto	binloop

done	
		;e_q	E1,[,x,byte,]=,MdD,byte		
;		e_q_	R ,=,E1,byte,[,x  ,byte
		eq_	CCPR1L,=,MdD,	byte

;		goto	testloop
		eq	 CCP1CON,	b'00001100'	; enable pwm

		goto	cycle
	end