
;***********************************************************************
;*   This file is the firmware to implement 
;*   GPIO 2 Transistor output driver                                *
;*    File Version:                                                 *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  macros3b.asm
	config683
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************
	cblock _MINRAM
	 SystemStatus,TimerVector
	 TimerTick,TimeCounter:2;,AsyncCounter:2
	 V40,V12
	endc
#define	E1	0x1000
#define	TMR07Bit	SystemStatus,7
#define STACK	_MAXRAM

#define Lo_Intensity	.8
#define Hi_Intensity	.18


#define GPIOinit	b'00000000'	; 0,1,2 OUTPUT initiate as LOW
#define TRISIOinit	b'11011010'	; configure 0,2,5 as OUTPUT, 1,3,4 as INPUT 
#define	OPTIONinit	b'11000000'	; no wakeup, no pullup, clock 1:2
#define ANSELinit 	B'01111000' 	; ADC Frc clock, AN3(GP4) as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on
#define PR2init		.40
#define CCPR1Linit      .0
#define CCP1CONinit	b'00000000'	; disable pwm, pwmbits 00
#define T2CONinit       b'00000100'	; switch on TMR2

	




	org 0x00
	init683
	goto	MAIN

cADC	eq_	ADCON0,=,b'00001101',lit8	; left justified , AN3, on
	dlay	6
	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1
	
	eq_	V40,=,ADRESH,byte

 
	eq_	ADCON0,=,b'00000101',lit8	; left justified , AN1, on
	dlay 	6
	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1

	do_	V12,=,V40,-,ADRESH,byte
	return


#define	Reached_Endvolt	SystemStatus,0


afterwdt 
	
MAIN	
	cblock
	 DispCounter:2,DisprVector,x
	endc
	eq_	DispCounter,=,0x0101,	lit16
	movlw	initdis
	movwf	DisprVector

	eq_	FSR,=,V12,		lit8	;variable to display


	settrap206B .3000,msec,fADC,TimeCounter,TimerVector
	movlw	b'11110011'	; disable pwm
	andwf	CCP1CON,F
	bcf	Reached_Endvolt
	goto ploop	;start with test
	
cycle	settrap206B .1000,msec,ADC,TimeCounter,TimerVector

plen	movlw	b'00001100'	; enable pwm
	iorwf	CCP1CON,F

ploop
;	if_not	PIR1,TMR2IF
;	 goto	t0	
;	bcf	PIR1,TMR2IF
;	eq	STACK,=,
;	bsf	GPIO,2
;	
;	bCf	GPIO,2
;	clrf	TMR2
;
t0	if_not	INTCON,T0IF
	 goto	ploop
	bcf	INTCON,T0IF


black	macro	Gbit
	banksel	Bank1
	 bsf	TRISIO,Gbit
	banksel	Bank0	; port  input = black
	endm   
red	macro   Gbit
	bcf	GPIO,Gbit
	banksel	Bank1
	 bcf	TRISIO,Gbit
	banksel	Bank0	; port  output,LOW = red
	endm
blue	macro   Gbit
	bsf	GPIO,Gbit
	banksel	Bank1
	 bcf	TRISIO,Gbit
	banksel	Bank0	; port  output,HIGH = blue
	endm


	decfsz	DispCounter,F
	 goto	disp_xit
	decfsz	DispCounter+1,F
	 goto   disp_xit
 
	movfw	DisprVector
	movwf	PCL



initdis	eq_	x,=,b'10000000', lit8	; bit 7

frstbit	movfw	x			; omit leading zeros
	andwf	INDF,W
	bNZ	long			; its a 1, start display
	rrf	x,F
	skpC				; underflow ?
	 goto	frstbit
	rlf	x,F			; send bit 0 anyway

strtdis	movfw	x
	andwf	INDF,W
	skpZ	
	 goto	long
	settrap206B .100,msec,pause,DispCounter,DisprVector
	red 5
 	goto disp_xit

long	settrap206B .400,msec,pause,DispCounter,DisprVector
 	blue 5
 	goto disp_xit	

pause	settrap206B .200,msec,rsmedis,DispCounter,DisprVector
	black 5
 	goto disp_xit
 	
rsmedis	rrf	x,F	;	next bit?
	bNC	strtdis	
	black 5
	settrap206B .5,sec,initdis,DispCounter,DisprVector

;
;
disp_xit

	decfsz	TimeCounter,F
	 goto	ploop
	decfsz	TimeCounter+1,F
	 goto   ploop
 
	movfw	TimerVector
	movwf	PCL


clred
;	movfw	TimerTick
;	subwf	TMR0,W
;	andlw	B'11110000'
;	skpZ

	 goto	ploop


;
;
;async	decfsz	AsyncCounter,F
;	 goto	ploop
;	decfsz	AsyncCounter+1,F
;	 goto	ploop			; 7msec to 158ms check input
;
;	goto 	cycle
;

ADC	movlw	b'11110011'	; disable pwm
	andwf	CCP1CON,F
	bcf	GPIO,2	        ;make sure transistor is low
	movlw	.10
	movwf	STACK
	decfsz	STACK,F
	 goto	$-1

	call	cADC

;	movlw	b'00001100'	; enable pwm
;	iorwf	CCP1CON,F

	if_not	Reached_Endvolt
	 goto	panelv	
	red 5
	if_ V12,>,0x08,lit8	;hold at 13.8V
	 goto decL

	if_ V12,>,0x05,lit8	; hyteresis 0.2 V
	 goto	cycle

panelv	if_	V12,<,0x35,lit8
	 goto trymore
	 bsf	Reached_Endvolt
	 goto cycle
	 
	 
trymore	if_	V40,>,.256*.375/.500,lit8
         goto	incCC

	if_	V40,>,.256*.365/.500,lit8	; hysteresis 0.1 Volt
	 goto	cycle



decL	if_not	CCP1CON,DC1B0 
	 goto	ddcb1
	bcf CCP1CON,DC1B0 
	goto	cycle	
ddcb1	if_not	CCP1CON,DC1B1 
	 goto	dincL
	bcf CCP1CON,DC1B1
	bsf CCP1CON,DC1B0
	goto	cycle

dincL	movf	CCPR1L,F
	skpNZ			;all zero
	 goto	MAIN		; cannot extract any juice..
				;wait for panel to be 40Volts		

	bsf CCP1CON,DC1B1
	bsf CCP1CON,DC1B0


	decf	CCPR1L,F
	goto	cycle		

incCC	if_	CCPR1L,>,.18,lit8
	 goto	cycle

	if_bit	CCP1CON,DC1B0 
	 goto	dcb1

	bsf CCP1CON,DC1B0 
	goto	cycle	
dcb1	if_bit	CCP1CON,DC1B1 
	 goto	incL
	bsf CCP1CON,DC1B1
	bcf CCP1CON,DC1B0
	goto	cycle

incL	bcf CCP1CON,DC1B1
	bcf CCP1CON,DC1B0


	incf	CCPR1L,F
	goto cycle	


fADC	call	cADC
	
;	if_	V12,>,.245,lit8
;	 goto	goblack
;
;	if_ V12,>,., lit8
;	 goto	goblue
;	if_	V12,>,.29,lit8		; battery voltage 10V+V12/.100
;	goto	gored
;	
;
;goblack	
;	black
;	settrap206B .1000,msec,fADC,TimeCounter,TimerVector	
;	goto ploop
;
;gored   
;	red
;	settrap206B .1000,msec,fADC,TimeCounter,TimerVector	
;	goto ploop
;goblue
;	blue
;	settrap206B .1000,msec,fADC,TimeCounter,TimerVector	
;	goto ploop
;
;

;	if_	V12,<,.40,lit8	; no battery detected
;	 goto tstpan



tstpan	red 5
	if_	V40,<, .240,lit8
	 goto	MAIN	
	black 5
	goto	cycle

	end