
;***********************************************************************
;*   This file is the firmware to implement 
;*   GPIO 2 Transistor output driver                                *
;*    File Version:                                                 *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  ..\macros3b.asm
	config683
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************
	cblock __MINRAM
	 SystemStatus,TimerVector
	 TimerTick,TimeCounter:2,AsyncCounter:2
	 x,V40,V12,wait6
	endc
#define	E1	0x1000
#define	TMR07Bit	SystemStatus,7
#define STACK	0x2F

#define Lo_Intensity	.8
#define Hi_Intensity	.18


#define GPIOinit	b'00000000'	; 0,1,2 OUTPUT initiate as LOW
#define TRISIOinit	b'11111011'	; configure 0,1 INPUT,2 as       OUTPUT 
#define	OPTIONinit	b'11000000'	; no wakeup, no pullup, clock 1:2
#define ANSELinit 	B'01111010' 	; ADC Frc clock, AN3(GP4),AN1 as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on
#define PR2init		.40
#define CCPR1Linit      .0
#define CCP1CONinit	b'00000000'	; disable pwm, pwmbits 00
#define T2CONinit       b'00000100'	; switch on TMR2

	org 0x00
	init683
	goto	MAIN



black	macro

	eq_	TRISIO,=, TRISIOinit|b'0010000',lit8	; port 5 input = black
	endm
red	macro
	bcf	GPIO,5
	eq_	TRISIO,=,TRISIOinit & b'1101111',lit8	; port 2 output,LOW = red
	endm
blue	macro
	bsf	GPIO,5
	eq_	TRISIO,=,TRISIOinit & b'1101111',lit8	; port 2 output,HIGH = blue
	endm
	


afterwdt 
	
MAIN	eq_	wait6,=,.6,lit8
	black
	settrap206B .3000,msec,fADC,TimeCounter,TimerVector
	movlw	b'11110011'	; disable pwm
	andwf	CCP1CON,F

	goto ploop	;start with test
	
cycle	black
	;	settrap206B .6,sec,ADC,TimeCounter,TimerVector


	settrap206B .1000,msec,ADC,TimeCounter,TimerVector
	movlw	b'00001100'	; enable pwm
	iorwf	CCP1CON,F

ploop
;	if_not	PIR1,TMR2IF
;	 goto	t0	
;	bcf	PIR1,TMR2IF
;	eq	STACK,=,
;	bsf	GPIO,2
;	
;	bCf	GPIO,2
;	clrf	TMR2
;
t0	if_not	INTCON,T0IF
	 goto	ploop
	bcf	INTCON,T0IF

	decfsz	TimeCounter,F
	 goto	ploop
	decfsz	TimeCounter+1,F
	 goto   ploop
 	movlw	b'11110011'	; disable pwm
	andwf	CCP1CON,F
	bcf	GPIO,2
	movlw	.6
	movwf	STACK
	decfsz	STACK,F
	 goto	$-1
	movfw	TimerVector
	movwf	PCL


clred
;	movfw	TimerTick
;	subwf	TMR0,W
;	andlw	B'11110000'
;	skpZ

	 goto	ploop


;
;
;async	decfsz	AsyncCounter,F
;	 goto	ploop
;	decfsz	AsyncCounter+1,F
;	 goto	ploop			; 7msec to 158ms check input
;
;	goto 	cycle
;
#define	AL	ADRESH
ADC	eq_	ADCON0,=,b'00001101',lit8	; left justified , AN3, on
	

	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1
	
	eq_	V40,=,AL,byte

 
	eq_	ADCON0,=,b'00000101',lit8	; left justified , AN1, on

	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1

	do_	V12,=,V40,-,AL,byte

	eq_	FSR,=,V12,lit8

	decfsz	wait6,F
	 goto nodis

	eq_	wait6,=,.6,lit8
	goto 	initdis




nodis	if_	V40,>,.256*.375/.500,lit8
         goto	incCC

	if_	V40,>,.256*.365/.500,lit8	; hysteresis 0.1 Volt
	 goto	cycle



	if_not	CCP1CON,DC1B0 
	 goto	ddcb1
	bcf CCP1CON,DC1B0 
	goto	cycle	
ddcb1	if_not	CCP1CON,DC1B1 
	 goto	dincL
	bcf CCP1CON,DC1B1
	bsf CCP1CON,DC1B0
	goto	cycle

dincL	movf	CCPR1L,F
	skpNZ			;all zero
	 goto	MAIN		; cannot extract any juice..
				;wait for panel to be 40Volts		

	bsf CCP1CON,DC1B1
	bsf CCP1CON,DC1B0


	decf	CCPR1L,F
	goto	cycle		

incCC	if_	CCPR1L,>,.18,lit8
	 goto	cycle

	if_bit	CCP1CON,DC1B0 
	 goto	dcb1

	bsf CCP1CON,DC1B0 
	goto	cycle	
dcb1	if_bit	CCP1CON,DC1B1 
	 goto	incL
	bsf CCP1CON,DC1B1
	bcf CCP1CON,DC1B0
	goto	cycle

incL	bcf CCP1CON,DC1B1
	bcf CCP1CON,DC1B0


	incf	CCPR1L,F
	goto cycle	


fADC	eq_	ADCON0,=,b'00001101',lit8	; left justified , AN3, on
	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1


	if_	AL,<, .250,lit8
	 goto	MAIN	
	goto	cycle




initdis	eq_	x,=,b'10000000', lit8	; bit 7

frstbit	movfw	x			; omit leading zeros
	andwf	AL,W
	bC	strtdis			; its a 1, start display
	rrf	x,F
	skpC				; underflow ?
	 goto	frstbit
	rlf	x,F			; send bit 0 anyway

strtdis	movfw	x
	andwf	INDF,W
	skpNC	
	 goto	long
	settrap206B .200,msec,pause,TimeCounter,TimerVector
	red
 	goto ploop

long	settrap206B .800,msec,pause,TimeCounter,TimerVector
 	blue
 	goto ploop	

pause	settrap206B .200,msec,rsmedis,TimeCounter,TimerVector
	black
 	goto ploop
 	
rsmedis	rrf	x,F	;	next bit?
	bC	cycle	;	done, wait for next measurement
	goto	strtdis


		goto	cycle
	end