
;***********************************************************************
;*   This file is the firmware to implement 
;*   GPIO 2 Transistor output driver                                *
;*    File Version:                                                 *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  ..\macros3b.asm
	config683
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************
	cblock __MINRAM
	 SystemStatus,TimerVector
	 TimerTick,TimeCounter:2,AsyncCounter:2
	 x
	endc
#define	E1	0x1000
#define	TMR07Bit	SystemStatus,7
#define STACK	0x2F

#define Lo_Intensity	.8
#define Hi_Intensity	.18


#define GPIOinit	b'00000000'	; 0,1,2 OUTPUT initiate as LOW
#define TRISIOinit	b'11111000'	; configure 0,1,2 as       OUTPUT 
#define	OPTIONinit	b'11000000'	; no wakeup, no pullup, clock 1:2
#define ANSELinit 	B'01111000' 	; ADC Frc clock, AN3(GP4) as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on
#define PR2init		.40
#define CCPR1Linit      .0
;#define CCP1CONinit	b'00001100'	; enable pwm
#define T2CONinit       b'00000100'	; switch on TMR2

	org 0x00
	init683
	goto	MAIN


#define	NFET_Gate_Port	GPIO,2


afterwdt 
	
MAIN	settrap206B .3000,msec,fADC,TimeCounter,TimerVector
	goto ploop	;start with test
	
cycle	settrap206B .1000,msec,ADC,TimeCounter,TimerVector
	eq	 CCP1CON,	b'00001100'	; enable pwm


ploop
;	if_not	PIR1,TMR2IF
;	 goto	t0	
;	bcf	PIR1,TMR2IF
;	eq	STACK,=,
;	bsf	GPIO,2
;	
;	bCf	GPIO,2
;	clrf	TMR2
;
t0	if_not	INTCON,T0IF
	 goto	ploop
	bcf	INTCON,T0IF
	decfsz	TimeCounter,F
	 goto	ploop
	decfsz	TimeCounter+1,F
	 goto   ploop
 	eq	CCP1CON,	b'00000000'	; disable pwm
	bcf	GPIO,2
	dlay	.20

	movfw	TimerVector
	movwf	PCL


clred
;	movfw	TimerTick
;	subwf	TMR0,W
;	andlw	B'11110000'
;	skpZ

	 goto	ploop




async	decfsz	AsyncCounter,F
	 goto	ploop
	decfsz	AsyncCounter+1,F
	 goto	ploop			; 7msec to 158ms check input

	goto 	cycle

ADC	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1

#define	AL	ADRESH

	if_	AL,>,.256*.375/.500,lit8
         goto	incCC
;
;
;	if_not	CCP1CON,DC1B0 
;	 goto	ddcb1
;	bcf CCP1CON,DC1B0 
;	goto	cycle	
;ddcb1	if_not	CCP1CON,DC1B1 
;	 goto	dincL
;	bcf CCP1CON,DC1B1
;	bsf CCP1CON,DC1B0
;	goto	cycle
;
;dincL	bsf CCP1CON,DC1B1
;	bsf CCP1CON,DC1B0


	decfsz	CCPR1L,F
	 goto	cycle
	goto MAIN		

incCC	if_	CCPR1L,>,.18,lit8
	 goto	cycle

;	if_bit	CCP1CON,DC1B0 
;	 goto	dcb1
;
;	bsf CCP1CON,DC1B0 
;	goto	cycle	
;dcb1	if_bit	CCP1CON,DC1B1 
;	 goto	incL
;	bsf CCP1CON,DC1B1
;	bcf CCP1CON,DC1B0
;	goto	cycle
;
;incL	bcf CCP1CON,DC1B1
;	bcf CCP1CON,DC1B0


	incf	CCPR1L,F
	goto cycle	


fADC	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1


	if_	AL,<, .250,lit8
	 goto	MAIN	
	goto	cycle



		goto	cycle
	end