;***********************************************************************
;*   This file is the firmware to implement a transistor output driver                                *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  ..\macros3b.asm
	config683
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************



	cblock __MINRAM	
	
	 SystemStatus,TimerVector,TimeCounter:2
	 

	endc

#define	TMR07Bit	SystemStatus,7
#define STACK	__MAXRAM

#define GPIOinit	b'00000110'	; all OUTPUT initiate as HIGH
#define TRISIOinit	b'11111001'	; configure GP1,2 as output 
#define	OPTIONinit	b'11000001'	; no wakup, no pullup, Clock 1:4
#define ANSELinit 	B'01110001' 	; ADC Frc clock, AN0(GP0) as analog
#define	ADCON0init	b'00000001'	; left justified , AN0, on



	nointr683
	init683

afterwdt 
	settrap206B .3000,msec,ADC,TimeCounter,TimerVector
	goto	ploop
	
MAIN	
	
cycle	settrap206B .60,sec,ADC,TimeCounter,TimerVector


ploop	if_bit	TMR0,7
	 goto	set7
	if_not	TMR07Bit
	 goto	clred
	bcf	TMR07Bit
	decfsz	TimeCounter,F
	 goto	clred
	decfsz	TimeCounter+1,F
	 goto    clred
	movfw	TimerVector
	movwf	PCL

set7	bsf	TMR07Bit


clred					; fast loop
	goto	ploop
	goto cycle


ADC	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1

#define	AL	ADRESH


	if_	AL,<, .256 * .15 / .50, lit8
         goto	west
	if_	AL,>, .256 * .35 / .50, lit8
	 goto	east
	 
	goto	cycle 

west	bcf	GPIO,2
	settrap206B .1,sec,endwest,TimeCounter,TimerVector
	goto	ploop
endwest	bsf	GPIO,2
	goto	cycle

east	bcf	GPIO,1
	settrap206B .1,sec,endeast,TimeCounter,TimerVector
	goto	ploop
endeast	bsf	GPIO,1
	goto	cycle
	
	

	end