;***********************************************************************
;*   This file is the firmware to implement a     *
;*   at GPIO 2 Transistor output driver                                *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: A.0                                               *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************

	list      p=10F206	; list directive to define processor
	#include <..\macros2b.asm>
	config206

;	ERRORLEVEL -302				; Get rid of banking messages...

;******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x08
	SystemStatus,CasE,ALT,VoltMem,TenMore,PR2,Duty
	CL,CH,BL,DL
	
	endc
#define STACK 0X1F
#define	IOdir	 b'11001000'

				; GP3	inp
				; GP2	outp
				; GP1	outp
				; GP0	outp
;******************************************************************************
;Reset Vector 
;******************************************************************************
		init206		; processor reset vector
		goto	Init
;		
;displaybits	eq	DL, .10
;		call	wak2delay
;
;
;		eq	DH, .15
;firstbit	movf	DH,F
;		if_any AH, 7, STATUS, Z
;		 goto nextbit-1
;		clrC
;		rlf	AL,F
;		rlf	AH,F
;		decf	DH,F
;		goto	firstbit
;
;		incf	DH,F
;nextbit		clrC				;restore AL
;		rlf	AL,F
;		rlf	AH,F
;
;		bcf	GPIO,5
;		movlw	1
;		skpC
;		 goto	wdelay
;		movlw	5
;		bsf	AL,0			;restore AL
;		bsf	GPIO,5
;
;wdelay		movwf	DL
;
;		movlw	iodir &	b'11011111'			;GP5 outout
;	
;		call	subtrisio
;
;;		movlw	b'00001100'
;;		iorwf	 CCP1CON, F	 ; enable PWM
;;
;		call	wak2delay
;	
;;dis		movlw	b'11110011'
;;		andwf	 CCP1CON, F	 ; disable PWM
;;
;		movlw	iodir |	b'00100000'		;GP5 input
;	
;		call	subtrisio
;
;		eq	BL,1
;		call	wak2delay
;		decfsz	DH,F
;		 goto nextbit
;		retlw	0		
;
		
wak2delay	clrwdt
		decfsz	CL,F
		 goto	$-2
		decfsz	CH,F
		 goto	$-4
		decfsz	BL,F
		 goto	$-6
		retlw	0


;******************************************************************************
;Initialization
;******************************************************************************

;
Init		eq	DL,.10

moreadc		eq	BL,.3		 ; 200ms
		call	wak2delay
		movlw	0x07
		xorwf	GPIO,F
		decfsz	DL,F
		 goto	moreadc
		eq	DL,.10

		movlw	0x0F		;all input
		TRIS	TRISGPIO
		eq	BL,.5		 ; 200ms
		call	wak2delay
		movlw	IOdir
		TRIS	TRISGPIO
		goto	moreadc
;

;
;	ADCON629 0
;
;	if_	case,eql,.1,	(byteconst)
;	 goto	nopwm
; 
;
;
;nopwm	mov STACK,AL
;	mov STACK-1,AH
;;	BANKSEL ADRESL 			;
;;	MOVF 	STACK,W 		;Read lower 8 bits
;;	BANKSEL AL	
;;	MOVWF 	AL 			;Store in GPR space
;
;;
;;	shrr	AL,	(word)			;max 9 bit
;;	shrr	AL,	(word)			;max 8 bit
;;	call	movALduty		;leaves AL = AL div 4
;	
;;	clrf	AH
;;	call displaybits
;;
;
;	if_	AL,lss,.230,		(byteconst)
;	 goto	ok_V
;	eq	case,.1
;	eq	PR2,.250		;emergency stop
;	goto	moreadc
;
;ok_V	if_	AL,lss,b'10000000',	(byteconst)
;	 clrf	case
;	
;
;	movlw	.220		;ALT = 192-AL 
;	subwf	AL,W
;	movwf	ALT
;	skpnZ				;no Zeros
;	 decf	ALT,F
;	comf	ALT,F
;
;blinky	eq	DH,.255			; wait for DL seconds
;	clrf	CH			; blink in the frequency of ALT * 20ms
;	movfw	ALT
;
;loi	incf	CH,F
;	subwf	DH,F
;	skpNC
;	 goto	loi
;mocl	mov	ALT,CL
;
;mobl	
;	bsf	GPIO,2
;	eq	Duty,.3
;	decfsz	Duty,F
;	 goto	$-1
;	bcf	GPIO,2
;	eq	PR2,.36
;	decfsz	PR2,F
;	 goto	$-1
;	decfsz	CL,F
;	 goto	mobl
;	
;
;	movlw	b'00000001'
;	xorwf	GPIO,F
;	decfsz	CH,F
;	 goto	mocl
;
;	decfsz	DL,F
;	 goto	blinky
;
;
;
;
;	movfw	case
;	addwf	PCL,F
;	 goto	case0
;	 goto	case1
;	 goto	case2
;	 goto	case3
;
;case0	if_	AL,lss,b'11000000',	(byteconst)
;	 goto	notmaxV
;	eq	case,.3
;	clrf	TenMore
;	goto	case3
;notmaxV	if_	PR2,lss,.41,		(byteconst)
;	 goto	is25kHz
;	dec_	PR2,			(byte)
;	eq	DL,.10
;	goto	moreadc
;
;is25kHz	eq	DL,.250			;25 seconds
;	goto	moreadc
;	
;
;case1	eq	DL,.10
;	if_	AL,grtr,b'10010000',	(byteconst)
;	 goto	moreadc
;
;	incf	case,F			;case = 2
;	mov	AL,VoltMem
;	goto	moreadc	
;
;
;case2	eq	DL,.5
;	if_	AL,grtr,VoltMem	,	(byte)
;	 goto	risingV
;	if_	PR2,lss,.41,		(byteconst)
;	 goto	risingV
;	dec_	PR2,			(byte)
;
;risingV	mov	AL,VoltMem
;	if_	AL,lss,b'10011000',	(byteconst)
;	 goto	moreadc	
;
;	decf	case,F		 	; case = 1
;	goto	moreadc
;
;case3	eq	DL,.10
;	if_	AL, lss, b'11000000' , 	(byteconst)
;	 goto tenmore
;lowerP	inc_	PR2,			(byte)
;	if_	PR2, lss, .250	   , 	(byteconst)
;	 goto	moreadc
;	eq	case,.1
;	goto	moreadc
;
;tenmore decfsz	TenMore,F
;	 goto	moreadc
;	incf	TenMore,F
;	goto	lowerP


	end
