;***********************************************************************
;*   This file is the firmware to implement a     *
;*   at GPIO 2 Transistor output driver                                *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: A.0                                               *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************

	list      p=10F206	; list directive to define processor
	#include <..\macros2b.asm>
	config206

;	ERRORLEVEL -302				; Get rid of banking messages...

;******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x08
	SystemStatus, shdw_TRISIO,CasE,ALT,VoltMem,TenMore,PR2,Duty
	AL,AH,DL,DH
	
	endc
#define STACK 0X1F
#define	IOdir	 b'00001011'

				; GP3	inp
				; GP2	(in)outp
				; GP1	inp
				; GP0	inp
;******************************************************************************
;Reset Vector 
;******************************************************************************
		init206		; processor reset vector
		goto	Init

		

#define		disport	1
displaybits	movlw	(1<<disport)
		iorwf	shdw_TRISIO,F
		movfw	shdw_TRISIO
		TRIS 	TRISGPIO	;GP2 input

		eq	STACK, .10
		call	wak2delay


		eq	DH, .15
firstbit	movf	DH,F
		if_any AH, 7, STATUS, Z
		 goto nextbit-1
		clrC
		rlf	AL,F
		rlf	AH,F
		decf	DH,F
		goto	firstbit

		incf	DH,F
nextbit		clrC				;restore AL
		rlf	AL,F
		rlf	AH,F

		bsf	GPIO,2
		movlw	1
		skpC
		 goto	wdelay
		movlw	5
		bsf	AL,0			;restore AL
		bsf	GPIO,2

wdelay		movwf	STACK
	
		movlw	0x0F -(1<<disport)
		andwf	shdw_TRISIO,F
		movfw	shdw_TRISIO
		TRIS 	TRISGPIO	;GP2 outout

		call	wak2delay

		movlw	(1<<disport)
		iorwf	shdw_TRISIO,F
		movfw	shdw_TRISIO
		TRIS 	TRISGPIO	;GP2 input

		eq	STACK,.1
		if_	DH,eql,.9,	(byteconst)
		 call	long
		
		call	wak2delay
		decfsz	DH,F
		 goto nextbit
		retlw	0
		
long		eq	STACK,.3
		retlw	0
;		
wak2delay	eq	STACK-1,.100
		clrwdt
		decfsz	STACK-2,F
		 goto	$-2
		decfsz	STACK-1,F
		 goto	$-4
		decfsz	STACK,F
		 goto	wak2delay
		retlw	0

#define		port	0
disC		bcf	GPIO,port	;port goes up when input?
		movlw	0x0F -(1<<port)
		andwf	shdw_TRISIO,F
		movfw	shdw_TRISIO
		TRIS 	TRISGPIO	; discharge C
		retlw 0
;******************************************************************************
;Initialization
;******************************************************************************


;
Init		call	disC
		if port == 1
		 movlw	GP1_Porton     ; configure comparator input
		endif
		if port == 0
		movlw	GP0_Porton
		 endif
		movwf	CMCON0


	 	eq	PR2,.64


	

moreadc	
;	eq	STACK,.3		 ; 200ms
;		call	wak2delay
;		movlw	0x07
;		xorwf	GPIO,F
;		decfsz	DL,F
;		 goto	moreadc
;		eq	DL,.10
;
;		movlw	0x0F		;all input
;		TRIS	TRISGPIO
;		eq	STACK,.5		 ; 200ms
;		call	wak2delay
;		movlw	IOdir
;		TRIS	TRISGPIO
;		goto	moreadc
;;



		inv_bit	SystemStatus,0
		btfss	SystemStatus,0
		 goto	nocomp

;
;		movlw	.4
;		movwf	STACK		; 15 us
;		decfsz	STACK,F
;		 goto	$-1		; 
;		clrwdt
		movlw	1<<port
		iorwf	shdw_TRISIO,F
		movfw	shdw_TRISIO	; GP(port) is input
		TRIS 	TRISGPIO	; charge C


		bsf	CMCON0,CMPON	; comparator on

nocomp		mov	PR2,STACK
loop100		btfsc	CMCON0,CMPOUT  	;btfss	GPIO,port
		 goto	exitloop100

		decfsz	STACK,F		; loop 5us
		 goto	loop100
		
	
exitloop100	bcf	CMCON0,CMPON	;comparator off
		ar_	AL,PR2,minus,STACK,	(byte)
		call	disC
		incf	STACK,F
		nop
		nop
		decfsz	STACK,F		; loop 5 us
		 goto	$-3
		clrf	AH
		call	displaybits
		goto	moreadc

;	if_	case,eql,.1,	(byteconst)
;	 goto	nopwm
; 
;
;
;nopwm	mov STACK,AL
;	mov STACK-1,AH
;;	BANKSEL ADRESL 			;
;;	MOVF 	STACK,W 		;Read lower 8 bits
;;	BANKSEL AL	
;;	MOVWF 	AL 			;Store in GPR space
;
;;
;;	shrr	AL,	(word)			;max 9 bit
;;	shrr	AL,	(word)			;max 8 bit
;;	call	movALduty		;leaves AL = AL div 4
;	
;;	clrf	AH
;;	call displaybits
;;
;
;	if_	AL,lss,.230,		(byteconst)
;	 goto	ok_V
;	eq	case,.1
;	eq	PR2,.250		;emergency stop
;	goto	moreadc
;
;ok_V	if_	AL,lss,b'10000000',	(byteconst)
;	 clrf	case
;	
;
;	movlw	.220		;ALT = 192-AL 
;	subwf	AL,W
;	movwf	ALT
;	skpnZ				;no Zeros
;	 decf	ALT,F
;	comf	ALT,F
;
;blinky	eq	DH,.255			; wait for DL seconds
;	clrf	CH			; blink in the frequency of ALT * 20ms
;	movfw	ALT
;
;loi	incf	CH,F
;	subwf	DH,F
;	skpNC
;	 goto	loi
;mocl	mov	ALT,CL
;
;mobl	
;	bsf	GPIO,2
;	eq	Duty,.3
;	decfsz	Duty,F
;	 goto	$-1
;	bcf	GPIO,2
;	eq	PR2,.36
;	decfsz	PR2,F
;	 goto	$-1
;	decfsz	CL,F
;	 goto	mobl
;	
;
;	movlw	b'00000001'
;	xorwf	GPIO,F
;	decfsz	CH,F
;	 goto	mocl
;
;	decfsz	DL,F
;	 goto	blinky
;
;
;
;
;	movfw	case
;	addwf	PCL,F
;	 goto	case0
;	 goto	case1
;	 goto	case2
;	 goto	case3
;
;case0	if_	AL,lss,b'11000000',	(byteconst)
;	 goto	notmaxV
;	eq	case,.3
;	clrf	TenMore
;	goto	case3
;notmaxV	if_	PR2,lss,.41,		(byteconst)
;	 goto	is25kHz
;	dec_	PR2,			(byte)
;	eq	DL,.10
;	goto	moreadc
;
;is25kHz	eq	DL,.250			;25 seconds
;	goto	moreadc
;	
;
;case1	eq	DL,.10
;	if_	AL,grtr,b'10010000',	(byteconst)
;	 goto	moreadc
;
;	incf	case,F			;case = 2
;	mov	AL,VoltMem
;	goto	moreadc	
;
;
;case2	eq	DL,.5
;	if_	AL,grtr,VoltMem	,	(byte)
;	 goto	risingV
;	if_	PR2,lss,.41,		(byteconst)
;	 goto	risingV
;	dec_	PR2,			(byte)
;
;risingV	mov	AL,VoltMem
;	if_	AL,lss,b'10011000',	(byteconst)
;	 goto	moreadc	
;
;	decf	case,F		 	; case = 1
;	goto	moreadc
;
;case3	eq	DL,.10
;	if_	AL, lss, b'11000000' , 	(byteconst)
;	 goto tenmore
;lowerP	inc_	PR2,			(byte)
;	if_	PR2, lss, .250	   , 	(byteconst)
;	 goto	moreadc
;	eq	case,.1
;	goto	moreadc
;
;tenmore decfsz	TenMore,F
;	 goto	moreadc
;	incf	TenMore,F
;	goto	lowerP


	end
