;***********************************************************************
;*   This file is the firmware to implement a     *
;*   at GPIO 2 Transistor output driver                                *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: A.0                                               *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************

	list      p=12F683	; list directive to define processor
	#include <..\macros3b.asm>
	config683

;	ERRORLEVEL -302				; Get rid of banking messages...

;******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	SystemStatus,case,Duty,VoltMem,TenMore
	AL,AH:3,BL
	MaxTmr:4,TmrVector:2
	CLH:2,DLH:2,CLM:2,DLM:2
	
	endc
#define	Adc_Trap	SystemStatus,0
#define STACK		0x7F

;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000		; processor reset vector
       	nop			; required by in circuit debugger
	goto    Init		; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG     0x004
	return			;IRQ TRAP
;******************************************************************************
;Subroutines
;******************************************************************************
;
;movdutyAL	clrf	AH
;		mov	CCPR1L,AL	;load
;		shll	AL,(word)
;		shll	AL,(word)
;		btfsc	CCP1CON,DC1B0
;		 bsf	AL,0
;		btfsc	CCP1CON,DC1B1
;		 bsf	AL,1
;		retlw 0
;
;

;subtrisio	
;		BANKSEL	Bank1		; 
;		movwf	TRISIO		;
;		BANKSEL	Bank0
;		return
;;		
;
		


settrap	macro	time,unit,vector,useMaxTmr,useTmrVector
		  variable	optn,intime,k,clow,chigh,chi2
k=1
	if unit == msec
k=.1000
	endif
	if unit == sec
k=.1000000
	endif

	; watch out!
	; OSCON:
				;bit 6-4 IRCF<2:0>: Internl Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz


optn = 0		; prescale 1
 
intime = time *k / (1 << optn)
	while	intime > .255*.256 *.256
optn += 1

intime = intime /2
	endw
clow =	intime	& 0xFF
chigh=  (intime >> 8) &0xFF
chi2  =  intime >> .16

	if	clow != 0
chigh+=1
	 if	chigh == .256
chi2 +=1
chigh==0
	 endif
	endif
	if chigh !=0
chi2 +=1
	endif

       if optn > 0	
	banksel	OPTION_REG
	movlw	b'11110000'
	andwf	OPTION_REG,F
	movlw	optn
	iorwf	OPTION_REG,F
	banksel	TMR0
       endif

	movlw	chigh
	movwf	useMaxTmr
	movlw	chi2
	movwf	useMaxTmr+1
;	movlw	0x00FF - (intime & 0xFF)
;	movwf	TMR0
	bcf	INTCON,T0IF		; test in calltrap
	movlw	vector 
	movwf	useTmrVector		; trap set 20 us ....4000sec



	endm

set_trap	macro	time,unit,useReg
		  variable	optn,intime,k,clow,chigh,chi2
k=1
	if unit == msec
k=.1000
	endif
	if unit == sec
k=.1000000
	endif

intime = time *k
clow =	intime	& 0xFF
chigh=  (intime >> 8) &0xFF
chi2  =  intime >> .16

	if	clow != 0
chigh+=1
	 if	chigh == .256
chi2 +=1
chigh==0
	 endif
	endif
	if chigh !=0
chi2 +=1
	endif


	movlw	chigh
	movwf	useReg
	movlw	chi2
	movwf	useReg+1
;	movlw	0x00FF - (intime & 0xFF)
;	movwf	TMR0
	bcf	INTCON,T0IF		; test in calltrap
	; trap set 2 msec ....--16sec without optn)



	endm


calltrap 	clrwdt
;		if_bit	TMR0,7
;	 	 goto	t7hi
;		if_bit	SystemStatus,7
;	  	 bsf	SystemStatus,6     	; Timer0 Interrrupt Overflow Flag
;		bcf	SystemStatus,7 		; replacement for test TMR0IF
;		if_not	SystemStatus,6
	        if_not		INTCON,T0IF
		 retlw	0
		bcf		INTCON,T0IF
;		bcf	SystemStatus,6
		decfsz	MaxTmr+2,F
		 goto usetmr
		decfsz	MaxTmr+3,F
		 goto usetmr

		movfw	TmrVector+1
		movwf	PCL

usetmr		decfsz	MaxTmr,F
		 retlw 0
		decfsz	MaxTmr+1,F
		 retlw 0
		movfw	TmrVector
		movwf	PCL				; must run into a retlw 0!

#define	V11.0	b'00011111'
#define	V12.0	b'01000010'
#define V12.6	b'01011000'
#define	V13.7	b'01111110'
#define	V14.7	b'10011111'



;
;
;calib		;if_not	GPIO,3
;		; goto calib2
;
;
calib1		eq_	BL,=,AL,		(byte)
		do_	BL,=,BL,-, V12.0,	(lit8)
	        skpC
		 goto	scase0

		do_	BL,=,BL,-, (V12.6-V12.0),(lit8)
		skpC
		 goto	scase1
		do_	BL,=,BL,-, (V13.7-V12.6),(lit8)
		skpC
		 goto	scase2
		do_	BL,=,BL,-, (V14.7-V13.7),(lit8)
		skpC
		 goto	scase3
		goto	scase4


;blink1		retlw 0
;		movfw	case
;		addwf	PCL,F
;		 goto scase0
;		 goto	scase1
;		 goto	scase2
;		 goto	scase3

scase0		set_trap .250,msec,MaxTmr+2
		if_not	GPIO,0
		 goto	blink0
		set_trap .750,msec,MaxTmr+2
		goto blink0
	
scase1	
		set_trap .200,msec,MaxTmr+2
		if_not	GPIO,0
		 goto	blink0
		set_trap .575,msec,MaxTmr+2
		goto blink0

scase2		set_trap .150,msec,MaxTmr+2
		if_not	GPIO,0
		 goto	blink0
		set_trap .400,msec,MaxTmr+2
		goto blink0

scase3		set_trap .100,msec,MaxTmr+2
		if_not	GPIO,0
		 goto	blink0
		set_trap .225,msec,MaxTmr+2
		 goto blink0

scase4		set_trap .75,msec,MaxTmr+2
		if_not	GPIO,0
		 goto	blink0
		set_trap .125,msec,MaxTmr+2
		
blink0		movlw	1
		xorwf	GPIO,F

		retlw 0

;calib2		movlw	blink1
;		movwf	TmrVector+1
;		goto    blink1			 


quietadc 	bsf	Adc_Trap
		retlw	0

#define		DH	STACK-2		
#define		disport	0

displaybits	bcf	GPIO,disport
		settrap .5,sec, ff, MaxTmr+2,TmrVector+1
		retlw	0

ff		eq	DH, .15
		goto firstbit

offlight	bcf	GPIO,disport		
		
		eq 	MaxTmr+3,((.200* .500 ) >> .16) +1
		if_	DH,not_eql,.9,	(byteconst)
		 goto	settmr
		 eq	MaxTmr+3,((.600* .500 ) >> .16) +1
settmr		movlw	morebits
		movwf	TmrVector+1
		retlw	0

morebits	decfsz	DH,F
		 goto nextbit
		settrap	.5,sec,displaybits,MaxTmr+2,TmrVector+1
		retlw	0

;******************************************************************************
;Initialization
;******************************************************************************



#define	OPTIONinit	b'11011000'
#define	PR2init		.250

#define	TRISIOinit	 b'11111010'
				; GP5	inp 
				; GP4	inp  ; AN3
				; GP3	inp
				; GP2	outp
				; GP1	inp
				; GP0	outp

#define ANSELinit B'01111010' 	;ADC Frc clock,
				;and GP1, 3 as analog
#define CCPR1Linit	.7	;10us Pulse start with


Init	init683
	settrap	1,sec,quietadc,MaxTmr,TmrVector
	settrap .30,msec,calib1,MaxTmr+2,TmrVector+1

	clrf	case
	eq	TenMore,.10

ERloop	call	adc3

	clrf	AH
;	call displaybits
;	goto	ERloop

	if_	AL,<,V11.0,lit8		; under voltage
         goto slpy
	if_	AL,==,.255,lit8		; over voltage
	 goto	slpy

	
loopy	call	calltrap

;	movlw	calib
;	if_bit	GPIO,3
;	 movwf	TmrVector+1


	if_not	Adc_Trap
	 GOTO	ERloop



moreadc bcf	Adc_Trap
	call	pwmoff
	bcf	GPIO,0
	btfss	case,0
	 bsf	GPIO,0

	dlay 	.200000-.2			; cool off
	call	adc3

	if_	case, !=,.1,	lit8
 	 call	pwmon

;	clrf	AH
;	call displaybits
;


ok_V	if_	AL,lss,(V12.6+V12.0)/2,	(byteconst)
	 clrf	case
	
	movfw	case
	addwf	PCL,F
	 goto	case0
	 goto	case1
	 goto	case2
	 goto	case3

case0	if_	AL,<,V14.7,	(byteconst)
	 goto	notmaxV
;	bsf	GPIO,0
;	goto $
	eq	case,.3
	clrf	TenMore
	goto	case3
notmaxV	if_	PR2,<,.41,		(byteconst)
	 goto	is25kHz
	dec_	PR2,			(byte)
	set_trap 1,sec,MaxTmr
	goto	ERloop

is25kHz	if_	AL,>,VoltMem,		byte
	 goto rvolt
	if_	AL,<,V13.7,		lit8
	 goto	ERloop
	incf	case,F
	decfsz  TenMore,F
	 decf	case,F
	goto	ERloop

rvolt	eq_	VoltMem,=,AL, 		byte
	eq	TenMore,.10
	;clrf MaxTmr			; max seconds
	goto	ERloop
	

case1	if_ PR2,>=,.250,			lit8
	 goto	cse1mp
	inc_	PR2,			byte	

cse1mp		;max Seconds

	if_	AL,>,V13.7,	(byteconst)
	 goto	ERloop

	incf	case,F			;case = 2
	eq_	VoltMem,=,AL, 		byte
	goto	ERloop


case2	set_trap .500,msec,MaxTmr
	if_	AL,>,VoltMem	,	(byte)
	 goto	risingV
	if_	PR2,<,.41,		(byteconst)
	 goto   ERloop
	dec_	PR2,			(byte)

risingV	eq_	VoltMem,=,AL	,	(byte)
	if_	AL,<,V13.7+(V13.7 /16),		(byteconst)
	 goto	ERloop	

	decf	case,F		 	; case = 1
	goto	ERloop

case3	set_trap 1,sec,MaxTmr

	if_	AL, lss, V14.7 , 	(byteconst)
	 goto tenmore

lowerP	inc_	PR2,			(byte)
	if_	PR2, < , .250	   , 	(byteconst)
	 goto	ERloop
	eq	case,.1
	goto	ERloop

tenmore decfsz	TenMore,F
	 goto	moreadc
	eq_	TenMore,=,.3,		lit8	; 3seconds to settle
	goto	lowerP


movALduty	clrC
		rrf	AL,F		;unload
		bcf	CCP1CON,DC1B0
		skpNC
		 bsf 	CCP1CON,DC1B0
		clrC
		rrf	AL,F
		bcf	CCP1CON,DC1B1
		skpNC
		 bsf 	CCP1CON,DC1B1
		mov	AL, CCPR1L
		retlw	0



pwmoff	bcf	T2CON,TMR2ON	 ; disable TMR2
	movlw	b'11110011'
	andwf	 CCP1CON, F	 ; disable PWM
	nop
	bcf	GPIO,2		 ; make sure GP2 is down
	retlw	0

pwmon	;mov 	Duty,AL
	;call	movALduty
	movlw	b'00001100'
	iorwf	 CCP1CON, F	 ; enable PWM
	bsf	T2CON,TMR2ON	 ; enable TMR2	;
	retlw	0

adc3	MOVLW 	B'00001101' 		;left justify,
	MOVWF 	ADCON0 			;Vdd Vref, AN3, On
	goto	$+1	
	goto	$+1
	goto	$+1			;Acquisiton delay
	BSF 	ADCON0,GO 			;Start conversion
	BTFSC 	ADCON0,GO 		;Is conversion done?
	GOTO 	$-1 			;No, test again

	MOVF 	ADRESH,W 		;Read upper 8 bits

;	movlw	V14.7+1			;test

	MOVWF 	AL 			;Store in GPR space
	retlw	0

slpy	call	pwmoff
	bsf	WDTCON,SWDTEN
	sleep
	bcf	WDTCON,SWDTEN
	call	adc3
	decfsz	STACK,F
	 goto	slpy
	eq_	STACK,=,.3,	lit8

	if_	AL,>,V13.7,	lit8
	 goto fstblnk
	if_	AL,>,V12.0,	lit8
	 goto	ERloop


	if_not	GPIO,0
	 goto	fstblnk
	eq_	STACK,=,.255,	lit8
	
fstblnk	call	blink0
	goto	slpy

		
wak2delay	eq_	STACK-2,=,.200*.255,(lit16)
		clrwdt
		decfsz	STACK-2,F
		 goto	$-2
		decfsz	STACK-1,F
		 goto	$-4
		decfsz	STACK,F
		 goto	wak2delay
		retlw	0



firstbit	movf	DH,F
		if_any AH, 7, STATUS, Z
		 goto nextbit-1
		clrC
		rlf	AL,F
		rlf	AH,F
		decf	DH,F
		goto	firstbit

		incf	DH,F
nextbit		clrC				;restore AL
		rlf	AL,F
		rlf	AH,F
;
;		bcf	GPIO,disport		;red LED on
		movlw	((.200* .500 ) >> .16) +1
		skpC
		 goto	wdelay
		movlw	((.1000  * .500 ) >>.16) +1
		bsf	AL,0			;restore AL

		bsf	GPIO,disport		;green LED on

wdelay		movwf	MaxTmr+3
		movlw	offlight
		movwf	TmrVector+1
		retlw	0




	end
