;***********************************************************************
;*   This file is the firmware to implement a     *
;*   at GPIO 2 Transistor output driver                                *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: A.0                                               *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************

	list      p=12F683	; list directive to define processor
	#include <..\macros2b.asm>
	config683

;	ERRORLEVEL -302				; Get rid of banking messages...

;******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	SystemStatus,case,ALT,VoltMem,TenMore
	AL,AH:3,BL,BH,CL,CH,DL,DH
	EEcount	
	CLH:2,DLH:2,CLM:2,DLM:2
	
	endc

#define	IOdir	 b'11111010'
				; GP5	inp 
				; GP4	inp  ; AN3
				; GP3	inp
				; GP2	outp
				; GP1	inp
				; GP0	outp

#define ANSELinit B'01111010' 	;ADC Frc clock,
				;and GP1, 3 as analog
#define CCPR1Linit	.8	;8us Pulse start with
;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000		; processor reset vector
	nop			; required by in circuit debugger
	goto    Init		; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG     0x004
	return			;IRQ TRAP
;******************************************************************************
;Subroutines
;******************************************************************************
;
;movdutyAL	clrf	AH
;		mov	CCPR1L,AL	;load
;		shll	AL,(word)
;		shll	AL,(word)
;		btfsc	CCP1CON,DC1B0
;		 bsf	AL,0
;		btfsc	CCP1CON,DC1B1
;		 bsf	AL,1
;		retlw 0
;
;
;movALduty	clrC
;		shrr	AL,(word)		;unload
;		bcf	CCP1CON,DC1B0
;		skpNC
;		 bsf 	CCP1CON,DC1B0
;		clrC
;		shrr	AL,(word)
;		bcf	CCP1CON,DC1B1
;		skpNC
;		 bsf 	CCP1CON,DC1B1
;		mov	AL, CCPR1L
;		retlw	0
;
;
;subtrisio	bsf	STATUS,5	;BANKSEL	Bank1		; 
;		movwf	TRISIO		;
;		BANKSEL	Bank0
;		return
;
;
;displaybits	eq	DL, .10
;		call	wak2delay
;
;
;		eq	DH, .15
;firstbit	movf	DH,F
;		if_any AH, 7, STATUS, Z
;		 goto nextbit-1
;		clrC
;		rlf	AL,F
;		rlf	AH,F
;		decf	DH,F
;		goto	firstbit
;
;		incf	DH,F
;nextbit		clrC				;restore AL
;		rlf	AL,F
;		rlf	AH,F
;
;		bcf	GPIO,5
;		movlw	1
;		skpC
;		 goto	wdelay
;		movlw	5
;		bsf	AL,0			;restore AL
;		bsf	GPIO,5
;
;wdelay		movwf	DL
;
;		movlw	iodir &	b'11011111'			;GP5 outout
;	
;		call	subtrisio
;
;;		movlw	b'00001100'
;;		iorwf	 CCP1CON, F	 ; enable PWM
;;
;		call	wak2delay
;	
;;dis		movlw	b'11110011'
;;		andwf	 CCP1CON, F	 ; disable PWM
;;
;		movlw	iodir |	b'00100000'		;GP5 input
;	
;		call	subtrisio
;
;		eq	BL,1
;		call	wak2delay
;		decfsz	DH,F
;		 goto nextbit
;		retlw	0		
;
;		
wak2delay	clrwdt
		decfsz	CL,F
		 goto	$-2
		decfsz	CH,F
		 goto	$-4
		decfsz	BL,F
		 goto	$-6
		retlw	0


;******************************************************************************
;Initialization
;******************************************************************************


Init	init683
	clrf	case
	eq	DL,.10
moreadc bcf	T2CON,TMR2ON	 ; disable TMR2
	movlw	b'11110011'
	andwf	 CCP1CON, F	 ; disable PWM
	nop
	bcf	GPIO,2		 ; make sure GP2 is down
	eq	BL,.1		 ; 200ms
	call	wak2delay
	MOVLW 	B'00001101' 		;left justify,
	MOVWF 	ADCON0 			;Vdd Vref, AN3, On
	goto	$+1	
	goto	$+1
	goto	$+1			;Acquisiton delay
	BSF 	ADCON0,GO 			;Start conversion
	BTFSC 	ADCON0,GO 		;Is conversion done?
	GOTO 	$-1 			;No, test again

	if_	case,eql,.1,(byteconst)
	 goto	nopwm
 
	movlw	b'00001100'
	iorwf	 CCP1CON, F	 ; enable PWM
	bsf	T2CON,TMR2ON	 ; enable TMR2	;

nopwm	MOVF 	ADRESH,W 		;Read upper 8 bits
	MOVWF 	AL 			;Store in GPR space

;	BANKSEL ADRESL 			;
;	MOVF 	ADRESL,W 		;Read lower 8 bits
;	BANKSEL AL	
;	MOVWF 	AL 			;Store in GPR space

;
;	shrr	AL			;max 9 bit
;	shrr	AL			;max 8 bit
;	call	movALduty		;leaves AL = AL div 4
	
;	clrf	AH
;	call displaybits
;

	if_	AL,lss,.230,		(byteconst)
	 goto	ok_V
	eq	case,.1
	eq	PR2,.250		;emergency stop
	goto	moreadc

ok_V	if_	AL,lss,b'10000000',	(byteconst)
	 clrf	case
	

	movlw	.220		;ALT = 192-AL 
	subwf	AL,W
	movwf	ALT
	skpnZ				;no Zeros
	 decf	ALT,F
	comf	ALT,F

blinky	eq	DH,.255			; wait for DL seconds
	clrf	CH			; blink in the frequency of ALT * 20ms
	movfw	ALT

loi	incf	CH,F
	subwf	DH,F
	skpNC
	 goto	loi
mocl	mov	ALT,CL

mobl	eq	BL,.80
	clrwdt
	decfsz	BL,F
	 goto	$-2
	decfsz	CL,F
	 goto	mobl
	

	movlw	b'00000001'
	xorwf	GPIO,F
	decfsz	CH,F
	 goto	mocl

	decfsz	DL,F
	 goto	blinky




	movfw	case
	addwf	PCL,F
	 goto	case0
	 goto	case1
	 goto	case2
	 goto	case3

case0	if_	AL,lss,b'11000000',	(byteconst)
	 goto	notmaxV
	eq	case,.3
	clrf	TenMore
	goto	case3
notmaxV	if_	PR2,lss,.41,		(byteconst)
	 goto	is25kHz
	dec_	PR2,			(byte)
	eq	DL,.10
	goto	moreadc

is25kHz	eq	DL,.250			;25 seconds
	goto	moreadc
	

case1	eq	DL,.10
	if_	AL,grtr,b'10010000',	(byteconst)
	 goto	moreadc

	incf	case,F			;case = 2
	mov	AL,VoltMem
	goto	moreadc	


case2	eq	DL,.5
	if_	AL,grtr,VoltMem	,	(byte)
	 goto	risingV
	if_	PR2,lss,.41,		(byteconst)
	 goto	risingV
	dec_	PR2,			(byte)

risingV	mov	AL,VoltMem
	if_	AL,lss,b'10011000',	(byteconst)
	 goto	moreadc	

	decf	case,F		 	; case = 1
	goto	moreadc

case3	eq	DL,.10
	if_	AL, lss, b'11000000' , 	(byteconst)
	 goto tenmore
lowerP	inc_	PR2,			(byte)
	if_	PR2, lss, .250	   , 	(byteconst)
	 goto	moreadc
	eq	case,.1
	goto	moreadc

tenmore decfsz	TenMore,F
	 goto	moreadc
	incf	TenMore,F
	goto	lowerP
	end
