
;***********************************************************************
;* This file is the firmware to implement a 10kHz pulse width modulated    *
;*   signal of 8..28 microseconds(depending on potentiometer @ AN3)    *
;*   at GPIO 2 Transistor output driver                                *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  ..\macros3b.asm
	config683
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************

	cblock 0x20
	 SystemStatus,TimerVector
	 TimerTick,TimeCounter:2 ;,AsyncCounter:2
	 x,r:2
	adcon0,adcon1,adcon3
	endc
#define	E1	0x1000
#define	TMR07Bit	SystemStatus,7
#define STACK	0x2F

#define Lo_Intensity	.8
#define Hi_Intensity	.28


;#define GPIOinit	b'00000000'	; 0,1,2 OUTPUT initiate as LOW
#define TRISIOinit	b'11111011'	; configure 0,1,3,4,5 as       INPUT 
#define	OPTIONinit	b'11000000'	; no wakeup, no pullup, clock 1:2
#define OSCCONinit      b'11100001'	; 8 MHz
#define ANSELinit 	B'01111011' 	; ADC Frc clock, AN3(GP4),AN1,AN0 as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on
#define PR2init		.100		;.40
#define CCPR1Linit      .10
#define CCP1CONinit	b'00000000'	; disable pwm
#define T2CONinit       b'00000100'	; switch on TMR2

	org 0x00
	init683
	goto	MAIN


slinear0	
#define	howmany	1
#define lowBoundary	0x20	;
#define rs1		0x01
#define highBoundary	0xE0	;
#define rs2		0xFF
	variable  hicount



	if_	STACK,<=,lowBoundary,lit8
	 goto	lors1
	if_	STACK,>=,highBoundary,lit8
	 goto	hirs2
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,lowBoundary,lit8
	eq_	STACK,=,rs1,lit8

	if	(rs2-rs1) >0
hicount = (rs2-rs1)*.256 / (highBoundary-lowBoundary)	

	else
hicount = (rs1-rs2)*.256 / (highBoundary-lowBoundary)
	endif
	 movlw	hicount	& 0xFF	

adloop
	while	(hicount >> 8) > 0
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto adloop 
	return
lors1	eq_	STACK,=,rs1,lit8
	return
hirs2	 eq_	STACK,=,rs2,lit8
	return

slinear1	
;#define	howmany	1
;#define lowBoundary	0x20	;
#define rs11		0x01
;#define highBoundary	0xE0	;
#define rs12		0x20
;	variable  hicount



	if_	STACK,<=,lowBoundary,lit8
	 goto	lors11
	if_	STACK,>=,highBoundary,lit8
	 goto	hirs12
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,lowBoundary,lit8
	eq_	STACK,=,rs11,lit8

	if	(rs12-rs11) >0
hicount = (rs12-rs11)*.256 / (highBoundary-lowBoundary)	

	else
hicount = (rs11-rs12)*.256 / (highBoundary-lowBoundary)
	endif
	 movlw	hicount	& 0xFF	

ad1loop
	while	(hicount >> 8) > 0
	 if	rs12-rs11 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs12-rs11 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto ad1loop 
	return
lors11	eq_	STACK,=,rs11,lit8
	return
hirs12	 eq_	STACK,=,rs12,lit8
	return
	
#define	NFET_Gate_Port	GPIO,2


afterwdt 

t_used = 2	
MAIN	settrap .3000,msec,ADC,TimeCounter,TimerVector; wait 3 secs
	goto	ploop
	
cycle	settrap .500,msec,ADC,TimeCounter,TimerVector


ploop
;	if_not	PIR1,TMR2IF
;	 goto	t0	
;	bcf	PIR1,TMR2IF
;	eq	STACK,=,
;	bsf	GPIO,2
;	
;	bCf	GPIO,2
;	clrf	TMR2
;
t0	if_not	INTCON,T0IF
	 goto	ploop
	bcf	INTCON,T0IF
	decfsz	TimeCounter,F
	 goto	ploop
	decfsz	TimeCounter+1,F
	 goto   ploop
 	do_	CCP1CON,=,CCP1CON,AND,b'11110011',lit8	; disable pwm
	bcf	GPIO,2

	movfw	TimerVector
	movwf	PCL


clred
;	movfw	TimerTick
;	subwf	TMR0,W
;	andlw	B'11110000'
;	skpZ

	 goto	ploop


;
;
;async	decfsz	AsyncCounter,F
;	 goto	ploop
;	decfsz	AsyncCounter+1,F
;	 goto	ploop			; 7msec to 158ms check input
;
;	goto 	cycle

ADC	

	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1
	eq_	STACK,=,ADRESH,byte
	eq_	ADCON0,=,b'00000101',lit8	;next :AN1,on
	call	slinear0
	eq_	adcon3,=,STACK,byte

	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1
	eq_	STACK,=,ADRESH,byte
	eq_	ADCON0,=,b'00000001',lit8	;next: AN0,on
	call	slinear0
	eq_	adcon1,=,STACK,byte

	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1
	eq_	STACK,=,ADRESH,byte
	eq_	ADCON0,=,b'00001101',lit8	;next: AN3,on
	call	slinear0
	eq_	adcon0,=,STACK,byte

;
;			;		eq	x,.0
;			;testloop		incfsz  x,F
;	goto linearze
;
;	goto $		; loop
;	
;vtable	addwf	PCL,F
;	dt	2* (2+2)-1
;	dt 0x00020,  0x0001
;	dt 0x03100,  0x03FF
;
;#define MdB	STACK-0
;#define LoB	STACK-2
;#define HiB	STACK-4
;
;#define MdD	STACK-6
;#define LoD	STACK-8
;#define HiD	STACK-.10
;  
;#define	AL	ADRESH
;;#define AL	x	;test
; 
;linearze	eq_	MdB,=,.1,	lit8
;		call	vtable
;		movwf	LoB
;		if_	AL,>,LoB,	byte
;		 goto	bases
;exbdry		do_	MdB,=,MdB,+,1,	lit8
;		movfw	MdB
;		call	vtable
;		movwf	MdD
;		goto done
;
;bases		movlw	0
;		call	vtable
;		movwf	MdB
;		call	vtable
;		movwf	HiB
;		if_	AL,>=,HiB,	byte
;		 goto exbdry
;
;basesearch	do_	MdB,=,MdB,-,(1+1),lit8 
;		movfw	MdB
;		call	vtable
;		movwf	LoB
;		if_	AL,>=,LoB,	byte
;		 goto 	binsearch
;		eq_	HiB,=,LoB,	byte
;		goto	basesearch
;
;binsearch	do_	MdB,=,MdB,+,1,	lit8
;		movfw	MdB
;		call	vtable
;		movwf	LoD
;		do_	MdB,=,MdB,+,(1+1),	lit8
;		movfw	MdB
;		call	vtable
;		movwf	HiD
;
;binloop		do_	MdB,=,LoB,+,HiB,	(byte)
;		rrf	MdB,F
;		do_	MdD,=,LoD,+,HiD,	(byte)
;		rrf	MdD,F
;		
;		if_	AL,>,MdB,		(byte)
;		 goto	higher
;
;		skpNZ				; AL equal MdB
;		 goto	done
;
;		eq_	HiB,=,MdB,	byte
;		eq_	HiD,=, MdD,	byte
;		goto	binloop
;higher		eq_	LoB,=,MdB,	byte
;		eq_	LoD,=,MdD,	byte
;		goto	binloop
;
;done	
;		;e_q	E1,[,x,byte,]=,MdD,byte		
;;		e_q_	R ,=,E1,byte,[,x  ,byte
;		eq_	CCPR1L,=,MdD,	byte
;
;;		goto	testloop
;		eq	 CCP1CON,	b'00001100'	; enable pwm
;
;		goto	cycle
;


	;result from adcon0 * result from adcon3

	do_	r,=,adcon0,*,adcon3,byte
	eq_	r+1,=,STACK,byte

;	eq_	r,=,adcon0,byte
;	eq_	r+1,=,0,lit8


	movf	r+1,F
	skpnZ
         goto	setT2is1
	shr_	r,		word
	shr_	r,		word
	shr_	adcon1,		byte
	shr_	adcon1,		byte
	bcf	T2CON,1
	bsf	T2CON,0		;set TMR2,1:4

	movf	r+1,F
	skpnZ
         goto	setpwmvalues
	
	shr_	r,word
	shr_	r,word
	shr_	adcon1,		byte
	shr_	adcon1,		byte
	bsf	T2CON,1
	bcf	T2CON,0		;set TMR2,1:16

	goto	setpwmvalues
setT2is1
	bcf	T2CON,1
	bcf	T2CON,0		;set TMR2,1:1

setpwmvalues
	eq_	x,=,b'11100001',lit8

findoscilfreq	
	movf	r+1,F
	skpnZ
	 goto	setoscon
	shr_	r,		word
	do_	x,=,x,-,b'00100000',lit8
	 goto	findoscilfreq	
	
;	decfsz	x,F
;	 goto	findoscilfreq
;	shr_	r,		word
;
setoscon
	
	eq_	OSCCON,=,x,	byte
	eq_	PR2,=,r,	byte
	shr_	adcon1,		byte
	mov_bit	STATUS,C,CCP1CON,DC1B0
	shr_	adcon1,		byte
	mov_bit	STATUS,C,CCP1CON,DC1B1
	eq_	CCPR1L,=,adcon1,byte
	do_	CCP1CON,=,CCP1CON,OR,b'00001100',lit8	; enable pwm

	goto	cycle
	
	end