
;************************************************************************************
;* This file is the firmware to implement a pulse depending on potentiometer @ AN1  *
;  (and a pause depending on potentiometer @ AN3 multiplied with potentiometer @ AN0*
;*   at GPIO 2 Transistor output driver                                             *
;*    File Version: A.0                                                             *
;*                  MARCH 2010                                                      *
;*    Author:       G M DRYGAS                                                      *
;*                  Principal Applications Engineer                                 *
;*    Company:      MICHAELS Unternehmergesellschaft                                *
;*                                                                                  *
;************************************************************************************
;*                                                                     *
;*    Files required:   macros3c                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=12F683	; list directive to define processor
	#include  ..\macros3c.asm
	config683
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************

	cblock _MINRAM
	 SystemStatus,TimerVector
	 TimerTick,TimeCounter:2 ;,AsyncCounter:2
	 x,r:2,ccpl
	adcon0,adcon1,adcon3
	endc
#define	E1	0x1000
#define	TMR07Bit	SystemStatus,7
#define STACK	_MAXRAM

#define Lo_Intensity	.8
#define Hi_Intensity	.28


#define GPIOinit	b'00000000'	; 2 OUTPUT initiate as LOW
#define TRISIOinit	b'11111011'	; configure 0,1,3,4,5 as       INPUT 
#define	Output_Port	GPIO,2
#define	OPTIONinit	b'11000111'	; no wakeup, no pullup, clock 1:256
#define OSCCONinit      b'11100001'	; 8 MHz
#define ANSELinit 	B'01111011' 	; ADC Frc clock, AN3(GP4),AN1,AN0 as analog
#define	ADCON0init	b'00001101'	; left justified , AN3, on
;#define PR2init		.100		;.40
;#define CCPR1Linit      .10
#define CCP1CONinit	b'00000000'	; disable pwm
;#define T2CONinit       b'00000100'	; switch on TMR2

delay3	macro	VarwithCycles		;will produce 7*VarwithCycles(lit24) + 16 cycles 
			       
 local	iloop

 	incf	VarwithCycles,W   	 
  	movwf   STACK-0
 	incf	VarwithCycles+1,W   	 
  	movwf   STACK-1
 	incf	VarwithCycles+2,W   	 
  	movwf   STACK-2
	

iloop
	 goto	$+1
	 goto	$+1

  	decfsz  STACK-0,F
   	 goto	iloop
  	decfsz  STACK-1,F
   	 goto	iloop+1	
	decfsz  STACK-2,F
   	 goto	iloop+2

	endm

delay2	macro	VarwithCycles		;will produce 5*VarwithCycles(lit16) + 10 cycles 
			       
 local	iloop

 	incf	VarwithCycles,W   	 
  	movwf   STACK-0
 	incf	VarwithCycles+1,W   	 
  	movwf   STACK-1	

iloop
	 goto	$+1
  	decfsz  STACK-0,F
   	 goto	iloop
  	decfsz  STACK-1,F
   	 goto	iloop+1	

	endm

delay1	macro	VarwithCycles		;will produce 3*VarwithCycles(lit16) + 4 cycles 
			       
 local	iloop

 	incf	VarwithCycles,W   	 
  	movwf   STACK-0	

iloop
  	decfsz  STACK-0,F
   	 goto	iloop
	endm

	org 0x00
	init683
	goto	MAIN


slinear0	
#define	howmany	1
#define lowBoundary	0x10	;
#define rs1		0x01
#define highBoundary	0xF0	;
#define rs2		0xFF
	variable  hicount



	if_	STACK,<=,lowBoundary,lit8
	 goto	lors1
	if_	STACK,>=,highBoundary,lit8
	 goto	hirs2
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,lowBoundary,lit8
	eq_	STACK,=,rs1,lit8

	if	(rs2-rs1) >0
hicount = (rs2-rs1)*.256 / (highBoundary-lowBoundary)	

	else
hicount = (rs1-rs2)*.256 / (highBoundary-lowBoundary)
	endif
	 movlw	hicount	& 0xFF	

adloop
	while	(hicount >> 8) > 0
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs2-rs1 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto adloop 
	return
lors1	eq_	STACK,=,rs1,lit8
	return
hirs2	 eq_	STACK,=,rs2,lit8
	return

slinear1	
;#define	howmany	1
;#define lowBoundary	0x20	;
#define rs11		0x01
;#define highBoundary	0xE0	;
#define rs12		0x20
;	variable  hicount



	if_	STACK,<=,lowBoundary,lit8
	 goto	lors11
	if_	STACK,>=,highBoundary,lit8
	 goto	hirs12
	clrf	STACK-1
	do_	STACK-2,=,STACK,-,lowBoundary,lit8
	eq_	STACK,=,rs11,lit8

	if	(rs12-rs11) >0
hicount = (rs12-rs11)*.256 / (highBoundary-lowBoundary)	

	else
hicount = (rs11-rs12)*.256 / (highBoundary-lowBoundary)
	endif
	 movlw	hicount	& 0xFF	

ad1loop
	while	(hicount >> 8) > 0
	 if	rs12-rs11 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
hicount -= .256	
	endw
	addwf	STACK-1,F
	skpnC
	 if	rs12-rs11 > 0
	  incf	STACK,F
	 else
	  decf	STACK,F
	 endif
	decfsz	STACK-2,F
	 goto ad1loop 
	return
lors11	eq_	STACK,=,rs11,lit8
	return
hirs12	 eq_	STACK,=,rs12,lit8
	return
	



afterwdt 

t_used = 2	
MAIN	eq_	adcon1,=,0,lit8
	settrap .3000,msec,ADC,TimeCounter,TimerVector; wait 3 secs
	goto	ploop
	
cycle	settrap .500,msec,ADC,TimeCounter,TimerVector


ploop		

tploop
	do_	STACK,=,adcon1,-,.12,lit8
	if_C					;adcon1,>,.11,lit8
	 goto	pulseloopdelay

	comf	STACK,w
	addwf	PCL,F
	 bsf	Output_Port
	 bsf	Output_Port
	 bsf	Output_Port
	 bsf	Output_Port	
	 bsf	Output_Port
	 bsf	Output_Port
	 bsf	Output_Port
	 bsf	Output_Port
	 bsf	Output_Port
	 bsf	Output_Port
	 bsf	Output_Port	;	1
	 bcf	Output_Port	; no pulse
	goto	perioddelay

pulseloopdelay
;	do_	ccpl,=,adcon1,-,.12,lit8
	shr_	STACK,	byte
	shr_	STACK,	byte
	incf	STACK,F
	bsf	Output_Port
	nop	;incf	ccpl,W   	 
  	nop	;movwf   STACK-0
	nop
	nop	
  	decfsz  STACK-0,F	; loop 4
   	 goto	$-2
	btfsc	adcon1,0
	 goto	$+1
	btfss	adcon1,1
         goto	$+3
	nop
	goto	$+1
	bcf	Output_Port

perioddelay
;	incf	adcon1,F	; test
;	goto	tploop		; test

  	delay2	r


t0	if_not	INTCON,T0IF
	 goto	ploop
	bcf	INTCON,T0IF
	decfsz	TimeCounter,F
	 goto	ploop
	decfsz	TimeCounter+1,F
	 goto   ploop
 ;	do_	CCP1CON,=,CCP1CON,AND,b'11110011',lit8	; disable pwm
;	bcf	GPIO,2

	movfw	TimerVector
	movwf	PCL


clred
;	movfw	TimerTick
;	subwf	TMR0,W
;	andlw	B'11110000'
;	skpZ

	 goto	ploop


;
;
;async	decfsz	AsyncCounter,F
;	 goto	ploop
;	decfsz	AsyncCounter+1,F
;	 goto	ploop			; 7msec to 158ms check input
;
;	goto 	cycle

ADC	

	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1
	eq_	STACK,=,ADRESH,byte
	eq_	ADCON0,=,b'00000101',lit8	;next :AN1,on
	call	slinear0
	eq_	adcon3,=,STACK,byte

	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1
	eq_	STACK,=,ADRESH,	byte

	eq_	ADCON0,=,b'00000001',lit8	;next: AN0,on
	call	slinear0
	shr_	STACK,		byte
	shr_	STACK,		byte
	do_	STACK,=,STACK,+,1,lit8
	eq_	adcon1,=,STACK,byte


	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1
	eq_	STACK,=,ADRESH,byte
	eq_	ADCON0,=,b'00001101',lit8	;next: AN3,on
	call	slinear0
	eq_	adcon0,=,STACK,byte

	do_	r,=,adcon0,*,adcon3,byte
	eq_	r+1,=,STACK,byte		;16bit result

	goto cycle

	
	end