;********************************************************************************
;     BLINKER TEST for HIGH VOLTAGE LED                                  		*
;********************************************************************************
;*                                  			                                *
;*    Files required:   m0-3.asm (macros) Copyright michael5.net@outlook.com    *
;*                                                                     			*
;********************************************************************************
;*                                                                     			*
;*    Notes:        hardware  e4swtch  											*
;*                                                                     			*
;********************************************************************************

	list      p=10F200	; list directive to define processor
	#include  ..\..\..\m0-3.asm
	config_
 	
#define	OPTIONinit	b'11000100'	; no pin wakup, no pullup, Clock 1:32
#define TRISIOinit 	b'00001000'	; all ports output bar GP3	
#define GPIOinit 	b'00000000'	; GPIO  all LOW 
;********************************************************************************

	init_					; reasonable initiation of special function registers 
	cblock	_MINRAM			; start of variables
	 SyS1,SyS2,Count
	endc
	#define STACK		_MAXRAM

start	
	bcf 	GPIO,1
    eq_  Count,=,.6, 					lit8
moon
    delay 	.2000000
	decfsz	Count,F
      goto moon

	bsf 	GPIO,1
    eq_  Count,=,.6, 					lit8
sun
    delay 	.2000000
	decfsz	Count,F
      goto sun

    eq_  Count,=,.6,					lit8
blink
    do_     GPIO,=,GPIO,XOR,b'00000010',lit8
	delay 	.2000000
	decfsz	Count,F
      goto    blink

	eq_		Count,=,.6,					lit8
flash
	bcf		GPIO,1
	delay 	.2000000
	bsf		GPIO,1
	delay	.10000
	decfsz	Count,F
	  goto	flash

	bcf		GPIO,1
	goto	start
	end