;****************************************************************************************
;*   This file is the firmware to implement a LED  AC lamp switch, based on 		*
;*   the PIC10F200.  It monitors the zero crossing of the AC waveform (and the ambient   *
;*   light with a LDR and drives a NFET to switch LED light     *
;*                                                                			*
;*                                                                     			*
;*   Control is accomplished through one or more interruptions of power to the circuit,	*
;*   which causes a certain sequence of effects                		                	*
;*          			                                                                *
;*             light	               duration  interrupt   timeout                                *
;*           	                                  within      goto		                            *
;*	  LDR senses "dark"	goto EVENT0            				                *             
;*    EVENT0:      low LED	       forever      EVENT1        EVENT0                        *
;*    
;*    EVENT15:      high LED 	  180 min	    EVENT0        EVENT0           				*
;*    		                        					                                *
;*											                                            *
;*                                   							                        *
;*    "When it is dark, you will switch on low LEDs, by interrrupting shortly you switch    *
;*     on high LED for  3 hours.! 
;*                                               *
;*             light	   duration  interrupt   timeout                                *
;*    LDR senses "dim or bright"       within      goto		                        *
;*					goto EVENT15                       			*
;*  				*
;**************************************************************************************    
;*	 pin assignment										*
;*   GPIO 0 LDR sensor                   						*
;*   GPIO 1 power supply output driver via transistor            				*
;*   GPIO 2 NFET output driver via transistor                                 		*
;*   GPIO 3 zero cross detection input                   			        *
;* 
;**************************************************************************************
;*   This file is a adation of firmware to implement                                  *
;*	2 timers, which on expiration can trigger 16 different single event routines      *
;*      furthermore the possibility of insertion of code into periodic routines       *
;*************************************************************************************                                                                                    *
;*   Refer to the MPASM User's Guide for additional information on     			      *
;*   features of the assembler (Document DS33014).                     			      *
;*                                                                     			      *
;*   Refer to the respective PICmicro data sheet for additional        			      *
;*   information on the instruction set.                               			      *
;*                                                                     			      *
;**************************************************************************************	
;*                                                                 			          *
;*    Filename:	    MICROCHIP OS for 10F2xx.asm                                       *
;*    Date:         December, 2009                                    	     		  *
;*    File Version: A, this is a new file                                    		  *
;*                                                                     	   	     	  *
;*    Author:       G Michael Drygas                                      		      *
;*                  Applications Engineer                    				          *
;*    Company:      MICHAEL5.net                 			      *
;**************************************************************************************
;*                                			                                          *
;*    Files required:   m0-3.asm (macros) for NATURAL assembler User Interface        *
;*                                                                     			      *
;*                                                                     			      *
;*                                                                     			      *
;**************************************************************************************
;*                                                                     			      *
;*    Notes:        hardware   								          *
;*		         					                                                  *
;*                                                                     			      *
;**************************************************************************************
	list      p=10F200	; list directive to define processor
	#include  ..\..\m0-3.asm
	config_WDT
 	
#define	OPTIONinit	b'11000100'	        ; no wakup, no pullup, Clock 1:32
#define TRISIOinit 	b'11111011'	        ; all ports input bar GP2	
#define pnp			b'00000000'         ; 0x04 for a pnp transistor
#define GPIOinit 	b'00000000' | pnp	; set output "off"
;#define AC          #$FF                  ; AC or DC operation
;**************************************************************************************

	init_			              ; reasonable initiation of special function registers 


	cblock	_MINRAM			        ; start of variables
	 SyS1,ACtimer,BouCou,DutyTime,PeriodTime,StarTime,StopTime,TMR0cache
   	 LoopAdj,BlinK
    endc
#define STACK		_MAXRAM
#define		Read_Out		SyS1,0
#define		AC_Status		SyS1,1
#define		AC_Bit			SyS1,2
#define		Mem_HiLo		SyS1,3
;#define		HiLo    		SyS1,4
#define		TMR05Bit		SyS1,5
#define		TMR07Bit		SyS1,7
#define 	Z_Detect_Port	GPIO,3	; zero crossing input for Reset on Change	
#define 	LDR_Port	GPIO,0
#define 	NFET_Port	GPIO,2
#define 	NFET_Port_Bit  b'00000100'

on macro 
          if pnp
			bcf NFET_Port          ;on
          else
            bsf NFET_Port
          endif
 endm
off macro
 if pnp
			bsf NFET_Port          ;off
          else
            bcf NFET_Port
          endif
 endm
;**************************************************************************************
#define fac .60             ; .1 ; test
;PWRUP	*****************************************************+
		eq	SyS1,0
;		eq	SyS2,0
;		eq_ SleepTimer,=,.10,   lit8
        eq_ LoopAdj,=,.0,      lit8 
		eq_ BouCou,=,.128,      lit8
        eq_ DutyTime,=,.0,      lit8
        eq_ StarTime,=,.0,      lit8
        eq_ StopTime,=,.0,      lit8
   ifdef AC
		bsf	AC_Status
		eq_ ACtimer,=,.30,      lit8
    endif
;        bsf HiLo                    ; FET is off nevertheless
;    clrwdt
;    goto $-1
;

TC0used = 3					        ; use 3 bytes of timer for TC0
	cblock
	 TC0:TC0used
	 NmbrEvent0
	endc	 
	EVENT0in	.30,msec,.15


;TC1used = 2
;	cblock
;	 TC1:TC1used,NmbrEvent1
;	endc
;		EVENT1in	1,msec,.15	    ;EVENT15 in 1 msec, goto MLOOP	 
;
JMPTable	
        andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0	
		 goto	EVENT1
		 goto	EVENT2	
		 goto	EVENT3
		 goto	EVENT4
		 goto	EVENT5
		 goto	EVENT6
		 goto	EVENT7
		 goto	EVENT8
		 goto	EVENT9
		 goto	EVENT10
		 goto	EVENT11
		 goto	EVENT12
		 goto	EVENT13
		 goto	EVENT14
		 goto	EVENT15

;
;decPR2	decf	PeriodReg,F		; PR2 -=1 brighter
;
;	skpgel	PeriodReg,.13
;	 goto	tblread
;	eq	BL,.128		;128=18ms 255= 38ms
;	movfw	PeriodReg
;decsub	subwf	BL,F
;	skpC	
;	 goto	motime
;	incfsz	UprampTime,F
;	 goto	decsub
;	incfsz	UprampTime+1,F
;	 goto	decsub
;	incf	UprampTime+2,F
;	goto	decsub
;
;tblread		call	readt
;		addwf	UprampTime,F
;		skpC
;		 goto	motime
;		incfsz	UprampTime+1,F
;		 goto	motime
;		incf	UprampTime+2,F
;		goto	motime
;
;readt		decf	PeriodReg,W
;		addwf	PCL,F
;		retlw	.255
;		retlw	.210 /.1
;		retlw	.210 /.2
;		retlw	.210 /.3
;		retlw	.210 /.4
;		retlw	.210 /.5
;		retlw	.210 /.6
;		retlw	.210 /.7
;		retlw	.210 /.8
;		retlw	.210 /.9
;		retlw	.210 /.10
;		retlw	.210 /.11
;		retlw	.210 /.12
;		
;	org	0x100
;**************************************************************************************	
 
MLOOP   
    movfw   LoopAdj
    addwf   PCL,f
    nop
    GOTO $+1 
    GOTO $+1
    GOTO $+1
    GOTO $+1
    GOTO $+1

	
    clrwdt
    CLRF    LoopAdj
    eq_      TMR0cache,=,TMR0,                  byte
    if_m     TMR0cache,==,StarTime,              byte
      on
      do_   StopTime,=, TMR0cache,+,DutyTime,   byte 
    end_m 
    if_m 	TMR0cache,==,StopTime,               byte			        ;  
	   off                                                      ; 
       do_  StarTime,=,TMR0cache,+,PeriodTime,   byte    
    end_m

tstloop
	if_ 	TMR0,5,is_on,1			        ;example for short periodic events
     goto   set5
    if_  	TMR07Bit,is_off,1
     goto   set5+2
    bsf	TMR05Bit
	 goto	PERIODIC2msec

set5    nop
       bsf	TMR05Bit 
; 
exitPERIODIC2msec		

n2MLO	
	if_	    TMR0,7,is_on,1			        ; software emulation of
	 goto	set7			                ; timer 0 overflow
	if_  	TMR07Bit,is_off,1		        ;
	 goto	set7+2
;	if_not	INTCON,T0IF		                ; wait for timer TMR0 to time out
;	 goto	MLOOP
;	bcf	INTCON,T0IF	
	bcf	TMR07Bit			        ; timer 0 has overflown 		



;	goto	PERIODIC8		        ; which is 256*64 us =8 milliseconds
exitPERIODIC8
	decfsz	TC0,F
	 goto	MLOOP-1
;	goto	PERIODIC2048		    ; after first TC0 expired, 2048 milliseconds 
exitPERIODIC2048			        ; have passed

	if TC0used > 1
;	movlw	0x07			;example for very long periodic events
;	andwf	TC0+1,W
;	movwf	STACK
;	movlw	-7
;	addwf	STACK,W
;	skpnZ
;	 goto	PERIODIC16sec	; every 16 seconds (Event0 must be later!)

exitPERIODIC16sec
	decfsz	TC0+1,F
	 goto	MLOOP-2
	endif
					                ; after TC0+1 expired, 8 minutes 44 seconds
	if TC0used > 2			        ; have passed
	decfsz	TC0+2,F
	 goto	MLOOP-3
	endif 
    ;off
	movfw	NmbrEvent0		        ; after TC0+2 expired, 37 hours 17 minutes
	goto	JMPTable 		        ; now jump to loaded Event
	 
endMLOOP0				            ; and continue execution here	 
end0MLOOP0
;	decfsz	TC1,F			        ; analogous as TC0
	 goto	endMLOOP1
;	if TC1used > 1
;	decfsz	TC1+1,F
;	 goto	endMLOOP1
;	endif
;	if TC1used > 2
;	decfsz	TC1+2,F
;	 goto	endMLOOP1
;	endif 
;	movfw	NmbrEvent1
;	goto	JMPTable 
;	 
	 
set7	nop
        bsf	TMR07Bit	
endMLOOP1	goto	MLOOP

;	org	0x200
;**************************************************************************************
PERIODIC2msec
    bcf	TMR05Bit			
		eq__ Read_Out,=,Z_Detect_Port

    ifndef AC
        if_m    Read_Out,is_on,1                ;     DC
    endif
    ifdef AC
		if__m	Read_Out,either_or,AC_Bit       ;change dectected    <<< AC
		  eq__	AC_Bit,=, Read_Out		 		; means AC is on    <<< AC

;			decfsz SleepTimer,F				    ; is Z detect working?
;		     goto $+2
;;           goto EVENT14

            eq_	ACtimer,=,.9,lit8           ;   <<< AC
    endif
            incf    BouCou,f
            if_m    BouCou,>,.130,      lit8
             decf   BouCou,f
;                                               ; Bounce Counter has overrun
		     if_m  AC_Status,is_off,1  			; but if coming from sleep
;               
		   	   bsf	AC_Status
;			   if_ NmbrEvent0,==,2,		lit8
;			     goto EVENT9p
;            
              if_ PeriodTime,>,.10,lit8      ; change intensity
               goto EVENT15b
              goto EVENT0

             end_m

            end_m

		else_m
;
   ifdef AC
		  decfsz	ACtimer,f				    ; waiting for AC to flip   <<< AC
           goto     exitPERIODIC2msec          ;           <<< AC
                               
         eq_	ACtimer, =,.9, lit8             ; wait 9* 2msec  <<< AC
   endif
          decf  BouCou,F

          if_ BouCou,>=,.126,            lit8
           goto exitPERIODIC2msec

          incf  BouCou,F                        ; BounceCounter has underrun
;  
          if_m  AC_Status,is_on,1  			    ; but if coming from wakey
;           
		   bcf	AC_Status					    ; TIMEOUT !!!
;           if_ HiLo,is_on,        singlebit
;            bcf	Mem_HiLo
;	       if_ HiLo,is_off,       singlebit
;            bsf	Mem_HiLo	  
;   		  
           off                      ;cut power to transistor
          end_m
;		  bcf	AC_Bit					        ; 

;         eq_	SleepTimer,=,.7,lit8 
		  movlw	b'11001011'	                    ; no wakup, no pullup, WDT 1:16
		  OPTION                                 ; 18msec * 16  :=288msec
quickslp
	      sleep
		end_m

		goto	exitPERIODIC2msec
;**************************************************************************************

afterwdt

		movlw	OPTIONinit	                    ; no wakup, no pullup, Clock 1:32
		OPTION
;       decfsz	SleepTimer,F		            ;8* 18ms
;		sleep
;
        off
	   goto PERIODIC2msec	


bright      eq_ DutyTime,=,.1,lit8
            eq_ PeriodTime,=,0,lit8
          retlw 0

PERIODIC8
;		goto	exitPERIODIC8			

PERIODIC2048	
;		goto	exitPERIODIC2048
		
PERIODIC16sec	
;		goto	exitPERIODIC16sec	
				 
EVENT0	    eq_ DutyTime,=,0,       lit8      
            
		    EVENT0in .120*fac,sec,0
	
EVENT1	
;		    EVENT0in .12,sec,2

EVENT2	
;		    EVENT0in .120*fac,sec,0
EVENT3
		 
EVENT4		

EVENT5		
		
EVENT6	

EVENT7		
;**************************************************************************************
EVENT8	
;	eq_ DutyTime,=,0,   lit8
            
;			EVENT0in .15*fac,sec,.9

EVENT9p
;            eq_ BlinK,=,.3,			lit8
EVENT9
;    		if_ LDR_Port,is_off,1
;             goto EVENT8
;            goto EVENT11
  
EVENT10
;		decfsz BlinK,F
;		     goto	$+1
;            goto EVENT11
;            if_m PeriodTime,!=,0,    lit8
;                 clrf PeriodTime
;            else_m
;                 eq_ PeriodTime,=,.255,lit8
;            end_m
;            EVENT0in 2,sec,.10
;
EVENT11     
;            EVENT0in .15*fac,sec,.12		


EVENT12	    
;           if_ LDR_Port,is_on,1
;	          goto EVENT11

EVENT13     
;           call bright
;			EVENT0in .180*fac,sec,.8
;	        movfw	TMR0
;	        addwf TC0+1,F
;            bnC
;             incf	TC0+2,f
;	
	

EVENT14     
      
;	        movlw NFET_Port_Bit
;		    xorwf	GPIO,F
;            delay	.2000000
;
;		    goto EVENT14

;            call bright
;		    EVENT0in 3,sec,.1  


EVENT15 
				
		    if_m LDR_Port,is_on,1
EVENT15b
              call bright
              eq__ AC_Bit,=,Z_Detect_Port
EVENT15c
;		      eq__ Read_Out,=,Z_Detect_Port
;
;     ifdef AC
;		      if__	Read_Out,equal,AC_Bit       ;wait until change dectected    <<< AC
;                 goto EVENT15c
;     endif
  		      				;switch on
         
            else_m
              eq_ DutyTime,=,.0,lit8
            end_m
		    EVENT0in .180*fac,sec,.0  
         

	
		end
;**************************************************************************************