;****************************************************************************************
;*   This file is the firmware to implement 
;*	2 timers, which on expiration can trigger 16 different single event routines
;*      furthermore the possibility of insertion of code into periodic routines 
;*	which occur every 64 microseconds, 8 milliseconds, 2 seconds and 16 seconds
;*
;*   Refer to the MPASM User's Guide for additional information on     			*
;*   features of the assembler (Document DS33014).                     			*
;*                                                                     			*
;*   Refer to the respective PICmicro data sheet for additional        			*
;*   information on the instruction set.                               			*
;*                                                                     			*
;****************************************************************************************	
;*                                                                 			*
;*    Filename:	    MICROCHIP OS for 10F200  .asm                              		                *
;*    Date:         Jul, 2014                                   			*
;*    File Version: A, this is a new file                                    		*
;*                                                                     			*
;*    Author:       G Michael                                       		*
;*                  Applications Engineer                    				*
;*    Company:                      *
;*                                               			*
;****************************************************************************************
;*                                			                                *
;*    Files required:   m0-3.asm (macros)                                          		*
;*                                                                     			*
;*                                                                     			*
;*                                                                     			*
;****************************************************************************************
;*                                                                     			*
;*    Notes:        hardware 								*
;*		         					*
;*                                                                     			*
;****************************************************************************************
	list      p=10F222	; list directive to define processor
	#include  ..\m0-3.asm
	config_
 	
#define	OPTIONinit	b'11000000'	; no wakup, no pullup, Clock 1:1
#define TRISIOinit 	b'00001011'	; all ports input bar GP2	
#define GPIOinit 	b'00000100'	; GPIO 2 high
;****************************************************************************************
    

	init_			; reasonable initiation of special function registers 


	cblock	_MINRAM			; start of variables
	 SyS1,SyS2,Result
	endc


#define STACK		_MAXRAM
#define	GPis_on		SyS1,0
#define	GPwas_on	SyS1,1
#define	TMR07Bit	SyS1,7

#define	minutes		.60

;PWRUP	
		eq	SyS1,0
		eq	SyS2,0

TC0used = 3					; use 3 bytes of timer for TC0
	cblock
	 TC0:TC0used
	 NmbrEvent0
	endc	 
		EVENT0in	.1500,msec,0  ; set time @ 5000 milliseconds

JMPTable	andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0	
		 goto	EVENT1
		 goto	EVENT2	
		 goto	EVENT3
		 goto	EVENT4
		 goto	EVENT5
		 goto	EVENT6
		 goto	EVENT7
		 goto	EVENT8
		 goto	EVENT9
		 goto	EVENT10
		 goto	EVENT11
		 goto	EVENT12
		 goto	EVENT13
		 goto	EVENT14
		 goto	EVENT15

;	org	0x100
	
MLOOP	clrwdt
;		if_	GPIO,1,is_off,	1
;		 goto EVENT1		; check if low voltage is on

;	if_not	TMR0,0			;example for very short periodic events
;	 goto	n64MLO
;	goto	PERIODIC64usec
exitPERIODIC64usec		
;	if_ 	TMR0,0,is_on,   1	; avoid multiple P64u's, wait until bit0 is set
;	 goto	exitPERIODIC64usec
;
n64MLO	
	if_	    TMR0,7,is_on, singlebit			; software emulation of
	 goto	set7			; timer 0 overflow
	if_ 	TMR07Bit,is_off, singlebit		;
	 goto	set7+1
		
	bcf	TMR07Bit

	goto	PERIODIC8		; which is 256*64 us =8 milliseconds
exitPERIODIC8
	decfsz	TC0,F
	 goto	endMLOOP0
	goto	PERIODIC2048		; after first TC0 expired, 2048 milliseconds 
exitPERIODIC2048			; have passed
	if TC0used > 1
	movlw	0x07			;example for very long periodic events
	andwf	TC0+1,W
	movwf	STACK
	movlw	-7
	addwf	STACK,W
	skpnZ
	 goto	PERIODIC16sec		; every 16 seconds (Event0 must be later!)
exitPERIODIC16sec
	decfsz	TC0+1,F
	 goto	endMLOOP0
	endif
					; after TC0+1 expired, 8 minutes 44 seconds
	if TC0used > 2			; have passed
	decfsz	TC0+2,F
	 goto	endMLOOP0
	endif 
	movfw	NmbrEvent0		; after TC0+2 expired, 37 hours 17 minutes
	goto	JMPTable 		; now jump to loaded Event
	 
endMLOOP0				; and continue execution here	 
end0MLOOP0
	if TC1used > 0
	decfsz	TC1,F			; analogous as TC0
    endif
	 goto	endMLOOP1


	if TC1used > 1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	endif
	if TC1used > 2
	decfsz	TC1+2,F
	 goto	endMLOOP1
	endif 
	if TC1used > 0
	movfw	NmbrEvent1
	goto	JMPTable 
	endif 
	 
set7	bsf	TMR07Bit	
endMLOOP1	goto	MLOOP

;	org	0x200
PERIODIC64usec			
		goto	exitPERIODIC64usec

PERIODIC8
		goto	exitPERIODIC8			

PERIODIC2048	
		goto	exitPERIODIC2048
		
PERIODIC16sec	
		goto	exitPERIODIC16sec	
				 
EVENT0		
		
          bcf GPIO,2
		  nop
		  nop
		  nop
		  nop
		  bsf GPIO,2
		delay .100
          goto EVENT0

EVENT1	
		
EVENT2			
		
EVENT3
		 
EVENT4		

EVENT5		
		
EVENT6	

EVENT7		

EVENT8		

EVENT9		

EVENT10		

EVENT11		


EVENT12	
	

EVENT13
	

EVENT14 
	
	

EVENT15 
	
;
;    if_ TMR0,<,Result, byte
;      bcf pwm_output
;    else_
;      bsf pwm_output

	
		end