;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..5 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G M DRYGAS                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      MICHAELS Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3b                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F222	; list directive to define processor
	#include  ..\m0-3.asm
	config_
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************


	cblock _MINRAM
	 SystemStatus
	 PR2,TimerTick,AsyncCounter:2

	endc
#define STACK		_MAXRAM
#define	TMR07Bit	SystemStatus,7


#define GPIOinit 	b'00000100'	; GPIO 2 high
#define TRISIOinit	b'11111011'	; configure NFET_Gate_Port as output 
#define	OPTIONinit	b'11001000'	; no wakup, no pullup, Clock 1:2
;#define	ADCON0init	b'01000001'	; gP0 analog, chanel 00,enable
;#define	ADCON0init	b'10000101'	; gP1 analog, chanel 01,enable


	init_


#define Lo_Intensity	.240
#define Hi_Intensity	.16
#define	NFET_Gate_Port	GPIO,2

TC0used = 3					; use 3 bytes of timer for TC0
	cblock
	 TC0:TC0used
	 NmbrEvent0
	endc	 


MAIN	
    eq_	PR2,=, Hi_Intensity*3,lit8	;start with intensity
	
cycle	
    incf	PR2,W 			; 5 .. 255=off
	skpnz
	 goto	ploop
	if_	GPIO,3,is_off,1
  	 bcf	NFET_Gate_Port		; NFET or Transistor on
	movfw	PR2
	addwf	TMR0,W			; 4 us
	movwf	TimerTick
ploop	
	bsf	NFET_Gate_Port		; and off
	
;
;	if_		TMR0,7,is_on,1
;	 goto	set7
;	if_		TMR07Bit,is_off,1
;	 goto	set7+1
;	bcf	TMR07Bit
;	decfsz	TC0,F
;	 goto	clred
;	decfsz	TC0+1,F
;	 goto    clred
;	movfw	NmbrEvent0
;	movwf	PCL
;
;set7	bsf	TMR07Bit
clred
	movfw	TimerTick
	subwf	TMR0,W
	andlw	B'11110000'
	skpZ
	 goto	ploop
	goto cycle



async	decfsz	AsyncCounter,F
	 goto	ploop
	decfsz	AsyncCounter+1,F
	 goto	ploop			; 7msec to 158ms check input

	goto 	cycle

ADC	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1

 	goto	linearze

;
;	eq	x,.0
;tstloop	incfsz	x,F
;	 goto	linearze
;	goto	$
;

vtable	addwf	PCL,F
	dt	2* (1+1)-1
	dt .32,	Hi_Intensity
	dt .255,Lo_Intensity

#define MdB	STACK-0
#define LoB	STACK-1
#define HiB	STACK-2

#define MdD	STACK-3
#define LoD	STACK-4
#define HiD	STACK-5
  
#define	AL	ADRES



linearze 		
		eq_	MdB,=,.1,	lit8
		call	vtable
		movwf	LoB
		if_	AL,>,LoB,	byte
		 goto	bases
exbdry		do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	MdD
		goto done

bases		movlw	0
		call	vtable
		movwf	MdB
		call	vtable
		movwf	HiB
		if_	AL,>=,HiB,	byte
		 goto exbdry

basesearch	do_	MdB,=,MdB,-,(1+1),lit8 
		movfw	MdB
		call	vtable
		movwf	LoB
		if_	AL,>=,LoB,	byte
		 goto 	binsearch
		eq_	HiB,=,LoB,	byte
		goto	basesearch

binsearch	do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	LoD
		do_	MdB,=,MdB,+,(1+1),	lit8
		movfw	MdB
		call	vtable
		movwf	HiD

binloop		do_	MdB,=,LoB,+,HiB,	(byte)
		rrf	MdB,F
		do_	MdD,=,LoD,+,HiD,	(byte)
		rrf	MdD,F
		
		if_	AL,>,MdB,		(byte)
		 goto	higher

		skpNZ				; AL equal MdB
		 goto	done

		eq_	HiB,=,MdB,	byte
		eq_	HiD,=, MdD,	byte
		goto	binloop
higher		eq_	LoB,=,MdB,	byte
		eq_	LoD,=,MdD,	byte
		goto	binloop

done		eq_	PR2,=,MdD,	byte
;		goto	tstloop
		goto	cycle
	end