;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..5 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*   from a 30 seconds pulse at  GPIO3                                 *
;*   GPIO1 Input needs 10nF to Vss and 220k (+2.7VZener) to Vdd        *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros.inc                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:  on every pulse on GPIO3                                  *
;*            pause width will start with 620 microseconds             *
;*            and ramp down to 16 microseconds, wait for x minutes     *
;*            and ramp up to  620 microseconds to go off               *
;*                                                                     *
;*             
;  program consists of following elements
;  -initialize on power up, wake up on pin change (or wdt reset -not used)
;  -test battery voltage
;  -set upramp delay
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to decremented cycletime and desired ramp shape
;  -loop until maximum brightness
;  -set new (latency) delay
;  -check input, if on, set extend latency
;  -loop in pulse width modulation cycle until until latency expires
;  -set downramp delay
;  -check input, if on, goto 'set upramp delay'
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to incremented cycletime and desired ramp shape
;  -loop until minimum brightness
;  -goto sleep, wait for wake up on pin change 	                       *
;***********************************************************************
	list      p=10F206	; list directive to define processor
	#include <p10f206.inc>	; processor specific variable definitions

	#include macros.inc
;	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC	; with charger
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without charger
;	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS
	IFDEF __10F206
	cblock 0x08				; var starting at  0x08
	 	UR_1
		UprampFrac
		UprampTime:3
		

	endc
	ENDIF
	
	cblock 0x10
		AL,AH,AHH,BL,BH
		
		PeriodCounter			; variables starting at  0x10
		SystemStatus			; flags
		PeriodReg			; intensity
		TimeCounter:3			; Time to wait for next PIR
		DutyCase,MaxTmr
	endc

	IFDEF __10F202
	cblock 0x08				; var starting at  0x08
	 
	endc
	ENDIF
		

;******************************************************************************
;***** CONSTANT DEFINITIONS
#define TRISGPIO 	6		; 10F200family speciality
					; 
#define	NFET_Gate_Port	GPIO,2		; 
#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111011'	; configure NFET_Gate_Port as output 
					;		   GPIO0,1,3 are input
#define PIR_On_Port	GPIO,3		; 

#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6

#define	Latency_Extend	SystemStatus,5
#define	PIR_Storage	SystemStatus,4
#define	Inter_Val	SystemStatus,3


#define Tmr0_Bit7	SystemStatus,0
#define send_first	SystemStatus,0

#define Lo_Intensity	.240
#define Hi_Intensity	.1


;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	;ORG     0xFF or 1xFF    ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	goto	RESET	



I004		nop
		nop
		nop
		nop
		nop
		nop
		nop
startcycle	

;		movfw	DutyPause
;		addwf	PCL,F
;		goto
;		CALL DELAY1STEP   ;1
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;3
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;5
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;7
;		CALL DELAY1STEP   
;		CALL DELAY1STEP   ;9
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;11
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;13
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;15
;		movfw	DutyLoPause
;		addwf	PCL,F
;		nop
;		nop
;		nop
;		nop
;		
;		nop
;		nop
;		nop
;		nop		
;	
;		nop
;		nop
;		nop
;		nop		
;
;		nop
;		nop
;		nop
;		nop		
;
;





		movfw	PeriodReg
		movwf	PeriodCounter
		decfsz	PeriodCounter,F		;1
		 goto	$-1		;2,3 cycles

		movfw	DutyCase		;0..15
		addwf	PCL,F
		 goto	onecycle
		 bsf	NFET_Gate_Port		; 1:  42+15
		 call	long
		 bsf	NFET_Gate_Port		; 3:  26
		 call	short
		 bsf	NFET_Gate_Port		; 5:  15+15
		 call	veryshort	
		 bsf	NFET_Gate_Port		; 7:  8
		 bsf	NFET_Gate_Port		; 8:  7
		 bsf	NFET_Gate_Port		; 9:  6us
		 bsf	NFET_Gate_Port		; 10: 5
		 bsf	NFET_Gate_Port		; 11: 4
		 bsf	NFET_Gate_Port		; 12: 3
		 bsf	NFET_Gate_Port		; 13: 2us
onecycle	 bsf	NFET_Gate_Port		; 14: 1us+15
		 bcf	NFET_Gate_Port		; 15: NFET or Transistor off
			
					
timouter	;clrf	TMR0			;  Test
		incfsz	TimeCounter,F
		 goto 	testport
		decf	UprampTime,W
		movwf	TimeCounter
		decfsz	TimeCounter+1,F		;16*255 = 4ms
		 goto 	startcycle-3
		btfsc	Inter_Val		;4ms * 255=1sec
		 goto	intervall		; case 0
		decfsz	TimeCounter+2,F
		 goto startcycle
		retlw	0

testport	btfss	PIR_On_Port	; 
	 	 goto	startcycle-4
		bsf	Latency_Extend
		goto	startcycle-2

long		goto	$+1	;
		goto	$+1
		goto	$+1
short		goto	$+1
		goto	$+1
veryshort	goto	$+1
		retlw	0
		
timefactor	movfw	DutyCase
		addwf	PCL,F
		retlw	.255*.16/.16
		retlw	.256*.16/.57   ;1
		retlw	.256*.16/.57   ;
		retlw	.256*.16/.41   ;3
		retlw	.256*.16/.41   ;
		retlw	.256*.16/.30   ;5
		retlw	.256*.16/.30   ; 
		retlw	.256*.16/.23   ;
		retlw	.256*.16/.22   ;8
		retlw	.256*.16/.21   ;
		retlw	.256*.16/.20   ;10
		retlw	.256*.16/.19   ;
		retlw	.256*.16/.18   ;12
		retlw	.256*.16/.17   ;-3*periodReg
		retlw   .255*.16/.16
		retlw	.255

periodfactor	movfw	PeriodReg
		addwf	PCL,F
		retlw	.255*.16/.16
		retlw	.255*.16/.16   ;1
		retlw	.256*.16/.19   ;
		retlw	.256*.16/.22   ;3
		retlw	.256*.16/.25   ;
		retlw	.256*.16/.28   ;5
		retlw	.256*.16/.31   ; 
		retlw	.256*.16/.34   ;
		retlw	.256*.16/.37   ;8
		retlw	.256*.16/.40   ;
		retlw	.256*.16/.43   ;10
		retlw	.256*.16/.46   ;
		retlw	.256*.16/.49   ;12
		retlw	.256*.16/.52   ;-3*periodReg
		retlw   .255*.16/.55   ;14
		retlw	.255*.16/.58   ;


volttab		movfw	DutyCase
		addwf	PCL,F

		retlw	b'10001000';	voltage value		;0
		retlw	b'10000010';	voltage value		;1
		retlw	b'10000000';	voltage value		;2

		retlw	b'01111110';	voltage value		;3
		retlw	b'01111100';	voltage value		;4
		retlw	b'01111010';	voltage value		;5
		retlw	b'01101000';	voltage value		;6
		retlw	b'01100100';	voltage value		;7
		retlw	b'01100010';	voltage value		;8
		retlw	b'01100000';	voltage value		;9
		retlw	b'01011100';	voltage value		;10

		retlw	b'01011010';	voltage value		;11
		retlw	b'01011001';	voltage value		;12

		retlw	b'01010100';	voltage value		;13
		retlw	b'01010000';	voltage value           ;14

		retlw	b'00100000';	overvoltage		;15

pause03		nop			;test
		decfsz	BL,F		;test
		 goto	$-2		;test
		decfsz	BH,F		;test
		goto	pause03		;test
		retlw 0			;test


RESET	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	
	GOTO	PWRUP		; goto error



undoreset			
 
	movlw	iodir
	TRIS 	TRISGPIO
	movlw	B'01001111'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:256 , WDT 1:1 ,
;				;bit 3 PSA: Prescaler Assignment bit
;				;1 = Prescaler assigned to the WDT
;				;0 = Prescaler assigned to Timer0
;				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				;Bit Value	Timer0 Rate 	WDT Rate
;				;000		1 : 2		1 : 1
;				;001		1 : 4		1:2
;				;010		1:8		1:4
;				;011		1:16		1:8
;				;100		1:32		1:16
;				;101		1:64		1:32
;				;110		1:128		1:64
;				;111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set port to LOW  
	movwf	GPIO

	call	undoreset	; TRIS + OPTION

	IFDEF __10F204	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	

;	eq	PeriodReg,Lo_Intensity	;test
;	eq	DutyCase, 0x00		;test
;	goto	MAIN			;test
;	goto	endvoltage			;test

;	eq	PeriodReg,1
;	eq	BL,.14
;testcycle	mov	BL,DutyCase
;	eeeq	TimeCounter, 0xFA0104
;	call	startcycle
;	decf	BL,F
;	goto	testcycle
;
	goto 	tstvoltage		; 1 ramp latency ramp cycle

prepslp				; wait for PIR to go UP
 	decfsz	PeriodCounter,F
	  goto $-1


	sleep			; at min consumption
					

;******************************************************************************
intervall	movlw	0x0F	
		xorwf	DutyCase,F
		goto	startcycle



decPR2	decf	PeriodReg,F		; PR2 -=1 brighter
seturtm	skpgel	PeriodReg, .15		;decf	UprampTime,F
	 goto	tblread
	movfw	PeriodReg				;4096 /(pR*3 +16)
	clrc
	movwf	AL
	rrf	AL,F
	clrc	
	rrf	AL,F
	movlw	.64
	subwf	AL,F
	comf	AL,W
	movwf	UprampTime+1
	goto	motime
tblread call	periodfactor
	movwf	UprampTime+1	
	goto	motime
	
;	skpgel	PeriodReg,.15
;	 goto	tblread
;	eq	BL,.128		;128=18ms 255= 38ms
;	movfw	PeriodReg
;decsub	subwf	BL,F
;	skpC	
;	 goto	motime
;	incfsz	UprampTime,F
;	 goto	decsub
;	incfsz	UprampTime+1,F
;	 goto	decsub
;	incf	UprampTime+2,F
;	goto	decsub
;
;tblread		call	readt
;		addwf	UprampTime,F
;		skpC
;		 goto	motime
;		incfsz	UprampTime+1,F
;		 goto	motime
;		incf	UprampTime+2,F
;		goto	motime
;
;readt		decf	PeriodReg,W
;		addwf	PCL,F
;		retlw	.255
;		retlw	.210 /.1
;		retlw	.210 /.2
;		retlw	.210 /.3
;		retlw	.210 /.4
;		retlw	.210 /.5
;		retlw	.210 /.6
;		retlw	.210 /.7
;		retlw	.210 /.8
;		retlw	.210 /.9
;		retlw	.210 /.10
;		retlw	.210 /.11
;		retlw	.210 /.12
;		retlw	.210 /.13
;               retlw	.210 /.14
;               retlw	.210 /.15
;
	;	eeq	url,.500000/.16
	; realtime division
	;	decf	PeriodReg,W
	;	movwf	BL
	;	addwf	BL,F
	;	skpnC
	;	 incf	BH,F
	;	addwf	BL,F
	;	skpnC
	;	 incf	BH,F		;(PR-1)*3
	;	call	Timefactor
	;	addwf	BL,F
	;	skpnC
	;	 incf	BH,F
	;	shrr	BL,4
	;	save	BL
	;xx	restore BL
	;	decc	url,BL
	;	bnC finsh
;		eeq	AL,.1
;
;	 zz 	incc	UprampTime,AL	;
;		shll	AL
;		shll	BL
;		decc	url,BL
;		skpc
;		 goto zz
;		incc	
;		goto xx
;	;rotlef	btfsc	AL,7
	;	 goto	decsub
	;	movfw	AL		;works on first not zero byte
	;	subwf	PeriodReg,W
	;	skpC
	;	 goto	decsub
	;	rlf	BH,F		; and subsequent bytes
	;	rlf	AL,F		
	;	goto	rotlef
	;decsub	movfw	BH	
	;	subwf	BL,W		; and subsequent bytes
	;	skpC
	;         goto	rotrght
	;	movwf	BL
	;	movfw	AL
	;	addwf	UprampTime,F	;
	;	skpnC
	;	 incf	UprampTime+1,F
	;rotrght	clrc	
	;	rrf	AL,F
	;	movf	AL,F
	;	skpnz
	;	 goto motime
	;	rrf	BH,F
	;	goto	decsub	
	;;***********************************************



;	nop
;	nop
;	nop	
;	movfw	DutyCase
;startcycl	addwf	PCL,F
;		goto intervall
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port		
;		bsf	NFET_Gate_Port
;		bcf	NFET_Gate_Port
;					
;timoute		clrf	TMR0; test
;		decfsz	TimeCounter,F
;		 goto 	startcycl-3
;		decfsz	TimeCounter+1,F		;
;		 goto 	tstpor	
;		decfsz	TimeCounter+2,F
;		 goto startcycl-1
;		btfss	Latency_Extend
;		 goto	endlatency
;		bcf	Latency_Extend;
;		goto	startcycl
;tstpor		btfsc	PIR_On_Port	; 
;		 bsf	Latency_Extend
;		goto startcycl-1
;
;



MAIN	eq	PeriodReg,Lo_Intensity
	mov	PeriodReg, UprampTime
	clrfff	UprampTime+1
	
;	call	timefactor
;	movwf	UprampTime+1
;	swapf   UprampTime+1,F
;	movlw	0x0F
;	andwf	UprampTime+1,F
;	
	clrf	SystemStatus
				; 
	bsf	Ramp_Running
	;bcf	Down_Running
	
	goto	motime


startpr	bcf	Latency_Extend	
	call 	startcycle					; timecounter expired
		btfss	Ramp_Running		; 
		 goto	endlatency		;      		     
		btfsc	Down_Running		; initialize downramp					
		 goto	down			;


;********************************** ramp up
		skpeql	PeriodReg,Hi_Intensity	;
		 goto	decPR2			;
						; ramp finished
						; 
endramp		bcf	Ramp_Running		; set latency time
		eq	UprampTime+2,0x38	; 56*256*256*(PeriodReg*3+14) us
		goto	motime
;************************************************

down		skpneql	PeriodReg,Lo_Intensity	; 
		 goto	prepslp			; goto sleep
incPR2		incf	PeriodReg,F		; PR2 +=1 dimmer
		incf	UprampTime
;
;		skpgel	PeriodReg,.13
;		 goto	tbl
;		movlw 	.7
;		goto	tbl+1
;tbl		call	readt
;		subwf	UprampTime,F
;		skpNC
;		 goto	 motime
;		movf	UprampTime+1,F
;		skpnz
;		 goto	ovl
;novl		decf	UprampTime+1,F
;		goto	motime
;ovl		movf	UprampTime+2,F
;		skpnz
;		 goto	crluf
;		decf	UprampTime+2,F
;		goto	novl
;crluf		clrf	UprampTime
		goto 	motime
;************************************************	
;	eq	BL,.255			;128=18ms 255= 38ms
;	movfw	PeriodReg	
;incsub	subwf	BL,F
;	skpC
;	 goto	motime
;	dec	UprampTime,F
;	movf	UprampTime,F
;	skpnz
;	 decf	UprampTime+1,F
;	decf	UprampTime,F
;	goto	incsub
;	
;
;********************************************************************
endlatency 	btfsc Latency_Extend		; latency extended due to	
	    	 goto motime-1			; picked up PIR signal
		bsf	Ramp_Running
		bsf	Down_Running
		eeeq	UprampTime, .90000/.27  
		goto	motime			;
;********************************************************************
		
tstport		btfss	PIR_On_Port	; 
	 	 goto	startcycle-4
		btfsc	Down_Running	; 
		 goto	reverserun
		bsf	Latency_Extend	; latency running
		goto	startcycle

reverserun	bcf	Down_Running
		clrfff	UprampTime
		goto	decPR2


		bcf	Latency_Extend
motime		decf	UprampTime,W
		movwf	TimeCounter
		incf	UprampTime+1,W
		movwf	TimeCounter+1
		incf	UprampTime+2,W
		movwf	TimeCounter+2
	; 
	goto	startpr	; 



afterwdt
;	bcf	PFET_Gate_Port
;	decfsz	PeriodCounter,F
;	  goto $-1
;	bsf	PFET_Gate_Port
	goto prepslp



				;
#define GP1_Porton	b'01110001'     ; configure comparator input=on
#define GP0_Porton	b'01110011'     ; configure comparator input=on, int ref, GP0


afterpin	goto	$+1
		decfsz	PeriodCounter,F
	  	 goto $-2		;5*256 =1280us
		btfss PIR_On_Port	; notest PIR still on?
	 	 goto prepslp		; notest too small PIR-Signal, or Change to OFF

#define	P100_Port	0

testcds		bcf	GPIO,P100_Port	; 
		if P100_Port
		 movlw	GP1_Porton     ; configure comparator input
		else
		movlw	GP0_Porton
		 endif
		movwf	CMCON0
		movlw	((1<< P100_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; discharge C
		movlw	.4
		movwf	AL		; 15 us
		decfsz	AL,F
		 goto	$-1		; 
		clrwdt
		movlw	iodir		;  GP,x is input
		TRIS 	TRISGPIO	; let C charge
		bsf	CMCON0,3	; comparator on
		clrf	AH
		clrf	AL		; 2 us
loop100		btfsc	CMCON0,7 	;btfss	GPIO,P100_Port
		 goto	exitloop100
		incfsz	AL,F
		 goto	loop100		;timeout 1000us	
		incfsz	AH,F
		 goto	loop100
		decf	AH,F
		decf	AL,F	
exitloop100	bcf	CMCON0,3	;comparator off
;		bcf	GPIO,P100_Port			;test		
;		movlw	((1<< P100_Port) ^ 0xFF) & iodir;test
;		TRIS 	TRISGPIO	; discharge C	;test
	
		skpgell AL, 0x007F
		  goto prepslp		; CDS too low, too bright

		eq	PeriodReg,Lo_Intensity

;		movwf PeriodReg		; 0-176
;		incl	PeriodReg,0x20	; 32-208
;;		eq	AL,.10 	;test
;		decfsz	AL,F	;test
;		 goto	$-1	;test
;		Goto testcds	;test
;	


#define	C10N_Port	1				;

tstvoltage	
		bcf	GPIO,C10N_Port
		if C10N_Port
		 movlw	GP1_Porton     ; configure comparator input
		else
		movlw	GP0_Porton
		 endif
	
				;bit 7 bit 0
				;bit 7 CMPOUT: Comparator Output bit
				;1 = VIN+ > VIN-
				;0 = VIN+ < VINbit
				;6 COUTEN: Comparator Output Enable bit(1, 2)
				;1 = Output of comparator is NOT placed on the COUT pin
				;0 = Output of comparator is placed in the COUT pin
				;bit 5 POL: Comparator Output Polarity bit(2)
				;1 = Output of comparator not inverted
				;0 = Output of comparator inverted
				;bit 4 CMPT0CS: Comparator TMR0 Clock Source bit(2)
				;1 = TMR0 clock source selected by T0CS control bit
				;0 = Comparator output used as TMR0 clock source
				;bit 3 CMPON: Comparator Enable bit
				;1 = Comparator is on
				;0 = Comparator is off
				;bit 2 CNREF: Comparator Negative Reference Select bit(2)
				;1 = CIN- pin(3)
				;0 = Internal voltage reference
				;bit 1 CPREF: Comparator Positive Reference Select bit(2)
				;1 = CIN+ pin(3)
				;0 = CIN- pin(3)
				;bit 0 CWU: Comparator Wake-up on Change Enable bit(2)
				;1 = Wake-up on comparator change is disabled
				;0 = Wake-up on comparator change is enabled.
				;Note 1: Overrides T0CS bit for TRIS control of GP2.
		movwf	CMCON0	
		movlw	((1<< C10N_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; discharge C
		eq	AL,.1		; 5 us delay
		decfsz	AL,F
		 goto	$-1		; 
		movlw	iodir		;  GP is input
		TRIS 	TRISGPIO	; charge C
		bsf	CMCON0,3	; comparator on
		clrf	AL
loop		btfsc	CMCON0,7
		 goto	exitloop
		incfsz	AL,F
		 goto	loop		;timeout 1000us	
		decf	AL,F	
		
exitloop	bcf	CMCON0,3	;comparator off



		eq	DutyCase,.15
morecalls	call    volttab
		subwf	AL,W
		skpC
		 goto	endvoltage
		decfsz	DutyCase,F
		goto	morecalls			
endvoltage	;		movlw	.14
		;movwf	DutyCase 
;		eq	PeriodReg,1
;		clrf	AH
;		
;;******************************************TEST TEST TEST
;displaybits	eq	AHH, 10
;		movlw	0
;		call	pause03
;		decfsz	AHH,F
;		 goto	$-2
;
;		eq	AHH, .15
;firstbit	movf	AHH,F
;		skpnanotb AH, 7, STATUS, Z
;		 goto nextbit-1
;		clrC
;		rlf	AL,F
;		rlf	AH,F
;		decf	AHH,F
;		goto	firstbit
;		incf	AHH,F
;nextbit		call	timefactor
;		movwf	TimeCounter+1
;		setc				;restore AL
;		rlf	AL,F
;		rlf	AH,F
;		skpNC
;		 goto	$+6
;		clrC
;		rrf	TimeCounter+1,F
;		clrC
;		rrf	TimeCounter+1,F
;		bcf	AL,0			;restore AL
;		eq	TimeCounter+2,1
;		call	startcycle
;
;		call	pause03
;		decfsz	AHH,F
;		 goto nextbit
;
;		decf	DutyCase,F
;		skplel	DutyCase,8
;		 goto	displaybits		
;		goto 	tstvoltage
;
;******************************************TEST TEST TEST
;exitp100		bsf	send_first		
;		skplesl	AH,.125
;		 goto	send125
;		skplesl	AH,.25
;		 goto	send25
;		skplesl	AH,.5
;		 goto	send5
;		skplesl	AH,.1
;		 goto	send1
;		eq	AH,.06
;		call	pause03
;		decfsz	AH,F
;		 goto	$-2
;		btfss	send_first
;		 goto	endsend
;		bcf	send_first
;		mov	AL,AH
;		goto	exitp100+1
;endsend		eq	AL,.20
;		call pause03
;		decfsz	AL,F
;		 goto	$-2
;		goto	testcds		
;send1		decf	AH,F	
;		eeq	BL,.2300
;		goto	send25cycles
;
;send5		decl	AH,.5	
;		eeq	BL,.8000
;		goto	send25cycles
;
;send25		decl	AH,.25	
;		eeq	BL,.22000
;		goto	send25cycles
;			
;		
;send125		decl	AH,.125	
;		eeq	BL,.65000
;		goto	send25cycles
;		
;
;
;send25cycles	eq	AHH,.8
;		decfsz	AHH,F
;		 goto	$-1
;		bsf	NFET_Gate_Port
;		bcf	NFET_Gate_Port
;		decfsz	BL,F
;		 goto	send25cycles
;		decfsz	BH,F
;		 goto	send25cycles
;		call	pause03
;		goto	exitp100+1
;
;;********************************TEST TEST TEST
;	eq	AL,.10 ;test
;		decfsz	AL,F;test
;		 goto	$-1;test
;		Goto testcds;test


		GOTO MAIN
	end
