;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..42 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*   initiated by a 30 seconds pulse at  GPIO3                                 *
;*   GPIO1 Input needs 10nF to Vss and 220k (+2.7VZener) to Vdd        *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: 3.7                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros.inc                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:  on every pulse on GPIO3                                  *
;*            pause width will start with 620 microseconds             *
;*            and ramp down to 16 microseconds, wait for x minutes     *
;*            and ramp up to  620 microseconds to go off               *
;*                                                                     *
;*             
;  program consists of following elements
;  -initialize on power up, wake up on pin change (or wdt reset -not used)
;  -test battery voltage
;  -test photo resistor
;  -set upramp delay
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to decremented cycletime and desired ramp shape
;  -loop until maximum brightness
;  -set new (latency) delay
;  -check input, if on, set extend latency
;  -loop in pulse width modulation cycle until until latency expires
;  -set downramp delay
;  -check input, if on, goto 'set upramp delay'
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to incremented cycletime and desired ramp shape
;  -loop until minimum brightness
;  -goto sleep, wait for wake up on pin change 	                       *
;***********************************************************************
	list      p=10F206	; list directive to define processor
	#include <p10f206.inc>	; processor specific variable definitions

	#include macros.inc
;	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC	; with charger
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without charger
		;bit 11-5 Unimplemented: Read as 0
		;bit 4 MCLRE: GP3/MCLR Pin Function Select bit
		;1 = GP3/MCLR pin function is MCLR
		;0 = GP3/MCLR pin function is digital I/O, MCLR internally tied to VDD
		;bit 3 CP: Code Protection bit
		;1 = Code protection off
		;0 = Code protection on
		;bit 2 WDTE: Watchdog Timer Enable bit
		;1 = WDT enabled
		;0 = WDT disabled
		;bit 1-0 Reserved: Read as 0
		;2: INTRC is the only oscillator mode offered on the PIC10F200/202/204/206
;	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS
	IFDEF __10F206
	cblock 0x08				; var starting at  0x08

		UprampTime:3

	endc
	ENDIF
	
	cblock 0x10
		AL,AH,AHH,BL,BH,BHH
		
		PeriodCounter			; variables starting at  0x10
		SystemStatus			; flags
		PeriodReg			; intensity
		TimeCounter:3			; Time to wait for next PIR
		DutyCase,HiIntensity
	endc

	IFDEF __10F202
	cblock 0x08				; var starting at  0x08
	 
	endc
	ENDIF
		

;******************************************************************************
;***** CONSTANT DEFINITIONS
#define TRISGPIO 	6		; 10F200family speciality
					; 
#define	NFET_Gate_Port	GPIO,2		; 
#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111011'	; configure NFET_Gate_Port as output 
					;		   GPIO0,1,3 are input
#define PIR_On_Port	GPIO,3		; 

#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6

#define	Latency_Extend	SystemStatus,5
#define	PIR_Storage	SystemStatus,4
#define	Inter_Val	SystemStatus,3


#define Tmr0_Bit7	SystemStatus,0
#define send_first	SystemStatus,0

#define Lo_Intensity	.255

				;
#define GP1_Porton	b'01110001'     ; configure comparator input=on
#define GP0_Porton	b'01110011'     ; configure comparator input=on, int ref, GP0




;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	;ORG     0xFF or 1xFF    ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	goto	RESET	



I004						; touches W, Z and C

;		movfw	DutyPause
;		addwf	PCL,F
;		goto
;		CALL DELAY1STEP   ;1
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;3
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;5
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;7
;		CALL DELAY1STEP   
;		CALL DELAY1STEP   ;9
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;11
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;13
;		CALL DELAY1STEP
;		CALL DELAY1STEP   ;15
;		movfw	DutyLoPause
;		addwf	PCL,F
;		nop
;		nop
;		nop
;		nop
;		
;		nop
;		nop
;		nop
;		nop		
;	
;		nop
;		nop
;		nop
;		nop		
;
;		nop
;		nop
;		nop
;		nop		
;
;





		movfw	PeriodReg
		movwf	PeriodCounter
		decfsz	PeriodCounter,F		;1
		 goto	$-1		;2,3 cycles

I007		movfw	DutyCase		;0..15
		addwf	PCL,F
		 goto	onecycle
		 bsf	NFET_Gate_Port		; 1:  42+15
		 call	long
		 bsf	NFET_Gate_Port		; 3:  26
		 call	short
		 bsf	NFET_Gate_Port		; 5:  15+15
		 call	veryshort	
		 bsf	NFET_Gate_Port		; 7:  8
		 bsf	NFET_Gate_Port		; 8:  7
		 bsf	NFET_Gate_Port		; 9:  6us
		 bsf	NFET_Gate_Port		; 10: 5
		 bsf	NFET_Gate_Port		; 11: 4
		 bsf	NFET_Gate_Port		; 12: 3
		 bsf	NFET_Gate_Port		; 13: 2us
onecycle	 bsf	NFET_Gate_Port		; 14: 1us+15
		 bcf	NFET_Gate_Port		; 15: NFET or Transistor off
			
					
timouter	retlw	0



long		goto	$+1	;
		goto	$+1
		goto	$+1
short		goto	$+1
		goto	$+1
veryshort	goto	$+1
		retlw	0

#define onecyc	.22
		
timefactor	movfw	DutyCase
		addwf	PCL,F
		retlw	onecyc 
		retlw	onecyc+.41    	;1
		retlw	onecyc+.41   	;
		retlw	onecyc+.25  	;3
		retlw	onecyc+.25   	;
		retlw	onecyc+.14   	;5
		retlw	onecyc+.14   	; 
		retlw	onecyc+.7   	;
		retlw	onecyc+.6   	;8
		retlw	onecyc+.5   	;
		retlw	onecyc+.4   	;10
		retlw	onecyc+.3   	;
		retlw	onecyc+.2   	;12
		retlw	onecyc+.1   	;
		retlw   onecyc   	;14
		retlw	onecyc-1    ;


volttab		movfw	DutyCase
		addwf	PCL,F
		retlw	0xff					;0
		retlw	b'10010010'; 0x92	voltage value	3.0	;1
		retlw	0
		retlw	b'10000111'; 0x87	voltage value	3.15	;3
		retlw	0
		retlw	b'01111111'; 0x7F	voltage value	3.25	;5
                retlw	0
		retlw	b'01110101'; 0x75	voltage value	3.4	;7

		retlw	b'01100011'; 0x63	voltage value		;8
		retlw	b'01010100'; 0x54	voltage value		;9
		retlw	b'01001011'; 0x4B	voltage value		;10

		retlw	b'01000100'; 0x44	voltage value		;11
		retlw	b'00111101'; 0x3d	voltage value		;12

		retlw	b'00111011'; 0x3b	voltage value		;13
		retlw	b'00111001'; 0x39	voltage value  4.8V     ;14

		retlw	b'00100000'; 0x20	overvoltage		;15

cdstab		
		addwf	PCL,F

#define		pblack	b'00100011';
#define		fvalue	b'00001011'
		retlw	b'00000000';	no good value		;0
		retlw	fvalue	;1 last value to fire
		retlw	(.15*pblack+.85*fvalue)/.100	;2

		retlw	(.25*pblack+.75*fvalue)/.100	;3
		retlw	(.35*pblack+.65*fvalue)/.100	;4
		retlw	(.45*pblack+.55*fvalue)/.100		;5
		retlw	(.55*pblack+.45*fvalue)/.100		;6
		retlw	(.65*pblack+.35*fvalue)/.100		;7
		retlw	(.73*pblack+.27*fvalue)/.100		;8
		retlw	(.80*pblack+.20*fvalue)/.100		;9
		retlw	(.86*pblack+.14*fvalue)/.100		;10

		retlw	(.91*pblack+.9*fvalue)/.100		;11
		retlw	(.94*pblack+.6*fvalue)/.100	;12

		retlw	(.96*pblack+.4*fvalue)/.100	;13
		retlw	(.98*pblack+.2*fvalue)/.100; 		0x22;         	;14

		retlw	pblack;    0x23;	pitch black		;15





undoreset			
 
	movlw	iodir
	TRIS 	TRISGPIO
	movlw	B'01001111'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:256 , WDT 1:1 ,
;				;bit 3 PSA: Prescaler Assignment bit
;				;1 = Prescaler assigned to the WDT
;				;0 = Prescaler assigned to Timer0
;				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				;Bit Value	Timer0 Rate 	WDT Rate
;				;000		1 : 2		1 : 1
;				;001		1 : 4		1:2
;				;010		1:8		1:4
;				;011		1:16		1:8
;				;100		1:32		1:16
;				;101		1:64		1:32
;				;110		1:128		1:64
;				;111		1:256		1:128
				
	OPTION	
	retlw	0



testeither	movwf	CMCON0
		movlw	b'11111100'
		andwf	GPIO,F
		movlw	iodir & b'11111100' ;((1<< P100_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; discharge C
		movlw	.4
		movwf	AL		; 15 us
		decfsz	AL,F
		 goto	$-1		; 
		clrwdt
		movlw	iodir		;  GP,x is input
		TRIS 	TRISGPIO	; let C charge
		bsf	CMCON0,3	; comparator on
		clrf	AH
		clrf	AL		; 2 us
loop100		btfsc	CMCON0,7 	;btfss	GPIO,P100_Port
		 goto	exitloop100
		incfsz	AL,F
		 goto	loop100		;timeout 1000us	
		incfsz	AH,F
		 goto	loop100
		decf	AH,F
		decf	AL,F	
exitloop100	bcf	CMCON0,3	;comparator off#
		retlw	0

	movlw	GP0_Porton

testrealtime	movwf	CMCON0
		movlw	b'11111100'
		andwf	GPIO,F
		movlw	iodir & b'11111100' ;((1<< P100_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; discharge C

		eq	AHH,-.16
		inc	AHH,PeriodReg
		skpnC
		 goto
		eq	AHH,.2
		shr	AHH
		mov	AHH,BHH
		incl	BHH,.8
		eq	BL,-.13
		call	timefactor
		addwf	BL
		
		call	I007			; 22-13
		mov	AHH,PeriodCounter
		mov	BHH,AL
		
		movlw	iodir		;  GP,x is input
		TRIS 	TRISGPIO	; let C charge
		bsf	CMCON0,3	; comparator on
		mov	

elloop100	btfsc	CMCON0,7 	;btfss	GPIO,P100_Port
		 goto	elexitloop100
		decfsz  PeriodCounter,F
		 goto	elloop100
		Call	I007
		mov	AHH,PeriodCounter
		inc	AL,BHH		; for loop
		addC	AH
		inc	AL,BL		; for I007
		skpC
		 goto	elloop100	
elexitloop100	bcf	CMCON0,3	;comparator off#
		dec	AL,PeriodCounter
		;		goto	displaybits

		retlw	0




pause03		nop			;test
		decfsz	BL,F		;test
		 goto	$-2		;test
		decfsz	BH,F		;test
		goto	pause03		;test
		retlw 0			;test



testport	btfss	PIR_On_Port	; 
	 	 goto	startcycle-4
		bsf	Latency_Extend
		goto	startcycle-2

ms512		nop
		nop
		nop
		nop
		nop
		nop
		nop
startcycle	call I004
	;	clrf	TMR0			;  Test
		decfsz	TimeCounter,F
		 goto 	testport
		decfsz	TimeCounter+1,F		;
		 goto 	startcycle-5
		btfss	Inter_Val		;16us*65k =512msec
		 goto	nointervall
intervall	movlw	0x0F	
		xorwf	DutyCase,F
nointervall	decfsz	TimeCounter+2,F
		 goto startcycle-1

		btfss	Ramp_Running		; 
		 goto	endlatency		;      		     
		btfsc	Down_Running		; initialize downramp					
		 goto	down			;


;************************************************ ramp up
		skpleq	PeriodReg,HiIntensity	;
		 goto	decPR2			;
						; ramp finished
						; 
endramp		bcf	Ramp_Running		; set latency time

		eeq	BH,0x0100		;.10			; 183 sec
		goto	calctimer


;************************************************ ramp down

down		skpneql	PeriodReg,Lo_Intensity	; 
		 goto	prepslp			; goto sleep
		btfsc	Latency_Extend
		 goto	reverserun




incPR2		incf	PeriodReg,F		; PR2 +=1 dimmer
		eeq	BH,.4			;.16			;1sec
		goto	calctimer





reverserun	bcf	Latency_Extend
		bcf	Down_Running
		eeq	BH,0x0001			; 100ms
		goto	calctimer

decPR2		decf	PeriodReg,F		; PR2 -=1 brighter
		skplel	PeriodReg,.64
		 goto 	motime
		skpnZ
		 goto	tstvolts		; at 64		 
		incf	UprampTime,F
		

		skplel	PeriodReg, .8
		 goto	motime

		eeq	BH,.10			;<<<<<<
		dec	BH, PeriodReg		; decelerated
	
	
calctimer	call	I004
		clrf	AH
		decf	PeriodReg,W
		movwf	AL
		addwf	AL,F
		skpnC
		 incf	AH,F
		addwf	AL,F
		skpnC
		 incf	AH,F
		call	I004
		call	timefactor
		addwf	AL,F
		skpnC
		 incf	AH,F
		clrf	AHH
		clrf	BL
		clrff	UprampTime+1		
		
subloop		call	I004
		
		incfsz	UprampTime+1,F
		 decf	UprampTime+2,F
		incf	UprampTime+2,F	
		deccc	BL,AL
		skpnC
		 goto	subloop
		goto	motime	

;
;
;	eeeq	UrL,0x7FFF*.16
;		clrfff	UprampTime
;		clrfff	BL
;		call	I004		; realtime division
;		decf	PeriodReg,W
;		movwf	BH
;		addwf	BH,F
;		skpnC
;		 incf	BHH,F
;		addwf	BH,F
;		skpnC
;		 incf	BHH,F		;(PR-1)*3
;		call	timefactor
;		addwf	BH,F
;		skpnC
;		 incf	BHH,F
;		eeeq	AL,0x000100		;realtime division
;maxshift	skpnanotb	AHH,0,	BHH,7
;		 goto	testsub
;		shll	AH
;		shll	BH
;		call	I004
;		goto	maxshift
;	
;	
;testsub		skp24ge	UrL, BL
;		 goto	nosub		
;		inccc	UprampTime,AL
;		deccc	UrL,BL
; 		call	I004
;nosub		shrrr	AL
;		shrrr	BL
;		call	I004
;		
;		btfss	AL,0		;early break
;		 goto testsub		;unsuccessful subtract
;

		bcf	Latency_Extend

motime		call	I004
		incf	UprampTime,W
		movwf	TimeCounter
		incf	UprampTime+1,W
		movwf	TimeCounter+1
		incf	UprampTime+2,W
		movwf	TimeCounter+2

		goto	startcycle-2	; 

endlatency
resumeduty

;;		shll	AL		;resolution enhancer
;;		shll	AL
		eq	BL,.15
elmorecds	call	I004
		movfw	BL
		call    cdstab
		subwf	AL,W		;if slow AH
		skpnC
		 goto	elendcds
		decfsz	BL,F
		 goto	elmorecds
		goto	rampdown		; too bright			

elendcds	;btfss	Latency_Extend	;
;		 goto	eldown		;ramp up or down ??
;		skpge	BL,HiIntensity
;		 goto	elrampup
;		skpnZ			;darker
;		 goto	elextend	
;		incf	PeriodReg,F
;
;eldown		mov	BL,HiIntensity		; just in case it will go up
;;
elextend	btfsc Latency_Extend		; latency extended due to	
	    	 goto motime-1			; picked up PIR signal
rampdown	bsf	Ramp_Running
		bsf	Down_Running
		eeq	UprampTime+1,0x0001
		goto	motime			;

elrampup	mov	BL,HiIntensity	
		bsf	Ramp_Running
		bcf	Down_Running
		eeq	UprampTime+1,0x0001

		goto	motime-1

	movlw	GP1_Porton	
	call	testrealtime
		eq	DutyCase,.15
morevolts		movfw	HiIntensity
		call    voltab
		subwf	AL,W		; slow CDS: AH
		skpnC
		 goto	motime
		decfsz	HiIntensity,F
		 goto	morevolts	
		
		;incf	HiIntensity,F	; test			; HiIntensity = 0
		;goto	eendcds	; test 
		goto prepslp		; runtime 8 bits runtime  CDS too low, too bright

	goto

RESET	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	
	GOTO	PWRUP		; goto error





PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set port to LOW  
	movwf	GPIO

	call	undoreset	; TRIS + OPTION

	IFDEF __10F204	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	

;	eq	PeriodReg,Lo_Intensity	;test
;	eq	DutyCase, 0x00		;test
;	goto	MAIN			;test
;	goto	endvoltage			;test

;	eq	PeriodReg,1
;	eq	BL,.14
;testcycle	mov	BL,DutyCase
;	eeeq	TimeCounter, 0xFA0104
;	call	startcycle
;	decf	BL,F
;	goto	testcycle
;
	goto	MAIN


	clrf	SystemStatus
	
	goto 	testcds		; 1 ramp latency ramp cycle

prepslp				; wait for PIR to go UP
 	decfsz	PeriodCounter,F
	  goto $-1


	sleep			; at min consumption
					

;******************************************************************************



MAIN	eq	PeriodReg,Lo_Intensity
	eq	DutyCase,.14
	;mov	PeriodReg, UprampTime
	clrfff	UprampTime		; zero cycles	
					; 
	bsf	Ramp_Running
	bcf	Down_Running
	movlw	GP0_Porton	
	call	testrealtime
		eq	HiIntensity,.15
mamorecds		movfw	HiIntensity
		call    cdstab
		subwf	AL,W		; slow CDS: AH
		skpnC
		 goto	motime-1
		decfsz	HiIntensity,F
		 goto	mamorecds	
		
		;incf	HiIntensity,F	; test			; HiIntensity = 0
		;goto	eendcds	; test 
		goto prepslp		; runtime 8 bits runtime  CDS too low, too bright

	goto	motime-1





afterwdt
;	bcf	PFET_Gate_Port
;	decfsz	PeriodCounter,F
;	  goto $-1
;	bsf	PFET_Gate_Port
	goto prepslp



afterpin	goto	$+1
		decfsz	PeriodCounter,F
	  	 goto $-2		; 5*256 =1280us
		btfss PIR_On_Port	; runtime PIR still on?
	 	 goto prepslp		; runtime too small PIR-Signal, or Change to OFF

#define	P100_Port	0

		


;		bcf	GPIO,P100_Port			;test		
;		movlw	((1<< P100_Port) ^ 0xFF) & iodir;test
;		TRIS 	TRISGPIO	; discharge C	;test


testcds		movlw	GP0_Porton
		
				;bit 7 bit 0
				;bit 7 CMPOUT: Comparator Output bit
				;1 = VIN+ > VIN-
				;0 = VIN+ < VINbit
				;6 COUTEN: Comparator Output Enable bit(1, 2)
				;1 = Output of comparator is NOT placed on the COUT pin
				;0 = Output of comparator is placed in the COUT pin
				;bit 5 POL: Comparator Output Polarity bit(2)
				;1 = Output of comparator not inverted
				;0 = Output of comparator inverted
				;bit 4 CMPT0CS: Comparator TMR0 Clock Source bit(2)
				;1 = TMR0 clock source selected by T0CS control bit
				;0 = Comparator output used as TMR0 clock source
				;bit 3 CMPON: Comparator Enable bit
				;1 = Comparator is on
				;0 = Comparator is off
				;bit 2 CNREF: Comparator Negative Reference Select bit(2)
				;1 = CIN- pin(3)
				;0 = Internal voltage reference
				;bit 1 CPREF: Comparator Positive Reference Select bit(2)
				;1 = CIN+ pin(3)
				;0 = CIN- pin(3)
				;bit 0 CWU: Comparator Wake-up on Change Enable bit(2)
				;1 = Wake-up on comparator change is disabled
				;0 = Wake-up on comparator change is enabled.
				;Note 1: Overrides T0CS bit for TRIS control of GP2.
		call testeither
;		shll	AL		; AH *4	; resolution enhancer
;		shll	AL
		eq	HiIntensity,.15
morecds		movfw	HiIntensity
		call    cdstab
		subwf	AL,W		; slow CDS: AH
		skpnC
		 goto	endcds
		decfsz	HiIntensity,F
		 goto	morecds	
		
		;incf	HiIntensity,F	; test			; HiIntensity = 0
		;goto	eendcds	; test 
		goto prepslp		; runtime 8 bits runtime  CDS too low, too bright


endcds		clrC	
		 rlf	HiIntensity,F	; max result 11110 =30
eendcds		;movv	AL,UprampTime	; test
		;mov	HiIntensity,UprampTime;test
		;clrf	UprampTime+1

tstvoltage	movlw	GP1_Porton
		call	testeither

		eq	DutyCase,.15
morecalls	call    volttab
		subwf	AL,W
		skpC
		 goto	endvoltage
		decfsz	DutyCase,F
		 goto	morecalls			
		bsf	Inter_Val
endvoltage	goto	MAIN		
		

		
;;;******************************************TEST TEST TEST

;
;
displaybits	
;		bsf	Latency_Extend	;eq	DutyCase, .8		;test
;		mov	HiIntensity, PeriodReg	;test
;		mov	DutyCase,AL		;test
;


		eq	AHH, .8
	
moredisp	call	pause03
		decfsz	AHH,F
		 goto	$-2

		eq	AHH, .15
firstbit	movf	AHH,F
		skpnanotb AH, 7, STATUS, Z
		 goto nextbit-1
		clrC
		rlf	AL,F
		rlf	AH,F
		decf	AHH,F
		goto	firstbit
		incf	AHH,F

nextbit		decf	PeriodReg,W
		movwf	BL
		addwf	BL,F
		addwf	BL,F
		call	timefactor
		addwf	BL,F
		clrc	
		rrf	BL,F
nb		eq	BH,0xFF
		eq	TimeCounter+1,.8
		movfw	BL
		incf	TimeCounter+1,F
		subwf	BH,F
		skpnC
		 goto	$-3
		clrc				;restore AL
		rlf	AL,F
		rlf	AH,F
		skpC
		 goto	$+6
		clrC
		rlf	TimeCounter+1,F
		clrC
		rlf	TimeCounter+1,F
		bsf	AL,0			;restore AL

		nop
		nop
		nop
		nop
		nop
		nop
		nop
stcycle		call I004
	;	clrf	TMR0			;  Test
		decfsz	TimeCounter,F
		 goto 	stcycle-7
		decfsz	TimeCounter+1,F		;
		 goto 	stcycle-5

		call	pause03
		decfsz	AHH,F
		 goto nextbit
		goto	resumeduty				

		btfss	Latency_Extend
;		 goto	enddisplay
;		bcf	Latency_Extend
;		movv	UprampTime,AL
;
;		eq	AHH,.4
;		goto	moredisp
;
;enddisplay	goto	testcds
;
		GOTO MAIN
	end
