;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..5 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*   from a 30 seconds pulse at  GPIO3                                 *
;*   GPIO1 Input needs 10nF to Vss and 220k (+2.7VZener) to Vdd        *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros.inc                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:  on every pulse on GPIO3                                  *
;*            pause width will start with 620 microseconds             *
;*            and ramp down to 16 microseconds, wait for x minutes     *
;*            and ramp up to  620 microseconds to go off               *
;*                                                                     *
;*             
;  program consists of following elements
;  -initialize on power up, wake up on pin change (or wdt reset -not used)
;  -test battery voltage
;  -set upramp delay
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to decremented cycletime and desired ramp shape
;  -loop until maximum brightness
;  -set new (latency) delay
;  -check input, if on, set extend latency
;  -loop in pulse width modulation cycle until until latency expires
;  -set downramp delay
;  -check input, if on, goto 'set upramp delay'
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to incremented cycletime and desired ramp shape
;  -loop until minimum brightness
;  -goto sleep, wait for wake up on pin change 	                       *
;***********************************************************************
	list      p=10F206	; list directive to define processor
	#include <p10f206.inc>	; processor specific variable definitions

	#include C:\Programme\Microchip\macros.inc
;	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC	; with charger
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without charger
;	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS
	IFDEF __10F206
	cblock 0x08				; var starting at  0x08
	 	UR_1
		UprampFrac
		UprampTime:3
		

	endc
	ENDIF
	
	cblock 0x10
		AL,AH,AHH,BL,BH
						; variables starting at  0x10
		SystemStatus			; flags
		PeriodReg			; intensity
		TimeCounter:3			; Time to wait for next PIR
		DutyCase,DutyTime,DutyPause,MaxTmr
	endc

	IFDEF __10F202
	cblock 0x08				; var starting at  0x08
	 
	endc
	ENDIF
		

;******************************************************************************
;***** CONSTANT DEFINITIONS
#define TRISGPIO 	6		; 10F200family speciality
					; 
#define	NFET_Gate_Port	GPIO,2		; 
#define	NFET_Bitmask	b'00000100'	; 
#define	NFET_Bit	2
#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111011'	; configure NFET_Gate_Port as output 
					;		   GPIO0,1,3 are input
#define PIR_On_Port	GPIO,3		; 

#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6

#define	Latency_Extend	SystemStatus,5
#define Tmr0_Bit7	SystemStatus,0
#define send_first	SystemStatus,0

#define Lo_Intensity	.240
#define Hi_Intensity	.1


;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	;ORG     0xFF or 1xFF    ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	
	GOTO	PWRUP		; goto error



undoreset			
 
	movlw	iodir
	TRIS 	TRISGPIO
	movlw	B'01001111'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:256 , WDT 1:1 ,
;				;bit 3 PSA: Prescaler Assignment bit
;				;1 = Prescaler assigned to the WDT
;				;0 = Prescaler assigned to Timer0
;				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				;Bit Value	Timer0 Rate 	WDT Rate
;				;000		1 : 2		1 : 1
;				;001		1 : 4		1:2
;				;010		1:8		1:4
;				;011		1:16		1:8
;				;100		1:32		1:16
;				;101		1:64		1:32
;				;110		1:128		1:64
;				;111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set port to LOW  
	movwf	GPIO

	call	undoreset	; TRIS + OPTION

	IFDEF __10F204	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	

;	eq	PeriodReg,Lo_Intensity	;test
;	eq	DutyCase, 0x00		;test
;	goto	MAIN			;test
;	goto	endvoltage			;test

	goto 	tstvoltage		; 1 ramp latency ramp cycle

prepslp				; wait for PIR to go UP
 	decfsz	AL,F
	  goto $-1


	sleep			; at min consumption
					

;******************************************************************************

intervall 	btfsc	Ramp_Running
		 goto	timouter-2
		btfss	TMR0,7			; TMR0 overflow
		 goto	$+5			; replacement
		btfsc	Tmr0_Bit7
		 goto	noflip			; both set
		bsf	Tmr0_Bit7		;
		goto	noflip
		btfss	Tmr0_Bit7
		 goto	noflip			; both not set
		bcf	Tmr0_Bit7
		incf	MaxTmr,F		; overflow
	

noflip		btfss	MaxTmr,5
		 goto timouter

		goto timouter-2




decPR2	decf	PeriodReg,F		; PR2 -=1 brighter

	skpgel	PeriodReg,.13
	 goto	tblread
	eq	BL,.128		;128=18ms 255= 38ms
	movfw	PeriodReg
decsub	subwf	BL,F
	skpC	
	 goto	motime
	incfsz	UprampTime,F
	 goto	decsub
	incfsz	UprampTime+1,F
	 goto	decsub
	incf	UprampTime+2,F
	goto	decsub

tblread		call	readt
		addwf	UprampTime,F
		skpC
		 goto	motime
		incfsz	UprampTime+1,F
		 goto	motime
		incf	UprampTime+2,F
		goto	motime

readt		decf	PeriodReg,W
		addwf	PCL,F
		retlw	.255
		retlw	.210 /.1
		retlw	.210 /.2
		retlw	.210 /.3
		retlw	.210 /.4
		retlw	.210 /.5
		retlw	.210 /.6
		retlw	.210 /.7
		retlw	.210 /.8
		retlw	.210 /.9
		retlw	.210 /.10
		retlw	.210 /.11
		retlw	.210 /.12
		

	;	eq	AL,.1		; realtime division
	;	movfw	PeriodReg
	;	movwf	BH
	;	clrC
	;rotlef	btfsc	AL,7
	;	 goto	decsub
	;	movfw	AL		;works on first not zero byte
	;	subwf	PeriodReg,W
	;	skpC
	;	 goto	decsub
	;	rlf	BH,F		; and subsequent bytes
	;	rlf	AL,F		
	;	goto	rotlef
	;decsub	movfw	BH	
	;	subwf	BL,W		; and subsequent bytes
	;	skpC
	;         goto	rotrght
	;	movwf	BL
	;	movfw	AL
	;	addwf	UprampTime,F	;
	;	skpnC
	;	 incf	UprampTime+1,F
	;rotrght	clrc	
	;	rrf	AL,F
	;	movf	AL,F
	;	skpnz
	;	 goto motime
	;	rrf	BH,F
	;	goto	decsub	
	;;***********************************************
;	nop
;	nop
;	nop	
;	movfw	DutyCase
;startcycl	addwf	PCL,F
;		goto intervall
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port		
;		bsf	NFET_Gate_Port
;		bcf	NFET_Gate_Port
;					
;timoute		clrf	TMR0; test
;		decfsz	TimeCounter,F
;		 goto 	startcycl-3
;		decfsz	TimeCounter+1,F		;
;		 goto 	tstpor	
;		decfsz	TimeCounter+2,F
;		 goto startcycl-1
;		btfss	Latency_Extend
;		 goto	endlatency
;		bcf	Latency_Extend;
;		goto	startcycl
;tstpor		btfsc	PIR_On_Port	; 
;		 bsf	Latency_Extend
;		goto startcycl-1
;
;



MAIN	;eq	PeriodReg,Lo_Intensity
	clrfff	UprampTime	
	clrf	SystemStatus				; 
	bsf	Ramp_Running
	;bcf	Down_Running
	
	goto	motime
		
PORTTEST	btfss	PIR_On_Port	; 
	 	 goto	RET1STEP-4
		
DELAY1STEP	GOTO $+1
		GOTO $+1
		GOTO $+1
		GOTO $+1
		GOTO $+1
		GOTO $+1
		;GOTO $+1
		nop
RET1STEP	RETLW	NFET_Bitmask

		nop
		nop
		nop
		nop
		nop
		nop

startcycle	movlw	NFET_Bitmask
		xorwf	GPIO,F
		movfw	DutyPause
		btfss	GPIO,NFET_Bit
		 movfw	DutyTime
		addwf	PCL,F
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP

	
					
timouter	;clrf	TMR0			;  Test
		decfsz	TimeCounter,F
		 goto 	tstport
		decfsz	TimeCounter+1,F		;
		 goto 	startcycle-5	
		decfsz	TimeCounter+2,F
		 goto startcycle-3


;			   DutyTime   us      total us
;				PauseTime  us		  Hz    %
;		SUM  0
;		              0    0  272  272  544      1838 50.0
;		SUM  1
;		              0    1  272  255  527      1898 51.6
;		              1    0  255  272  527      1898 48.4
;		SUM  2
;		              0    2  272  238  510      1961 53.3
;		              1    1  255  255  510      1961 50.0
;		              2    0  238  272  510      1961 46.7
;		SUM  3
;		              0    3  272  221  493      2028 55.2
;		              1    2  255  238  493      2028 51.7
;		              2    1  238  255  493      2028 48.3
;		              3    0  221  272  493      2028 44.8
;		SUM  4
;		              0    4  272  204  476      2101 57.1
;		              1    3  255  221  476      2101 53.6
;		              2    2  238  238  476      2101 50.0
;		              3    1  221  255  476      2101 46.4
;		              4    0  204  272  476      2101 42.9
;		SUM  5
;		              0    5  272  187  459      2179 59.3
;		              1    4  255  204  459      2179 55.6
;		              2    3  238  221  459      2179 51.9
;		              3    2  221  238  459      2179 48.1
;		              4    1  204  255  459      2179 44.4
;		              5    0  187  272  459      2179 40.7
;		SUM  6
;		              0    6  272  170  442      2262 61.5
;		              1    5  255  187  442      2262 57.7
;		              2    4  238  204  442      2262 53.8
;		              3    3  221  221  442      2262 50.0
;		              4    2  204  238  442      2262 46.2
;		              5    1  187  255  442      2262 42.3
;		              6    0  170  272  442      2262 38.5
;		SUM  7
;		              0    7  272  153  425      2353 64.0
;		              1    6  255  170  425      2353 60.0
;		              2    5  238  187  425      2353 56.0
;		              3    4  221  204  425      2353 52.0
;		              4    3  204  221  425      2353 48.0
;		              5    2  187  238  425      2353 44.0
;		              6    1  170  255  425      2353 40.0
;		              7    0  153  272  425      2353 36.0
;		SUM  8
;		              0    8  272  136  408      2451 66.7
;		              1    7  255  153  408      2451 62.5
;		              2    6  238  170  408      2451 58.3
;		              3    5  221  187  408      2451 54.2
;		              4    4  204  204  408      2451 50.0
;		              5    3  187  221  408      2451 45.8
;		              6    2  170  238  408      2451 41.7
;		              7    1  153  255  408      2451 37.5
;		              8    0  136  272  408      2451 33.3
;		SUM  9
;		              0    9  272  119  391      2558 69.6
;		              1    8  255  136  391      2558 65.2
;		              2    7  238  153  391      2558 60.9
;		              3    6  221  170  391      2558 56.5
;		              4    5  204  187  391      2558 52.2
;		              5    4  187  204  391      2558 47.8
;		              6    3  170  221  391      2558 43.5
;		              7    2  153  238  391      2558 39.1
;		              8    1  136  255  391      2558 34.8
;		              9    0  119  272  391      2558 30.4
;		SUM 10
;		              0   10  272  102  374      2674 72.7
;		              1    9  255  119  374      2674 68.2
;		              2    8  238  136  374      2674 63.6
;		              3    7  221  153  374      2674 59.1
;		              4    6  204  170  374      2674 54.5
;		              5    5  187  187  374      2674 50.0
;		              6    4  170  204  374      2674 45.5
;		              7    3  153  221  374      2674 40.9
;		              8    2  136  238  374      2674 36.4
;		              9    1  119  255  374      2674 31.8
;		             10    0  102  272  374      2674 27.3
;		SUM 11
;		              0   11  272   85  357      2801 76.2
;		              1   10  255  102  357      2801 71.4
;		              2    9  238  119  357      2801 66.7
;		              3    8  221  136  357      2801 61.9
;		              4    7  204  153  357      2801 57.1
;		              5    6  187  170  357      2801 52.4
;		              6    5  170  187  357      2801 47.6
;		              7    4  153  204  357      2801 42.9
;		              8    3  136  221  357      2801 38.1
;		              9    2  119  238  357      2801 33.3
;		             10    1  102  255  357      2801 28.6
;		             11    0   85  272  357      2801 23.8
;		SUM 12
;		              0   12  272   68  340      2941 80.0
;		              1   11  255   85  340      2941 75.0
;		              2   10  238  102  340      2941 70.0
;		              3    9  221  119  340      2941 65.0
;		              4    8  204  136  340      2941 60.0
;		              5    7  187  153  340      2941 55.0
;		              6    6  170  170  340      2941 50.0
;		              7    5  153  187  340      2941 45.0
;		              8    4  136  204  340      2941 40.0
;		              9    3  119  221  340      2941 35.0
;		             10    2  102  238  340      2941 30.0
;		             11    1   85  255  340      2941 25.0
;		             12    0   68  272  340      2941 20.0
;		SUM 13
;		              0   13  272   51  323      3096 84.2
;		              1   12  255   68  323      3096 78.9
;		              2   11  238   85  323      3096 73.7
;		              3   10  221  102  323      3096 68.4
;		              4    9  204  119  323      3096 63.2
;		              5    8  187  136  323      3096 57.9
;		              6    7  170  153  323      3096 52.6
;		              7    6  153  170  323      3096 47.4
;		              8    5  136  187  323      3096 42.1
;		              9    4  119  204  323      3096 36.8
;		             10    3  102  221  323      3096 31.6
;		             11    2   85  238  323      3096 26.3
;		             12    1   68  255  323      3096 21.1
;		             13    0   51  272  323      3096 15.8
;		SUM 14
;		              0   14  272   34  306      3268 88.9
;		              1   13  255   51  306      3268 83.3
;		              2   12  238   68  306      3268 77.8
;		              3   11  221   85  306      3268 72.2
;		              4   10  204  102  306      3268 66.7
;		              5    9  187  119  306      3268 61.1
;		              6    8  170  136  306      3268 55.6
;		              7    7  153  153  306      3268 50.0
;		              8    6  136  170  306      3268 44.4
;		              9    5  119  187  306      3268 38.9
;		             10    4  102  204  306      3268 33.3
;		             11    3   85  221  306      3268 27.8
;		             12    2   68  238  306      3268 22.2
;		             13    1   51  255  306      3268 16.7
;		             14    0   34  272  306      3268 11.1
;		SUM 15
;		              0   15  272   17  289      3460 94.1
;		              1   14  255   34  289      3460 88.2
;		              2   13  238   51  289      3460 82.4
;		              3   12  221   68  289      3460 76.5
;		              4   11  204   85  289      3460 70.6
;		              5   10  187  102  289      3460 64.7
;		              6    9  170  119  289      3460 58.8
;		              7    8  153  136  289      3460 52.9
;		              8    7  136  153  289      3460 47.1
;		              9    6  119  170  289      3460 41.2
;		             10    5  102  187  289      3460 35.3
;		             11    4   85  204  289      3460 29.4
;		             12    3   68  221  289      3460 23.5
;		             13    2   51  238  289      3460 17.6
;		             14    1   34  255  289      3460 11.8
;		             15    0   17  272  289      3460  5.9
;		SUM 16
;		              1   15  255   17  272      3676 93.8
;		              2   14  238   34  272      3676 87.5
;		              3   13  221   51  272      3676 81.3
;		              4   12  204   68  272      3676 75.0
;		              5   11  187   85  272      3676 68.8
;		              6   10  170  102  272      3676 62.5
;		              7    9  153  119  272      3676 56.3
;		              8    8  136  136  272      3676 50.0
;		              9    7  119  153  272      3676 43.8
;		             10    6  102  170  272      3676 37.5
;		             11    5   85  187  272      3676 31.3
;		             12    4   68  204  272      3676 25.0
;		             13    3   51  221  272      3676 18.8
;		             14    2   34  238  272      3676 12.5
;		             15    1   17  255  272      3676  6.3
;		SUM 17
;		              2   15  238   17  255      3922 93.3
;		              3   14  221   34  255      3922 86.7
;		              4   13  204   51  255      3922 80.0
;		              5   12  187   68  255      3922 73.3
;		              6   11  170   85  255      3922 66.7
;		              7   10  153  102  255      3922 60.0
;		              8    9  136  119  255      3922 53.3
;		              9    8  119  136  255      3922 46.7
;		             10    7  102  153  255      3922 40.0
;		             11    6   85  170  255      3922 33.3
;		             12    5   68  187  255      3922 26.7
;		             13    4   51  204  255      3922 20.0
;		             14    3   34  221  255      3922 13.3
;		             15    2   17  238  255      3922  6.7
;		SUM 18
;		              3   15  221   17  238      4202 92.9
;		              4   14  204   34  238      4202 85.7
;		              5   13  187   51  238      4202 78.6
;		              6   12  170   68  238      4202 71.4
;		              7   11  153   85  238      4202 64.3
;		              8   10  136  102  238      4202 57.1
;		              9    9  119  119  238      4202 50.0
;		             10    8  102  136  238      4202 42.9
;		             11    7   85  153  238      4202 35.7
;		             12    6   68  170  238      4202 28.6
;		             13    5   51  187  238      4202 21.4
;		             14    4   34  204  238      4202 14.3
;		             15    3   17  221  238      4202  7.1
;		SUM 19
;		              4   15  204   17  221      4525 92.3
;		              5   14  187   34  221      4525 84.6
;		              6   13  170   51  221      4525 76.9
;		              7   12  153   68  221      4525 69.2
;		              8   11  136   85  221      4525 61.5
;		              9   10  119  102  221      4525 53.8
;		             10    9  102  119  221      4525 46.2
;		             11    8   85  136  221      4525 38.5
;		             12    7   68  153  221      4525 30.8
;		             13    6   51  170  221      4525 23.1
;		             14    5   34  187  221      4525 15.4
;		             15    4   17  204  221      4525  7.7
;		SUM 20
;		              5   15  187   17  204      4902 91.7
;		              6   14  170   34  204      4902 83.3
;		              7   13  153   51  204      4902 75.0
;		              8   12  136   68  204      4902 66.7
;		              9   11  119   85  204      4902 58.3
;		             10   10  102  102  204      4902 50.0
;		             11    9   85  119  204      4902 41.7
;		             12    8   68  136  204      4902 33.3
;		             13    7   51  153  204      4902 25.0
;		             14    6   34  170  204      4902 16.7
;		             15    5   17  187  204      4902  8.3
;		SUM 21
;		              6   15  170   17  187      5348 90.9
;		              7   14  153   34  187      5348 81.8
;		              8   13  136   51  187      5348 72.7
;		              9   12  119   68  187      5348 63.6
;		             10   11  102   85  187      5348 54.5
;		             11   10   85  102  187      5348 45.5
;		             12    9   68  119  187      5348 36.4
;		             13    8   51  136  187      5348 27.3
;		             14    7   34  153  187      5348 18.2
;		             15    6   17  170  187      5348  9.1
;		SUM 22
;		              7   15  153   17  170      5882 90.0
;		              8   14  136   34  170      5882 80.0
;		              9   13  119   51  170      5882 70.0
;		             10   12  102   68  170      5882 60.0
;		             11   11   85   85  170      5882 50.0
;		             12   10   68  102  170      5882 40.0
;		             13    9   51  119  170      5882 30.0
;		             14    8   34  136  170      5882 20.0
;		             15    7   17  153  170      5882 10.0
;		SUM 23
;		              8   15  136   17  153      6536 88.9
;		              9   14  119   34  153      6536 77.8
;		             10   13  102   51  153      6536 66.7
;		             11   12   85   68  153      6536 55.6
;		             12   11   68   85  153      6536 44.4
;		             13   10   51  102  153      6536 33.3
;		             14    9   34  119  153      6536 22.2
;		             15    8   17  136  153      6536 11.1
;		SUM 24
;		              9   15  119   17  136      7353 87.5
;		             10   14  102   34  136      7353 75.0
;		             11   13   85   51  136      7353 62.5
;		             12   12   68   68  136      7353 50.0
;		             13   11   51   85  136      7353 37.5
;		             14   10   34  102  136      7353 25.0
;		             15    9   17  119  136      7353 12.5
;		SUM 25
;		             10   15  102   17  119      8403 85.7
;		             11   14   85   34  119      8403 71.4
;		             12   13   68   51  119      8403 57.1
;		             13   12   51   68  119      8403 42.9
;		             14   11   34   85  119      8403 28.6
;		             15   10   17  102  119      8403 14.3
;		SUM 26
;		             11   15   85   17  102      9804 83.3
;		             12   14   68   34  102      9804 66.7
;		             13   13   51   51  102      9804 50.0
;		             14   12   34   68  102      9804 33.3
;		             15   11   17   85  102      9804 16.7
;		SUM 27
;		             12   15   68   17   85     11765 80.0
;		             13   14   51   34   85     11765 60.0
;		             14   13   34   51   85     11765 40.0
;		             15   12   17   68   85     11765 20.0
;		SUM 28
;		             13   15   51   17   68     14706 75.0
;		             14   14   34   34   68     14706 50.0
;		             15   13   17   51   68     14706 25.0
;		SUM 29
;		             14   15   34   17   51     19608 66.7
;		             15   14   17   34   51     19608 33.3
;		SUM 30
;		             15   15   17   17   34     29412 50.0
;		





		; timecounter expired
		btfss	Ramp_Running		; 
		 goto	endlatency		;      		     
		btfsc	Down_Running		; initialize downramp					
		 goto	down			;


;********************************** ramp up
		skpeql	PeriodReg,Hi_Intensity	;
		 goto	decPR2			;
						; ramp finished
						; 
endramp		bcf	Ramp_Running		; set latency time
		eq	UprampTime+2,0x38	; 56*256*256*(PeriodReg*3+14) us
		goto	motime
;************************************************

down		skpneql	PeriodReg,Lo_Intensity	; 
		 goto	prepslp			; goto sleep
incPR2		incf	PeriodReg,F		; PR2 +=1 dimmer
		skpgel	PeriodReg,.13
		 goto	tbl
		movlw 	.7
		goto	tbl+1
tbl		call	readt
		subwf	UprampTime,F
		skpNC
		 goto	 motime
		movf	UprampTime+1,F
		skpnz
		 goto	ovl
novl		decf	UprampTime+1,F
		goto	motime
ovl		movf	UprampTime+2,F
		skpnz
		 goto	crluf
		decf	UprampTime+2,F
		goto	novl
crluf		clrf	UprampTime
		goto 	motime
;************************************************	
;	eq	BL,.255			;128=18ms 255= 38ms
;	movfw	PeriodReg	
;incsub	subwf	BL,F
;	skpC
;	 goto	motime
;	dec	UprampTime,F
;	movf	UprampTime,F
;	skpnz
;	 decf	UprampTime+1,F
;	decf	UprampTime,F
;	goto	incsub
;	
;
;********************************************************************
endlatency 	btfsc Latency_Extend		; latency extended due to	
	    	 goto motime-1			; picked up PIR signal
		bsf	Ramp_Running
		bsf	Down_Running
		eeeq	UprampTime, .90000/.27  
		goto	motime			;
;********************************************************************
		
tstport		btfss	PIR_On_Port	; 
	 	 goto	startcycle-4
		btfsc	Down_Running	; 
		 goto	reverserun
		bsf	Latency_Extend	; latency running
		goto	startcycle

reverserun	bcf	Down_Running
		clrfff	UprampTime
		goto	decPR2


	bcf	Latency_Extend
motime		incf	UprampTime,W
		movwf	TimeCounter
		incf	UprampTime+1,W
		movwf	TimeCounter+1
		incf	UprampTime+2,W
		movwf	TimeCounter+2
	; 
	goto	startcycle	; 



afterwdt
;	bcf	PFET_Gate_Port
;	decfsz	PeriodCounter,F
;	  goto $-1
;	bsf	PFET_Gate_Port
	goto prepslp

pause03		nop			;test
		decfsz	BL,F		;test
		 goto	$-2		;test
		decfsz	BH,F		;test
		goto	pause03		;test
		retlw 0			;test


				;
#define GP1_Porton	b'01110001'     ; configure comparator input=on
#define GP0_Porton	b'01110011'     ; configure comparator input=on, int ref, GP0


afterpin	goto	$+1
		decfsz	AL,F
	  	 goto $-2		;5*256 =1280us
		btfss PIR_On_Port	; notest PIR still on?
	 	 goto prepslp		; notest too small PIR-Signal, or Change to OFF

#define	P100_Port	0

testcds		bsf	GPIO,P100_Port	; 
		movlw	((1<< P100_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; charge C
		movlw	.4
		movwf	AL		; 15 us
		decfsz	AL,F
		 goto	$-1		; 
		clrwdt
		movlw	iodir		;  GP,x is input
		TRIS 	TRISGPIO	; let C discharge
		clrf	AH
		clrf	AL		; 1 us
loop100		btfss	GPIO,P100_Port
		 goto	exitloop100
		incfsz	AL,F
		 goto	loop100		;timeout 1000us	
		incfsz	AH,F
		 goto	loop100
		decf	AH,F
		decf	AL,F	
exitloop100	
;		bcf	GPIO,P100_Port			;test		
;		movlw	((1<< P100_Port) ^ 0xFF) & iodir;test
;		TRIS 	TRISGPIO	; discharge C	;test
	
		movlw	.5
		subwf	AH,W
		skpC
		  goto prepslp		; CDS too low, too bright

		eq	PeriodReg,Lo_Intensity

;		movwf PeriodReg		; 0-176
;		incl	PeriodReg,0x20	; 32-208
;;		eq	AL,.10 	;test
;		decfsz	AL,F	;test
;		 goto	$-1	;test
;		Goto testcds	;test
;	


#define	C10N_Port	1				;

tstvoltage	eq	DutyTime, 0
		eq	DutyPause,0
		goto	startcycle;	;test
		
		eq	PeriodReg,Lo_Intensity
		bcf	GPIO,C10N_Port
		if C10N_Port
		 movlw	GP1_Porton     ; configure comparator input
		else
		movlw	GP0_Porton
		 endif
	
				;bit 7 bit 0
				;bit 7 CMPOUT: Comparator Output bit
				;1 = VIN+ > VIN-
				;0 = VIN+ < VINbit
				;6 COUTEN: Comparator Output Enable bit(1, 2)
				;1 = Output of comparator is NOT placed on the COUT pin
				;0 = Output of comparator is placed in the COUT pin
				;bit 5 POL: Comparator Output Polarity bit(2)
				;1 = Output of comparator not inverted
				;0 = Output of comparator inverted
				;bit 4 CMPT0CS: Comparator TMR0 Clock Source bit(2)
				;1 = TMR0 clock source selected by T0CS control bit
				;0 = Comparator output used as TMR0 clock source
				;bit 3 CMPON: Comparator Enable bit
				;1 = Comparator is on
				;0 = Comparator is off
				;bit 2 CNREF: Comparator Negative Reference Select bit(2)
				;1 = CIN- pin(3)
				;0 = Internal voltage reference
				;bit 1 CPREF: Comparator Positive Reference Select bit(2)
				;1 = CIN+ pin(3)
				;0 = CIN- pin(3)
				;bit 0 CWU: Comparator Wake-up on Change Enable bit(2)
				;1 = Wake-up on comparator change is disabled
				;0 = Wake-up on comparator change is enabled.
				;Note 1: Overrides T0CS bit for TRIS control of GP2.
		movwf	CMCON0	
		movlw	((1<< C10N_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; discharge C
		eq	AL,.1		; 5 us delay
		decfsz	AL,F
		 goto	$-1		; 
		movlw	iodir		;  GP is input
		TRIS 	TRISGPIO	; charge C
		bsf	CMCON0,3	; comparator on
		clrf	AL
loop		btfsc	CMCON0,7
		 goto	exitloop
		incfsz	AL,F
		 goto	loop		;timeout 1000us	
		decf	AL,F	
		
exitloop	bcf	CMCON0,3	;comparator off
			
		eq	DutyCase,.9
		skpgel	AL,0x58		; .88		4.25V
   		 goto endvoltage
		decf	DutyCase,F
		decf	DutyCase,F
		skpgel	AL,0x58+0x16	;.88+.20 =108	3.7V
		 goto endvoltage
		decf 	DutyCase,F
		decf	DutyCase,F
		skpgel	AL,0x58+0x26	;.88.+.36= 124  3.35V
		 goto	endvoltage		
		decf	DutyCase,F
		decf	DutyCase,F
		skpgel	AL,0x58+0x30	;.88+.48 = 136  3.1V
 		 goto	endvoltage
		decf	DutyCase,F
		decf	DutyCase,F	
		skplel	AL,0x58+0x38	;.88+.56 = .144 3.0V
		decf	DutyCase,F	; warning blinker
endvoltage	;mov	AL,AH

;******************************************TEST TEST TEST
;exitp100		bsf	send_first		
;		skplesl	AH,.125
;		 goto	send125
;		skplesl	AH,.25
;		 goto	send25
;		skplesl	AH,.5
;		 goto	send5
;		skplesl	AH,.1
;		 goto	send1
;		eq	AH,.06
;		call	pause03
;		decfsz	AH,F
;		 goto	$-2
;		btfss	send_first
;		 goto	endsend
;		bcf	send_first
;		mov	AL,AH
;		goto	exitp100+1
;endsend		eq	AL,.20
;		call pause03
;		decfsz	AL,F
;		 goto	$-2
;		goto	testcds		
;send1		decf	AH,F	
;		eeq	BL,.2300
;		goto	send25cycles
;
;send5		decl	AH,.5	
;		eeq	BL,.8000
;		goto	send25cycles
;
;send25		decl	AH,.25	
;		eeq	BL,.22000
;		goto	send25cycles
;			
;		
;send125		decl	AH,.125	
;		eeq	BL,.65000
;		goto	send25cycles
;		
;
;
;send25cycles	eq	AHH,.8
;		decfsz	AHH,F
;		 goto	$-1
;		bsf	NFET_Gate_Port
;		bcf	NFET_Gate_Port
;		decfsz	BL,F
;		 goto	send25cycles
;		decfsz	BH,F
;		 goto	send25cycles
;		call	pause03
;		goto	exitp100+1
;
;;********************************TEST TEST TEST
;	eq	AL,.10 ;test
;		decfsz	AL,F;test
;		 goto	$-1;test
;		Goto testcds;test


		GOTO MAIN
	end
