;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..5 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*   from a 30 seconds pulse at  GPIO3                                 *
;*   GPIO1 Input needs 10nF to Vss and 220k  to Vdd        *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros.inc                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:  on every pulse on GPIO3                                  *
;*            pause width will start with 620 microseconds             *
;*            and ramp down to 16 microseconds, wait for x minutes     *
;*            and ramp up to  620 microseconds to go off               *
;*                                                                     *
;*             
;  program consists of following elements
;  -initialize on power up, wake up on pin change (or wdt reset -not used)
;  -test battery voltage
;  -set upramp delay
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to decremented cycletime and desired ramp shape
;  -loop until maximum brightness
;  -set new (latency) delay
;  -check input, if on, set extend latency
;  -loop in pulse width modulation cycle until until latency expires
;  -set downramp delay
;  -check input, if on, goto 'set upramp delay'
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to incremented cycletime and desired ramp shape
;  -loop until minimum brightness
;  -goto sleep, wait for wake up on pin change 	                       *
;***********************************************************************
	list      p=10F206	; list directive to define processor
	#include <p10f206.inc>	; processor specific variable definitions

	#include macros.inc
;	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC	
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC  

;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************

	IFDEF __10F206
	cblock 0x08				; var starting at  0x08
		UprampTime:4
		

	endc
	ENDIF
	
	cblock 0x10
		AL,AH,BL,BH
		TimerTick,TMR1H				; variables starting at  0x10
		SystemStatus			; flags
		PR2,PR2Counter			; intensity
		Timer0Counter:3			; Time to wait for next PIR
		DutyTime,DutyPause
		InInt,UsDel
	endc
#define	CL	Timer0Counter
#define	CH	Timer0Counter+1
#define	DL	Timer0Counter+2

	IFDEF __10F202
	cblock 0x08				; var starting at  0x08
	 
	endc
	ENDIF

		

;******************************************************************************
;***** CONSTANT DEFINITIONS
#define TRISGPIO 	6		; 10F200family speciality
					; 
#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111011'	; configure NFET_Gate_Port as output 
					;		   GPIO0,1,3 are input

#define	ZeroCrosses	AH
#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6
#define Tmr0_Bit7	SystemStatus,5
#define	PIR1_TMR1IF	SystemStatus,4
#define	Second_Pass		SystemStatus,3	; TRIAC firing enabled
#define	Goto_Sleep	SystemStatus,2
#define	Blin_Ker	SystemStatus,2
#define	Ac_Onbuffer	SystemStatus,1
#define	AC_ON		SystemStatus,0	; AC Voltage detected

#define Lointensity	.240
#define Hiintensity	.1

#define triacGate	1
#define Acport		1
#define	Voltport	1
#define PIRport		3
#define	LEDport		2
#define CDSport		0
#define Triac_Gate	GPIO,triacGate
#define Ac_Port		GPIO,Acport
#define PIR_Port	GPIO,PIRport
#define LED_Port	GPIO,LEDport
#define CDS_Port	GPIO,CDSport
#define Volt_Port	GPIO,Voltport



;******************************************************************************
;***** RESET VECTOR AND START OF CODE


	;ORG     0xFF or 1xFF    ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	call	undoreset
	goto	wakeup
;ORG 0x004
;***************************************************************************************
;"Interrupt Vector"     
;***************************************************************************************
I004		bcf	Second_Pass
		movlw	.40		;movfw	TimerTick	;TMR2 overflow replacement
		addwf	TMR0,w		;subwf	TMR0,W
		subwf	TimerTick,w	;movwf	InInt
		movwf	InInt
		btfss	InInt,7	
		 goto	tmr0chk		;goto	late		
		  			; movlw	.32
					;addwf	InInt,W
		decfsz	PR2Counter,F
    		 goto	workoffpr2
		;dont forget restore PR2counter
		subwf	UsDel,w   	; skpc
				; goto tmr0chk
		movwf	PCL

usdelay		nop
		nop
		nop
		nop


		nop
		nop
		nop
		nop

		nop	; d=8
		nop
		nop
		nop

		nop
		nop
		nop
		nop

		nop
		nop
		nop
		nop


		nop
		nop
		nop
		nop

		nop
		nop	;249
		nop
		nop

		nop
		nop
		nop
lateentry	nop     ;255
		
		nop
		nop
		nop
		nop


		nop
		nop
		nop
		nop

		nop
		nop
		nop
		nop

		nop
		nop
		nop
		nop
		movlw	1<<LEDport
		xorwf	GPIO,F

		btfsc	Second_Pass
 		 goto	restorcntrs
		bsf	Second_Pass
		movlw	usdelay
		addwf	DutyTime,w
		movwf	PCL

restorcntrs	add	TimerTick, TMR0,DutyPause
		mov	PR2,PR2Counter


tmr0chk		skpaornb Tmr0_Bit7, TMR0,7	
		 bsf	Tmr0_Bit7
		skpnabutb  TMR0,7 ,Tmr0_Bit7
		 retlw	0
		bcf	Tmr0_Bit7
		incfsz	TMR1H,F
		 goto	$+2
		bsf	PIR1_TMR1IF
flip		incfsz	Timer0Counter,F
		 retlw  0
		incfsz	Timer0Counter+1,F
		 retlw	0
		incfsz	Timer0Counter+2,F
		 retlw  0

		btfss	Ramp_Running
		 goto	endlatency
		btfsc	Down_Running
		 goto	rundown
		
		skpneql	PR2, Hiintensity
		  goto	latency
		decf	PR2,F				;brighter
		
		decfsz	UprampTime,F			; extend ramp time
		 goto	exitir-1			; brighter=longer
		decf	UprampTime+1,F
		goto	exitir-1
	;------------------------------------- ramp down
rundown 		
		skpneql	PR2, Lointensity
		  goto	gooff
		incf	PR2,F
		goto	exitir-1

gooff		bsf	Down_Running			; 
		bsf	Goto_Sleep
		retlw	0

latency 	
		neeeq	UprampTime, 0x0057FFFF		; TIMER0MAX = 512ms *256 *2= 300sec=
		bcf	Ramp_Running
		goto	exitir-1

endlatency	neeeq	UprampTime, 0x00001FFF 	;1 sec (* 240 = 4min total) 
		bsf	Ramp_Running
		bsf	Down_Running
		call	motime

exitir		goto	I004

late		decfsz	PR2Counter,F
		 goto	worko2
		movlw	lateentry
		addwf	InInt,W
		movwf	PCL

workoffpr2	skpC
		 goto	tmr0chk
worko2		incl	TimerTick,.48
		goto	tmr0chk

;******************************************************************************
;Subroutines
;******************************************************************************
motime		mov	UprampTime, TMR0
		movvv	UprampTime+1,Timer0Counter
		retlw 0

undoreset			
 
	movlw	iodir
	TRIS 	TRISGPIO
	movlw	B'01001010'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:8 , WDT 1:1 ,
;				;bit 3 PSA: Prescaler Assignment bit
;				;1 = Prescaler assigned to the WDT
;				;0 = Prescaler assigned to Timer0
;				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				;Bit Value	Timer0 Rate 	WDT Rate
;				;000		1 : 2		1 : 1
;				;001		1 : 4		1:2
;				;010		1:8		1:4
;				;011		1:16		1:8
;				;100		1:32		1:16
;				;101		1:64		1:32
;				;110		1:128		1:64
;				;111		1:256		1:128
				
	OPTION	
	retlw	0


dark200ms	bcf	LED_Port
		eq	DL, 1
wakedelay	clrwdt
		decfsz	CL,F
		 goto	$-2
		decfsz	CH,F
		 goto	$-4
		decfsz	DL,F
		 goto	$-6

		retlw	0



		retlw	0



wakeup	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	
	GOTO	PWRUP		; goto error


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set port to LOW  
	movwf	GPIO

	call	undoreset	; TRIS + OPTION

	IFDEF __10F204	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	
	

	goto 	MAIN		; 1 ramp latency ramp cycle

prepslp				; wait for PIR to go UP
 	decfsz	AL,F
	  goto $-1


	sleep			; at min consumption
					

;******************************************************************************






MAIN			clrf	SystemStatus	
	eq	DutyTime, .48		;48 = 10us 0=58us
	eq	DutyPause, .21	        ;21=55us 68= 102 + 
	eq	PR2,.1			;+ 48*pr2-1 (max 254*48 = 12192us)
	mov	PR2,PR2Counter
	add	TimerTick,TMR0,DutyPause
	bcf	LED_Port
	eq	UsDel, usdelay

;	eq	PeriodReg,Lo_Intensity	;test
;	eq	DutyCase, 0x00		;test
;	goto	MAIN			;test
;	goto	endvoltage			;test


testcds		bsf	CDS_Port	; 
		movlw	((1<< CDSport) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; charge C
		movlw	.4
		movwf	AL		; 15 us
		call	I004
		decfsz	AL,F
		 goto	$-2		; 
		movlw	iodir		;  GP,x is input
		TRIS 	TRISGPIO	; let C discharge
		mov	TMR0,AL
		movlw	-.4
		movwf	TMR1H	; 
		bcf	PIR1_TMR1IF
loop100		call	I004
		skpnotaorb	CDS_Port,PIR1_TMR1IF
		 goto	loop100		

;		bcf	GPIO,P100_Port			;test		
;		movlw	((1<< P100_Port) ^ 0xFF) & iodir;test
;		TRIS 	TRISGPIO	; discharge C	;test
		sub	AL,TMR0,AL
		movlw	-.4
		subwf	TMR1H,w
		movwf	AH
		skpC
		 decf	AH,F	;overflow
	
displaybits	
					;disable PWM
		eq	BL, 6
		call	dark200ms
		decfsz	BL,F
		 goto	$-2

		eq	BL, .15
firstbit	movf	BL,F
		skpnanotb AH, 7, STATUS, Z
		 goto nextbit-1
		clrC
		rlf	AL,F
		rlf	AH,F
		decf	BL,F
		goto	firstbit
		incf	BL,F
nextbit		clrc
		rlf	AL,F
		rlf	AH,F
		movlw	-0x04
		skpnC	
		 movlw	-0x14
		movwf	DL-1
		add	TimerTick, TMR0,DutyPause
		call	I004	 ;enable PWM
		movf	DL-1,F
		skpZ
		 goto	$-3
		call	dark200ms
		
		decfsz	BL,F
		 goto nextbit
		eq	BL, 8
		call	dark200ms
		decfsz	BL,F
		 goto	$-2

		goto	MAIN



		skpgel	AH,.5
		  goto  MAIN




	neeeq	UprampTime, 0x00000080	; 128*8us = 1.024ms
	bsf	Ramp_Running
	bcf	Down_Running
	call	motime



	bcf	Goto_Sleep
;**********************************wakey loop, LEDon
loop	movbit	AC_ON, Ac_Onbuffer
	bcf	AC_ON
	call	I004
	btfss	PIR1_TMR1IF
	 goto	loop
	call testcds
	skpgel	AH,.6			; too bright for LED to be useful
	 goto	PWRUP

		btfss	PIR_Port
		 goto	noinput
	
		btfsc	Ramp_Running			;Input is high
		 goto	tstdwn
		call	motime				;extend latency
		goto	noinput
tstdwn		btfss	Down_Running
		 goto	noinput				; uprunning	
		bcf	Down_Running
		neeeq	UprampTime, 0x000000F0		; 15*16*8us = 1.92ms
		call	motime
		
noinput

	btfsc	Goto_Sleep
	 goto	PWRUP

	skpnabutb Ac_Onbuffer, AC_ON	; AC came on
	 goto loop
	


				;
#define GP1_Porton	b'01110001'     ; configure comparator input=on
#define GP0_Porton	b'01110011'     ; configure comparator input=on, int ref, GP0

afterwdt
afterpin	goto	$+1
		decfsz	AL,F
	  	 goto $-2		;5*256 =1280us
		btfss PIR_Port	; notest PIR still on?
	 	 goto prepslp		; notest too small PIR-Signal, or Change to OFF





#define	C10N_Port	1				;

tstvoltage	eq	DutyTime, .15
		eq	DutyPause, .15
		;		goto	startcycle;	;test
		
		eq	PR2,Lointensity
		bcf	GPIO,C10N_Port
		if C10N_Port
		 movlw	GP1_Porton     ; configure comparator input
		else
		movlw	GP0_Porton
		 endif
	
				;bit 7 bit 0
				;bit 7 CMPOUT: Comparator Output bit
				;1 = VIN+ > VIN-
				;0 = VIN+ < VINbit
				;6 COUTEN: Comparator Output Enable bit(1, 2)
				;1 = Output of comparator is NOT placed on the COUT pin
				;0 = Output of comparator is placed in the COUT pin
				;bit 5 POL: Comparator Output Polarity bit(2)
				;1 = Output of comparator not inverted
				;0 = Output of comparator inverted
				;bit 4 CMPT0CS: Comparator TMR0 Clock Source bit(2)
				;1 = TMR0 clock source selected by T0CS control bit
				;0 = Comparator output used as TMR0 clock source
				;bit 3 CMPON: Comparator Enable bit
				;1 = Comparator is on
				;0 = Comparator is off
				;bit 2 CNREF: Comparator Negative Reference Select bit(2)
				;1 = CIN- pin(3)
				;0 = Internal voltage reference
				;bit 1 CPREF: Comparator Positive Reference Select bit(2)
				;1 = CIN+ pin(3)
				;0 = CIN- pin(3)
				;bit 0 CWU: Comparator Wake-up on Change Enable bit(2)
				;1 = Wake-up on comparator change is disabled
				;0 = Wake-up on comparator change is enabled.
				;Note 1: Overrides T0CS bit for TRIS control of GP2.
		movwf	CMCON0	
		movlw	((1<< C10N_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; discharge C
		eq	AL,.1		; 5 us delay
		decfsz	AL,F
		 goto	$-1		; 
		movlw	iodir		;  GP is input
		TRIS 	TRISGPIO	; charge C
		bsf	CMCON0,3	; comparator on
		clrf	AL
tstvloop		btfsc	CMCON0,7
		 goto	exitloop
		incfsz	AL,F
		 goto	tstvloop		;timeout 1000us	
		decf	AL,F	
		
exitloop	bcf	CMCON0,3	;comparator off
;			
;		eq	DutyCase,.9
;		skpgel	AL,0x58		; .88		4.25V
;   		 goto endvoltage
;		decf	DutyCase,F
;		decf	DutyCase,F
;		skpgel	AL,0x58+0x16	;.88+.20 =108	3.7V
;		 goto endvoltage
;		decf 	DutyCase,F
;		decf	DutyCase,F
;		skpgel	AL,0x58+0x26	;.88.+.36= 124  3.35V
;		 goto	endvoltage		
;		decf	DutyCase,F
;		decf	DutyCase,F
;		skpgel	AL,0x58+0x30	;.88+.48 = 136  3.1V
; 		 goto	endvoltage
;		decf	DutyCase,F
;		decf	DutyCase,F	
;		skplel	AL,0x58+0x38	;.88+.56 = .144 3.0V
;		decf	DutyCase,F	; warning blinker
endvoltage	;mov	AL,AH


		GOTO MAIN
	end
