;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..7 microseconds  *
;*   at GPIO 2 Transistor output driver                                *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: 1.0                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros.inc                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;***********************************************************************
	list      p=10F206	; list directive to define processor
	#include <p10f206.inc>	; processor specific variable definitions

	#include ..\macros.inc
;	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC	; with charger
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without charger
;	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS
	IFDEF __10F206
	cblock 0x08				; var starting at  0x08

		UprampTime:3

	endc
	ENDIF
	
	cblock 0x10
		AL,AH,AHH,BL,BH,BHH
		
		PeriodCounter			; variables starting at  0x10
		SystemStatus			; flags
		PeriodReg			; intensity
		TimeCounter:3			; Time to wait for next PIR
		DutyCase,HiIntensity
	endc

	IFDEF __10F202
	cblock 0x08				; var starting at  0x08
	 
	endc
	ENDIF
		

;******************************************************************************
;***** CONSTANT DEFINITIONS
#define TRISGPIO 	6		; 10F200family speciality
					; 
#define	NFET_Gate_Port	GPIO,2		; 
#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111011'	; configure NFET_Gate_Port as output 


;***** RESET VECTOR AND START OF CODE
	;ORG     0xFF or 1xFF    ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	goto	RESET	



I004						; touches W, Z and C


		movfw	PeriodReg
		movwf	PeriodCounter
		decfsz	PeriodCounter,F		;1
		 goto	$-1		;2,3 cycles

		movfw	DutyCase		;0..15
		addwf	PCL,F
		 goto	onecycle
		 bsf	NFET_Gate_Port		; 1:  42+15
		 call	long
		 bsf	NFET_Gate_Port		; 3:  26
		 call	short
		 bsf	NFET_Gate_Port		; 5:  15+15
		 call	veryshort	
		 bsf	NFET_Gate_Port		; 7:  8
		 bsf	NFET_Gate_Port		; 8:  7
		 bsf	NFET_Gate_Port		; 9:  6us
		 bsf	NFET_Gate_Port		; 10: 5
		 bsf	NFET_Gate_Port		; 11: 4
		 bsf	NFET_Gate_Port		; 12: 3
		 bsf	NFET_Gate_Port		; 13: 2us
onecycle	 bsf	NFET_Gate_Port		; 14: 1us+15
		 bcf	NFET_Gate_Port		; 15: NFET or Transistor off
			
					
timouter	retlw	0



long		goto	$+1	;
		goto	$+1
		goto	$+1
short		goto	$+1
		goto	$+1
veryshort	goto	$+1
		retlw	0



undoreset	movlw	iodir
		TRIS 	TRISGPIO
		movlw	B'01001111'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:256 , WDT 1:1 ,
;				;bit 3 PSA: Prescaler Assignment bit
;				;1 = Prescaler assigned to the WDT
;				;0 = Prescaler assigned to Timer0
;				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				;Bit Value	Timer0 Rate 	WDT Rate
;				;000		1 : 2		1 : 1
;				;001		1 : 4		1:2
;				;010		1:8		1:4
;				;011		1:16		1:8
;				;100		1:32		1:16
;				;101		1:64		1:32
;				;110		1:128		1:64
;				;111		1:256		1:128
				
	OPTION	
	retlw	0

#define onecyc	.22
		
timefactor	movfw	DutyCase
		addwf	PCL,F
		retlw	onecyc 
		retlw	onecyc+.41    	;1
		retlw	onecyc+.41   	;
		retlw	onecyc+.25  	;3
		retlw	onecyc+.25   	;
		retlw	onecyc+.14   	;5
		retlw	onecyc+.14   	; 
		retlw	onecyc+.7   	;
		retlw	onecyc+.6   	;8
		retlw	onecyc+.5   	;
		retlw	onecyc+.4   	;10
		retlw	onecyc+.3   	;
		retlw	onecyc+.2   	;12
		retlw	onecyc+.1   	;
		retlw   onecyc   	;14
		retlw	onecyc-1    ;





RESET	call	undoreset


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set port to LOW  
	movwf	GPIO

	call	undoreset	; TRIS + OPTION

	IFDEF __10F204	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	


		eq	PeriodReg,7
sttest		eq	AHH,.14
testcycle	mov	AHH,DutyCase

		decf	PeriodReg,W
		movwf	BL
		addwf	BL,F
		addwf	BL,F
		call	timefactor
		addwf	BL,F
		clrc	
		rrf	BL,F
nb		eq	BH,0xFF
		eq	TimeCounter+1,.8
		movfw	BL
		incf	TimeCounter+1,F
		subwf	BH,F
		skpnC
		 goto	$-3
		eq	TimeCounter+2,1
		clrC
		rlf	TimeCounter+1
		rlf	TimeCounter+1
ms512		nop
		nop
		nop
		nop
		nop
		nop
		nop
startcycle	call I004
	;	clrf	TMR0			;  Test
		decfsz	TimeCounter,F
		 goto 	startcycle-7
		decfsz	TimeCounter+1,F		;
		 goto 	startcycle-5
;		btfss	Inter_Val		;16us*65k =512msec
;		 goto	nointervall
;intervall	movlw	0x0F	
;		xorwf	DutyCase,F
nointervall	decfsz	TimeCounter+2,F
		 goto startcycle-3

	decf	AHH,F
	skplel	AHH,.8
	 goto	testcycle
	goto	sttest


	end
