;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..5 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*   from a 30 seconds pulse at  GPIO3                                 *
;*   GPIO1 Input needs 10nF to Vss and 220k (+2.7VZener) to Vdd        *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros.inc                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:  on every pulse on GPIO3                                  *
;*            pause width will start with 620 microseconds             *
;*            and ramp down to 16 microseconds, wait for x minutes     *
;*            and ramp up to  620 microseconds to go off               *
;*                                                                     *
;*             
;  program consists of following elements
;  -initialize on power up, wake up on pin change (or wdt reset -not used)
;  -test battery voltage
;  -set upramp delay
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to decremented cycletime and desired ramp shape
;  -loop until maximum brightness
;  -set new (latency) delay
;  -check input, if on, set extend latency
;  -loop in pulse width modulation cycle until until latency expires
;  -set downramp delay
;  -check input, if on, goto 'set upramp delay'
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to incremented cycletime and desired ramp shape
;  -loop until minimum brightness
;  -goto sleep, wait for wake up on pin change 	                       *
;***********************************************************************
	list      p=10F206	; list directive to define processor
	#include <p10f206.inc>	; processor specific variable definitions

	#include C:\Programme\Microchip\macros.inc
;	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC	; with charger
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without charger
;	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS
	IFDEF __10F206
	cblock 0x08				; var starting at  0x08
	 	UR_1
		UprampFrac
		UprampTime:3
		

	endc
	ENDIF
	
	cblock 0x10
		AL,AH,AHH,BL,BH
						; variables starting at  0x10
		SystemStatus			; flags
		PeriodReg			; intensity
		TimeCounter:3			; Time to wait for next PIR
		DutyCase,DutyTime,DutyPause,MaxTmr
	endc

	IFDEF __10F202
	cblock 0x08				; var starting at  0x08
	 
	endc
	ENDIF
		

;******************************************************************************
;***** CONSTANT DEFINITIONS
#define TRISGPIO 	6		; 10F200family speciality
					; 
#define	NFET_Gate_Port	GPIO,2		; 
#define	NFET_Bitmask	b'00000100'	; 
#define	NFET_Bit	2
#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111011'	; configure NFET_Gate_Port as output 
					;		   GPIO0,1,3 are input
#define PIR_On_Port	GPIO,3		; 

#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6

#define	Latency_Extend	SystemStatus,5
#define Tmr0_Bit7	SystemStatus,0
#define send_first	SystemStatus,0

#define Lo_Intensity	.240
#define Hi_Intensity	.1


;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	;ORG     0xFF or 1xFF    ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	
	GOTO	PWRUP		; goto error



undoreset			
 
	movlw	iodir
	TRIS 	TRISGPIO
	movlw	B'01001111'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:256 , WDT 1:1 ,
;				;bit 3 PSA: Prescaler Assignment bit
;				;1 = Prescaler assigned to the WDT
;				;0 = Prescaler assigned to Timer0
;				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				;Bit Value	Timer0 Rate 	WDT Rate
;				;000		1 : 2		1 : 1
;				;001		1 : 4		1:2
;				;010		1:8		1:4
;				;011		1:16		1:8
;				;100		1:32		1:16
;				;101		1:64		1:32
;				;110		1:128		1:64
;				;111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set port to LOW  
	movwf	GPIO

	call	undoreset	; TRIS + OPTION

	IFDEF __10F204	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	

;	eq	PeriodReg,Lo_Intensity	;test
;	eq	DutyCase, 0x00		;test
;	goto	MAIN			;test
;	goto	endvoltage			;test

	goto 	tstvoltage		; 1 ramp latency ramp cycle

prepslp				; wait for PIR to go UP
 	decfsz	AL,F
	  goto $-1


	sleep			; at min consumption
					

;******************************************************************************

intervall 	btfsc	Ramp_Running
		 goto	timouter-2
		btfss	TMR0,7			; TMR0 overflow
		 goto	$+5			; replacement
		btfsc	Tmr0_Bit7
		 goto	noflip			; both set
		bsf	Tmr0_Bit7		;
		goto	noflip
		btfss	Tmr0_Bit7
		 goto	noflip			; both not set
		bcf	Tmr0_Bit7
		incf	MaxTmr,F		; overflow
	

noflip		btfss	MaxTmr,5
		 goto timouter

		goto timouter-2




decPR2	decf	PeriodReg,F		; PR2 -=1 brighter

	skpgel	PeriodReg,.13
	 goto	tblread
	eq	BL,.128		;128=18ms 255= 38ms
	movfw	PeriodReg
decsub	subwf	BL,F
	skpC	
	 goto	motime
	incfsz	UprampTime,F
	 goto	decsub
	incfsz	UprampTime+1,F
	 goto	decsub
	incf	UprampTime+2,F
	goto	decsub

tblread		call	readt
		addwf	UprampTime,F
		skpC
		 goto	motime
		incfsz	UprampTime+1,F
		 goto	motime
		incf	UprampTime+2,F
		goto	motime

readt		decf	PeriodReg,W
		addwf	PCL,F
		retlw	.255
		retlw	.210 /.1
		retlw	.210 /.2
		retlw	.210 /.3
		retlw	.210 /.4
		retlw	.210 /.5
		retlw	.210 /.6
		retlw	.210 /.7
		retlw	.210 /.8
		retlw	.210 /.9
		retlw	.210 /.10
		retlw	.210 /.11
		retlw	.210 /.12
		

	;	eq	AL,.1		; realtime division
	;	movfw	PeriodReg
	;	movwf	BH
	;	clrC
	;rotlef	btfsc	AL,7
	;	 goto	decsub
	;	movfw	AL		;works on first not zero byte
	;	subwf	PeriodReg,W
	;	skpC
	;	 goto	decsub
	;	rlf	BH,F		; and subsequent bytes
	;	rlf	AL,F		
	;	goto	rotlef
	;decsub	movfw	BH	
	;	subwf	BL,W		; and subsequent bytes
	;	skpC
	;         goto	rotrght
	;	movwf	BL
	;	movfw	AL
	;	addwf	UprampTime,F	;
	;	skpnC
	;	 incf	UprampTime+1,F
	;rotrght	clrc	
	;	rrf	AL,F
	;	movf	AL,F
	;	skpnz
	;	 goto motime
	;	rrf	BH,F
	;	goto	decsub	
	;;***********************************************
;	nop
;	nop
;	nop	
;	movfw	DutyCase
;startcycl	addwf	PCL,F
;		goto intervall
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port		
;		bsf	NFET_Gate_Port
;		bcf	NFET_Gate_Port
;					
;timoute		clrf	TMR0; test
;		decfsz	TimeCounter,F
;		 goto 	startcycl-3
;		decfsz	TimeCounter+1,F		;
;		 goto 	tstpor	
;		decfsz	TimeCounter+2,F
;		 goto startcycl-1
;		btfss	Latency_Extend
;		 goto	endlatency
;		bcf	Latency_Extend;
;		goto	startcycl
;tstpor		btfsc	PIR_On_Port	; 
;		 bsf	Latency_Extend
;		goto startcycl-1
;
;



MAIN	;eq	PeriodReg,Lo_Intensity
	clrfff	UprampTime	
	clrf	SystemStatus				; 
	bsf	Ramp_Running
	;bcf	Down_Running
	
	goto	motime
		
PORTTEST	btfss	PIR_On_Port	; 
	 	 goto	RET1STEP-4
		
DELAY1STEP	GOTO $+1
		GOTO $+1
		GOTO $+1
		GOTO $+1
		GOTO $+1
		GOTO $+1
		;GOTO $+1
		nop
RET1STEP	RETLW	NFET_Bitmask

		nop
		nop
		nop
		nop
		nop
		nop

startcycle	movfw	DutyTime	
		addwf	PCL,F
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bsf	GPIO,NFET_Bit
		bcf	GPIO,NFET_Bit



		movfw	DutyPause
		addwf	PCL,F
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP
		CALL DELAY1STEP

	
					
timouter	;clrf	TMR0			;  Test
		decfsz	TimeCounter,F
		 goto 	tstport
		decfsz	TimeCounter+1,F		;
		 goto 	startcycle-5	
		decfsz	TimeCounter+2,F
		 goto startcycle-3


;			   DutyTime   us      total us
;				PauseTime  us		  Hz    %
		
;		SUM  0
;		              0    0   16  272  288      3472  5.6
;		SUM  1
;		              0    1   16  255  271      3690  5.9
;		              1    0   15  272  287      3484  5.2
;		SUM  2
;		              0    2   16  238  254      3937  6.3
;		              1    1   15  255  270      3704  5.6
;		              2    0   14  272  286      3497  4.9
;		SUM  3
;		              0    3   16  221  237      4219  6.8
;		              1    2   15  238  253      3953  5.9
;		              2    1   14  255  269      3717  5.2
;		              3    0   13  272  285      3509  4.6
;		SUM  4
;		              0    4   16  204  220      4545  7.3
;		              1    3   15  221  236      4237  6.4
;		              2    2   14  238  252      3968  5.6
;		              3    1   13  255  268      3731  4.9
;		              4    0   12  272  284      3521  4.2
;		SUM  5
;		              0    5   16  187  203      4926  7.9
;		              1    4   15  204  219      4566  6.8
;		              2    3   14  221  235      4255  6.0
;		              3    2   13  238  251      3984  5.2
;		              4    1   12  255  267      3745  4.5
;		              5    0   11  272  283      3534  3.9
;		SUM  6
;		              0    6   16  170  186      5376  8.6
;		              1    5   15  187  202      4950  7.4
;		              2    4   14  204  218      4587  6.4
;		              3    3   13  221  234      4274  5.6
;		              4    2   12  238  250      4000  4.8
;		              5    1   11  255  266      3759  4.1
;		              6    0   10  272  282      3546  3.5
;		SUM  7
;		              0    7   16  153  169      5917  9.5
;		              1    6   15  170  185      5405  8.1
;		              2    5   14  187  201      4975  7.0
;		              3    4   13  204  217      4608  6.0
;		              4    3   12  221  233      4292  5.2
;		              5    2   11  238  249      4016  4.4
;		              6    1   10  255  265      3774  3.8
;		              7    0    9  272  281      3559  3.2
;		SUM  8
;		              0    8   16  136  152      6579 10.5
;		              1    7   15  153  168      5952  8.9
;		              2    6   14  170  184      5435  7.6
;		              3    5   13  187  200      5000  6.5
;		              4    4   12  204  216      4630  5.6
;		              5    3   11  221  232      4310  4.7
;		              6    2   10  238  248      4032  4.0
;		              7    1    9  255  264      3788  3.4
;		              8    0    8  272  280      3571  2.9
;		SUM  9
;		              0    9   16  119  135      7407 11.9
;		              1    8   15  136  151      6623  9.9
;		              2    7   14  153  167      5988  8.4
;		              3    6   13  170  183      5464  7.1
;		              4    5   12  187  199      5025  6.0
;		              5    4   11  204  215      4651  5.1
;		              6    3   10  221  231      4329  4.3
;		              7    2    9  238  247      4049  3.6
;		              8    1    8  255  263      3802  3.0
;		              9    0    7  272  279      3584  2.5
;		SUM 10
;		              0   10   16  102  118      8475 13.6
;		              1    9   15  119  134      7463 11.2
;		              2    8   14  136  150      6667  9.3
;		              3    7   13  153  166      6024  7.8
;		              4    6   12  170  182      5495  6.6
;		              5    5   11  187  198      5051  5.6
;		              6    4   10  204  214      4673  4.7
;		              7    3    9  221  230      4348  3.9
;		              8    2    8  238  246      4065  3.3
;		              9    1    7  255  262      3817  2.7
;		             10    0    6  272  278      3597  2.2
;		SUM 11
;		              0   11   16   85  101      9901 15.8
;		              1   10   15  102  117      8547 12.8
;		              2    9   14  119  133      7519 10.5
;		              3    8   13  136  149      6711  8.7
;		              4    7   12  153  165      6061  7.3
;		              5    6   11  170  181      5525  6.1
;		              6    5   10  187  197      5076  5.1
;		              7    4    9  204  213      4695  4.2
;		              8    3    8  221  229      4367  3.5
;		              9    2    7  238  245      4082  2.9
;		             10    1    6  255  261      3831  2.3
;		             11    0    5  272  277      3610  1.8
;		SUM 12
;		              0   12   16   68   84     11905 19.0
;		              1   11   15   85  100     10000 15.0
;		              2   10   14  102  116      8621 12.1
;		              3    9   13  119  132      7576  9.8
;		              4    8   12  136  148      6757  8.1
;		              5    7   11  153  164      6098  6.7
;		              6    6   10  170  180      5556  5.6
;		              7    5    9  187  196      5102  4.6
;		              8    4    8  204  212      4717  3.8
;		              9    3    7  221  228      4386  3.1
;		             10    2    6  238  244      4098  2.5
;		             11    1    5  255  260      3846  1.9
;		             12    0    4  272  276      3623  1.4
;		SUM 13
;		              0   13   16   51   67     14925 23.9
;		              1   12   15   68   83     12048 18.1
;		              2   11   14   85   99     10101 14.1
;		              3   10   13  102  115      8696 11.3
;		              4    9   12  119  131      7634  9.2
;		              5    8   11  136  147      6803  7.5
;		              6    7   10  153  163      6135  6.1
;		              7    6    9  170  179      5587  5.0
;		              8    5    8  187  195      5128  4.1
;		              9    4    7  204  211      4739  3.3
;		             10    3    6  221  227      4405  2.6
;		             11    2    5  238  243      4115  2.1
;		             12    1    4  255  259      3861  1.5
;		             13    0    3  272  275      3636  1.1
;		SUM 14
;		              0   14   16   34   50     20000 32.0
;		              1   13   15   51   66     15152 22.7
;		              2   12   14   68   82     12195 17.1
;		              3   11   13   85   98     10204 13.3
;		              4   10   12  102  114      8772 10.5
;		              5    9   11  119  130      7692  8.5
;		              6    8   10  136  146      6849  6.8
;		              7    7    9  153  162      6173  5.6
;		              8    6    8  170  178      5618  4.5
;		              9    5    7  187  194      5155  3.6
;		             10    4    6  204  210      4762  2.9
;		             11    3    5  221  226      4425  2.2
;		             12    2    4  238  242      4132  1.7
;		             13    1    3  255  258      3876  1.2
;		             14    0    2  272  274      3650  0.7
;		SUM 15
;		              0   15   16   17   33     30303 48.5
;		              1   14   15   34   49     20408 30.6
;		              2   13   14   51   65     15385 21.5
;		              3   12   13   68   81     12346 16.0
;		              4   11   12   85   97     10309 12.4
;		              5   10   11  102  113      8850  9.7
;		              6    9   10  119  129      7752  7.8
;		              7    8    9  136  145      6897  6.2
;		              8    7    8  153  161      6211  5.0
;		              9    6    7  170  177      5650  4.0
;		             10    5    6  187  193      5181  3.1
;		             11    4    5  204  209      4785  2.4
;		             12    3    4  221  225      4444  1.8
;		             13    2    3  238  241      4149  1.2
;		             14    1    2  255  257      3891  0.8
;		             15    0    1  272  273      3663  0.4
;		SUM 16
;		              1   15   15   17   32     31250 46.9
;		              2   14   14   34   48     20833 29.2
;		              3   13   13   51   64     15625 20.3
;		              4   12   12   68   80     12500 15.0
;		              5   11   11   85   96     10417 11.5
;		              6   10   10  102  112      8929  8.9
;		              7    9    9  119  128      7813  7.0
;		              8    8    8  136  144      6944  5.6
;		              9    7    7  153  160      6250  4.4
;		             10    6    6  170  176      5682  3.4
;		             11    5    5  187  192      5208  2.6
;		             12    4    4  204  208      4808  1.9
;		             13    3    3  221  224      4464  1.3
;		             14    2    2  238  240      4167  0.8
;		             15    1    1  255  256      3906  0.4
;		SUM 17
;		              2   15   14   17   31     32258 45.2
;		              3   14   13   34   47     21277 27.7
;		              4   13   12   51   63     15873 19.0
;		              5   12   11   68   79     12658 13.9
;		              6   11   10   85   95     10526 10.5
;		              7   10    9  102  111      9009  8.1
;		              8    9    8  119  127      7874  6.3
;		              9    8    7  136  143      6993  4.9
;		             10    7    6  153  159      6289  3.8
;		             11    6    5  170  175      5714  2.9
;		             12    5    4  187  191      5236  2.1
;		             13    4    3  204  207      4831  1.4
;		             14    3    2  221  223      4484  0.9
;		             15    2    1  238  239      4184  0.4
;		SUM 18
;		              3   15   13   17   30     33333 43.3
;		              4   14   12   34   46     21739 26.1
;		              5   13   11   51   62     16129 17.7
;		              6   12   10   68   78     12821 12.8
;		              7   11    9   85   94     10638  9.6
;		              8   10    8  102  110      9091  7.3
;		              9    9    7  119  126      7937  5.6
;		             10    8    6  136  142      7042  4.2
;		             11    7    5  153  158      6329  3.2
;		             12    6    4  170  174      5747  2.3
;		             13    5    3  187  190      5263  1.6
;		             14    4    2  204  206      4854  1.0
;		             15    3    1  221  222      4505  0.5
;		SUM 19
;		              4   15   12   17   29     34483 41.4
;		              5   14   11   34   45     22222 24.4
;		              6   13   10   51   61     16393 16.4
;		              7   12    9   68   77     12987 11.7
;		              8   11    8   85   93     10753  8.6
;		              9   10    7  102  109      9174  6.4
;		             10    9    6  119  125      8000  4.8
;		             11    8    5  136  141      7092  3.5
;		             12    7    4  153  157      6369  2.5
;		             13    6    3  170  173      5780  1.7
;		             14    5    2  187  189      5291  1.1
;		             15    4    1  204  205      4878  0.5
;		SUM 20
;		              5   15   11   17   28     35714 39.3
;		              6   14   10   34   44     22727 22.7
;		              7   13    9   51   60     16667 15.0
;		              8   12    8   68   76     13158 10.5
;		              9   11    7   85   92     10870  7.6
;		             10   10    6  102  108      9259  5.6
;		             11    9    5  119  124      8065  4.0
;		             12    8    4  136  140      7143  2.9
;		             13    7    3  153  156      6410  1.9
;		             14    6    2  170  172      5814  1.2
;		             15    5    1  187  188      5319  0.5
;		SUM 21
;		              6   15   10   17   27     37037 37.0
;		              7   14    9   34   43     23256 20.9
;		              8   13    8   51   59     16949 13.6
;		              9   12    7   68   75     13333  9.3
;		             10   11    6   85   91     10989  6.6
;		             11   10    5  102  107      9346  4.7
;		             12    9    4  119  123      8130  3.3
;		             13    8    3  136  139      7194  2.2
;		             14    7    2  153  155      6452  1.3
;		             15    6    1  170  171      5848  0.6
;		SUM 22
;		              7   15    9   17   26     38462 34.6
;		              8   14    8   34   42     23810 19.0
;		              9   13    7   51   58     17241 12.1
;		             10   12    6   68   74     13514  8.1
;		             11   11    5   85   90     11111  5.6
;		             12   10    4  102  106      9434  3.8
;		             13    9    3  119  122      8197  2.5
;		             14    8    2  136  138      7246  1.4
;		             15    7    1  153  154      6494  0.6
;		SUM 23
;		              8   15    8   17   25     40000 32.0
;		              9   14    7   34   41     24390 17.1
;		             10   13    6   51   57     17544 10.5
;		             11   12    5   68   73     13699  6.8
;		             12   11    4   85   89     11236  4.5
;		             13   10    3  102  105      9524  2.9
;		             14    9    2  119  121      8264  1.7
;		             15    8    1  136  137      7299  0.7
;		SUM 24
;		              9   15    7   17   24     41667 29.2
;		             10   14    6   34   40     25000 15.0
;		             11   13    5   51   56     17857  8.9
;		             12   12    4   68   72     13889  5.6
;		             13   11    3   85   88     11364  3.4
;		             14   10    2  102  104      9615  1.9
;		             15    9    1  119  120      8333  0.8
;		SUM 25
;		             10   15    6   17   23     43478 26.1
;		             11   14    5   34   39     25641 12.8
;		             12   13    4   51   55     18182  7.3
;		             13   12    3   68   71     14085  4.2
;		             14   11    2   85   87     11494  2.3
;		             15   10    1  102  103      9709  1.0
;		SUM 26
;		             11   15    5   17   22     45455 22.7
;		             12   14    4   34   38     26316 10.5
;		             13   13    3   51   54     18519  5.6
;		             14   12    2   68   70     14286  2.9
;		             15   11    1   85   86     11628  1.2
;		SUM 27
;		             12   15    4   17   21     47619 19.0
;		             13   14    3   34   37     27027  8.1
;		             14   13    2   51   53     18868  3.8
;		             15   12    1   68   69     14493  1.4
;		SUM 28
;		             13   15    3   17   20     50000 15.0
;		             14   14    2   34   36     27778  5.6
;		             15   13    1   51   52     19231  1.9
;		SUM 29
;		             14   15    2   17   19     52632 10.5
;		             15   14    1   34   35     28571  2.9
;		SUM 30
;		             15   15    1   17   18     55556  5.6



;			   DutyTime   us      total us
;				PauseTime  us		  Hz    %
;		
;		
; 	 	             15    0    1  272  273      3663   0.37
;		             15    1    1  255  256      3906   0.39
;		             15    2    1  238  239      4184   0.42
;		             15    3    1  221  222      4505   0.45
;		             15    4    1  204  205      4878   0.49
;		             15    5    1  187  188      5319   0.53
;		             15    6    1  170  171      5848   0.58
;		             15    7    1  153  154      6494   0.65
;		             15    8    1  136  137      7299   0.73
;		             14    0    2  272  274      3650   0.73
;		             14    1    2  255  257      3891   0.78
;		             14    2    2  238  240      4167   0.83
;		             15    9    1  119  120      8333   0.83
;		             14    3    2  221  223      4484   0.90
;		             14    4    2  204  206      4854   0.97
;		             15   10    1  102  103      9709   0.97
;		             14    5    2  187  189      5291   1.06
;		             13    0    3  272  275      3636   1.09
;		             15   11    1   85   86     11628   1.16
;		             14    6    2  170  172      5814   1.16
;		             13    1    3  255  258      3876   1.16
;		             13    2    3  238  241      4149   1.24
;		             14    7    2  153  155      6452   1.29
;		             13    3    3  221  224      4464   1.34
;		             12    0    4  272  276      3623   1.45
;		             15   12    1   68   69     14493   1.45
;		             14    8    2  136  138      7246   1.45
;		             13    4    3  204  207      4831   1.45
;		             12    1    4  255  259      3861   1.54
;		             13    5    3  187  190      5263   1.58
;		             12    2    4  238  242      4132   1.65
;		             14    9    2  119  121      8264   1.65
;		             13    6    3  170  173      5780   1.73
;		             12    3    4  221  225      4444   1.78
;		             11    0    5  272  277      3610   1.81
;		             14   10    2  102  104      9615   1.92
;		             12    4    4  204  208      4808   1.92
;		             15   13    1   51   52     19231   1.92
;		             13    7    3  153  156      6410   1.92
;		             11    1    5  255  260      3846   1.92
;		             11    2    5  238  243      4115   2.06
;		             12    5    4  187  191      5236   2.09
;		             10    0    6  272  278      3597   2.16
;		             13    8    3  136  139      7194   2.16
;		             11    3    5  221  226      4425   2.21
;		             12    6    4  170  174      5747   2.30
;		             10    1    6  255  261      3831   2.30
;		             14   11    2   85   87     11494   2.30
;		             11    4    5  204  209      4785   2.39
;		             10    2    6  238  244      4098   2.46
;		             13    9    3  119  122      8197   2.46
;		              9    0    7  272  279      3584   2.51
;		             12    7    4  153  157      6369   2.55
;		             11    5    5  187  192      5208   2.60
;		             10    3    6  221  227      4405   2.64
;		              9    1    7  255  262      3817   2.67
;		             10    4    6  204  210      4762   2.86
;		             12    8    4  136  140      7143   2.86
;		              8    0    8  272  280      3571   2.86
;		             13   10    3  102  105      9524   2.86
;		             15   14    1   34   35     28571   2.86
;		              9    2    7  238  245      4082   2.86
;		             11    6    5  170  175      5714   2.86
;		             14   12    2   68   70     14286   2.86
;		              8    1    8  255  263      3802   3.04
;		              9    3    7  221  228      4386   3.07
;		             10    5    6  187  193      5181   3.11
;		             11    7    5  153  158      6329   3.16
;		              7    0    9  272  281      3559   3.20
;		              8    2    8  238  246      4065   3.25
;		             12    9    4  119  123      8130   3.25
;		              9    4    7  204  211      4739   3.32
;		             13   11    3   85   88     11364   3.41
;		              7    1    9  255  264      3788   3.41
;		             10    6    6  170  176      5682   3.41
;		              8    3    8  221  229      4367   3.49
;		              6    0   10  272  282      3546   3.55
;		             11    8    5  136  141      7092   3.55
;		              9    5    7  187  194      5155   3.61
;		              7    2    9  238  247      4049   3.64
;		             12   10    4  102  106      9434   3.77
;		             14   13    2   51   53     18868   3.77
;		             10    7    6  153  159      6289   3.77
;		              6    1   10  255  265      3774   3.77
;		              8    4    8  204  212      4717   3.77
;		              5    0   11  272  283      3534   3.89
;		              7    3    9  221  230      4348   3.91
;		              9    6    7  170  177      5650   3.95
;		             11    9    5  119  124      8065   4.03
;		              6    2   10  238  248      4032   4.03
;		              8    5    8  187  195      5128   4.10
;		              5    1   11  255  266      3759   4.14
;		             13   12    3   68   71     14085   4.23
;		              4    0   12  272  284      3521   4.23
;		             10    8    6  136  142      7042   4.23
;		              7    4    9  204  213      4695   4.23
;		              6    3   10  221  231      4329   4.33
;		              9    7    7  153  160      6250   4.38
;		              5    2   11  238  249      4016   4.42
;		             12   11    4   85   89     11236   4.49
;		              4    1   12  255  267      3745   4.49
;		              8    6    8  170  178      5618   4.49
;		              3    0   13  272  285      3509   4.56
;		              7    5    9  187  196      5102   4.59
;		             11   10    5  102  107      9346   4.67
;		              6    4   10  204  214      4673   4.67
;		              5    3   11  221  232      4310   4.74
;		              4    2   12  238  250      4000   4.80
;		             10    9    6  119  125      8000   4.80
;		              3    1   13  255  268      3731   4.85
;		              9    8    7  136  143      6993   4.90
;		              2    0   14  272  286      3497   4.90
;		              8    7    8  153  161      6211   4.97
;		              7    6    9  170  179      5587   5.03
;		              6    5   10  187  197      5076   5.08
;		              5    4   11  204  215      4651   5.12
;		              4    3   12  221  233      4292   5.15
;		              3    2   13  238  251      3984   5.18
;		              2    1   14  255  269      3717   5.20
;		              1    0   15  272  287      3484   5.23
;		              4    4   12  204  216      4630   5.56
;		              7    7    9  153  162      6173   5.56
;		              1    1   15  255  270      3704   5.56
;		             13   13    3   51   54     18519   5.56
;		              2    2   14  238  252      3968   5.56
;		             12   12    4   68   72     13889   5.56
;		              8    8    8  136  144      6944   5.56
;		              9    9    7  119  126      7937   5.56
;		              3    3   13  221  234      4274   5.56
;		              5    5   11  187  198      5051   5.56
;		             11   11    5   85   90     11111   5.56
;		             14   14    2   34   36     27778   5.56
;		              0    0   16  272  288      3472   5.56
;		              6    6   10  170  180      5556   5.56
;		             10   10    6  102  108      9259   5.56
;		             15   15    1   17   18     55556   5.56
;		              0    1   16  255  271      3690   5.90
;		              1    2   15  238  253      3953   5.93
;		              2    3   14  221  235      4255   5.96
;		              3    4   13  204  217      4608   5.99
;		              4    5   12  187  199      5025   6.03
;		              5    6   11  170  181      5525   6.08
;		              6    7   10  153  163      6135   6.13
;		              7    8    9  136  145      6897   6.21
;		              0    2   16  238  254      3937   6.30
;		              8    9    8  119  127      7874   6.30
;		              1    3   15  221  236      4237   6.36
;		              9   10    7  102  109      9174   6.42
;		              2    4   14  204  218      4587   6.42
;		              3    5   13  187  200      5000   6.50
;		             10   11    6   85   91     10989   6.59
;		              4    6   12  170  182      5495   6.59
;		              5    7   11  153  164      6098   6.71
;		              0    3   16  221  237      4219   6.75
;		             11   12    5   68   73     13699   6.85
;		              6    8   10  136  146      6849   6.85
;		              1    4   15  204  219      4566   6.85
;		              2    5   14  187  201      4975   6.97
;		              7    9    9  119  128      7813   7.03
;		              3    6   13  170  183      5464   7.10
;		              0    4   16  204  220      4545   7.27
;		              8   10    8  102  110      9091   7.27
;		              4    7   12  153  165      6061   7.27
;		             12   13    4   51   55     18182   7.27
;		              1    5   15  187  202      4950   7.43
;		              5    8   11  136  147      6803   7.48
;		              2    6   14  170  184      5435   7.61
;		              9   11    7   85   92     10870   7.61
;		              6    9   10  119  129      7752   7.75
;		              3    7   13  153  166      6024   7.83
;		              0    5   16  187  203      4926   7.88
;		              1    6   15  170  185      5405   8.11
;		              4    8   12  136  148      6757   8.11
;		             13   14    3   34   37     27027   8.11
;		              7   10    9  102  111      9009   8.11
;		             10   12    6   68   74     13514   8.11
;		              2    7   14  153  167      5988   8.38
;		              5    9   11  119  130      7692   8.46
;		              0    6   16  170  186      5376   8.60
;		              8   11    8   85   93     10753   8.60
;		              3    8   13  136  149      6711   8.72
;		              1    7   15  153  168      5952   8.93
;		              6   10   10  102  112      8929   8.93
;		             11   13    5   51   56     17857   8.93
;		              4    9   12  119  131      7634   9.16
;		              2    8   14  136  150      6667   9.33
;		              9   12    7   68   75     13333   9.33
;		              0    7   16  153  169      5917   9.47
;		              7   11    9   85   94     10638   9.57
;		              5   10   11  102  113      8850   9.73
;		              3    9   13  119  132      7576   9.85
;		              1    8   15  136  151      6623   9.93
;		              4   10   12  102  114      8772  10.53
;		              8   12    8   68   76     13158  10.53
;		              0    8   16  136  152      6579  10.53
;		             10   13    6   51   57     17544  10.53
;		             14   15    2   17   19     52632  10.53
;		              2    9   14  119  133      7519  10.53
;		              6   11   10   85   95     10526  10.53
;		             12   14    4   34   38     26316  10.53
;		              1    9   15  119  134      7463  11.19
;		              3   10   13  102  115      8696  11.30
;		              5   11   11   85   96     10417  11.46
;		              7   12    9   68   77     12987  11.69
;		              0    9   16  119  135      7407  11.85
;		              2   10   14  102  116      8621  12.07
;		              9   13    7   51   58     17241  12.07
;		              4   11   12   85   97     10309  12.37
;		             11   14    5   34   39     25641  12.82
;		              6   12   10   68   78     12821  12.82
;		              1   10   15  102  117      8547  12.82
;		              3   11   13   85   98     10204  13.27
;		              0   10   16  102  118      8475  13.56
;		              8   13    8   51   59     16949  13.56
;		              5   12   11   68   79     12658  13.92
;		              2   11   14   85   99     10101  14.14
;		             13   15    3   17   20     50000  15.00
;		             10   14    6   34   40     25000  15.00
;		              1   11   15   85  100     10000  15.00
;		              7   13    9   51   60     16667  15.00
;		              4   12   12   68   80     12500  15.00
;		              0   11   16   85  101      9901  15.84
;		              3   12   13   68   81     12346  16.05
;		              6   13   10   51   61     16393  16.39
;		              2   12   14   68   82     12195  17.07
;		              9   14    7   34   41     24390  17.07
;		              5   13   11   51   62     16129  17.74
;		              1   12   15   68   83     12048  18.07
;		              0   12   16   68   84     11905  19.05
;		              4   13   12   51   63     15873  19.05
;		              8   14    8   34   42     23810  19.05
;		             12   15    4   17   21     47619  19.05
;		              3   13   13   51   64     15625  20.31
;		              7   14    9   34   43     23256  20.93
;		              2   13   14   51   65     15385  21.54
;		              6   14   10   34   44     22727  22.73
;		             11   15    5   17   22     45455  22.73
;		              1   13   15   51   66     15152  22.73
;		              0   13   16   51   67     14925  23.88
;		              5   14   11   34   45     22222  24.44
;		             10   15    6   17   23     43478  26.09
;		              4   14   12   34   46     21739  26.09
;		              3   14   13   34   47     21277  27.66
;		              9   15    7   17   24     41667  29.17
;		              2   14   14   34   48     20833  29.17
;		              1   14   15   34   49     20408  30.61
;		              8   15    8   17   25     40000  32.00
;		              0   14   16   34   50     20000  32.00
;		              7   15    9   17   26     38462  34.62
;		              6   15   10   17   27     37037  37.04
;		              5   15   11   17   28     35714  39.29
;		              4   15   12   17   29     34483  41.38
;		              3   15   13   17   30     33333  43.33
;		              2   15   14   17   31     32258  45.16
;		              1   15   15   17   32     31250  46.88
;		              0   15   16   17   33     30303  48.48
;		


;			   DutyTime   us      total us
;				PauseTime  us		  Hz    %


;		              0    0   16  272  288      3472  5.6
;		              1    0   15  272  287      3484  5.2
;		              2    0   14  272  286      3497  4.9
;		              3    0   13  272  285      3509  4.6
;		              4    0   12  272  284      3521  4.2
;		              5    0   11  272  283      3534  3.9
;		              6    0   10  272  282      3546  3.5
;		              7    0    9  272  281      3559  3.2
;		              8    0    8  272  280      3571  2.9
;		              9    0    7  272  279      3584  2.5
;		             10    0    6  272  278      3597  2.2
;		             11    0    5  272  277      3610  1.8
;		             12    0    4  272  276      3623  1.4
;		             13    0    3  272  275      3636  1.1
;		             14    0    2  272  274      3650  0.7
;		             15    0    1  272  273      3663  0.4
;		              0    1   16  255  271      3690  5.9
;		              1    1   15  255  270      3704  5.6
;		              2    1   14  255  269      3717  5.2
;		              3    1   13  255  268      3731  4.9
;		              4    1   12  255  267      3745  4.5
;		              5    1   11  255  266      3759  4.1
;		              6    1   10  255  265      3774  3.8
;		              7    1    9  255  264      3788  3.4
;		              8    1    8  255  263      3802  3.0
;		              9    1    7  255  262      3817  2.7
;		             10    1    6  255  261      3831  2.3
;		             11    1    5  255  260      3846  1.9
;		             12    1    4  255  259      3861  1.5
;		             13    1    3  255  258      3876  1.2
;		             14    1    2  255  257      3891  0.8
;		             15    1    1  255  256      3906  0.4
;		              0    2   16  238  254      3937  6.3
;		              1    2   15  238  253      3953  5.9
;		              2    2   14  238  252      3968  5.6
;		              3    2   13  238  251      3984  5.2
;		              4    2   12  238  250      4000  4.8
;		              5    2   11  238  249      4016  4.4
;		              6    2   10  238  248      4032  4.0
;		              7    2    9  238  247      4049  3.6
;		              8    2    8  238  246      4065  3.3
;		              9    2    7  238  245      4082  2.9
;		             10    2    6  238  244      4098  2.5
;		             11    2    5  238  243      4115  2.1
;		             12    2    4  238  242      4132  1.7
;		             13    2    3  238  241      4149  1.2
;		             14    2    2  238  240      4167  0.8
;		             15    2    1  238  239      4184  0.4
;		              0    3   16  221  237      4219  6.8
;		              1    3   15  221  236      4237  6.4
;		              2    3   14  221  235      4255  6.0
;		              3    3   13  221  234      4274  5.6
;		              4    3   12  221  233      4292  5.2
;		              5    3   11  221  232      4310  4.7
;		              6    3   10  221  231      4329  4.3
;		              7    3    9  221  230      4348  3.9
;		              8    3    8  221  229      4367  3.5
;		              9    3    7  221  228      4386  3.1
;		             10    3    6  221  227      4405  2.6
;		             11    3    5  221  226      4425  2.2
;		             12    3    4  221  225      4444  1.8
;		             13    3    3  221  224      4464  1.3
;		             14    3    2  221  223      4484  0.9
;		             15    3    1  221  222      4505  0.5
;		              0    4   16  204  220      4545  7.3
;		              1    4   15  204  219      4566  6.8
;		              2    4   14  204  218      4587  6.4
;		              3    4   13  204  217      4608  6.0
;		              4    4   12  204  216      4630  5.6
;		              5    4   11  204  215      4651  5.1
;		              6    4   10  204  214      4673  4.7
;		              7    4    9  204  213      4695  4.2
;		              8    4    8  204  212      4717  3.8
;		              9    4    7  204  211      4739  3.3
;		             10    4    6  204  210      4762  2.9
;		             11    4    5  204  209      4785  2.4
;		             12    4    4  204  208      4808  1.9
;		             13    4    3  204  207      4831  1.4
;		             14    4    2  204  206      4854  1.0
;		             15    4    1  204  205      4878  0.5
;		              0    5   16  187  203      4926  7.9
;		              1    5   15  187  202      4950  7.4
;		              2    5   14  187  201      4975  7.0
;		              3    5   13  187  200      5000  6.5
;		              4    5   12  187  199      5025  6.0
;		              5    5   11  187  198      5051  5.6
;		              6    5   10  187  197      5076  5.1
;		              7    5    9  187  196      5102  4.6
;		              8    5    8  187  195      5128  4.1
;		              9    5    7  187  194      5155  3.6
;		             10    5    6  187  193      5181  3.1
;		             11    5    5  187  192      5208  2.6
;		             12    5    4  187  191      5236  2.1
;		             13    5    3  187  190      5263  1.6
;		             14    5    2  187  189      5291  1.1
;		             15    5    1  187  188      5319  0.5
;		              0    6   16  170  186      5376  8.6
;		              1    6   15  170  185      5405  8.1
;		              2    6   14  170  184      5435  7.6
;		              3    6   13  170  183      5464  7.1
;		              4    6   12  170  182      5495  6.6
;		              5    6   11  170  181      5525  6.1
;		              6    6   10  170  180      5556  5.6
;		              7    6    9  170  179      5587  5.0
;		              8    6    8  170  178      5618  4.5
;		              9    6    7  170  177      5650  4.0
;		             10    6    6  170  176      5682  3.4
;		             11    6    5  170  175      5714  2.9
;		             12    6    4  170  174      5747  2.3
;		             13    6    3  170  173      5780  1.7
;		             14    6    2  170  172      5814  1.2
;		             15    6    1  170  171      5848  0.6
;		              0    7   16  153  169      5917  9.5
;		              1    7   15  153  168      5952  8.9
;		              2    7   14  153  167      5988  8.4
;		              3    7   13  153  166      6024  7.8
;		              4    7   12  153  165      6061  7.3
;		              5    7   11  153  164      6098  6.7
;		              6    7   10  153  163      6135  6.1
;		              7    7    9  153  162      6173  5.6
;		              8    7    8  153  161      6211  5.0
;		              9    7    7  153  160      6250  4.4
;		             10    7    6  153  159      6289  3.8
;		             11    7    5  153  158      6329  3.2
;		             12    7    4  153  157      6369  2.5
;		             13    7    3  153  156      6410  1.9
;		             14    7    2  153  155      6452  1.3
;		             15    7    1  153  154      6494  0.6
;		              0    8   16  136  152      6579 10.5
;		              1    8   15  136  151      6623  9.9
;		              2    8   14  136  150      6667  9.3
;		              3    8   13  136  149      6711  8.7
;		              4    8   12  136  148      6757  8.1
;		              5    8   11  136  147      6803  7.5
;		              6    8   10  136  146      6849  6.8
;		              7    8    9  136  145      6897  6.2
;		              8    8    8  136  144      6944  5.6
;		              9    8    7  136  143      6993  4.9
;		             10    8    6  136  142      7042  4.2
;		             11    8    5  136  141      7092  3.5
;		             12    8    4  136  140      7143  2.9
;		             13    8    3  136  139      7194  2.2
;		             14    8    2  136  138      7246  1.4
;		             15    8    1  136  137      7299  0.7
;		              0    9   16  119  135      7407 11.9
;		              1    9   15  119  134      7463 11.2
;		              2    9   14  119  133      7519 10.5
;		              3    9   13  119  132      7576  9.8
;		              4    9   12  119  131      7634  9.2
;		              5    9   11  119  130      7692  8.5
;		              6    9   10  119  129      7752  7.8
;		              7    9    9  119  128      7813  7.0
;		              8    9    8  119  127      7874  6.3
;		              9    9    7  119  126      7937  5.6
;		             10    9    6  119  125      8000  4.8
;		             11    9    5  119  124      8065  4.0
;		             12    9    4  119  123      8130  3.3
;		             13    9    3  119  122      8197  2.5
;		             14    9    2  119  121      8264  1.7
;		             15    9    1  119  120      8333  0.8
;		              0   10   16  102  118      8475 13.6
;		              1   10   15  102  117      8547 12.8
;		              2   10   14  102  116      8621 12.1
;		              3   10   13  102  115      8696 11.3
;		              4   10   12  102  114      8772 10.5
;		              5   10   11  102  113      8850  9.7
;		              6   10   10  102  112      8929  8.9
;		              7   10    9  102  111      9009  8.1
;		              8   10    8  102  110      9091  7.3
;		              9   10    7  102  109      9174  6.4
;		             10   10    6  102  108      9259  5.6
;		             11   10    5  102  107      9346  4.7
;		             12   10    4  102  106      9434  3.8
;		             13   10    3  102  105      9524  2.9
;		             14   10    2  102  104      9615  1.9
;		             15   10    1  102  103      9709  1.0
;		              0   11   16   85  101      9901 15.8
;		              1   11   15   85  100     10000 15.0
;		              2   11   14   85   99     10101 14.1
;		              3   11   13   85   98     10204 13.3
;		              4   11   12   85   97     10309 12.4
;		              5   11   11   85   96     10417 11.5
;		              6   11   10   85   95     10526 10.5
;		              7   11    9   85   94     10638  9.6
;		              8   11    8   85   93     10753  8.6
;		              9   11    7   85   92     10870  7.6
;		             10   11    6   85   91     10989  6.6
;		             11   11    5   85   90     11111  5.6
;		             12   11    4   85   89     11236  4.5
;		             13   11    3   85   88     11364  3.4
;		             14   11    2   85   87     11494  2.3
;		             15   11    1   85   86     11628  1.2
;		              0   12   16   68   84     11905 19.0
;		              1   12   15   68   83     12048 18.1
;		              2   12   14   68   82     12195 17.1
;		              3   12   13   68   81     12346 16.0
;		              4   12   12   68   80     12500 15.0
;		              5   12   11   68   79     12658 13.9
;		              6   12   10   68   78     12821 12.8
;		              7   12    9   68   77     12987 11.7
;		              8   12    8   68   76     13158 10.5
;		              9   12    7   68   75     13333  9.3
;		             10   12    6   68   74     13514  8.1
;		             11   12    5   68   73     13699  6.8
;		             12   12    4   68   72     13889  5.6
;		             13   12    3   68   71     14085  4.2
;		             14   12    2   68   70     14286  2.9
;		             15   12    1   68   69     14493  1.4
;		              0   13   16   51   67     14925 23.9
;		              1   13   15   51   66     15152 22.7
;		              2   13   14   51   65     15385 21.5
;		              3   13   13   51   64     15625 20.3
;		              4   13   12   51   63     15873 19.0
;		              5   13   11   51   62     16129 17.7
;		              6   13   10   51   61     16393 16.4
;		              7   13    9   51   60     16667 15.0
;		              8   13    8   51   59     16949 13.6
;		              9   13    7   51   58     17241 12.1
;		             10   13    6   51   57     17544 10.5
;		             11   13    5   51   56     17857  8.9
;		             12   13    4   51   55     18182  7.3
;		             13   13    3   51   54     18519  5.6
;		             14   13    2   51   53     18868  3.8
;		             15   13    1   51   52     19231  1.9
;		              0   14   16   34   50     20000 32.0
;		              1   14   15   34   49     20408 30.6
;		              2   14   14   34   48     20833 29.2
;		              3   14   13   34   47     21277 27.7
;		              4   14   12   34   46     21739 26.1
;		              5   14   11   34   45     22222 24.4
;		              6   14   10   34   44     22727 22.7
;		              7   14    9   34   43     23256 20.9
;		              8   14    8   34   42     23810 19.0
;		              9   14    7   34   41     24390 17.1
;		             10   14    6   34   40     25000 15.0
;		             11   14    5   34   39     25641 12.8
;		             12   14    4   34   38     26316 10.5
;		             13   14    3   34   37     27027  8.1
;		             14   14    2   34   36     27778  5.6
;		             15   14    1   34   35     28571  2.9
;		              0   15   16   17   33     30303 48.5
;		              1   15   15   17   32     31250 46.9
;		              2   15   14   17   31     32258 45.2
;		              3   15   13   17   30     33333 43.3
;		              4   15   12   17   29     34483 41.4
;		              5   15   11   17   28     35714 39.3
;		              6   15   10   17   27     37037 37.0
;		              7   15    9   17   26     38462 34.6
;		              8   15    8   17   25     40000 32.0
;		              9   15    7   17   24     41667 29.2
;		             10   15    6   17   23     43478 26.1
;		             11   15    5   17   22     45455 22.7
;		             12   15    4   17   21     47619 19.0
;		             13   15    3   17   20     50000 15.0
;		             14   15    2   17   19     52632 10.5
;		             15   15    1   17   18     55556  5.6
;		

		; timecounter expired
		btfss	Ramp_Running		; 
		 goto	endlatency		;      		     
		btfsc	Down_Running		; initialize downramp					
		 goto	down			;


;********************************** ramp up
		skpeql	PeriodReg,Hi_Intensity	;
		 goto	decPR2			;
						; ramp finished
						; 
endramp		bcf	Ramp_Running		; set latency time
		eq	UprampTime+2,0x38	; 56*256*256*(PeriodReg*3+14) us
		goto	motime
;************************************************

down		skpneql	PeriodReg,Lo_Intensity	; 
		 goto	prepslp			; goto sleep
incPR2		incf	PeriodReg,F		; PR2 +=1 dimmer
		skpgel	PeriodReg,.13
		 goto	tbl
		movlw 	.7
		goto	tbl+1
tbl		call	readt
		subwf	UprampTime,F
		skpNC
		 goto	 motime
		movf	UprampTime+1,F
		skpnz
		 goto	ovl
novl		decf	UprampTime+1,F
		goto	motime
ovl		movf	UprampTime+2,F
		skpnz
		 goto	crluf
		decf	UprampTime+2,F
		goto	novl
crluf		clrf	UprampTime
		goto 	motime
;************************************************	
;	eq	BL,.255			;128=18ms 255= 38ms
;	movfw	PeriodReg	
;incsub	subwf	BL,F
;	skpC
;	 goto	motime
;	dec	UprampTime,F
;	movf	UprampTime,F
;	skpnz
;	 decf	UprampTime+1,F
;	decf	UprampTime,F
;	goto	incsub
;	
;
;********************************************************************
endlatency 	btfsc Latency_Extend		; latency extended due to	
	    	 goto motime-1			; picked up PIR signal
		bsf	Ramp_Running
		bsf	Down_Running
		eeeq	UprampTime, .90000/.27  
		goto	motime			;
;********************************************************************
		
tstport		btfss	PIR_On_Port	; 
	 	 goto	startcycle-4
		btfsc	Down_Running	; 
		 goto	reverserun
		bsf	Latency_Extend	; latency running
		goto	startcycle

reverserun	bcf	Down_Running
		clrfff	UprampTime
		goto	decPR2


	bcf	Latency_Extend
motime		incf	UprampTime,W
		movwf	TimeCounter
		incf	UprampTime+1,W
		movwf	TimeCounter+1
		incf	UprampTime+2,W
		movwf	TimeCounter+2
	; 
	goto	startcycle	; 



afterwdt
;	bcf	PFET_Gate_Port
;	decfsz	PeriodCounter,F
;	  goto $-1
;	bsf	PFET_Gate_Port
	goto prepslp

pause03		nop			;test
		decfsz	BL,F		;test
		 goto	$-2		;test
		decfsz	BH,F		;test
		goto	pause03		;test
		retlw 0			;test


				;
#define GP1_Porton	b'01110001'     ; configure comparator input=on
#define GP0_Porton	b'01110011'     ; configure comparator input=on, int ref, GP0


afterpin	goto	$+1
		decfsz	AL,F
	  	 goto $-2		;5*256 =1280us
		btfss PIR_On_Port	; notest PIR still on?
	 	 goto prepslp		; notest too small PIR-Signal, or Change to OFF

#define	P100_Port	0

testcds		bsf	GPIO,P100_Port	; 
		movlw	((1<< P100_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; charge C
		movlw	.4
		movwf	AL		; 15 us
		decfsz	AL,F
		 goto	$-1		; 
		clrwdt
		movlw	iodir		;  GP,x is input
		TRIS 	TRISGPIO	; let C discharge
		clrf	AH
		clrf	AL		; 1 us
loop100		btfss	GPIO,P100_Port
		 goto	exitloop100
		incfsz	AL,F
		 goto	loop100		;timeout 1000us	
		incfsz	AH,F
		 goto	loop100
		decf	AH,F
		decf	AL,F	
exitloop100	
;		bcf	GPIO,P100_Port			;test		
;		movlw	((1<< P100_Port) ^ 0xFF) & iodir;test
;		TRIS 	TRISGPIO	; discharge C	;test
	
		movlw	.5
		subwf	AH,W
		skpC
		  goto prepslp		; CDS too low, too bright

		eq	PeriodReg,Lo_Intensity

;		movwf PeriodReg		; 0-176
;		incl	PeriodReg,0x20	; 32-208
;;		eq	AL,.10 	;test
;		decfsz	AL,F	;test
;		 goto	$-1	;test
;		Goto testcds	;test
;	


#define	C10N_Port	1				;

tstvoltage	eq	DutyTime, .15
		eq	DutyPause, .15
		goto	startcycle;	;test
		
		eq	PeriodReg,Lo_Intensity
		bcf	GPIO,C10N_Port
		if C10N_Port
		 movlw	GP1_Porton     ; configure comparator input
		else
		movlw	GP0_Porton
		 endif
	
				;bit 7 bit 0
				;bit 7 CMPOUT: Comparator Output bit
				;1 = VIN+ > VIN-
				;0 = VIN+ < VINbit
				;6 COUTEN: Comparator Output Enable bit(1, 2)
				;1 = Output of comparator is NOT placed on the COUT pin
				;0 = Output of comparator is placed in the COUT pin
				;bit 5 POL: Comparator Output Polarity bit(2)
				;1 = Output of comparator not inverted
				;0 = Output of comparator inverted
				;bit 4 CMPT0CS: Comparator TMR0 Clock Source bit(2)
				;1 = TMR0 clock source selected by T0CS control bit
				;0 = Comparator output used as TMR0 clock source
				;bit 3 CMPON: Comparator Enable bit
				;1 = Comparator is on
				;0 = Comparator is off
				;bit 2 CNREF: Comparator Negative Reference Select bit(2)
				;1 = CIN- pin(3)
				;0 = Internal voltage reference
				;bit 1 CPREF: Comparator Positive Reference Select bit(2)
				;1 = CIN+ pin(3)
				;0 = CIN- pin(3)
				;bit 0 CWU: Comparator Wake-up on Change Enable bit(2)
				;1 = Wake-up on comparator change is disabled
				;0 = Wake-up on comparator change is enabled.
				;Note 1: Overrides T0CS bit for TRIS control of GP2.
		movwf	CMCON0	
		movlw	((1<< C10N_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; discharge C
		eq	AL,.1		; 5 us delay
		decfsz	AL,F
		 goto	$-1		; 
		movlw	iodir		;  GP is input
		TRIS 	TRISGPIO	; charge C
		bsf	CMCON0,3	; comparator on
		clrf	AL
loop		btfsc	CMCON0,7
		 goto	exitloop
		incfsz	AL,F
		 goto	loop		;timeout 1000us	
		decf	AL,F	
		
exitloop	bcf	CMCON0,3	;comparator off
			
		eq	DutyCase,.9
		skpgel	AL,0x58		; .88		4.25V
   		 goto endvoltage
		decf	DutyCase,F
		decf	DutyCase,F
		skpgel	AL,0x58+0x16	;.88+.20 =108	3.7V
		 goto endvoltage
		decf 	DutyCase,F
		decf	DutyCase,F
		skpgel	AL,0x58+0x26	;.88.+.36= 124  3.35V
		 goto	endvoltage		
		decf	DutyCase,F
		decf	DutyCase,F
		skpgel	AL,0x58+0x30	;.88+.48 = 136  3.1V
 		 goto	endvoltage
		decf	DutyCase,F
		decf	DutyCase,F	
		skplel	AL,0x58+0x38	;.88+.56 = .144 3.0V
		decf	DutyCase,F	; warning blinker
endvoltage	;mov	AL,AH

;******************************************TEST TEST TEST
;exitp100		bsf	send_first		
;		skplesl	AH,.125
;		 goto	send125
;		skplesl	AH,.25
;		 goto	send25
;		skplesl	AH,.5
;		 goto	send5
;		skplesl	AH,.1
;		 goto	send1
;		eq	AH,.06
;		call	pause03
;		decfsz	AH,F
;		 goto	$-2
;		btfss	send_first
;		 goto	endsend
;		bcf	send_first
;		mov	AL,AH
;		goto	exitp100+1
;endsend		eq	AL,.20
;		call pause03
;		decfsz	AL,F
;		 goto	$-2
;		goto	testcds		
;send1		decf	AH,F	
;		eeq	BL,.2300
;		goto	send25cycles
;
;send5		decl	AH,.5	
;		eeq	BL,.8000
;		goto	send25cycles
;
;send25		decl	AH,.25	
;		eeq	BL,.22000
;		goto	send25cycles
;			
;		
;send125		decl	AH,.125	
;		eeq	BL,.65000
;		goto	send25cycles
;		
;
;
;send25cycles	eq	AHH,.8
;		decfsz	AHH,F
;		 goto	$-1
;		bsf	NFET_Gate_Port
;		bcf	NFET_Gate_Port
;		decfsz	BL,F
;		 goto	send25cycles
;		decfsz	BH,F
;		 goto	send25cycles
;		call	pause03
;		goto	exitp100+1
;
;;********************************TEST TEST TEST
;	eq	AL,.10 ;test
;		decfsz	AL,F;test
;		 goto	$-1;test
;		Goto testcds;test


		GOTO MAIN
	end
