;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   at GPIO 2 Transistor output driver                                *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: A.0                                               *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************

	list      p=12F683	; list directive to define processor
	#include <p12f683.inc>	; processor specific variable definitions

	#include C:\Programme\Microchip\macros.inc
	__CONFIG  _CP_OFF & _WDT_OFF & _BOD_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

;	ERRORLEVEL -302				; Get rid of banking messages...

;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80


;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000		; processor reset vector
	nop			; required by in circuit debugger
	goto    Init		; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG     0x004
	return			; interrupt trap - return without re-enabling 

;******************************************************************************
;Initialization
;******************************************************************************
;******************************************************************************
;Initialization
;******************************************************************************
Init	movlw	b'00000000'	; all GPIO Low
	movwf	GPIO
	BANKSEL	Bank1		; BANK1

#define iodir	b'11001111'

	movlw	iodir     ; set direction bits 
	movwf	TRISIO		;
				; GP5	outp 
				; GP4	outp
				; GP3	inp
				; GP2	outp
				; GP1	inp
				; GP0	inp
 
	movlw	B'11011000'	; Timer0 internal clock, 1:32 prescale
	movwf	OPTION_REG	; set option register for Timer0 functions
				;OPTION_REG  OPTION REGISTER (ADDRESS: 81h)
				;Note: To achieve a 1:1 prescaler assignment for
				;TMR0, assign the prescaler to the WDT by
				;setting PSA bit to 1 (Option<3>). See
				;Section 5.4 Prescaler.
				;R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1
				;GPPU INTEDG T0CS  T0SE   PSA   PS2   PS1   PS0
				;  7     6     5     4      3    2     1     0
				;bit 7 GPPU: GPIO Pull-up Enable bit
				;1 = GPIO pull-ups are disabled
				;0 = GPIO pull-ups are enabled by individual port latch values in WPU register
				;
				;bit 6 INTEDG: Interrupt Edge Select bit
				;1 = Interrupt on rising edge of GP2/INT pin
				;0 = Interrupt on falling edge of GP2/INT pin
				;
				;bit 5 T0CS: TMR0 Clock Source Select bit
				;1 = Transition on GP2/T0CKI pin
				;0 = Internal instruction cycle clock (CLKOUT)
				;
				;bit 4 T0SE: TMR0 Source Edge Select bit
				;1 = Increment on high-to-low transition on GP2/T0CKI pin
				;0 = Increment on low-to-high transition on GP2/T0CKI pin
				;
				;bit 3 PSA: Prescaler Assignment bit
				;1 = Prescaler is assigned to the WDT
				;0 = Prescaler is assigned to the Timer0 module
				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
				;Note 1: A dedicated 16-bit WDT postscaler is available for the PIC12F683. See
				;Section 12.6 Watchdog Timer (WDT) for more information.
				;Legend:
				;R = Readable bit W = Writable bit U = Unimplemented bit, read as 0
				;- n = Value at POR 1 = Bit is set 0 = Bit is cleared x = Bit is unknown
				;Bit Value   TMR0 Rate 	   WDT Rate(1)
				;000		1:2		1:1	
				;001		1:4		1 : 2
				;010		1:8		1:4
				;011		1:16		1:8
				;100		1:32		1:16
				;101		1:64		1:32
				;110		1:128		1:64
				;111		1:256		1:128
				;
	;	

	movlw	b'00010000'
	movwf	ANSEL		; configure A/D  GP0 and GP1 analog
				;ANSEL  ANALOG SELECT REGISTER (ADDRESS: 9Fh)
				;U-0 R/W-0 R/W-0 R/W-0 R/W-1 R/W-1 R/W-1 R/W-1
				;   ADCS2 ADCS1 ADCS0  ANS3  ANS2  ANS1  ANS0
				; 7     6    5     4     3      2     1  bit 0
				;bit 7 Unimplemented: Read as 0
				;bit 6-4 ADCS<2:0>: A/D Conversion Clock Select bits
				;000 = FOSC/2
				;001 = FOSC/8
				;010 = FOSC/32
				;x11 = FRC (clock derived from a dedicated internal oscillator = 500 kHz max)
				;100 = FOSC/4
				;101 = FOSC/16
				;110 = FOSC/64
				;bit 3-0 ANS<3:0>: Analog Select bits
				;Analog select between analog or digital function on pins ANS<3:0>, respectively.
				;1 = Analog input. Pin is assigned as analog input(1).
				;0 = Digital I/O. Pin is assigned to port or special function.
				;Note 1: Setting a pin to an analog input automatically disables the digital input circuitry,
				;weak pull-ups and interrupt-on-change if available. The corresponding TRISIO bit
				;must be set to input mode in order to allow external control of the voltage on the pin.
 
	movlw	b'01100001'
	movwf	OSCCON		; 4MHz
				;OSCCON  OSCILLATOR CONTROL REGISTER (ADDRESS: 8Fh)
				;Note: Due to the wide range of oscillator start-up
				;times, the Fail-Safe circuit is not active
				;during oscillator start-up (i.e., after exiting
				;Reset or Sleep). After an appropriate
				;amount of time, the user should check the
				;OSTS bit (OSCCON<3>) to verify the
				;oscillator start-up and system clock
				;switchover has successfully completed.
				;U-0 R/W-1 R/W-1 R/W-0  R-1    R-0 R-0 R/W-0
				;   IRCF2 IRCF1 IRCF0 OSTS(1) HTS LTS SCS
				; 7    6     5     4     3      2   1   0
				;bit 7 Unimplemented: Read as 0
				;
				;bit 6-4 IRCF<2:0>: Internal Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
				;
				;bit 3 OSTS: Oscillator Start-up Time-out Status bit
				;1 = Device is running from the external system clock defined by FOSC<2:0>
				;0 = Device is running from the internal system clock (HFINTOSC or LFINTOSC)
				;
				;bit 2 HTS: HFINTOSC (High Frequency  8 MHz to 125 kHz) Status bit
				;1 = HFINTOSC is stable
				;0 = HFINTOSC is not stable
				;
				;bit 1 LTS: LFINTOSC (Low Frequency  31 kHz) Stable bit
				;1 = LFINTOSC is stable
				;0 = LFINTOSC is not stable
				;
				;bit 0 SCS: System Clock Select bit
				;1 = Internal oscillator is used for system clock
				;0 = Clock source defined by FOSC<2:0>
				;Note 1: Bit resets to 0 with Two-Speed Start-up and LP, XT or HS selected as the oscillator
				;mode or Fail-Safe mode is enabled.

	banksel	Bank0		; switch back to PORT memory bank
	movlw	b'00000111'     
	movwf	CMCON0		; comparator enable input GP1 - Internal reference
				;CMCON0  COMPARATOR CONTROL REGISTER 0 (ADDRESS: 19h)
				;U-0 R-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;   COUT    CINV  CIS   CM2   CM1   CM0
				; 7    6  5     4    3     2     1     0
				;
				;bit 6 COUT: Comparator Output bit
				;When CINV = 0:
				;1 = VIN+ > VIN-
				;0 = VIN+ < VIN-
				;When CINV = 1:
				;1 = VIN+ < VIN-
				;0 = VIN+ > VINbit
				;
				;bit 4 CINV: Comparator Output Inversion bit
				;1 = Output inverted
				;0 = Output not inverted
				;
				;bit 3 CIS: Comparator Input Switch bit
				;When CM<2:0> = 110 or 101:
				;1 = VIN- connects to CIN+   GP0
				;0 = VIN- connects to CINbit GP1
				;
				;2 CM<2:0>: Comparator Mode bits
				;
				;FIGURE 8-3: COMPARATOR I/O OPERATING MODES
				;Note: Comparator interrupts should be disabled
				;during a Comparator mode change.
				;Otherwise, a false interrupt may occur.
				;Comparator Reset (POR Default Value  Low Power)         	
				;CM<2:0> = 000
				;                                                 
				;Comparator Off (Lowest Power)
				;	CM<2:0> = 111

				;Comparator without Output                                	Comparator w/o Output and with Internal Reference
				;CM<2:0> = 010 							CM<2:0> = 100
				;
				;Comparator with Output and Internal Reference 			Multiplexed Input with Internal Reference and Output
				;CM<2:0> = 011 							CM<2:0> = 101
				;
				;Comparator with Output 					
				;CM<2:0> = 001 	
				
				; Multiplexed Input with Internal Reference
				;		CM<2:0> = 110
				;
	movlw	b'00010100'	; 1 seconds
	movwf	WDTCON
	clrwdt
				;WDTCON  WATCHDOG TIMER CONTROL REGISTER (ADDRESS: 18h)
				;TABLE 12-8: SUMMARY OF WATCHDOG TIMER REGISTERS
				;U-0 U-0 U-0 R/W-0  R/W-1  R/W-0  R/W-0  R/W-0
				;         WDTPS3 WDTPS2 WDTPS1 WDTPS0 SWDTEN
				; 7   6   5     4     3       2     1      0
				;bit 7-5 Unimplemented: Read as 0
				;bit 4-1 WDTPS<3:0>: Watchdog Timer Period Select bits
				;Bit Value = Prescale Rate
				;0000 = 1:32
				;0001 = 1:64
				;0010 = 1:128
				;0011 = 1:256
				;0100 = 1:512 (Reset value)  = 16ms
				;0101 = 1:1024               = 32
				;0110 = 1:2048                 64
				;0111 = 1:4096                 128
				;1000 = 1:8192		       256
				;1001 = 1:16384			512
				;1010 = 1:32768			1024
				;1011 = 1:65536			2048
				;1100 = Reserved
				;1101 = Reserved
				;1110 = Reserved
				;1111 = Reserved
				;bit 0 SWDTEN: Software Enable or Disable the Watchdog Timer(1)
				;1 = WDT is turned on
				;0 = WDT is turned off (Reset value)
				;Note 1: If WDTE configuration bit = 1, then WDT is always enabled, irrespective of this
				;control bit. If WDTE configuration bit = 0, then it is possible to turn WDT on/off with
				;this control bit.
				
	movlw	b'00000000'
	movwf	INTCON		;

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
		AL,AH,BL		; 
		UprampTime:3
		SystemStatus			; flags
		PeriodReg			; intensity
		TimeCounter:3			; Time to wait for next PIR
		DutyCase,DutyTime,DutyPause,MaxTmr

	endc

#define PIR_On_Port	GPIO,3		; 

#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6

#define	Latency_Extend	SystemStatus,5


#define Lo_Intensity	.255
#define Hi_Intensity	.8
	
;******************************************************************************
;Main 
;******************************************************************************
Main	
	clrfff	UprampTime	
	clrf	SystemStatus				; 
	bsf	Ramp_Running

	BANKSEL	Bank1		; BANK1
	movlw	iodir
	iorlw	b'00000100'	; clr output 

	movwf	TRISIO		;
	bcf	PIE1,TMR2IE	; clr interrupt , if necessary

	eq	PR2,Lo_Intensity
			  ; 256*4 us = 0.976kHz 
					  ; 256      = 3.906kHz	
					  ; 9        = 111,1kHz

	BANKSEL	Bank0


		;CCP1CON  CCP CONTROL REGISTER 1 (ADDRESS: 15h)
	
		; U-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0   R/W-0  R/W-0
		;       DC1B1 DC1B0 CCP1M3 CCP1M2 CCP1M1 CCP1M0
		;  7    6   5     4     3      2      1      0     
		;bit7
		;Unimplemented: Read as 0
		;bit6
		;Unimplemented: Read as 0
		;bit5 , bit4
		;DC1B<1:0>: PWM Least Significant bits
		;Capture mode:
		;Unused.
		;Compare mode:
		;Unused.
		;PWM mode:
		;These bits are the two LSbs of the PWM duty cycle. The eight MSbs are found in CCPR1L.
		;bit 3
		;CCP1M<3:0>: CCP1 Mode Select bits
		;0000 = Capture/Compare/PWM disabled (resets CCP1 module)
		;0100 = Capture mode, every falling edge
		;0101 = Capture mode, every rising edge
		;0110 = Capture mode, every 4th rising edge
		;0111 = Capture mode, every 16th rising edge
		;1000 = Compare mode, set output on match (CCP1IF bit is set)
		;1001 = Compare mode, clear output on match (CCP1IF bit is set)
		;1010 = Compare mode, generate software interrupt on match (CCP1IF bit is set,
		;CCP1 pin is unaffected)
		;1011 = Compare mode, trigger special event (CCP1IF bit is set, CCP1 pin is unaffected);
		;CCP1 resets TMR1 and starts an A/D conversion (if A/D module is enabled)
		;11xx = PWM mode
		;
	eq CCP1CON, b'00001100'
;                     7  4   0   ;  16 duty cycle
	eq	CCPR1L, 0x04	 ;  4 * prescaler = 16 values from 250ns to 4us


;		REGISTER 7-1: T2CON  TIMER2 CONTROL REGISTER (ADDRESS: 12h)
;		U-0 R/W-0   R/W-0    R/W-0   R/W-0   R/W-0  R/W-0   R/W-0
;		   TOUTPS3 TOUTPS2 TOUTPS1 TOUTPS0 TMR2ON T2CKPS1 T2CKPS0
;		 7    6        5bit 0
;		bit 7 Unimplemented: Read as 0
;		bit 6-3 TOUTPS<3:0>: Timer2 Output Postscale Select bits
;		0000 = 1:1 postscale
;		0001 = 1:2 postscale
;		
;		
;		
;		1111 = 1:16 postscale
;		bit 2 TMR2ON: Timer2 On bit
;		1 = Timer2 is on
;		0 = Timer2 is off
;		bit 1-0 T2CKPS<1:0>: Timer2 Clock Prescale Select bits
;		00 = Prescaler is 1    <----- for spoton
;		01 = Prescaler is 4    <----- for campinglight
;		1x = Prescaler is 16
;	
	bcf	PIR1,TMR2IF	
	eq	T2CON, b'00000000'
	bsf	T2CON,TMR2ON
	btfss	PIR1,TMR2IF
	 goto	$-1
	BANKSEL	Bank1		; BANK1
	movlw	iodir
	andlw	b'00000100' ^ 0xFF	; enable output 

	movwf	TRISIO		;
	BANKSEL	Bank0		; BANK0

	goto	motime
	
loop	eq	BL,.1
	decfsz	AL,F		; 256*3 
	 goto	$-1
	decfsz	AH,F		; *256 + 3*256
	 goto	$-3		;  = 197376 us
	decfsz	BL,F
	 goto	$-5
;	movlw	b'00110000'
;	xorwf 	GPIO,F		
	BANKSEL	Bank1		; BANK1
	clrC
	incfsz	PR2,F
	goto $+2
	 goto	Main		; reset BANK there

;
;	BANKSEL	Bank0		; BANK0
;
;	ClrC			;CRLRC
;	mov	CCPR1L,AL	;load
;	rlf	AL,F
;	rlf	AL,F
;	btfsc	CCP1CON,DC1B0
;	 bsf	AL,0
;	btfsc	CCP1CON,DC1B1
;	 bsf	AL,1
;
;	rlf	AL,F		;*4
;	rlf	AL,F
;
;	rrf	AL,F		;unload
;	bcf	CCP1CON,DC1B0
;	skpNC
;	 bsf 	CCP1CON,DC1B0
;	rrf	AL,F
;	bcf	CCP1CON,DC1B1
;	skpNC
;	 bsf 	CCP1CON,DC1B1
;	mov	AL, CCPR1L
;	
	goto	loop


		bcf	Latency_Extend
motime		incf	UprampTime,W
		movwf	TimeCounter
		incf	UprampTime+1,W
		movwf	TimeCounter+1
		incf	UprampTime+2,W
		movwf	TimeCounter+2
					; 
		goto	startcycle	; 



	end
