;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   at GPIO 2 Transistor output driver                                *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: A.0                                               *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************

	list      p=12F683	; list directive to define processor
	#include <p12f683.inc>	; processor specific variable definitions

	#include C:\Programme\Microchip\macros.inc
	__CONFIG  _CP_OFF & _WDT_OFF & _BOD_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

;	ERRORLEVEL -302				; Get rid of banking messages...

;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define Lo_Intensity	.255
#define Hi_Intensity	.8

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	W_Temp,Status_Temp,SystemStatus,AL,AH,BL,Timer1_Counter:2
	Upramp_Time:4		; 
	endc
#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6
#define Goto_Sleep	SystemStatus,5

;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000		; processor reset vector
	nop			; required by in circuit debugger
	goto    Init		; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG     0x004
	movwf	W_Temp	
	swapf	STATUS,W
	movwf	Status_Temp
	btfss	PIR1,TMR1IF
	 goto	exitir
	;			REGISTER 3-5: PIR1: PERIPHERAL INTERRUPT REQUEST REGISTER 1
	;			R/W-0 R/W-0 R/W-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0
	;			EEIF  ADIF  CCP1IF   CMIF  OSFIF TMR2IF TMR1IF
	;			  7     6      5   4    3     2     1      0  
	
	;			bit 7 EEIF: EEPROM Write Operation Interrupt Flag bit
	;			1 = The write operation completed (must be cleared in software)
	;			0 = The write operation has not completed or has not been started

	;			bit 6 ADIF: A/D Interrupt Flag bit
	;			1 = A/D conversion complete
	;			0 = A/D conversion has not completed or has not been started

	;			bit 5 CCP1IF: CCP1 Interrupt Flag bit
	;			Capture mode:
	;			1 = A TMR1 register capture occurred (must be cleared in software)
	;			0 = No TMR1 register capture occurred
	;			Compare mode:
	;			1 = A TMR1 register compare match occurred (must be cleared in software)
	;			0 = No TMR1 register compare match occurred
	;			PWM mode:
	;			Unused in this mode

	;			bit 4 Unimplemented: Read as 0

	;			bit 3 CMIF: Comparator Interrupt Flag bit
	;			1 = Comparator 1 output has changed (must be cleared in software)
	;			0 = Comparator 1 output has not changed

	;			bit 2 OSFIF: Oscillator Fail Interrupt Flag bit
	;			1 = System oscillator failed, clock input has changed to INTOSC 
	;				(must be cleared in software)
	;			0 = System clock operating

	;			bit 1 TMR2IF: Timer2 to PR2 Match Interrupt Flag bit
	;			1 = Timer2 to PR2 match occurred (must be cleared in software)
	;			0 = Timer2 to PR2 match has not occurred

	;			bit 0 TMR1IF: Timer1 Overflow Interrupt Flag bit
	;			1 = Timer1 register overflowed (must be cleared in software)
	;			0 = Timer1 has not overflowed				
	bcf	PIR1, TMR1IF
;-----------------------------	timer1  expired
		btfss	GPIO,3
		 goto	noinput
		btfsc	Ramp_Running			;Input is high
		 goto	tstdwn
		call	motime					;extend latency
		goto	exitir
tstdwn	btfss	Down_Running
		 goto	noinput					; uprunning	
		bcf	Down_Running
		neeeq	Upramp_Time, 0x00000080	; 128*8us = 1.024ms
		call	motime
		goto	exitir
	
	
noinput
		incfsz	Timer1_Counter,F
		 goto	exitir
		incfsz	Timer1_Counter+1,F
		 goto	exitir
	;------------------------------------- timer expired
	
		btfss	Ramp_Running
		 goto	endlatency
		btfsc	Down_Running
		 goto	rundown
		BANKSEL	Bank1		
		skpneql	PR2, Hi_Intensity
		  goto	latency
		decf	PR2,F					;brighter
		BANKSEL	Bank0		
		decfsz	Upramp_Time,F			; extend ramp time
		 goto	exitir-1				; brighter=longer
		decf	Upramp_Time+1,F
		goto	exitir-1
	;------------------------------------- ramp down
rundown bsf	STATUS,5					;BANKSEL	Bank1	
		skpneql	PR2, Lo_Intensity
		  goto	gooff
		incf	PR2,F
		BANKSEL	Bank0
		goto	exitir-1
gooff	bcf	STATUS,5					;BANKSEL	Bank0
		clrf	CCPR1L					;dutycycle :=0
		bsf	Down_Running				; 
		bsf	Goto_Sleep
		goto	exitir

latency bcf	STATUS,5	;BANKSEL	Bank0
		neeeq	Upramp_Time, 0x0257FFFF	; TIMER1MAX = 512ms *256 *2= 300sec=
		bcf	Ramp_Running
		goto	exitir-1
endlatency
		neeeq	Upramp_Time, 0x0001FFFF ;1 sec * 240 
		bsf	Ramp_Running
		bsf	Down_Running
		call	motime
exitir	swapf	Status_Temp,W
	movwf	STATUS
	swapf	W_Temp,F
	swapf	W_Temp,W
	retfie			;  return with re-enabling 

;******************************************************************************
;Subroutines
;******************************************************************************
motime	movv	Upramp_Time, TMR1L
		movv	Upramp_Time+2,Timer1_Counter
		retlw 0
;******************************************************************************
;Initialization
;******************************************************************************
Init	movlw	b'00000000'	; all GPIO Low
	movwf	GPIO

	BANKSEL	Bank1		; BANK1

#define iodir	b'11001011'

	movlw	iodir     ; set direction bits 
	movwf	TRISIO		;
				; GP5	outp 
				; GP4	outp
				; GP3	inp
				; GP2	outp
				; GP1	inp
				; GP0	inp
 
	movlw	B'11011000'	; Timer0 internal clock, 1:32 prescale
	movwf	OPTION_REG	; set option register for Timer0 functions
				;OPTION_REG  OPTION REGISTER (ADDRESS: 81h)
				;Note: To achieve a 1:1 prescaler assignment for
				;TMR0, assign the prescaler to the WDT by
				;setting PSA bit to 1 (Option<3>). See
				;Section 5.4 Prescaler.
				;R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1
				;GPPU INTEDG T0CS  T0SE   PSA   PS2   PS1   PS0
				;  7     6     5     4      3    2     1     0
				;bit 7 GPPU: GPIO Pull-up Enable bit
				;1 = GPIO pull-ups are disabled
				;0 = GPIO pull-ups are enabled by individual port latch values in WPU register
				;
				;bit 6 INTEDG: Interrupt Edge Select bit
				;1 = Interrupt on rising edge of GP2/INT pin
				;0 = Interrupt on falling edge of GP2/INT pin
				;
				;bit 5 T0CS: TMR0 Clock Source Select bit
				;1 = Transition on GP2/T0CKI pin
				;0 = Internal instruction cycle clock (CLKOUT)
				;
				;bit 4 T0SE: TMR0 Source Edge Select bit
				;1 = Increment on high-to-low transition on GP2/T0CKI pin
				;0 = Increment on low-to-high transition on GP2/T0CKI pin
				;
				;bit 3 PSA: Prescaler Assignment bit
				;1 = Prescaler is assigned to the WDT
				;0 = Prescaler is assigned to the Timer0 module
				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
				;Note 1: A dedicated 16-bit WDT postscaler is available for the PIC12F683. See
				;Section 12.6 Watchdog Timer (WDT) for more information.
				;Legend:
				;R = Readable bit W = Writable bit U = Unimplemented bit, read as 0
				;- n = Value at POR 1 = Bit is set 0 = Bit is cleared x = Bit is unknown
				;Bit Value   TMR0 Rate 	   WDT Rate(1)
				;000		1:2		1:1	
				;001		1:4		1 : 2
				;010		1:8		1:4
				;011		1:16		1:8
				;100		1:32		1:16
				;101		1:64		1:32
				;110		1:128		1:64
				;111		1:256		1:128
				;
	;	

	movlw	b'00010000'
	movwf	ANSEL		; configure A/D  GP0 and GP1 analog
				;ANSEL  ANALOG SELECT REGISTER (ADDRESS: 9Fh)
				;U-0 R/W-0 R/W-0 R/W-0 R/W-1 R/W-1 R/W-1 R/W-1
				;   ADCS2 ADCS1 ADCS0  ANS3  ANS2  ANS1  ANS0
				; 7     6    5     4     3      2     1  bit 0
				;bit 7 Unimplemented: Read as 0
				;bit 6-4 ADCS<2:0>: A/D Conversion Clock Select bits
				;000 = FOSC/2
				;001 = FOSC/8
				;010 = FOSC/32
				;x11 = FRC (clock derived from a dedicated internal oscillator = 500 kHz max)
				;100 = FOSC/4
				;101 = FOSC/16
				;110 = FOSC/64
				;bit 3-0 ANS<3:0>: Analog Select bits
				;Analog select between analog or digital function on pins ANS<3:0>, respectively.
				;1 = Analog input. Pin is assigned as analog input(1).
				;0 = Digital I/O. Pin is assigned to port or special function.
				;Note 1: Setting a pin to an analog input automatically disables the digital input circuitry,
				;weak pull-ups and interrupt-on-change if available. The corresponding TRISIO bit
				;must be set to input mode in order to allow external control of the voltage on the pin.
 
	movlw	b'01100001'
	movwf	OSCCON		; 4MHz
				;OSCCON  OSCILLATOR CONTROL REGISTER (ADDRESS: 8Fh)
				;Note: Due to the wide range of oscillator start-up
				;times, the Fail-Safe circuit is not active
				;during oscillator start-up (i.e., after exiting
				;Reset or Sleep). After an appropriate
				;amount of time, the user should check the
				;OSTS bit (OSCCON<3>) to verify the
				;oscillator start-up and system clock
				;switchover has successfully completed.
				;U-0 R/W-1 R/W-1 R/W-0  R-1    R-0 R-0 R/W-0
				;   IRCF2 IRCF1 IRCF0 OSTS(1) HTS LTS SCS
				; 7    6     5     4     3      2   1   0
				;bit 7 Unimplemented: Read as 0
				;
				;bit 6-4 IRCF<2:0>: Internal Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
				;
				;bit 3 OSTS: Oscillator Start-up Time-out Status bit
				;1 = Device is running from the external system clock defined by FOSC<2:0>
				;0 = Device is running from the internal system clock (HFINTOSC or LFINTOSC)
				;
				;bit 2 HTS: HFINTOSC (High Frequency  8 MHz to 125 kHz) Status bit
				;1 = HFINTOSC is stable
				;0 = HFINTOSC is not stable
				;
				;bit 1 LTS: LFINTOSC (Low Frequency  31 kHz) Stable bit
				;1 = LFINTOSC is stable
				;0 = LFINTOSC is not stable
				;
				;bit 0 SCS: System Clock Select bit
				;1 = Internal oscillator is used for system clock
				;0 = Clock source defined by FOSC<2:0>
				;Note 1: Bit resets to 0 with Two-Speed Start-up and LP, XT or HS selected as the oscillator
				;mode or Fail-Safe mode is enabled.
	movlw	b'00000000'
	movwf	PIE1		;

	;			REGISTER 3-4: PIE1: PERIPHERAL INTERRUPT ENABLE REGISTER 1
	;			R/W-0 R/W-0 R/W-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0
	;			EEIE  ADIE  CCP1IE   CMIE  OSFIE TMR2IE TMR1IE
	;			  7     6      5    4   3      2    1      0it 0

	;			bit 7 EEIE: EE Write Complete Interrupt Enable bit
	;			1 = Enables the EE write complete interrupt
	;			0 = Disables the EE write complete interrupt

	;			bit 6 ADIE: A/D Converter (ADC) Interrupt Enable bit
	;			1 = Enables the ADC interrupt
	;			0 = Disables the ADC interrupt

	;			bit 5 CCP1IE: CCP1 Interrupt Enable bit
	;			1 = Enables the CCP1 interrupt
	;			0 = Disables the CCP1 interrupt

	;			bit 4 Unimplemented: Read as 0

	;			bit 3 CMIE: Comparator Interrupt Enable bit
	;			1 = Enables the Comparator 1 interrupt
	;			0 = Disables the Comparator 1 interrupt

	;			bit 2 OSFIE: Oscillator Fail Interrupt Enable bit
	;			1 = Enables the oscillator fail interrupt
	;			0 = Disables the oscillator fail interrupt

	;			bit 1 TMR2IE: Timer2 to PR2 Match Interrupt Enable bit
	;			1 = Enables the Timer2 to PR2 match interrupt
	;			0 = Disables the Timer2 to PR2 match interrupt

	;			bit 0 TMR1IE: Timer1 Overflow Interrupt Enable bit
	;			1 = Enables the Timer1 overflow interrupt
	;			0 = Disables the Timer1 overflow interrupt


	banksel	Bank0		; switch back to PORT memory bank


	movlw	b'00000111'     
	movwf	CMCON0		; comparator enable input GP1 - Internal reference
				;CMCON0  COMPARATOR CONTROL REGISTER 0 (ADDRESS: 19h)
				;U-0 R-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;   COUT    CINV  CIS   CM2   CM1   CM0
				; 7    6  5     4    3     2     1     0
				;
				;bit 6 COUT: Comparator Output bit
				;When CINV = 0:
				;1 = VIN+ > VIN-
				;0 = VIN+ < VIN-
				;When CINV = 1:
				;1 = VIN+ < VIN-
				;0 = VIN+ > VINbit
				;
				;bit 4 CINV: Comparator Output Inversion bit
				;1 = Output inverted
				;0 = Output not inverted
				;
				;bit 3 CIS: Comparator Input Switch bit
				;When CM<2:0> = 110 or 101:
				;1 = VIN- connects to CIN+   GP0
				;0 = VIN- connects to CINbit GP1
				;
				;2 CM<2:0>: Comparator Mode bits
				;
				;FIGURE 8-3: COMPARATOR I/O OPERATING MODES
				;Note: Comparator interrupts should be disabled
				;during a Comparator mode change.
				;Otherwise, a false interrupt may occur.
				;Comparator Reset (POR Default Value  Low Power)         	
				;CM<2:0> = 000
				;                                                 
				;Comparator Off (Lowest Power)
				;	CM<2:0> = 111

				;Comparator without Output                                	Comparator w/o Output and with Internal Reference
				;CM<2:0> = 010 							CM<2:0> = 100
				;
				;Comparator with Output and Internal Reference 			Multiplexed Input with Internal Reference and Output
				;CM<2:0> = 011 							CM<2:0> = 101
				;
				;Comparator with Output 					
				;CM<2:0> = 001 	
				
				; Multiplexed Input with Internal Reference
				;		CM<2:0> = 110
				;
				
	movlw	b'00000000'
	movwf	INTCON		;
	;			REGISTER 3-3: INTCON: INTERRUPT CONTROL REGISTER
	;			R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
	;			GIE   PEIE  T0IE  INTE  GPIE  T0IF  INTF  GPIF
	;			 7     6     5     4     3     2     1     0
	;			
	;			bit 7 GIE: Global Interrupt Enable bit
	;			1 = Enables all unmasked interrupts
	;			0 = Disables all interrupts

	;			bit 6 PEIE: Peripheral Interrupt Enable bit
	;			1 = Enables all unmasked peripheral interrupts
	;			0 = Disables all peripheral interrupts
	;
	;			bit 5 T0IE: Timer0 Overflow Interrupt Enable bit
	;			1 = Enables the Timer0 interrupt
	;			0 = Disables the Timer0 interrupt

	;			bit 4 INTE: GP2/INT External Interrupt Enable bit
	;			1 = Enables the GP2/INT external interrupt
	;			0 = Disables the GP2/INT external interrupt

	;			bit 3 GPIE: GPIO Change Interrupt Enable bit(1)
	;			1 = Enables the GPIO change interrupt
	;			0 = Disables the GPIO change interrupt

	;			bit 2 T0IF: Timer0 Overflow Interrupt Flag bit(2)
	;			1 = Timer0 register has overflowed (must be cleared in software)
	;			0 = Timer0 register did not overflow

	;			bit 1 INTF: GP2/INT External Interrupt Flag bit
	;			1 = The GP2/INT external interrupt occurred (must be cleared in software)
	;			0 = The GP2/INT external interrupt did not occur

	;			bit 0 GPIF: GPIO Change Interrupt Flag bit
	;			1 = When at least one of the GPIO <5:0> pins changed state (must be cleared in software)
	;			0 = None of the GPIO <5:0> pins have changed state

	;			Note 1: IOC register must also be enabled.
	;			2: T0IF bit is set when TMR0 rolls over. TMR0 is unchanged on Reset and should be initialized before
	;			clearing T0IF bit.
	;			
	goto prpslp

	
;******************************************************************************
;Subroutines 
;******************************************************************************

;change dutycycle
;	BANKSEL	Bank0		; BANK0
;
;	ClrC			;CRLRC
;	mov	CCPR1L,AL	;load 6 bits
;	rlf	AL,F
;	rlf	AL,F
;	btfsc	CCP1CON,DC1B0
;	 bsf	AL,0
;	btfsc	CCP1CON,DC1B1
;	 bsf	AL,1
;
;	rlf	AL,F		;do changes
;	rlf	AL,F
;
;	rrf	AL,F		;unload
;	bcf	CCP1CON,DC1B0
;	skpNC
;	 bsf 	CCP1CON,DC1B0
;	rrf	AL,F
;	bcf	CCP1CON,DC1B1
;	skpNC
;	 bsf 	CCP1CON,DC1B1
;	mov	AL, CCPR1L
;	return	
;******************************************************************************
;Main 
;******************************************************************************

Main	clrf	SystemStatus

	BANKSEL	Bank1		; BANK1
	;movlw	iodir
	;iorlw	b'00000100'	; clr output 

	;movwf	TRISIO		;
	;bcf	PIE1,TMR2IE	; clr interrupt , if necessary
	
	movlw	Lo_Intensity	; .255
	movwf	PR2			  ; 256*4 us = 0.976kHz 
					  ; 256      = 3.906kHz	
					  ; 9        = 111,1kHz

	BANKSEL	Bank0

	movlw	b'00110000'
	movwf	T1CON
		;			REGISTER 6-1: T1CON: TIMER1 CONTROL REGISTER
		;			R/W-0       R/W-0    R/W-0   R/W-0   R/W-0   R/W-0  R/W-0 R/W-0
		;			T1GINV(1) TMR1GE(2) T1CKPS1 T1CKPS0 T1OSCEN T1SYNC TMR1CS TMR1ON
		;			   7         6         5       4       3       2      1      0
	
		;			bit 7 T1GINV: Timer1 Gate Invert bit(1)
		;			1 = Timer1 gate is active-high (Timer1 counts when gate is high)
		;			0 = Timer1 gate is active-low (Timer1 counts when gate is low)
	
		;			bit 6 TMR1GE: Timer1 Gate Enable bit(2)
		;			If TMR1ON = 0:
		;			This bit is ignored
		;			If TMR1ON = 1:
		;			1 = Timer1 is on if Timer1 gate is not active
		;			0 = Timer1 is on
	
		;			bit 5-4 T1CKPS<1:0>: Timer1 Input Clock Prescale Select bits
		;			11 = 1:8 Prescale Value
		;			10 = 1:4 Prescale Value
		;			01 = 1:2 Prescale Value
		;			00 = 1:1 Prescale Value
	
		;			bit 3 T1OSCEN: LP Oscillator Enable Control bit
		;			If INTOSC without CLKOUT oscillator is active:
		;			1 = LP oscillator is enabled for Timer1 clock
		;			0 = LP oscillator is off
		;			Else:
		;			This bit is ignored. LP oscillator is disabled.
	
		;			bit 2 T1SYNC: Timer1 External Clock Input Synchronization Control bit
		;			TMR1CS = 1:
		;			1 = Do not synchronize external clock input
		;			0 = Synchronize external clock input
		;			TMR1CS = 0:
		;			This bit is ignored. Timer1 uses the internal clock
	
		;			bit 1 TMR1CS: Timer1 Clock Source Select bit
		;			1 = External clock from T1CKI pin (on the rising edge)
		;			0 = Internal clock (FOSC/4)
	
		;			bit 0 TMR1ON: Timer1 On bit
		;			1 = Enables Timer1
		;			0 = Stops Timer1
		;			(1): T1GINV bit inverts the Timer1 gate logic, regardless of source.
		;			(2): TMR1GE bit must be set to use either T1G pin or COUT, as selected by the T1GSS bit of the CMCON1
		;			register, as a Timer1 gate source.
		;			


	eq CCP1CON, b'00011100'
;                     7  4   0   ;  17 duty cycle
	eq	CCPR1L, 0x04	 ;  4 * prescaler = 16 values from 250ns to 4us

		;CCP1CON  CCP CONTROL REGISTER 1 (ADDRESS: 15h)
	
		; U-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0   R/W-0  R/W-0
		;       DC1B1 DC1B0 CCP1M3 CCP1M2 CCP1M1 CCP1M0
		;  7    6   5     4     3      2      1      0     
		;bit7
		;Unimplemented: Read as 0
		;bit6
		;Unimplemented: Read as 0
		
		;bit5 , bit4
		;DC1B<1:0>: PWM Least Significant bits
		;Capture mode:
		;Unused.
		;Compare mode:
		;Unused.
		;PWM mode:
		;These bits are the two LSbs of the PWM duty cycle. The eight MSbs are found in CCPR1L.
		
		;bit 3
		;CCP1M<3:0>: CCP1 Mode Select bits
		;0000 = Capture/Compare/PWM disabled (resets CCP1 module)
		;0100 = Capture mode, every falling edge
		;0101 = Capture mode, every rising edge
		;0110 = Capture mode, every 4th rising edge
		;0111 = Capture mode, every 16th rising edge
		;1000 = Compare mode, set output on match (CCP1IF bit is set)
		;1001 = Compare mode, clear output on match (CCP1IF bit is set)
		;1010 = Compare mode, generate software interrupt on match (CCP1IF bit is set,
		;CCP1 pin is unaffected)
		;1011 = Compare mode, trigger special event (CCP1IF bit is set, CCP1 pin is unaffected);
		;CCP1 resets TMR1 and starts an A/D conversion (if A/D module is enabled)
		;11xx = PWM mode
		;

	bcf	PIR1,TMR2IF	
	eq	T2CON, b'00000001'	
	bsf	T2CON,TMR2ON

	;		REGISTER 7-1: T2CON  TIMER2 CONTROL REGISTER (ADDRESS: 12h)
	;		U-0 R/W-0   R/W-0    R/W-0   R/W-0   R/W-0  R/W-0   R/W-0
	;		   TOUTPS3 TOUTPS2 TOUTPS1 TOUTPS0 TMR2ON T2CKPS1 T2CKPS0
	;		 7    6        5       4       3       2      1    bit 0
	;		bit 7 Unimplemented: Read as 0
	;		bit 6-3 TOUTPS<3:0>: Timer2 Output Postscale Select bits
	;		0000 = 1:1 postscale
	;		0001 = 1:2 postscale
	;		
	;		
	;		
	;		1111 = 1:16 postscale
	;		bit 2 TMR2ON: Timer2 On bit
	;		1 = Timer2 is on
	;		0 = Timer2 is off
	;		bit 1-0 T2CKPS<1:0>: Timer2 Clock Prescale Select bits
	;		00 = Prescaler is 1    <----- for spoton
	;		01 = Prescaler is 4    <----- for campinglight
	;		1x = Prescaler is 16
	;	

;	btfss	PIR1,TMR2IF
;	 goto	$-1
;	BANKSEL	Bank1		; BANK1
;	movlw	iodir
;	andlw	b'00000100' ^ 0xFF	; enable output 
;	movwf	TRISIO		;
;	BANKSEL	Bank0		; BANK0

	neeeq	Upramp_Time, 0x00000080	; 128*8us = 1.024ms
	bsf	Ramp_Running
	call	motime

	BANKSEL	Bank1
	bsf	PIE1,TMR1IE		; enable TIMER1INTERRUPT
	BANKSEL	Bank0
	bsf	INTCON,PEIE		; enable periph interrupt
	bsf	INTCON,GIE		; enable General Interrupt
	bsf	T1CON,TMR1ON



loop	clrwdt
tstslp	btfss	Goto_Sleep
	 goto	loop

prpslp	bcf	T2CON,TMR2ON
	bcf	T1CON,TMR1ON
	eq CCP1CON, b'00010000'	;disable PWM
	bcf	GPIO,2
	movlw	b'00010011'	; 512ms seconds
	movwf	WDTCON

				;WDTCON  WATCHDOG TIMER CONTROL REGISTER (ADDRESS: 18h)
				;TABLE 12-8: SUMMARY OF WATCHDOG TIMER REGISTERS
				;U-0 U-0 U-0 R/W-0  R/W-1  R/W-0  R/W-0  R/W-0
				;         WDTPS3 WDTPS2 WDTPS1 WDTPS0 SWDTEN
				; 7   6   5     4     3       2     1      0
				;bit 7-5 Unimplemented: Read as 0
				;bit 4-1 WDTPS<3:0>: Watchdog Timer Period Select bits
				;Bit Value = Prescale Rate
				;0000 = 1:32
				;0001 = 1:64
				;0010 = 1:128
				;0011 = 1:256
				;0100 = 1:512 (Reset value)  = 16ms
				;0101 = 1:1024               = 32
				;0110 = 1:2048                 64
				;0111 = 1:4096                 128
				;1000 = 1:8192		       256
				;1001 = 1:16384			512
				;1010 = 1:32768			1024
				;1011 = 1:65536			2048
				;1100 = Reserved
				;1101 = Reserved
				;1110 = Reserved
				;1111 = Reserved

				;bit 0 SWDTEN: Software Enable or Disable the Watchdog Timer(1)
				;1 = WDT is turned on
				;0 = WDT is turned off (Reset value)

				;Note 1: If WDTE configuration bit = 1, then WDT is always enabled, irrespective of this
				;control bit. If WDTE configuration bit = 0, then it is possible to turn WDT on/off with
				;this control bit.
	

	sleep

aftrslp	btfss	GPIO,3
	 goto	$-2		; go back to sleep
	bcf	WDTCON,SWDTEN	; switch off WDT
	goto 	Main



;
;	BANKSEL	Bank0		; BANK0
;
;	ClrC			;CRLRC
;	mov	CCPR1L,AL	;load
;	rlf	AL,F
;	rlf	AL,F
;	btfsc	CCP1CON,DC1B0
;	 bsf	AL,0
;	btfsc	CCP1CON,DC1B1
;	 bsf	AL,1
;
;	rlf	AL,F		;*4
;	rlf	AL,F
;
;	rrf	AL,F		;unload
;	bcf	CCP1CON,DC1B0
;	skpNC
;	 bsf 	CCP1CON,DC1B0
;	rrf	AL,F
;	bcf	CCP1CON,DC1B1
;	skpNC
;	 bsf 	CCP1CON,DC1B1
;	mov	AL, CCPR1L
;	
	goto	loop


	end
