;********************************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   on GPIO 2 Transistor output driver   
;*   and a Triac ingnition pulse on GPIO 4                             *
;********************************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: 1.3                                               *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;********************************************************************************

	list      p=12F683	; list directive to define processor
	#include <p12f683.inc>	; processor specific variable definitions

	#include macros.inc
 __CONFIG  _CP_OFF &_WDT_OFF &_BOD_ON &_PWRTE_ON &_INTRC_OSC_NOCLKOUT &_MCLRE_OFF &_CPD_OFF

;	ERRORLEVEL -302				; Get rid of banking messages...

;***************************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define Lointensity	.255
#define Hiintensity	.8

;***************************************************************************************
;General Purpose Registers (GPR's) 
;***************************************************************************************

	cblock	0x20
	WTemp,StatusTemp,SystemStatus
	AL,AH,BL,BH,CL,CH,DL,DH,InInt
	Timer0Counter:3, UprampTime:4		; 

	endc


#define	ZeroCrosses	AH
#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6
#define Goto_Sleep	SystemStatus,5
#define	AC_is_High	SystemStatus,4
#define	Lamp_On		SystemStatus,3	; TRIAC firing enabled
#define	Read_Out	SystemStatus,2
#define	Blin_Ker	SystemStatus,2
#define	Ac_Onbuffer	SystemStatus,1
#define	AC_ON		SystemStatus,0	; AC Voltage detected


;***************************************************************************************
;Reset Vector 
;***************************************************************************************
	ORG     0x000			; processor reset vector
	nop				; required by in circuit debugger
	goto    Init			; go to beginning of program

;***************************************************************************************
;Interrupt Vector     
;***************************************************************************************
#define triacGate	4
#define Acport		0
#define PIRport		3
#define Triac_Gate	GPIO,triacGate
#define Ac_Port		GPIO,Acport
#define PIR_Port	GPIO,PIRport
#define iodir	b'11001011'

	ORG     0x004
	movwf	WTemp	
	swapf	STATUS,W
	movwf	StatusTemp
	btfss	INTCON,GPIF
	 goto	int2
	bcf	INTCON,GPIF		;will not necessarily clear (2interrupts)
	
	movbit	Ac_Port, Read_Out
	skpxorb Read_Out , AC_is_High	
	  goto err2
  	movbit	Read_Out, AC_is_High
	bsf	AC_ON			; reset in Main Program
	btfss	Lamp_On			
	 goto	int2

	btfss	AC_is_High		;work off Triac firing
	 goto	intchlo
 	eq	InInt,.12
	decfsz	InInt,F
	 goto	$-1

intchlo bcf	Triac_Gate		
	eq	InInt,.10
	decfsz	InInt,F
	 goto	$-1
	bsf	Triac_Gate		


	

int2	btfss	INTCON,T0IF
	 goto	exitir
	bcf	INTCON,T0IF
;-----------------------------------------------	timer0  expired
	
	
		incfsz	Timer0Counter,F
		 goto	exitir
		incfsz	Timer0Counter+1,F
		 goto	exitir
		incfsz	Timer0Counter+2,F
		 goto	exitir
	;------------------------------------- 		timer0counter expired
		btfsc	Lamp_On
		 goto	gooff
;	
		btfss	Ramp_Running
		 goto	endlatency
		btfsc	Down_Running
		 goto	rundown
		BANKSEL	Bank1		
		skpneql	PR2, Hiintensity
		  goto	latency
		decf	PR2,F				;brighter
		BANKSEL	Bank0		
		decfsz	UprampTime,F			; extend ramp time
		 goto	exitir-1			; brighter=longer
		decf	UprampTime+1,F
		goto	exitir-1
	;------------------------------------- ramp down
rundown 	bsf	STATUS,5	;BANKSEL	Bank1	
		skpneql	PR2, Lointensity
		  goto	gooff
		incf	PR2,F
		BANKSEL	Bank0
		goto	exitir-1

gooff		bcf	STATUS,5	;BANKSEL	Bank0
;		clrf	CCPR1L				;dutycycle :=0
		bsf	Down_Running			; 
		bsf	Goto_Sleep
		goto	exitir

latency 	bcf	STATUS,5	;BANKSEL	Bank0
		neeeq	UprampTime, 0x0157FFFF		; TIMER0MAX = 512ms *256 *2= 300sec=
		bcf	Ramp_Running
		goto	exitir-1

endlatency	neeeq	UprampTime, 0x0001FFFF 	;1 sec (* 240 = 4min total) 
		bsf	Ramp_Running
		bsf	Down_Running
		call	motime

exitir	swapf	StatusTemp,W
	movwf	STATUS
	swapf	WTemp,F
	swapf	WTemp,W
	retfie						;  return with re-enabling 

err2	nop			; catches erroneous interrrupts
;	nop
;	decfsz	InInt,F
;	 goto	$-3
;	nop        
	goto	exitir


;******************************************************************************
;Subroutines
;******************************************************************************
motime		mov	UprampTime, TMR0
		movvv	UprampTime+1,Timer0Counter
		retlw 0

subtrisio	bsf	STATUS,5	;BANKSEL	Bank1		; 
		movwf	TRISIO		;
		BANKSEL	Bank0
		return
;******************************************************************************
;Subroutines 
;******************************************************************************


testpwr		bcf	AC_ON
		bsf	INTCON,GPIE
		
		bsf	INTCON,GIE
		eq	Timer0Counter, .10
tstpwr1		btfsc	AC_ON
		 goto	tstpwr2		;call	testAC		interrupt will do it
		btfss	INTCON,T0IF	;256*8 = 2msec
		 goto	tstpwr1
		bcf	INTCON,T0IF
		decfsz	Timer0Counter,F
		 goto	tstpwr1
tstpwr2		bcf	INTCON,GPIE
		bcf	INTCON,GIE
		retlw	0		; AC_ON is set	

#define 	P100_Port	5

testcds		movlw	((1<< P100_Port) ^ 0xFF) & iodir
		call	subtrisio
		bsf	GPIO,P100_Port	; 	
		movlw	.4
		movwf	AL		; 15 us
		decfsz	AL,F
		 goto	$-1		; 
		clrwdt
		movlw	iodir | (1<< P100_Port)		;  GP,x is input
		call	subtrisio
		;bcf	GPIO,P100_Port
		;TMRO prescale 4
		;bcf	INTCON,T0IF
		;clrf	TMR0
		clrf	AH
		clrf	AL		; 1 us
loop100		btfss	GPIO,P100_Port
		 goto	exitloop100
		incfsz	AL,F
		 goto	loop100		;timeout 1000us	
		;btfss	INTCON,T0IF
		; goto	loop100
		; bcf	INTCON,T0IF
		clrwdt
;		incfsz	AH,F
;		 goto	loop100
;		decf	AH,F
		decf	AL,F
		; eq	AL,.255	
exitloop100	mov	AL,AH	;	mov TMR0 AL
		retlw	0


dark200ms	eq CCP1CON, b'00010000'	;disable PWM
		bcf	GPIO,2
		movlw  b'000010001'	; 264 ms
		movwf	WDTCON
		clrwdt
		sleep
		bcf	WDTCON,SWDTEN
		retlw	0


displaybits	;bsf	STATUS,5;		BANKSEL	Bank1		; BANK1
;	
;	movlw	Hiintensity>>1	; .255
;	movwf	PR2			  ; 256*4 us = 0.976kHz 
;					  ; 256      = 3.906kHz	
;					  ; 9        = 111,1kHz
;
;	BANKSEL	Bank0
	

	eq CCP1CON, b'00011100'	 ; enable PWM

;                     7  4   0   ;  17 duty cycle
;	eq	CCPR1L, 0x04	 ;  4 * prescaler = 16 values from 250ns to 4us
	bsf	T2CON,TMR2ON	 ; enable TMR2
		eq	BL, 8
		call	dark200ms
		decfsz	BL,F
		 goto	$-2
		eq	BL, 8
nextbit		eq CCP1CON, b'00011100'	 ;enable PWM
		rlf	AH,F
		movlw	0x1
		skpnC	
		 movlw	0x05
		movwf	DL
		call	wakedelay	;0.25/1.3sec
		call	dark200ms
		
		decfsz	BL,F
		 goto nextbit
		eq	BL, 8
		call	dark200ms
		decfsz	BL,F
		 goto	$-2
		retlw	0
		
wakedelay	clrwdt
		decfsz	CL,F
		 goto	$-2
		decfsz	CH,F
		 goto	$-4
		decfsz	DL,F
		 goto	$-6
		retlw	0



testvoltage
#define	C10nport	1
		bcf	GPIO,C10nport
		
		eq	CMCON0,b'00000111';comparator off
		banksel	Bank1
		movlw	b'10100100'	; 0.5 V + 0.6?
		movwf	VRCON
		banksel	Bank0	
		movlw	((1<< C10nport) ^ 0xFF) & iodir
		call subtrisio		; discharge C
		eq	AL,.4		; 15 us delay
		decfsz	AL,F
		 goto	$-1		; 
		movlw	iodir		;  GP is input
		call subtrisio		; charge C
		eq	CMCON0,b'00000100'	; comparator on
		clrf	AL
tvloop		btfss	CMCON0,COUT
		 goto	exittvloop
		incfsz	AL,F
		 goto	tvloop		;timeout 1000us	
		decf	AL,F	
		
exittvloop	eq	CMCON0,b'00000111';comparator off
		banksel	Bank1
		movlw	b'00100100'	; 0.5 V + 0.6?
		movwf	VRCON
		banksel	Bank0	
			
;		eq	DutyCase,.9
;		skpgel	AL,0x58		; .88		4.25V
;   		 goto endvoltage
;		decf	DutyCase,F
;		decf	DutyCase,F
;		skpgel	AL,0x58+0x16	;.88+.20 =108	3.7V
;		 goto endvoltage
;		decf 	DutyCase,F
;		decf	DutyCase,F
;		skpgel	AL,0x58+0x26	;.88.+.36= 124  3.35V
;		 goto	endvoltage		
;		decf	DutyCase,F
;		decf	DutyCase,F
;		skpgel	AL,0x58+0x30	;.88+.48 = 136  3.1V
; 		 goto	endvoltage
;		decf	DutyCase,F
;		decf	DutyCase,F	
;		skplel	AL,0x58+0x38	;.88+.56 = .144 3.0V
;		decf	DutyCase,F	; warning blinker
endvoltage	mov	AL,AH
;


;change dutycycle
;	BANKSEL	Bank0		; BANK0
;
;	ClrC			;CRLRC
;	mov	CCPR1L,AL	;load 6 bits
;	rlf	AL,F
;	rlf	AL,F
;	btfsc	CCP1CON,DC1B0
;	 bsf	AL,0
;	btfsc	CCP1CON,DC1B1
;	 bsf	AL,1
;

	movlw	.62
	subwf	AH,W
	movwf	AL

	bcf	Blin_Ker
	skpgel	AL,.30
	 goto	noblink
	bsf	Blin_Ker
	goto	mini	

noblink skpgel	AL,.17
	goto	tstz
	movwf 	BL		; subtract 1/2 diff
	clrc	
	rrf	BL,F
	movfw	BL
	subwf	AL,F

tstz	movf	AL,F
	skpZ
	 goto loaddut 
mini	eq	AL,.3
	
	
loaddut	CLRC
	rrf	AL,F		;unload
	bcf	CCP1CON,DC1B0
	skpNC
	 bsf 	CCP1CON,DC1B0
	CLRC
	rrf	AL,F
	bcf	CCP1CON,DC1B1
	skpNC
	 bsf 	CCP1CON,DC1B1
	mov	AL, CCPR1L
	return	
;******************************************************************************

;******************************************************************************
;Initialization
;******************************************************************************


Init	movlw	b'00000000' | (1<<triacGate)	; all GPIO Low exept triac
	movwf	GPIO

	BANKSEL	Bank1		; BANK1


	movlw	iodir     ; set direction bits 
	movwf	TRISIO		;
				; GP5	outp 
				; GP4	outp
				; GP3	inp
				; GP2	outp
				; GP1	inp
				; GP0	inp
 
	movlw	B'11010010'	; Timer0 internal clock, 1:8 prescale
	movwf	OPTION_REG	; set option register for Timer0 functions
				;OPTION_REG  OPTION REGISTER (ADDRESS: 81h)
				;Note: To achieve a 1:1 prescaler assignment for
				;TMR0, assign the prescaler to the WDT by
				;setting PSA bit to 1 (Option<3>). See
				;Section 5.4 Prescaler.
				;R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1 R/W-1
				;GPPU INTEDG T0CS  T0SE   PSA   PS2   PS1   PS0
				;  7     6     5     4      3    2     1     0
				;bit 7 GPPU: GPIO Pull-up Enable bit
				;1 = GPIO pull-ups are disabled
				;0 = GPIO pull-ups are enabled by individual port latch 
				;   values   in WPU register
				;
				;bit 6 INTEDG: Interrupt Edge Select bit
				;1 = Interrupt on rising edge of GP2/INT pin
				;0 = Interrupt on falling edge of GP2/INT pin
				;
				;bit 5 T0CS: TMR0 Clock Source Select bit
				;1 = Transition on GP2/T0CKI pin
				;0 = Internal instruction cycle clock (CLKOUT)
				;
				;bit 4 T0SE: TMR0 Source Edge Select bit
				;1 = Increment on high-to-low transition on GP2/T0CKI pin
				;0 = Increment on low-to-high transition on GP2/T0CKI pin
				;
				;bit 3 PSA: Prescaler Assignment bit
				;1 = Prescaler is assigned to the WDT
				;0 = Prescaler is assigned to the Timer0 module
				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
				;Note 1: A dedicated 16-bit WDT postscaler is available 
				;for the PIC12F683. See
				;Section 12.6 Watchdog Timer (WDT) for more information.
				;
			
				;Bit Value   TMR0 Rate 	   WDT Rate(1)
				;000		1:2		1:1	
				;001		1:4		1 : 2
				;010		1:8		1:4
				;011		1:16		1:8
				;100		1:32		1:16
				;101		1:64		1:32
				;110		1:128		1:64
				;111		1:256		1:128
				;  1,000,000 /64 /125 /125 = 1sec
	;	

	movlw	b'00000000'
	movwf	ANSEL		; configure A/D 
				;ANSEL  ANALOG SELECT REGISTER (ADDRESS: 9Fh)
				;U-0 R/W-0 R/W-0 R/W-0 R/W-1 R/W-1 R/W-1 R/W-1
				;   ADCS2 ADCS1 ADCS0  ANS3  ANS2  ANS1  ANS0
				; 7     6    5     4     3      2     1  bit 0
				;bit 7 Unimplemented: Read as 0
				;bit 6-4 ADCS<2:0>: A/D Conversion Clock Select bits
				;000 = FOSC/2
				;001 = FOSC/8
				;010 = FOSC/32
				;x11 = FRC (clock derived from a dedicated internal 
				;		oscillator = 500 kHz max)
				;100 = FOSC/4
				;101 = FOSC/16
				;110 = FOSC/64
				;bit 3-0 ANS<3:0>: Analog Select bits
				;Analog select between analog or digital function on pins 
				;ANS<3:0>, respectively.
				;1 = Analog input. Pin is assigned as analog input(1).
				;0 = Digital I/O. Pin is assgn to port or special function.
				;Note1:Setting a pin to an analog input automatically 
				;	disables the digital input circuitry,
				;	weak pull-ups and interrupt-on-change if available. 
				;The corresponding TRISIO bit
				;must be set to input mode in order to allow external 
				;control of the voltage on the pin.
 
	movlw	b'01100001'
	movwf	OSCCON		; 4MHz
				;OSCCON  OSCILLATOR CONTROL REGISTER (ADDRESS: 8Fh)
				;Note: Due to the wide range of oscillator start-up
				;times, the Fail-Safe circuit is not active
				;during oscillator start-up (i.e., after exiting
				;Reset or Sleep). After an appropriate
				;amount of time, the user should check the
				;OSTS bit (OSCCON<3>) to verify the
				;oscillator start-up and system clock
				;switchover has successfully completed.
				;U-0 R/W-1 R/W-1 R/W-0  R-1    R-0 R-0 R/W-0
				;   IRCF2 IRCF1 IRCF0 OSTS(1) HTS LTS SCS
				; 7    6     5     4     3      2   1   0
				;bit 7 Unimplemented: Read as 0
				;
				;bit 6-4 IRCF<2:0>: Internl Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
				;
				;bit 3 OSTS: Oscillator Start-up Time-out Status bit
				;1 = Device is running from the external system clock 
				;    defined by FOSC<2:0>
				;0 = Device is running from the internal system clock 
				;    (HFINTOSC or LFINTOSC)
				;
				;bit 2 HTS: HFINTOSC (High Frequency  8 MHz to 125 kHz) 
				;1 = HFINTOSC is stable
				;0 = HFINTOSC is not stable
				;
				;bit 1 LTS: LFINTOSC (Low Frequency  31 kHz) Stable bit
				;1 = LFINTOSC is stable
				;0 = LFINTOSC is not stable
				;
				;bit 0 SCS: System Clock Select bit
				;1 = Internal oscillator is used for system clock
				;0 = Clock source defined by FOSC<2:0>
				;Note 1: Bit resets to 0 with Two-Speed Start-up and LP, 
				;XT or HS selected as the oscillator
				;mode or Fail-Safe mode is enabled.
	movlw	b'00000000'
	movwf	PIE1		;

	;			REGISTER 3-4: PIE1: PERIPHERAL INTERRUPT ENABLE REGISTER 1
	;			R/W-0 R/W-0 R/W-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0
	;			EEIE  ADIE  CCP1IE   CMIE  OSFIE TMR2IE TMR1IE
	;			  7     6      5    4   3      2    1      0it 0

	;			bit 7 EEIE: EE Write Complete Interrupt Enable bit
	;			1 = Enables the EE write complete interrupt
	;			0 = Disables the EE write complete interrupt

	;			bit 6 ADIE: A/D Converter (ADC) Interrupt Enable bit
	;			1 = Enables the ADC interrupt
	;			0 = Disables the ADC interrupt

	;			bit 5 CCP1IE: CCP1 Interrupt Enable bit
	;			1 = Enables the CCP1 interrupt
	;			0 = Disables the CCP1 interrupt

	;			bit 4 Unimplemented: Read as 0

	;			bit 3 CMIE: Comparator Interrupt Enable bit
	;			1 = Enables the Comparator 1 interrupt
	;			0 = Disables the Comparator 1 interrupt

	;			bit 2 OSFIE: Oscillator Fail Interrupt Enable bit
	;			1 = Enables the oscillator fail interrupt
	;			0 = Disables the oscillator fail interrupt

	;			bit 1 TMR2IE: Timer2 to PR2 Match Interrupt Enable bit
	;			1 = Enables the Timer2 to PR2 match interrupt
	;			0 = Disables the Timer2 to PR2 match interrupt

	;			bit 0 TMR1IE: Timer1 Overflow Interrupt Enable bit
	;			1 = Enables the Timer1 overflow interrupt
	;			0 = Disables the Timer1 overflow interrupt


	banksel	Bank0		; switch back to PORT memory bank


	movlw	b'00000111'     ;comparator off
	movwf	CMCON0		
				; comparator enable input GP1 - Internal reference
				;CMCON0  COMPARATOR CONTROL REGISTER 0 (ADDRESS: 19h)
				;U-0 R-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;   COUT    CINV  CIS   CM2   CM1   CM0
				; 7    6  5     4    3     2     1     0
				;
				;bit 6 COUT: Comparator Output bit
				;When CINV = 0:
				;1 = VIN+ > VIN-
				;0 = VIN+ < VIN-
				;When CINV = 1:
				;1 = VIN+ < VIN-
				;0 = VIN+ > VINbit
				;
				;bit 4 CINV: Comparator Output Inversion bit
				;1 = Output inverted
				;0 = Output not inverted
				;
				;bit 3 CIS: Comparator Input Switch bit
				;When CM<2:0> = 110 or 101:
				;1 = VIN- connects to CIN+   GP0
				;0 = VIN- connects to CINbit GP1
				;
				;2 CM<2:0>: Comparator Mode bits
				;
				;FIGURE 8-3: COMPARATOR I/O OPERATING MODES
				;Note: Comparator interrupts should be disabled
				;during a Comparator mode change.
				;Otherwise, a false interrupt may occur.
				;Comparator Reset (POR Default Value  Low Power)         	
				;CM<2:0> = 000
				;                                                 
				;Comparator Off (Lowest Power)
				;CM<2:0> = 111

				;Comparator without Output                                	
				;CM<2:0> = 010 							
				;
				;Comparator w/o Output and with Internal Reference
				;CM<2:0> = 100
				;
				;Comparator with Output and Internal Reference 			
				;CM<2:0> = 011 							
				;
				;Multiplexed Input with Internal Reference and Output
				;CM<2:0> = 101
				;
				;Comparator with Output 					
				;CM<2:0> = 001 	
				
				;Multiplexed Input with Internal Reference
				;CM<2:0> = 110
				;
				
	movlw	b'00000000'	;disable interrupts
	movwf	INTCON		;
	;			REGISTER 3-3: INTCON: INTERRUPT CONTROL REGISTER
	;			R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
	;			GIE   PEIE  T0IE  INTE  GPIE  T0IF  INTF  GPIF
	;			 7     6     5     4     3     2     1     0
	;			
	;			bit 7 GIE: Global Interrupt Enable bit
	;			1 = Enables all unmasked interrupts
	;			0 = Disables all interrupts

	;			bit 6 PEIE: Peripheral Interrupt Enable bit
	;			1 = Enables all unmasked peripheral interrupts
	;			0 = Disables all peripheral interrupts
	;
	;			bit 5 T0IE: Timer0 Overflow Interrupt Enable bit
	;			1 = Enables the Timer0 interrupt
	;			0 = Disables the Timer0 interrupt

	;			bit 4 INTE: GP2/INT External Interrupt Enable bit
	;			1 = Enables the GP2/INT external interrupt
	;			0 = Disables the GP2/INT external interrupt

	;			bit 3 GPIE: GPIO Change Interrupt Enable bit(1)
	;			1 = Enables the GPIO change interrupt
	;			0 = Disables the GPIO change interrupt

	;			bit 2 T0IF: Timer0 Overflow Interrupt Flag bit(2)
	;			1 = Timer0 register has overflowed 
	;			    (must be cleared in software)
	;			0 = Timer0 register did not overflow

	;			bit 1 INTF: GP2/INT External Interrupt Flag bit
	;			1 = The GP2/INT external interrupt occurred 
	;			(must be cleared in software)
	;			0 = The GP2/INT external interrupt did not occur

	;			bit 0 GPIF: GPIO Change Interrupt Flag bit
	;			1 = When at least one of the GPIO <5:0> pins changed state 
	;			(must be cleared in software)
	;			0 = None of the GPIO <5:0> pins have changed state

	;			Note 1: IOC register must also be enabled.
	;			2: T0IF bit is set when TMR0 rolls over. 
	;			TMR0 is unchanged on Reset 
	;			and should be initialized before
	;			clearing T0IF bit.
	;
	banksel	Bank1
	movlw	b'00000001'	;enable interrupt GP0
	movwf	IOC
				;REGISTER 4-4: IOC  INTERRUPT-ON-CHANGE GPIO REGISTER 
				;(ADDRESS: 96h)
				;U-0 U-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0 R/W-0
				;       IOC5  IOC4  IOC3  IOC2  IOC1  IOC0
				;bit 7 bit 0
				;bit 7-6 Unimplemented: Read as 0
				;bit 5-0 IOC<5:0>: Interrupt-on-change GPIO Control bit
				;1 = Interrupt-on-change enabled
				;0 = Interrupt-on-change disabled
				;Note 1: Global Interrupt Enable (GIE) must be enabled for
				;       individual interrupts to be recognized.

;	movlw	b'00010000'	;enable weak pullup GPio4
;	movwf	WPU


	movlw	Hiintensity <<1	; 16us = 62,5kHz
	movwf	PR2			; min 256*4 us = 0.976kHz 
	banksel Bank0


	eq CCP1CON, b'00010000'	 ; disable PWM
;                     7  4   0   ;  17 duty cycle
	eq	CCPR1L, 0x04	 ;  4 * prescaler = 16 values from 250ns to 4us

			;CCP1CON  CCP CONTROL REGISTER 1 (ADDRESS: 15h)
		
			; U-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0   R/W-0  R/W-0
			;       DC1B1 DC1B0 CCP1M3 CCP1M2 CCP1M1 CCP1M0
			;  7    6   5     4     3      2      1      0     
			;bit7
			;Unimplemented: Read as 0
			;bit6
			;Unimplemented: Read as 0
			
			;bit5 , bit4
			;DC1B<1:0>: PWM Least Significant bits
			;Capture mode:
			;Unused.
			;Compare mode:
			;Unused.
			;PWM mode:
			;These bits are the two LSbs of the PWM duty cycle. 
			;The eight MSbs are found in CCPR1L.
			
			;bit 3
			;CCP1M<3:0>: CCP1 Mode Select bits
			;0000 = Capture/Compare/PWM disabled (resets CCP1 module)
			;0100 = Capture mode, every falling edge
			;0101 = Capture mode, every rising edge
			;0110 = Capture mode, every 4th rising edge
			;0111 = Capture mode, every 16th rising edge
			;1000 = Compare mode, set output on match (CCP1IF bit is set)
			;1001 = Compare mode, clear output on match (CCP1IF bit is set)
			;1010 = Compare mode, generate software interrupt on match 
			;	(CCP1IF bit is set,
			;	CCP1 pin is unaffected)
			;1011 = Compare mode, trigger special event (CCP1IF bit is set, 
			;	CCP1 pin is unaffected);
			;	CCP1 resets TMR1 and starts an A/D conversion 
			;	(if A/D module is enabled)
			;11xx = PWM mode
			;
	
	;bcf	PIR1,TMR2IF	
	eq	T2CON, b'00000000'	; switch off TMR2

	;		REGISTER 7-1: T2CON  TIMER2 CONTROL REGISTER (ADDRESS: 12h)
	;		U-0 R/W-0   R/W-0    R/W-0   R/W-0   R/W-0  R/W-0   R/W-0
	;		   TOUTPS3 TOUTPS2 TOUTPS1 TOUTPS0 TMR2ON T2CKPS1 T2CKPS0
	;		 7    6        5       4       3       2      1    bit 0
	;		bit 7 Unimplemented: Read as 0
	;		bit 6-3 TOUTPS<3:0>: Timer2 Output Postscale Select bits
	;		0000 = 1:1 postscale
	;		0001 = 1:2 postscale
	;		
	;		
	;		
	;		1111 = 1:16 postscale
	;		bit 2 TMR2ON: Timer2 On bit
	;		1 = Timer2 is on
	;		0 = Timer2 is off
	;		bit 1-0 T2CKPS<1:0>: Timer2 Clock Prescale Select bits
	;		00 = Prescaler is 1    <----- for spoton
	;		01 = Prescaler is 4    <----- for campinglight
	;		1x = Prescaler is 16
	;	

			
	;goto Main


;	call	dark200ms	
;	call	testcds
;	call	displaybits
;	eq	Timer1Counter, .122
;	eq	ZeroCrosses,.0
;	clrf	TMR0
;	bcf	INTCON,T0IF
;	movlw	b'00010010'	; wdtoff
;	movwf	WDTCON
;	call	testfreq
;	call	displaybits
;	movlw	b'00010010'	; wdtoff
;	movwf	WDTCON
;
;

	clrf	SystemStatus
	movbit	Ac_Port, AC_is_High

;tst	call	testpwr
;
;	btfss	AC_ON
;	 goto off
;	eq CCP1CON, b'00011100'	 ;enable PWM
;	goto tst
;off	
;	eq CCP1CON, b'00010000'	 ;disable PWM
;	goto	tst	
;

;	goto pprpslp
	call	testvoltage
;	call	testcds
;	call	displaybits
;	goto $-2

	
;Main 
;******************************************************************************

;**********************************sleepy loop
;pprpslp	clrf	INTCON
;	bcf	T2CON,TMR2ON
;	bcf	T1CON,TMR1ON
;	eq CCP1CON, b'00010000'	;disable PWM
;	bcf	GPIO,2		; transistor low
;

	bcf	GPIO,4
prpslp	movlw	b'00010011'	; 512ms seconds
	movwf	WDTCON

				;WDTCON  WATCHDOG TIMER CONTROL REGISTER (ADDRESS: 18h)
				;TABLE 12-8: SUMMARY OF WATCHDOG TIMER REGISTERS
				;U-0 U-0 U-0 R/W-0  R/W-1  R/W-0  R/W-0  R/W-0
				;         WDTPS3 WDTPS2 WDTPS1 WDTPS0 SWDTEN
				; 7   6   5     4     3       2     1      0
				;bit 7-5 Unimplemented: Read as 0
				;bit 4-1 WDTPS<3:0>: Watchdog Timer Period Select bits
				;Bit Value = Prescale Rate
				;0000 = 1:32
				;0001 = 1:64
				;0010 = 1:128
				;0011 = 1:256
				;0100 = 1:512 (Reset value)  = 16ms
				;0101 = 1:1024               = 32
				;0110 = 1:2048                 64
				;0111 = 1:4096                 128
				;1000 = 1:8192		       256
				;1001 = 1:16384			512
				;1010 = 1:32768			1024
				;1011 = 1:65536			2048
				;1100 = Reserved
				;1101 = Reserved
				;1110 = Reserved
				;1111 = Reserved

				;bit 0 SWDTEN: Software Enable or Disable the 
				;		Watchdog Timer(1)
				;1 = WDT is turned on
				;0 = WDT is turned off (Reset value)

				;Note 1: If WDTE configuration bit = 1, then WDT is always 
				;enabled, irrespective of this
				;control bit. If WDTE configuration bit = 0, then it is 
				;possible to turn WDT on/off with this control bit.
	

	sleep
	call testcds
	btfss	AH,7		;too bright, refuse work
	 goto	prpslp-1
	bsf	GPIO,4		;switch on PIR


;	movbit	AC_ON, Ac_Onbuffer 
;	call	testpwr
;	skpnabutb Ac_Onbuffer, AC_ON
;	 goto tstPIR
;
;alarm	bcf	WDTCON,SWDTEN	; switch off WDT
;	call testcds
;
;	skpgel	AH,.1		;too bright, refuse work
;	 goto	prpslp
;	skpgel	AH,.12		;too dark, try LED
; 	 goto	lampon
;	goto 	LEDon		; 
;
;
;tstPIR	skpnorb	AC_ON, PIR_Port	
;	 goto alarm		;; PIR and AC on
;

	btfss	PIR_Port	; testPIR
	 goto	prpslp		; go back to sleep

	bcf	WDTCON,SWDTEN	; No AC, emergency light
	;goto 	LEDon		; 






LEDon
	BANKSEL	Bank1		; BANK1
	;movlw	iodir
	;iorlw	b'00000100'	; clr output 

	;movwf	TRISIO		;
	;bcf	PIE1,TMR2IE	; clr interrupt , if necessary
	
	movlw	Lointensity	; .255
	movwf	PR2			  ; 256*4 us = 0.976kHz 
					  ; 256      = 3.906kHz	
					  ; 9        = 111,1kHz

	BANKSEL	Bank0
	eq CCP1CON, b'00011100'	 ; enable PWM
;                     7  4   0   ;  17 duty cycle
	eq	CCPR1L, 0x04	 ;  4 * prescaler = 16 values from 250ns to 4us
	bsf	T2CON,TMR2ON	 ; enable TMR2
	clrf	TMR1H
	movlw	b'00110001'	; enable TMR1 , 1:8 prescale
	movwf	T1CON
	;		REGISTER 6-1: T1CON: TIMER1 CONTROL REGISTER
	;		R/W-0       R/W-0    R/W-0   R/W-0   R/W-0   R/W-0  R/W-0 R/W-0
	;		T1GINV(1) TMR1GE(2) T1CKPS1 T1CKPS0 T1OSCEN T1SYNC TMR1CS TMR1ON
	;		   7         6         5       4       3       2      1      0

	;		bit 7 T1GINV: Timer1 Gate Invert bit(1)
	;		1 = Timer1 gate is active-high (Timer1 counts when gate is high)
	;		0 = Timer1 gate is active-low (Timer1 counts when gate is low)

	;		bit 6 TMR1GE: Timer1 Gate Enable bit(2)
	;		If TMR1ON = 0:
	;		This bit is ignored
	;		If TMR1ON = 1:
	;		1 = Timer1 is on if Timer1 gate is not active
	;		0 = Timer1 is on

	;		bit 5-4 T1CKPS<1:0>: Timer1 Input Clock Prescale Select bits
	;		11 = 1:8 Prescale Value
	;		10 = 1:4 Prescale Value
	;		01 = 1:2 Prescale Value
	;		00 = 1:1 Prescale Value

	;		bit 3 T1OSCEN: LP Oscillator Enable Control bit
	;		If INTOSC without CLKOUT oscillator is active:
	;		1 = LP oscillator is enabled for Timer1 clock
	;		0 = LP oscillator is off
	;		Else:
	;		This bit is ignored. LP oscillator is disabled.

	;		bit 2 T1SYNC: Timer1 External Clock Input Synchronization Controlbit
	;		TMR1CS = 1:
	;		1 = Do not synchronize external clock input
	;		0 = Synchronize external clock input
	;		TMR1CS = 0:
	;		This bit is ignored. Timer1 uses the internal clock

	;		bit 1 TMR1CS: Timer1 Clock Source Select bit
	;		1 = External clock from T1CKI pin (on the rising edge)
	;		0 = Internal clock (FOSC/4)

	;		bit 0 TMR1ON: Timer1 On bit
	;		1 = Enables Timer1
	;		0 = Stops Timer1
	;		(1): T1GINV bit inverts the Timer1 gate logic, regardless of source.
	;		(2): TMR1GE bit must be set to use either T1G pin or COUT, 
	;		as selected by the T1GSS bit of the CMCON1
	;		register, as a Timer1 gate source.
	;			

	neeeq	UprampTime, 0x00000080	; 128*8us = 1.024ms
	bsf	Ramp_Running
	bcf	Down_Running
	call	motime

	bsf	INTCON,T0IE		; enable TMR0 INTERRUPT
	bcf	Lamp_On
	bsf	INTCON,GPIE
	bsf	INTCON,GIE		; enable General Interrupt
	bcf	Goto_Sleep
;**********************************wakey loop, LEDon
loop	movbit	AC_ON, Ac_Onbuffer
	bcf	AC_ON
	bcf	PIR1,TMR1IF
	btfss	PIR1,TMR1IF
	 goto	$-1			;512ms time for interrupts
	btfss	Blin_Ker
	 goto	ldn1
	call	dark200ms
	call 	dark200ms
	eq CCP1CON, b'00011100'	 ; enable PWM
	

ldn1	call testcds
	btfss	AH,7	;skpgel	AH,.12			; too bright for LED to be useful
	 goto	Init

		btfss	PIR_Port
		 goto	noinput
		call	testvoltage
		btfsc	Ramp_Running			;Input is high
		 goto	tstdwn
		call	motime				;extend latency
		goto	noinput
tstdwn		btfss	Down_Running
		 goto	noinput				; uprunning	
		bcf	Down_Running
		neeeq	UprampTime, 0x000000F0		; 15*16*8us = 1.92ms
		call	motime
		
noinput

	btfsc	Goto_Sleep
	 goto	endled

	skpnabutb Ac_Onbuffer, AC_ON	; AC came on
	 goto loop
;	goto endled


endled	clrf	INTCON			; kill all interrupt flags
	clrf	T1CON			; stop Timer1
	eq CCP1CON, b'00010000'	 	; disable PWM
	clrf	T2CON			; stop Timer2
	bcf	GPIO,2			; Transistor low
	btfsc	Goto_Sleep
	 goto	prpslp	
;***************************************************************************************
	btfss	AC_ON
	 goto	prpslp
;**********************************wakey loop   TRIAC
lampon	
	bsf	Lamp_On
	bsf	INTCON,T0IE
	bsf	INTCON, GPIE
	bsf	INTCON,GIE		; enable General Interrupt

	movlw	b'00110001'		; tmr1 on
	movwf	T1CON
refr	neeeq	UprampTime, 0x00FFFFF	; 256*8 = 2msec *256 = 512ms*16 = 8sec
	call	motime
	bcf	Goto_Sleep		
lmpn1	bcf	AC_ON
	btfsc	PIR_Port
	 goto	refr			;extend latency if PIR gets signal
	clrf	TMR1H
	bcf	PIR1,TMR1IF
	btfss	PIR1,TMR1IF		;time for interrupts
	 goto	$-1

;	call testcds
;	skpgel	AH,.1		;too bright, refuse work (16bit compare?)
;	 goto	Init

	skpnotaorb AC_ON, Goto_Sleep	; lost AC or timeout
         goto	lmpn1

	clrf	INTCON			; kill all interrupts
	bcf	T1CON,TMR1ON		; stop TMR1
	bcf	Lamp_On
	bcf	Goto_Sleep
	;------------------------------------- 		timer1 counter expired
	goto	LEDon


;			REGISTER 3-5: PIR1: PERIPHERAL INTERRUPT REQUEST REGISTER 1
;			R/W-0 R/W-0 R/W-0 U-0 R/W-0 R/W-0 R/W-0  R/W-0
;			EEIF  ADIF  CCP1IF   CMIF  OSFIF TMR2IF TMR1IF
;			  7     6      5   4    3     2     1      0  

;			bit 7 EEIF: EEPROM Write Operation Interrupt Flag bit
;			1 = The write operation completed (must be cleared in software)
;			0 = The write operation has not completed or has not been started

;			bit 6 ADIF: A/D Interrupt Flag bit
;			1 = A/D conversion complete
;			0 = A/D conversion has not completed or has not been started

;			bit 5 CCP1IF: CCP1 Interrupt Flag bit
;			Capture mode:
;			1 = A TMR1 register capture occurred (must be cleared in software)
;			0 = No TMR1 register capture occurred
;			Compare mode:
;			1 = A TMR1 register compare match occurred 
;				(must be cleared in software)
;			0 = No TMR1 register compare match occurred
;			PWM mode:
;			Unused in this mode

;			bit 4 Unimplemented: Read as 0

;			bit 3 CMIF: Comparator Interrupt Flag bit
;			1 = Comparator 1 output has changed (must be cleared in software)
;			0 = Comparator 1 output has not changed

;			bit 2 OSFIF: Oscillator Fail Interrupt Flag bit
;			1 = System oscillator failed, clock input has changed to INTOSC 
;				(must be cleared in software)
;			0 = System clock operating

;			bit 1 TMR2IF: Timer2 to PR2 Match Interrupt Flag bit
;			1 = Timer2 to PR2 match occurred (must be cleared in software)
;			0 = Timer2 to PR2 match has not occurred

;			bit 0 TMR1IF: Timer1 Overflow Interrupt Flag bit
;			1 = Timer1 register overflowed (must be cleared in software)
;			0 = Timer1 has not overflowed				






;
;	BANKSEL	Bank0		; BANK0
;
;	ClrC			;CRLRC
;	mov	CCPR1L,AL	;load
;	rlf	AL,F
;	rlf	AL,F
;	btfsc	CCP1CON,DC1B0
;	 bsf	AL,0
;	btfsc	CCP1CON,DC1B1
;	 bsf	AL,1
;
;	rlf	AL,F		;*4
;	rlf	AL,F
;
;	rrf	AL,F		;unload
;	bcf	CCP1CON,DC1B0
;	skpNC
;	 bsf 	CCP1CON,DC1B0
;	rrf	AL,F
;	bcf	CCP1CON,DC1B1
;	skpNC
;	 bsf 	CCP1CON,DC1B1
;	mov	AL, CCPR1L
;	
	goto	loop


	end
