indicatoron	macro
		if outputactivelow
		 bcf	Indi_Output	;on =inverted output
		else
		 bsf	Indi_Output
		endif

		endm
indicatoroff	macro
		if outputactivelow
		 bsf	Indi_Output	;on =inverted output
		else
		 bcf	Indi_Output
		endif
		endm

skpifnoinput macro
		if inputactivelow 
		 btfss	Input_Port
		else 		
		 btfsc	Input_Port
		endif
	     endm

skpifinput  macro
		if inputactivelow 
		 btfsc	Input_Port
		else 		
		 btfss	Input_Port
		endif
	    endm


pwmon	    macro		
		if outputactivelow
		 bcf	Pwm_Output	;PWM switched on: inverted output
		else
		 bsf	Pwm_Output
		endif
	    endm

pwmoff	    macro		
		if outputactivelow
		 bsf	Pwm_Output	;PWM switched off: inverted output
		else
		 bcf	Pwm_Output
		endif
	    endm

neeeq 	    macro var, val
		if (val & 0xFF) == 0xFF
		clrf	var
		else
 		movlw	0xFF - (val & 0xFF)
 		movwf	var
		endif
		if ((val>>.8) & 0xFF) == 0xFF
		clrf	var+1
		else
		movlw	0xFF - ((val>>.8) & 0xFF)
 		movwf	var+1
		endif

		if ((val>>.16) & 0xFF) == 0xFF
		clrf	var+2
		else
		movlw	0xFF - ((val>>.16) & 0xFF)
 		movwf	var+2
		endif

		if ((val>>.24) & 0xFF) == 0xFF
		clrf	var+3
		else
		movlw	0xFF - ((val>>.24) & 0xFF)
 		movwf	var+3

		endif
 	    endm

eeeeq 	    macro var, val
	if val & 0xFF
 		movlw	val & 0xFF
 		movwf	var
		else
		clrf	var
		endif
		if (val>>.8) & 0xFF
		movlw	(val>>.8) & 0xFF
 		movwf	var+1
		else
		clrf	var+1
		endif
		if	(val>>.16) & 0xFF
		movlw	(val>>.16) & 0xFF
		movwf	var+2
		else
		clrf	var+2
		endif
		if	val>>.24
		movlw	val>>.24
		movwf	var+3
		else
		clrf	var+3
		endif
		
 	    endm

eeeq 	    macro var, val
 		if val & 0xFF
 		movlw	val & 0xFF
 		movwf	var
		else
		clrf	var
		endif
		if (val>>.8) & 0xFF
		movlw	(val>>.8) & 0xFF
 		movwf	var+1
		else
		clrf	var+1
		endif
		if	val>>.16
		movlw	val>>.16
		movwf	var+2
		else
		clrf	var+2
		endif
		
 	    endm

eeq 	    macro var, val
		if val & 0xFF
 		movlw	val & 0xFF
 		movwf	var
		else
		clrf	var
		endif
		if	val>>8
 		movlw	val>>8
 		movwf	var+1
		else
		clrf	var+1
		endif
 	    endm
eq 	    macro var, val
		if val
 		movlw	val
 		movwf	var
		else
		clrf	var
		endif
  	    endm

sub	macro	Diff, SubEnd, SubTor
		movfw	SubTor
		subwf	SubEnd,W
		movwf	Diff
	
	endm
subb	macro	Diff, SubEnd, SubTor
		movfw	SubTor
		subwf	SubEnd,W
		movwf	Diff
		
		movfw	SubTor+1
		skpC	
		 incf	SubTor+1,W
		subwf	SubEnd+1,W
		movwf	Diff+1
	endm

decC	    macro	Target
		skpC
		 decf	Target,F
	    endm

add	    macro result, var1, var2
		movfw	var1
		addwf	var2,W
		movwf	result
	    endm

addd	    macro result, var1, var2
		movfw	var1
		addwf	var2,W
		movwf	result
		movfw	var1+1
		skpnC
		 incfsz	var1+1,F
		addwf	var2+1,W
		movwf	result
	    endm

addC	    macro	Target
		skpnC
		 incf	Target,F
	    endm

inc	    macro result, var1
		movfw	var1
		addwf	result,F
	    endm
incc	    macro result, var1
		movfw	var1
		addwf	result,F
		movfw	var1+1
		skpnC
		 incfsz	var1+1,W
		addwf	result+1,F
	    endm
inccc	    macro result, var1
		movfw	var1
		addwf	result,F
		movfw	var1+1
		skpnC
		 incfsz	var1+1,W
		addwf	result+1,F
		movfw	var1+2
		skpnC
		 incfsz	var1+2,W
		addwf	result+2,F
	    endm
incccc	    macro result, var1
		movfw	var1
		addwf	result,F
		movfw	var1+1
		skpnC
		 incfsz	var1+1,W
		addwf	result+1,F
		movfw	var1+2
		skpnC
		 incfsz	var1+2,W
		addwf	result+2,F
		movfw	var1+3
		skpnC
		 incfsz	var1+3,W
		addwf	result+3,F
	    endm
dec	    macro result, var1
		movfw	var1
		subwf	result,F
	    endm
decc	    macro result, var1
		movfw	var1
		subwf	result,F
		movfw	var1+1
		skpC
		 incfsz	var1+1,W	;overflow
		subwf	result+1,F
	    endm			;overflow on NC

deccc	    macro result, var1
		movfw	var1
		subwf	result,F
		movfw	var1+1
		skpC
		 incfsz	var1+1,W	;overflow
		subwf	result+1,F
		movfw	var1+2
		skpC
		 incfsz	var1+2,W
		subwf	result+2,F
	    endm			;overflow on NC





incl	    macro result, val
		movlw	val
		addwf	result,F
	    endm

incll	macro	var1, val
		movlw	val & 0xFF
		addwf	var1,F
		movlw	(val >>.8) & 0xFF
		skpC
		 goto	$+2
		if ((val >>.8)+1) & 0xFF
		  movlw	((val >>.8)+1) & 0xFF
		else
		  goto $+2
		endif
		addwf	var1+1,F
	endm		
inclll	macro 	var1, val
		movlw	val & 0xFF
		addwf	var1,F
		movlw	(val >>.8) & 0xFF
		skpC
		 goto	$+2
		if ((val >>.8)+1) & 0xFF
		  movlw	((val >>.8)+1) & 0xFF
		else
		  goto $+2
		endif
		addwf	var1+1,F
		movlw	((val >>.16) & 0xFF)
		skpC
		 goto	$+2
		if ((val >>.16)+1) & 0xFF
		  movlw	((val >>.16)+1) & 0xFF
		else
		  goto $+2
		endif
		addwf	var1+2,F
		endm	
incllll	macro 	var1, val
		inclll var1, val

		movlw	((val >>.24) & 0xFF)
		skpC
		 goto	$+2
		if ((val >>.24)+1) & 0xFF
		  movlw	((val >>.24)+1) & 0xFF
		else
		  goto $+2
		endif
		addwf	var1+3,F
	endm		
	

decl	    macro result, val
		incl	result, -val
	    endm

decll	macro	var1, val
	 	incll	var1, -val
	endm		
declll	macro	var1, val
		inclll	var1, -val
	endm	
decllll	macro	var1, val
		incllll var1, -val
	endm		

SWAPWF  MACRO  REG
        XORWF  REG,F
        XORWF  REG,W
        XORWF  REG,F
        ENDM
swapreg macro	var1,var2
		movfw	var1
		xorwf	var2,F
		xorwf	var2,w
		xorwf	var2,F
		movwf	var1
	endm
	
shmrrr	macro	Target, shifts, IndeX
		movlw	shifts
		movwf	IndeX
		clrC
		rrf	Target+2,F
		rrf	Target+1,F
		rrf	Target,F
		decfsz	IndeX,F
		 goto	$-5
	endm

shr	macro	Target
		clrC
		rrf	Target,F
	endm
shrr	macro	Target
		clrC
		rrf	Target+1,F
		rrf	Target,F
	endm


shrrr	macro	Target
		clrC
		rrf	Target+2,F
		rrf	Target+1,F
		rrf	Target,F
	endm

shll	macro	Target
		clrC
		rlf	Target,F
		rlf	Target+1,F
	endm

shlll	macro	Target
		clrC
		rlf	Target,F
		rlf	Target+1,F
		rlf	Target+2,F
	
	endm


skpleq	    macro var1, var2	;skip var1 less equal var2
		incf	var2,w	; 255 not covered, any 8bit number
		subwf	var1,W	; is less or equal 255
		skpNC
	    endm

skpge	    macro var1, var2	;skip var1 greater equal var2
		movfw	var2
		subwf	var1,W
		skpC
	    endm

skpgeq	    macro var1, var2
		movfw	var2
		subwf	var1,W
		skpC
	    endm


skpeq	    macro var1, var2
		movfw	var1
		subwf	var2,W
		skpz
	    endm

skpneq	    macro var1, var2
		movfw	var1
		subwf	var2,W
		skpnz
	    endm

skpeql	    macro var1, val	;skip var1  equal literal
		movlw	val
		subwf	var1,W
		skpz
	    endm

skpneql	    macro var1, val	;skip var1  not equal literal
		movlw	val
		subwf	var1,W
		skpnz
	    endm

skpgel	    macro var1, val	;skip var1 greater equal literal
		movlw	val
		subwf	var1,W
		skpC
	    endm
skpgell	macro var1, val
		movlw	val >> .8
		subwf	var1+1,w
		skpNZ
		 goto	$+4
		skpNC
		 goto	$+6		; is greater
		goto	$+4		; is less
		movlw	val & 0xFF	; +1 is equal
		subwf	var1,w
		skpC
;		 conditional code

	endm
skplesll macro var1, val	;skip var1 less  literal
		movlw	val >>.8
		subwf	var1+1,W
		skpNZ	
		 goto	$+4
		skpNC
		 goto	$+5	;is greater
		goto	$+5	;is less
		movlw	val & 0xFF
		subwf	var1,W
		skpNC	

	
	    endm


skplesl	    macro var1, val	;skip var1 less  literal
		movlw	val
		subwf	var1,W
		skpNC
	    endm


skplel	    macro var1, val	;skip var1 less equal literal
		movlw	val+.1	; 255 not covered, any 8bit number
		subwf	var1,W	; is less or equal 255
		skpNC
	    endm

skp16ge	macro var1, var2
		movfw	var2+1
		subwf	var1+1,w
		skpNZ
		 goto	$+4
		skpNC
		 goto	$+6	; is greater
		goto	$+4	; is less
		movfw	var2	; +1 is equal
		subwf	var1,w
		skpC
;		 conditional code
	endm

skp24ge	macro var1, var2
		movfw	var2+2
		subwf	var1+2,w
		skpNZ
		 goto	$+4
		skpnC
		 goto	$+.13	; is greater
		goto	$+.11	; is less
		movfw	var2+1
		subwf	var1+1,w
		skpNZ
		 goto	$+4
		skpNC
		 goto	$+6	; is greater
		goto	$+4	; is less
		movfw	var2	; +1 is equal
		subwf	var1,w
		skpC
;		 conditional code
	endm

;****************************************** now legal macros **********************


;execnotabutb
skpaornb	macro	base1, bit1, base2, bit2;bit1	bit2 result
		btfss	base1, bit1		; 1      0     skp
		 btfss	base2, bit2		; 1      1     skp
		goto	$+2			; 0      0     skp
				;       	; 0      1     
				; execute not(bit1) and  bit2
	endm

;execand
skpnorb	macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfsc	base1, bit1		; 1      0     skp
		 btfss	base2, bit2		; 1      1
		goto	$+2			; 0      0     skp
				;       	; 0      1     skp
				; execute (bit1) and (bit2)
	endm

;execnor
skporb	macro	base1, bit1, base2, bit2	;base1, bit1	bit2 result
		btfss	base1, bit1		; 1      0   skp
		 btfsc	base2, bit2		; 1      1   skp	
		goto	$+2			; 0      0 
						; 0      1   skp
				;exeute not (bit1 or bit 2)
	endm

;execanotb
skpnotaorb	macro	base1, bit1, base2, bit2;bit1	bit2 result
		btfsc	base1, bit1		; 1      0     
		 btfsc	base2, bit2		; 1      1     skp
		goto	$+2			; 0      0     skp
				;       	; 0      1     skp
				; execute (bit1) and not(bit2)
	endm



;execaornotb
skpnabutb macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfss	base1, bit1		; 1      0     
		  				; 1      1     
		 btfss	base2, bit2		; 0      0     
		      				; 0      1     skp
				;
				; execute bit1 or not(bit2)
	endm

;execaorb
skpnanotb	macro	base1, bit1, base2, bit2;bit1	bit2 result
		btfss	base1, bit1		; 1      0     
		 btfsc	base2, bit2		; 1      1     
						; 0      0     skp
				;       	; 0      1     
				; execute not(bit1) and  not(bit2)
	endm
				
;execnandb
skpandb macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfsc	base1, bit1		; 1      0     
		     				; 1      1     skp     
		 btfss	base2, bit2		; 0      0     
		 				; 0      1     
				;
				;execute bit1 or bit2
	endm


;execxorb 
skpeqb macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfss	base1, bit1		; 1      0     
		 goto  	$+4			; 1      1    skp
		btfss	base2, bit2		; 0      0    skp
		 goto   $+3			; 0      1    
		goto	$+3
		btfsc   base2, bit2
					;execute    bit1 xor bit2
	endm

;execeqb 
skpxorb macro	base1, bit1, base2, bit2	;bit1	bit2 result
		btfss	base1, bit1		; 1      0    skp 
		 goto  	$+4			; 1      1    
		btfsc	base2, bit2		; 0      0    
		 goto   $+3			; 0      1    skp
		goto	$+3
		btfss   base2, bit2
					;
				;execute    bit1 eq bit2
	endm


movbit	macro Source,Sbit, Target, Tbit
		bsf	Target,Tbit
		btfss	Source,Sbit
		 bcf	Target,Tbit
	endm

;***************************************************end not legal macros*********** 

movEEAd	macro	data1	
		banksel	data1
		movfw	data1
		banksel	EEADR	
		movwf	EEADR
	endm	


movEEDt	macro	data1	
		banksel	data1
		movfw	data1
		banksel	EEDAT	
		movwf	EEDAT
	endm

movEEAD	macro	adr, data1
		banksel	adr
		movfw	adr
		banksel	EEADR	
		movwf	EEADR
		banksel	data1
		movfw	data1
		banksel	EEDAT	
		movwf	EEDAT
	endm
readEE	macro	adrl,var

		banksel	EEADR
		movlw	adrl
		movwf	EEADR
		bsf	EECON1,RD
		movfw	EEDAT
		banksel	var
		movwf	var
	endm



mov	macro Source, Target
		movfw	Source
		movwf	Target
	endm

movv	macro Source, Target
		movfw	Source
		movwf	Target
		movfw	Source+1
		movwf	Target+1
	endm
movvv	macro Source, Target
		movfw	Source
		movwf	Target
		movfw	Source+1
		movwf	Target+1
		movfw	Source+2
		movwf	Target+2
	endm

endloop	    macro var, label
		movfw	var	; L and Hi =0
		iorwf	var+1,W
		skpnz
	 	 goto $+6
		movlw	0x01
		subwf	var,F	; L  or H not zero		
		skpC		; borrow
	 	 decf	var+1,F
		goto label	; e.g. 		 eeq count,600
	    endm		;      labl	 nop
				;		 endloop count, labl



shr16	macro	Target, shifts
		movlw	shifts
		movwf	IndeX
		clrC
		rrf	Target+1,F
		rrf	Target,F
		decfsz	IndeX,F
		 goto	$-4
	endm
clrf16	macro	var
		clrf	var
		clrf	var+1
	endm

add2	macro	var1, var2
		movfw	var1
		addwf	var2,F
		addcf	var2+1,F
		movfw	var1+1
		addwf	var2+1,F
	endm		
shl2	macro 	var
		clrc
		rlf	var,F
		rlf	var+1,F
	endm
#define 	DiviSor		BL
#define 	DiviDend	BH
#define 	DiviTemp	TempOut



modulo10 macro
		movlw	.10
		movwf	DiviSor
		clrf	AH
mod8	       movlw	1
		movwf	AL
		movfw	DiviSor
		movwf	DiviTemp
		subwf	DiviDend,W
		bNC	finish
		movwf	DiviDend
		movfw	AL
		addwf	AH,F
rrTemp	       clrC	
		rlf	DiviTemp,F	; rrf = *2
		rlf	AL,F
		movfw	DiviTemp
		subwf	DiviDend,W
		bnC	mod8		; unsucessful sub	
		movwf	DiviDend
		movfw	AL
		addwf	AH,F
		goto	rrTemp
finish         movfw	AH
		movwf	DiviSor		;decimal result in BL, BH 	
		endm


decsuccc	macro	DDend,DSor
		deccc	DDend,Dsor
		skpC
		 retLW 0
		inccc DDend,Dsor
		retlw 0
		
div24by8	DiviDend, DiviSor	;
		
d24mod8	       	eq	AL,.1
		mov	DiviSor,DiviTemp
		decsuccc	DiviDend,DiviTemp
		bNC	d24finish
	
		
d24rrTemp	clrC	
		rlfff	DiviTemp	; DiviTemp = *2
		rlf	AL,F
		movfw	DiviTemp
		sub24	DiviDend,DiviTemp,
		bnC	d24mod8		; unsucessful sub	
		movwf	DiviDend
		movfw	AL
		addwf	AH,F
		goto	d24rrTemp
d24finish       inccc	Divindend,DiviTemp
		movwf	DiviSor		;decimal result in BL, BH 	
		endm

;div16by16	DiviDend, DiviSor


;
;
;	eeeq	UrL,0x7FFF*.16
;		clrfff	UprampTime
;		clrfff	BL
;		call	I004		; realtime division
;		decf	PeriodReg,W
;		movwf	BH
;		addwf	BH,F
;		skpnC
;		 incf	BHH,F
;		addwf	BH,F
;		skpnC
;		 incf	BHH,F		;(PR-1)*3
;		call	timefactor
;		addwf	BH,F
;		skpnC
;		 incf	BHH,F
;		eeeq	AL,0x000100		;realtime division
;maxshift	skpnanotb	AHH,0,	BHH,7
;		 goto	testsub
;		shll	AH
;		shll	BH
;		call	I004
;		goto	maxshift
;	
;	
;testsub		skp24ge	UrL, BL
;		 goto	nosub		
;		inccc	UprampTime,AL
;		deccc	UrL,BL
; 		call	I004
;nosub		shrrr	AL
;		shrrr	BL
;		call	I004
;		
;		btfss	AL,0		;early break
;		 goto testsub		;unsuccessful subtract
;


mul8x8.8 macro MultiplAnd, MultConstant
		clr2f	BL		; result in BL
		movl2	AL, MultConstant ;0x0064	; decimal .100
moreadd	        btfss	MultiplAnd,0
		 goto	noadd
		add2	AL, BL		; B= A+B
noadd	       shl2	AL		; A= A * 2
		clrc
		rrf	MultiplAnd,F	; more bits to work with?
		movf	MultiplAnd,F
		bnz	moreadd
	endm				; result in BL,BH

mul8x8 macro ReSult, MultiplAnd, MultiKator
		clrff	ReSult		; result 
		mov	MultiKator,AL 
		clrf	AH;
		mov	MultiplAnd,BL
moreadd	        btfss	MultiplAnd,0
		 goto	noadd
		add2	AL, ReSult	; R= A+R
noadd	       shl2	AL		; A= A * 2
		clrc
		rrf	BL,F	; more bits to work with?
		movf	BL,F
		bnz	moreadd
	endm				; result in BL,BH

shl4	macro 	var
		clrc
		rlf	var,F
		rlf	var+1,F
		rlf	var+2,F
		rlf	var+3,F
	endm
add4	macro	var1, var2
		movfw	var1
		addwf	var2,F
		addcf	var2+1,F
		movfw	var1+1
		addwf	var2+1,F
		addcf	var2+2,F
		movfw	var1+2
		addwf	var2+2,F
		addcf	var2+3,F
		movfw	var1+3
		addwf	var2+3,F
	endm	
clrff	macro	var
		clrf	var
		clrf	var+1
	endm	
clrfff	macro	var
		clrf	var
		clrf	var+1
		clrf	var+2
	endm	

clrffff	macro	var
		clrf	var
		clrf	var+1
		clrf	var+2
		clrf	var+3
	endm
movf2 	macro var1, var2
		movfw	var1
		movwf	var2
		movfw	var1+1
		movwf	var2+1
	endm
movfff 	macro var1, var2
		movfw	var1
		movwf	var2
		movfw	var1+1
		movwf	var2+1
		movfw	var1+2
		movwf	var2+2
	endm
	
 
mul16.8x8.8l macro MultiplAnd, val ,vfrac  ; Lo 8(fraction) /Hi 8(integer)	
				; needs 
				;cblock 
				; 1 byte extra above and under Multipland,AL_1:4,BL:2
				;		DL
				;#define 	DH		DL+1
				; will leave factors intact
		movfff	MultiplAnd, AL_1 
		clrf	AH+1
		eq	BL, vfrac 			;
		eq	BH, val
		clrffff	MultiplAnd-1		; result in MultiplikAnd


moreadd	        btfss	BL,0		
		 goto	noadd
		add4	AL_1, MultiplAnd-1		; R= A+R
noadd	       shl4	AL_1		; A= A * 2
		clrc
		rrf	BH,F	
		rrf	BL,F		; B= B div 2 more bits to work with?
		movfw	BH
		iorwf	BL,W
		bnz	moreadd
	
	endm				;  
 	
 
mul8.8x8.8r macro Result,MultiplAnd, MultiKator   ; Lo 8(fraction) /Hi 8(integer)	
				; needs 
				;cblock 
				; Result:4,AL_1:4,DL:2
				;endc

				;#define 	BL		BL_1+1
				;#define 	BH		BL_1+2

				;#define 	AL		AL_1+1
				;#define 	AH		AL_1+2
				;#define 	DH		DL+1
				; will leave factors intact
		clrffff	Result		; result in BL
		movf2	MultiKator, AL_1 
		clr2f	AH
		movf2	MultiplAnd, DL ;
moreadd	        btfss	DL,0		
		 goto	noadd
		add4	AL_1, Result		; B= A+B
noadd	       shl4	AL_1		; A= A * 2
		clrc
		rrf	DH,F	
		rrf	DL,F		; D= D div 2 more bits to work with?
		movfw	DH
		iorwf	DL,W
		bnz	moreadd
		mov	Result+1,Result		; Resolution reduction
		mov	Result+2,Result+1; Resolution reduction
		mov	Result+3,Result+2; Resolution reduction
		clrf	Result+3	; Resolution reduction
	endm				; result in BL,BH,BH+1 !!
 	
		
;TB040
;DS91040A-page 2 Preliminary ? 2000 Microchip Technology Inc.
;EXAMPLE 1: 8-BIT EXAMPLE
;A = v0xCF48
;A2 = 0xCF48
;or
;Step
;1	1000 0000 (0x80)	this squared is less than 0xCF48, start next cycle with a new bit

;2	1100 0000 (0xC0)this squared is less than 0xCF48, start next cycle with a new bit
;3	1110 0000 (0xE0)
;4	1111 0000 (0xF0)
;5	1110 1000 (0xE8)
;6	1110 0100 (0xE4)
;7	1110 0110 (0xE6)
;8	1110 0111 (0xE7)
;9	1110 0110 (0xE6)
;Aprocess is finished; otherwise, this could keep going for more accurate
;fractional approximation

;
;new bit
;1100 0000 (0xC0)
;new bit
;
;new bit
;
;shifted bit
;
;shifted bit
;
;new bit
;
;new bit
;
;bit shifted out
;
;Description
;;this squared is less than 0xCF48, start next cycle with a new bit
;this squared is less than 0xCF48, start next cycle with a new bit
;this is greater than 0xCF48, shift bit right
;this is greater than 0xCF48, shift bit right
;this squared is less than 0xCF48, start next cycle with a new bit
;this squared is less than 0xCF48, start next cycle with a new bit
;this is greater than 0xCF48, shift right
;right-most bit is thrown away for the integer approximation and the
;
