;***********************************************************************
;*   This file is the firmware to implement a                          *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;*   at GPIO 2 Transistor output driver                                *
;*                                                                     *
;*    File Version: A.2                                                *
;*                                                                     *
;*    Author:       G MICHAEL DRYGAS                                   *
;*                                    				       *
;*    Company:    MICHAELS Unternehmergesellschaft (haftungsbeschrnkt)*
;*                 reg DE                                             *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros3c                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;
	list      p=10F206	; list directive to define processor
	#include  ..\macros3c.asm
	config206
;***************************************************************************************
;VARIABLE DEFINITIONS in General Purpose Registers  
;***************************************************************************************


	cblock _MINRAM
	 SystemStatus,PR2,PR2HighCounter
	 UporDown

	endc

#define	TMR07Bit	SystemStatus,7
#define	Timer_Overflow	SystemStatus,6
#define STACK	_MAXRAM

#define GPIOinit	b'00000000'	; all OUTPUT initiate as LOW
#define TRISIOinit	b'11111011'	; configure GP2 as output 
#define	OPTIONinit	b'11001000'	; no wakup, no pullup, Clock 1:1
;#define	ADCON0init	b'01000001'	; gP0 analog, chanel 00,enable
;#define	ADCON0init	b'10000101'	; gP1 analog, chanel 01,enable

loopEVENT0in	macro	time,unit,jumpto
	variable	optn,intime,k,clow,chigh,chi2,chi3,dus,tlab
			

		  
k=1
	if unit == msec
k=.1000
	endif
	if unit == sec
k=.1000000
	endif


	IFDEF	__12F683
				; OSCON:
				;bit 6-4 IRCF<2:0>: Internl Oscillator Frequency Select bits
				;000 = 31 kHz
				;001 = 125 kHz
				;010 = 250 kHz
				;011 = 500 kHz
				;100 = 1 MHz
				;101 = 2 MHz
				;110 = 4 MHz
				;111 = 8 MHz
	 IFDEF	OSCONinit
optn =	OSCONinit & b'01110000'
	 ELSE
optn =	b'01100001'
	 ENDIF

optn = optn >> 4
	
	 if	optn == 0
dus = 65
	 else
dus = 1<<(7-optn)
	 endif
	ELSE
dus = 2				; every other processor runs at 2 half microseconds (1MHz)
	ENDIF
	
	
optn = 0
 	IFDEF	OPTIONinit	
	 if ! (OPTIONinit & b'00001000')
optn = 1 + (OPTIONinit & b'00000111')
	endif	
	ENDIF
; OSCONinit * OPTIONinit

dus = dus << optn		; prescale from OSCON in half (0.5) microseconds 

	if unit == sec
k = k / dus 
intime = time *k * 2 	; number of timer ticks required
	else
intime = time * k / dus * 2
	endif			
clow =	intime	& 0xFF
chigh=  (intime >> 8) 
	if chigh > 0 
	 if TC0used < 1		; determine maximum of variables to use for
	 error "Required Delay needs higher clock prescaler !!"			
	 endif
	endif 
chi2  =  (intime >> .16)
	if chi2 > 0 
	 if TC0used < 2
	 error "Required Delay needs higher clock prescaler !!"
	 endif
	endif 
chi3  =  (intime >> .24)
	if chi3 > 0 
	 if TC0used < 3
	 error "Required Delay needs higher clock prescaler !!"
	 endif
	endif
	 
	if chi3 > .255
	 error "Required Delay needs higher clock prescaler !!"	 
	else

	 if TC0used > 0
	  if (intime >>8) < .1024		; omit if precise timing required
chigh = (chigh+1) & 0xFF
	  eq_ 	TC0,=,chigh,		lit8	
	  endif
	 endif

	 if TC0used > 1
	  if chi2 < .1024
chi2 = (chi2+1) & 0xFF
	 if	chi2 == chigh
	  movwf	TC0+1
	 else

	   eq_ 	TC0+1,=,chi2,	lit8
	   endif	
	  endif
	 endif
	 if TC0used > 2
chi3 +=1
	 if	chi3 == chi2
	  movwf	TC0+2
	 else
	  eq_ 	TC0+2,=,chi3,	lit8	
	 endif
	 endif

	endif

;	if (chigh < 4) & (chi2 == 0) & (chi3 == 0) 

;	 movlw	0x00FF - (intime & 0xFF)
;	 movwf	TMR0
;
;	 ifdef	__12F683
;	  bcf	INTCON,T0IF
;	 endif
;
;	 ifdef	__10F206
;	 ;	mov_bit TMR0,7,TMR7bit
;
;	  bcf	TMR7bit
;	  if_bit TMR0,7
;	   bsf	TMR7bit
;	  endif
;	 endif 




	if      jumpto != 0xFF
	 movlw	jumpto
	 movwf	PrjP0
;	endif
	
;	 
	  	
	    goto	end0MLOOP0
	endif
	endm
	


	init2xx
	eq_	PR2,=,.250,	lit8
	eq	SystemStatus,0

TC0used = 3	
	cblock
	 TC0:TC0used
	 RampTime:TC0used
	endc	
	loopEVENT0in	.1,msec,0xFF;	d
	eq_	RampTime,=,TC0,	 TC0used*8
	eq_	UporDown,=,0xff,	lit8
	goto firedelay

nofiredelay
	goto	$+1
	goto	$+1
	goto	$+1
	nop
	goto	continuedelay
MLOOP	
	;goto	$+1
	;goto	$+1
	decfsz	PR2HighCounter,F
	 goto	nofiredelay	 
fire	bsf	GPIO,2
	nop
	bcf	GPIO,2
	decfsz	STACK,F
	 goto	$-1
firedelay
	swapf	PR2,W
	andlw	0x0F
	movwf	PR2HighCounter
	incf	PR2HighCounter,F 

continuedelay	
	movlw	b'00001111'
	andwf	PR2,W
	movwf	STACK
	incf	STACK,F
        nop
afterfire
	if_bit	Timer_Overflow
	 goto	timeroverflow	 
	 
	decfsz	TC0,F
	 goto	stpw8
;	goto	PERIODIC2048
;MLOOP01
	 
	 
	if TC0used > 1
	
;		movlw	0x07
;		andwf	TC0+1,W
;		addlw	-7
;		skpnZ
;		 goto	PERIODIC16sec
;MLOOP017
	decfsz	TC0+1,F
	 goto	stpw10
	endif

	if TC0used > 2
	decfsz	TC0+2,F
	 goto	stpw12
	endif 

	bsf	Timer_Overflow
	goto	stpw14


	 

endMLOOP0 	
stpw8		goto	$+1
stpw10		goto	$+1
stpw12		goto	$+1
stpw14		goto	$+1
stpw16		goto	$+1
stpw18		goto	$+1
stpw20		goto	$+1
stpw22		goto	$+1
stpw24		goto	$+1
stpw26		goto	$+1
stpw28		goto	$+1
stpw30		goto	$+1

nodelay
       

	goto	MLOOP
timeroverflow
	bcf	Timer_Overflow
	movf	UporDown,F
	if_Z
	 goto	rampdown
	do_	PR2,=,PR2,+,UporDown,	byte
;	nop
;	bcf	STATUS,Z
	if_Z
	 goto	changeramp
	eq_	TC0,=,RampTime,	TC0used*8
	goto	stpw22
changeramp
	if_not	UporDown,7
	 goto	staylow		; maximum pause
stayon1h
	eq	UporDown,0
	loopEVENT0in .60,sec,0xFF
	eq_	PR2,=,1,	lit8
	goto	stpw24	

rampdown
	eq	UporDown,0x01
	loopEVENT0in .2,sec,0xFF
	eq_	RampTime,=,TC0,	TC0used*8
	nop
	goto	stpw26	
staylow
	eq	PR2,0xFF	; no loopEVENT = maximum delay
	goto	stpw26
	end