;*************************************************************************************
;*    Filename:	    GP3-GP2fflop.asm                                                 *
;*    Date:         November, 2014                                     	     		 *
;*    File Version: A, this is a new file                                    	     *
;*                                                                  	   	     	 *
;*    Author:       G Michael Drygas                                      		     *
;*                  Applications Engineer                     				         *
;*    Company:      MICHAEL5.net                 		 						     *
;*************************************************************************************
;*                                			                                         *
;*    Files required:   m0-4.asm (macros) for NATURAL assembler User Interface       *               
;*************************************************************************************
;*                                                                     			     *
;*    Notes:        hardware PCB TUBE/1/DCswtch200s.brd 						     *
;*                                                                     		         *
;*************************************************************************************

		list      p=10F200	; list directive to define processor
		#include  ..\..\m0-4.asm
		#define _WDTON
		config_
 	
		#define	OPTIONinit	b'11001011'	; no wakup, no pullup, WDT 1:16
		#define TRISIOinit 	b'00001000'	; all ports output bar GP3	
		#define GPIOinit 	b'00000000'	; GPIO  all LOW 
		
	init_			; reasonable initiation of special function registers 

		cblock	_MINRAM			; start of variables
		 SyS1,SyS2
		endc
	
		#define STACK		_MAXRAM
	    #define MemHilo 	SyS1,6
	
	bcf 	MemHilo
main
	clrwdt
    eq__   GPIO,2,=,MemHilo
    delay .100000
	if_		GPIO,3,is_on,1
     goto    main
    bcf		GPIO,2			;switchoff for power saving
moreslp  
	      sleep
afterwdt
	if_		GPIO,3,is_off,1
      goto	moreslp
	if_m	MemHilo,is_on,1
      bcf	MemHilo
      goto main
    end_m
    bsf	MemHilo
    goto main

 end