;*************************************************************************************
;*    Filename:	    GP3-GP2fflop.asm                                                 *
;*    Date:         November, 2014                                     	     		 *
;*    File Version: A, this is a new file                                    	     *
;*                                                                  	   	     	 *
;*    Author:       G Michael Drygas                                      		     *
;*                  Applications Engineer                     				         *
;*    Company:      MICHAEL5.net                 		 						     *
;*************************************************************************************
;*                                			                                         *
;*    Files required:   m0-4.asm (macros) for NATURAL assembler User Interface       *               
;*************************************************************************************
;*                                                                     			     *
;*    Notes:        hardware PCB TUBE/1/DCswtch200s.brd 						     *
;*                                                                     		         *
;*************************************************************************************

		list      p=10F200	; list directive to define processor
		#include  ..\..\m0-4.asm
		#define _WDTON
		config_
 	
		#define	OPTIONinit	b'11001011'	; no wakup, no pullup, WDT 1:16
		#define TRISIOinit 	b'00001000'	; all ports output bar GP3	
		#define GPIOinit 	b'00000000'	; GPIO  all LOW 
		
	init_			; reasonable initiation of special function registers 
		#define OUTP		2

	goto RESET1

tick
	decfsz	Tck,F
	 goto noflip
    
	do_		GPIO,=,GPIO,XOR,1<<OUTP,	lit8
	comf	FlipDty,F
	eq_		Tck,=,FlipDty,byte
    RETLW 0
noflip
    goto $+1
    goto $+1

    RETLW 0

		cblock	_MINRAM			; start of variables
		 SyS1,Tck,FlipDty,PR_Duty
		endc
	
		#define STACK		_MAXRAM
	    #define MemHilo 	SyS1,6
RESET1
	eq_		PR_Duty,=,.254,lit8;   Period minus Duty = pause time
	movwf	FlipDty
	movwf	Tck
;	bcf		GPIO,OUTP              Output is low
	bcf 	MemHilo
	goto	$+1	
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1	

main
	clrwdt
;    eq__    GPIO,2,=,MemHilo
    call 	tick
	if_		GPIO,3,is_on,1
     goto    main-8
    bcf		GPIO,2			;switchoff for power saving
moreslp  
	      sleep
afterwdt
	if_		GPIO,3,is_off,1
      goto	moreslp
set half
		if_m 	PR_Duty,!=,FlipDty,byte
		 eq_	PR_Duty,=,,byte
		 comf	TAvr,W
	 	 movwf	FlipDty
		else_m
		 eq_	PR_Duty,=,TAvr,byte
		 movfw	TAvr
	     movwf	FlipDty
		end_m

	if_m	MemHilo,is_on,1
      bcf	MemHilo
        
       Ramp is ondown
      goto main
    end_m
    bsf	MemHilo
ramp ison up


    goto main

 end