;*************************************************************************************
;*    Filename:	    GP3-GP2fflop.asm                                                 *
;*    Date:         November, 2014                                     	     		 *
;*    File Version: A, this is a new file                                    	     *
;*                                                                  	   	     	 *
;*    Author:       G Michael Drygas                                      		     *
;*                  Applications Engineer                     				         *
;*    Company:      MICHAEL5.net                 		 						     *
;*************************************************************************************
;*                                			                                         *
;*    Files required:   m0-4.asm (macros) for NATURAL assembler User Interface       *               
;*************************************************************************************
;*                                                                     			     *
;*    Notes:        hardware PCB TUBE/1/DCswtch200s.brd 						     *
;*                                                                     		         *
;*************************************************************************************

		list      p=10F200	; list directive to define processor
		#include  ..\..\m0-4.asm
		#define _WDTON
		config_
 	
		#define	OPTIONinit	b'11000100'	; no wakup, no pullup, clock 1:32
		#define TRISIOinit 	b'00001000'	; all ports output bar GP3	
		#define GPIOinit 	b'00000000'	; GPIO  all LOW 
		
	init_			; reasonable initiation of special function registers 

		cblock	_MINRAM			; start of variables
		 SyS1,SyS2
		endc
	
		#define STACK		_MAXRAM
	    #define MemHilo 	SyS1,6
		#define	TMR07Bit	SyS1,7
	

;PWRUP	
	eq	SyS1,0
	eq	SyS2,0

		#define	TC0used 3					; use 3 bytes of timer for TC0
		cblock
		 TC0:TC0used
		 NmbrEvent0
		endc	 
	
	EVENT0in	.500,msec,0xFF  ; set time @ 500 milliseconds
	clrf		NmbrEvent0		; set execution  for EVENT0
	goto 		main

JMPTable	
	andlw	0x0F
	addwf	PCL,F
	 goto	EVENT0	
	 goto	EVENT1
	 goto	EVENT2	
	 goto	EVENT3
	 goto	EVENT4
	 goto	EVENT5
	 goto	EVENT6
	 goto	EVENT7
	 goto	EVENT8
	 goto	EVENT9
	 goto	EVENT10
	 goto	EVENT11
	 goto	EVENT12
	 goto	EVENT13
	 goto	EVENT14
	 goto	EVENT15

;	org	0x100

main
	bcf 	MemHilo

MLOOP	

	clrwdt
	if_		TMR0,7,is_on,1			; software emulation of
	 goto	set7					; timer 0 overflow
	if_		TMR07Bit,is_off,1		;
	 goto	set7+1
	bcf		TMR07Bit
    eq__   GPIO,2,=,MemHilo
	decfsz	TC0,F
	 goto	endMLOOP0
	decfsz	TC0+1,F
	 goto	endMLOOP0
	decfsz	TC0+2,F
	 goto	endMLOOP0

	movfw	NmbrEvent0		; after TC0+2 expired, 
	goto	JMPTable 		; now jump to loaded Event

end0MLOOP0
endMLOOP0
	if_		GPIO,3,is_on,1
     goto    MLOOP
    bcf		GPIO,2			;switchoff for power saving
moreslp  
	      sleep
afterwdt
	if_		GPIO,3,is_off,1
      goto	moreslp
	if_m	MemHilo,is_on,1
      bcf	MemHilo
      goto EVENT0
    end_m
    bsf	MemHilo
	goto EVENT0

set7	
	bsf	TMR07Bit
	goto	MLOOP

EVENT0		
		EVENT0in .3600,sec,.1	;loop
	
EVENT1	
		bcf	GPIO,2
		goto	EVENT0
EVENT2			
		
EVENT3
		 
EVENT4		

EVENT5		
		
EVENT6	

EVENT7		

EVENT8		

EVENT9		

EVENT10		

EVENT11		


EVENT12	
	
EVENT13
	
	
EVENT14 
	
		

EVENT15 
	

	

 end