;*************************************************************************************
;*    Filename:	    10F206-BIKE.asm                                                 *
;*    Date:         September, 2015                                     	     		 *
;*    File Version: A, this is a new file                                    	     *
;*                                                                  	   	     	 *
;*    Author:       G Michael Drygas                                      		     *
;*                  Applications Engineer                     				         *
;*    Company:      MICHAEL5.net                 		 						     *
;*************************************************************************************
;*                                			                                         *
;*    Files required:   m0-4.asm (macros) for NATURAL assembler User Interface       *               
;*************************************************************************************
;*                                                                     			     *
;*    Notes:        hardware PCB TUBE/2/222divider.brd						     *
;*                                                                     		         *
;*************************************************************************************
	list      p=10F206	; list directive to define processor
	#include  ..\..\m0-4.asm
	config_
 	
#define	OPTIONinit	b'11000111'	; no wakup, no pullup, Clock 1:256
#define TRISIOinit 	b'00001011'	; all ports output bar GP3	
#define GPIOinit 	b'00000000'	; GPIO  all LOW 
; #define CMCON0init GP0_Porton ; comparator off
;****************************************************************************************

	init_			; reasonable initiation of special function registers 


	cblock	_MINRAM			; start of variables
	 Sys1,Tck,FlipDty,PR_Duty,Avr:2,Vta
	TMR0save,TMR0high,T1S:2,T0S:2
	endc
#define STACK		_MAXRAM
#define ShdGP3		Sys1,3
#define RGP3		Sys1,4
#define cfRESET		Sys1,5
#define nega_bit	Sys1,0
#define	TMR07Bit	Sys1,7

#define OUTP		2
	goto RESET1

tick
	decfsz	Tck,F
	 goto noflip
    
	do_		GPIO,=,GPIO,XOR,1<<OUTP,	lit8
	comf	FlipDty,F
	eq_		Tck,=,FlipDty,byte
    RETLW 0
noflip
    goto $+1
    goto $+1

    RETLW 0
;****************************************************************************************

;Vta = (vta+3*INDF)/4

avrof4		clrf	Avr+1
		movfw	INDF    
		addwf	INDF,F
		skpNC
		 incf	Avr+1,F
		addwf	INDF,F
		skpNC
		 incf	Avr+1,F
		movfw	Vta		; Value to add
		addwf	INDF,F
		skpNC
		 incf	Avr+1,F

		clrC
		rrf	Avr+1,F
		rrf	INDF,F
		clrC
		rrf	Avr+1,F
		rrf	INDF,F		; result in INDF

		retlw 0	
;****************************************************************************************


RESET1
	eq_		PR_Duty,=,.254,lit8
	movwf	FlipDty
	movwf	Tck
	movwf	Avr
	bcf		GPIO,OUTP
	eq__	RGP3,=,GPIO,3
	clrf	TMR0high
	bsf		cfRESET

	goto	$+1	
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
	goto	$+1
main
	CALL	tick 					;11 us
   	if_	TMR0,==,TMR0save, byte
      goto main-8
   	eq_ 	TMR0save,=,TMR0,byte

	movf	TMR0,F
	if_Z_m	
	  if_ TMR0high,>=,.10,lit8
        goto RESET1					;no pulse detected
      incf 	TMR0high,F
	  nop
	  goto	main-1
    end_m						;7us

	eq__	ShdGP3,=,GPIO,3
	if__	RGP3,equal,ShdGP3
	  goto main
								; change on GP3 detected
	CALL	tick 					;11 us
	eq__	RGP3,=,ShdGP3
	if__	RGP3,and,cfRESET
      goto	RESET1
	if_m	cfRESET,is_on,1
		bcf cfRESET	

		clrf	TMR0
		clrf	TMR0high
		goto	main-3
	end_m

	if_m	RGP3,is_on,1
		eq_	T0S,=,TMR0,byte
	 	eq_ T0S+1,=,TMR0high,byte
		clrf	TMR0
		clrf	TMR0high
		goto	main
	else_m
		eq_	T1S,=,TMR0,byte
	 	eq_ T1S+1,=,TMR0high,byte
		clrf	TMR0
		clrf	TMR0high

		if_	T0S,>,T1S,word
		  goto RESET1

		call	tick
	 
		 swapf	T1S,F
		 movlw	b'00001111'
		 andwf	T1S,F
		 swapf	T1S+1,W
		 iorwf	T1S,F

		eq_		T1S,=,b'01110101',lit8
		
		 goto linearze	
;****************************************************************************************


vtable	addwf	PCL,F
	dt	3* (1+1)-1
	dt .37,.128
	dt .65, .220
	dt b'10101111',	.246

#define MdB	STACK-0
#define LoB	STACK-1
#define HiB	STACK-2

#define MdD	STACK-3
#define LoD	STACK-4
#define HiD	STACK-5
  
#define	AL	T1S
;#define AL	x	;test
 
linearze		
	    eq_	MdB,=,.1,	lit8
		call	vtable
		movwf	LoB
	    call	tick
		if_	AL,>,LoB,	byte
		 goto	bases
exbdry		
	    do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	MdD
		goto done

bases		
		movlw	0
		call	vtable
		movwf	MdB
		call	vtable
		movwf	HiB   
		call tick
		if_	AL,>=,HiB,	byte
		 goto exbdry

basesearch	do_	MdB,=,MdB,-,(1+1),lit8 
		movfw	MdB
		call	vtable
		movwf	LoB
		if_	AL,>=,LoB,	byte
		 goto 	binsearch
		eq_	HiB,=,LoB,	byte
		goto	basesearch

binsearch	
		call tick
		do_	MdB,=,MdB,+,1,	lit8
		movfw	MdB
		call	vtable
		movwf	LoD
		do_	MdB,=,MdB,+,(1+1),	lit8
		movfw	MdB
		call	vtable
		movwf	HiD

binloop		
		call tick
		do_	MdB,=,LoB,+,HiB,	(byte)
		rrf	MdB,F
		do_	MdD,=,LoD,+,HiD,	(byte)
		rrf	MdD,F
		
		if_	AL,>,MdB,		(byte)
		 goto	higher

		skpNZ				; AL equal MdB
		 goto	done

		eq_	HiB,=,MdB,	byte
		eq_	HiD,=, MdD,	byte
		goto	binloop
higher		eq_	LoB,=,MdB,	byte
		eq_	LoD,=,MdD,	byte
		goto	binloop

done		
;		e_q	E1,[,x,byte,]=,MdD,byte		
;		e_q_	R ,=,E1,byte,[,x  ,byte
	
	     eq_		Vta,=,MdD,	byte;
	
;		call tick	
;
	
;
		movlw	Avr
		movwf	FSR
		call	avrof4
		call tick
	;	eq_	Avr,=,.220,lit8

		 if_m PR_Duty,!=,FlipDty,byte
			eq_	PR_Duty,=,Avr,byte
	           comf	Avr,W
			 movwf	FlipDty
		 else_m
			eq_	PR_Duty,=,Avr,byte
			 nop
			 movwf	FlipDty
		 end_m

	nop
	nop
	nop



 	goto	main-5
	
	end_m

		end