;***********************************************************************
;*   This file is the firmware to implement a AC lamp dimmer, based on *
;*   the PIC10F200.  It monitors the zero crossing of the AC waveform  *
;*   and pulses the gate of a TRIAC appropriately for dimming an AC    *
;*   lamp.                                                             *
;*                                                                     *
;*   Intenisty control is accomplished through  up and down button     *
;*                                                                     *
;*                                                                     *
;*   GPIO 0 up Intensity
;*   GPIO 1 down Intensity                                             *
;*   GPIO 2 triac output driver                                        *
;*                   *
;*                                                                     *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Filename:	    dimmer202.asm                                         *
;*    Date:         Januar, 2007                                    *
;*    File Version: A.0                                                *
;*                                                                     *
;*    Author:       g michael                                      *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:    macros.inc                                              *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:                                                           *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************

	#include p10f202.inc
	#include macros.inc
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC

	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS

	cblock 0x08
		AL,AH,BL,IndeX			; Define all user varables starting at location 0x7
		SystemStatus			; byte that holds system flags
		PeriodReg
		TimeCounter:4
	
	endc

;******************************************************************************
;***** CONSTANT DEFINITIONS
 
#define Lo_Intensity	.200
#define Hi_Intensity	.3


;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	; goto error
#define 	TRISGPIO 	6

#define Up_Port		GPIO,0				; 
#define Down_Port	GPIO,1				; 
#define	FET_Gate_Port	GPIO,2				; 
#define Power_On_Port	GPIO,3				; 

undoreset			
 
	movlw	b'11111011'	; configure FET_Gate_Port  as output GPIO0,1,3 are input
	TRIS 	TRISGPIO
	movlw	B'11001000'	; PIN wakeup disable, weak pullup disabled
				; Timer0 internal clock, clock 64:1 , WDT 1:1 ,
;				bit 3 PSA: Prescaler Assignment bit
;				1 = Prescaler assigned to the WDT
;				0 = Prescaler assigned to Timer0
;				bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				Bit Value	Timer0 Rate 	WDT Rate
;				000		1 : 2		1 : 1
;				001		1 : 4		1:2
;				010		1:8		1:4
;				011		1:16		1:8
;				100		1:32		1:16
;				101		1:64		1:32
;				110		1:128		1:64
;				111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	b'00000000'	; set all Outputs to Low Voltage
	
	movwf	GPIO

	call	undoreset
		
	IFDEF __10F204	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	
	goto 	MAIN

MAIN	clrf	SystemStatus
	movlw	.1
	movwf	TimeCounter
	movwf	TimeCounter+1
	movwf	TimeCounter+2
	movwf	TimeCounter+3
	incllll	TimeCounter, .60* .60 * .1634
	eq	PeriodReg, Lo_Intensity

startcycle 	incf	PeriodReg,W 		;5 .. 255=off
		skpnz
		 goto pwrlost
		bsf	FET_Gate_Port
		clrwdt
		movwf	IndeX
		nop
		bcf	FET_Gate_Port
		
					
		decfsz	TimeCounter,F
		 goto	nil
	
		decfsz	TimeCounter+1,F
		 goto	tstpower
		decfsz	TimeCounter+2,F
		 goto	nil-2
		incf	TimeCounter+1,F
		incf	TimeCounter,F
		incf	TimeCounter+2,F
		incf	TimeCounter+3,F
		goto	setlo
tstpower 	btfsc Power_On_Port
		 goto	nil-2
		movlw	.1
		movwf	TimeCounter
		movwf	TimeCounter+1
		movwf	TimeCounter+2
		movwf	TimeCounter+3
		skpeql	PeriodReg, Lo_Intensity
		 goto	setlo
		eq	PeriodReg, Hi_Intensity
		incllll	TimeCounter, .60* .60 * .41666
		goto setdone

setlo		incllll	TimeCounter, .60* .60 * .1634
		eq	PeriodReg, Lo_Intensity	
setdone		goto	pwrlost
	
		decf	IndeX,F
		decf	IndeX,F
		decf	IndeX,F
nil		decfsz	IndeX,F		;1
		 goto	$-1		;2,3 cycles
	
		goto	startcycle
	
	

afterpin	 
	decfsz	IndeX,F
	  goto $-1
	nop
	nop
	decfsz	IndeX,F
	 goto $-3
	btfsc Power_On_Port	; Power still on?
	 goto	startcycle	; resume after Power lost and regained
	goto pwrlost


afterwdt 

pwrlost 	
	movlw	B'01001000'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:1 , WDT 1:1 
	OPTION
	
	sleep				

	end
