;***********************************************************************
;*   This file is the firmware to implement a AC lamp dimmer, based on *
;*   the PIC10F200.  It monitors the zero crossing of the AC waveform  *
;*   and pulses the gate of a TRIAC appropriately for dimming an AC    *
;*   lamp.                                                             *
;*                                                                     *
;*   Intenisty control is accomplished through  up and down button     *
;*                                                                     *
;*                                                                     *
;*   GPIO 0 up Intensity
;*   GPIO 1 down Intensity                                             *
;*   GPIO 2 triac output driver                                        *
;*   GPIO 3 zero cross detection input the the circuit                 *
;*                                                                     *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Filename:	    dimmer202.asm                                         *
;*    Date:         Januar, 2007                                    *
;*    File Version: A.0                                                *
;*                                                                     *
;*    Author:       g michael                                      *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:                                                  *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:                                                           *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************

	#include p10f202.inc
	#include macros.inc
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC

	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS

	cblock 0x08
		AL,AH,BL,IndeX				; Define all user varables starting at location 0x7
		SystemStatus			; byte that holds system flags
		SleepTimer			; counts dead cycle to zero IntensiTy
		CounTer:3			; used for 4hr timer
		DeadCount		; holds IR low min time for decode
		CountsHalfCycle;:2		; holds time delay for triac startup
		StartupCount;:2			; temporary variable
		MaxTmr;:2			; maximal value btween 2 Z_cross
		IntensiTy
		ResulT:2
		K32,PlusT,MinusT
	endc

;******************************************************************************
;***** CONSTANT DEFINITIONS

#define Tmr0_Bit7	SystemStatus,7
#define	After_Pwrup	SystemStatus,6
#define Dun_Flag	SystemStatus,5			; interlock to prevent repeat of commands
#define Phase_Plus	SystemStatus,0			; used to determined if zerocross or IR data change

;***** 4 hour timer preset macro
four_hours	macro				; macro to load delay time for 4 hour timer
	movlw	0x00
	movwf	counter
	movlw	0x5E
	movwf	counter+1
	movlw	0x1A
	movwf	counter+2
	endm

;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	; goto error
#define 	TRISGPIO 	6

#define Rx_Enable_Port	GPIO,0				; enables IR receiver
#define Rx_Data_Port	GPIO,1				; carries IR receiver data input
#define	Triac_Gate_Port	GPIO,2				; active low triac drive
#define Z_Detect_Port	GPIO,3				; zero crossing input for Reset on Change

undoreset			
	;movlw	B'00001000'	; set direction bits; GPIO3 is input (high-z) GPIO0:2 are output 
	movlw	b'11111011'	; configure Triac_Gate_Port  as output
	TRIS 	TRISGPIO	
;	movlw	B'01000100'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal, clock 1:32 , WDT 1:1
				
	movlw	B'11000101'	; PIN wakeup disable, weak pullup disabled
				; Timer0 internal clock, clock 64:1 , WDT 1:1 ,
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	;movlw	b'00000000'	; set all Outputs to Low Voltage
	movlw	b'00000100'	; turn off the Triac_Gate_Port 
	movwf	GPIO

	call	undoreset
	
;comp	movlw	b'11110111'     ; configure comparator inputs as digital I/O
;	movwf	CMCON0		; comment instruction for PIC10F200 /202

	movlw	B'11001100'	; PIN wakeup disable, weak pullup disabled
				; Timer0 internal clock, clock 1:1 , WDT 1:16 ,
	OPTION	
	clrf	SystemStatus
	bsf	After_Pwrup	; wait 18*16 msec
	
	sleep			; at min consumption
					

;******************************************************************************


MAIN	eq	StartupCount, .35
	clrwdt			; 18ms time for GPIO3 to go up (9/10 msec expected)
	btfss	Z_Detect_Port
	 goto	$-1
	btfss	Z_Detect_Port	; test GPIO3 again (sort of debounce)
	 goto	$-4
startcycle
	clrwdt
	btfsc	Z_Detect_Port	; wait for falling edge
	 goto	$-1
	btfsc	Z_Detect_Port
	 goto $-4		; 2us debounce

	mov	StartupCount, IndeX		;Q3 wave

	clrwdt	
	decfsz	IndeX,F		;35*3 = 100us
	 goto	$-2
	eq	IndeX,0x08
	bcf	Triac_Gate_Port
	clrwdt
	decfsz	IndeX,F		;1
	 goto	$-1		;2,3 *8 =24us
	bsf	Triac_Gate_Port
	clrwdt
	btfss	Z_Detect_Port	;wait until TMR0 o/f
         goto	$-1		;movfw	CountsHalfCycle
	btfss	Z_Detect_Port	;subwf	TMR0,W
	 goto	$-4		;skpz
	 nop			; goto $-3
	nop
	nop
	clrwdt
	decfsz	IndeX,F
	 goto	$-5		; 7*256 =1792
	eq	IndeX,0x08
	bcf	Triac_Gate_Port
	clrwdt
	decfsz	IndeX,F
	 goto	$-1
	bsf	Triac_Gate_Port
	clrwdt
	btfsc	Z_Detect_Port	
         goto	$-1
	btfsc	Z_Detect_Port
	 goto	$-4
	movf	DeadCount,F
	skpz
	 goto startcycle
	decfsz	DeadCount,F
	 goto	startcycle
	btfsc	GPIO,0
	 goto	testGPIO1
 	 incfsz StartupCount,W	;max 255
	  incf	StartupCount,F
	 goto debouncecount
testGPIO1
	btfss	GPIO,1
	 goto startcycle
	movf	StartupCount,f
	skpz
	 decf	StartupCount,f
debouncecount	eq 	DeadCount, .50

		
	goto	startcycle





afterpin goto	MAIN		; resume after Power lost and regained
	


afterwdt btfss	After_Pwrup
	  goto	pwrlost
	 bcf	After_Pwrup	; resume after initial sleep

	goto	MAIN
pwrlost
	movlw	B'01001111'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:1 , WDT 1:128, (power will be off before that)
	OPTION	
	sleep				

	end
