;***********************************************************************
;*   This file is the firmware to implement a LEDlamp dimmer, based on *
;*   the PIC10F200.  The program will produce a 4 microsecond pulse on *
;*   followed by a 773 microsecond pause- a frequncy of1.29kHz with a  *
;*   duty cycle of 0.51%.                 If the power is lost for a   *
;*   shorter period than the capacitor can supply sleep energy, the    *
;*   timing will be toggled  to 4 microseconds on and 23 microsecnds   *
;*   off- a frequency of 37 kHz with a duty cycle of 14.8%             *
;*   After 1 hour the device will go to first  state and               *
;*   after another hour produce no more pulses                         *
;*   GPIO2 is used as MOSFET output driver                             *
;*   GPIO3 as power monitor input                                      *
;*                                                                     *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Filename:	    10F202HI-LED.asm                                   *
;*    Date:         March, 2007                                        *
;*    File Version: A.0                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:    macros.inc                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes: program uses sleep modus and wake up on pin change        *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************

	;#include p10f202.inc
	;#include macros.inc
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC

	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS

	cblock 0x10
		AL,AH,BL			; Define all user varables starting at location 0x10 for 10F200
		SystemStatus			; byte that holds system flags
		PeriodReg
		DutyTime
		PeriodCounter
		TimeCounter:4
		
	endc
	IFDEF __10F202
	cblock 0x08
	 
	endc
	ENDIF

;******************************************************************************
;***** CONSTANT DEFINITIONS
 
#define Lo_Intensity	.254
#define Hi_Intensity	.3


;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	; goto error
#define 	TRISGPIO 	6

#define Up_Port		GPIO,0				; 
#define Down_Port	GPIO,1				; 
#define	FET_Gate_Port	GPIO,2				; 
#define Power_On_Port	GPIO,3				; 

undoreset			
 
	movlw	b'11111011'	; configure FET_Gate_Port  as output GPIO0,1,3 are input
	TRIS 	TRISGPIO
	movlw	B'11001000'	; PIN wakeup disable, weak pullup disabled
				; Timer0 internal clock, clock 64:1 , WDT 1:1 ,
;				bit 3 PSA: Prescaler Assignment bit
;				1 = Prescaler assigned to the WDT
;				0 = Prescaler assigned to Timer0
;				bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				Bit Value	Timer0 Rate 	WDT Rate
;				000		1 : 2		1 : 1
;				001		1 : 4		1:2
;				010		1:8		1:4
;				011		1:16		1:8
;				100		1:32		1:16
;				101		1:64		1:32
;				110		1:128		1:64
;				111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	b'00000000'	; set all Outputs to Low Voltage
	movwf	GPIO

	call	undoreset
		
	IFDEF __10F204	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	
	goto 	MAIN	



inclo	eq	PeriodReg, Lo_Intensity
	eeeeq	TimeCounter,  (.3600 * .1634) +  0x01010101
	eq	DutyTime,.1
	retlw	0

inchi	eq	PeriodReg, Hi_Intensity
	eeeeq	TimeCounter,  (.3600 * .41666) + 0x01010101
	eq	DutyTime,.1
	retlw 0

MAIN	clrf	SystemStatus

	call	inclo

startcycle 	incf	PeriodReg,W 		;5 .. 255=off
		skpnz
		 goto pwrlost
		movwf	PeriodCounter
		mov	DutyTime,DutyCounter
		bsf	FET_Gate_Port
		decfsz	DutyCounter
		 goto	$-1
		bcf	FET_Gate_Port
		
					
		decfsz	TimeCounter,F
		 goto	nil
	
		decfsz	TimeCounter+1,F
		 goto	tstpower
		decfsz	TimeCounter+2,F
		 goto	nil-2
		decfsz	TimeCounter+3,F
		 goto	nil-3
		
decintens	skpeql	PeriodReg, Hi_Intensity
		 goto pwrlost
		call	inclo
		goto	nil-3
	
tstpower 	btfsc Power_On_Port
		 goto	nil-2
		skpeql	PeriodReg, Hi_Intensity
		 goto	sethi
		call	inclo
		goto pwrlost

sethi		call	inchi
		goto	pwrlost

		decf	PeriodCounter,F
		decf	PeriodCounter,F
		decf	PeriodCounter,F
nil		decfsz	PeriodCounter,F		;1
		 goto	$-1		;2,3 cycles
	
		goto	startcycle
	
	

afterpin	 
	decfsz	PeriodCounter,F
	  goto $-1
	nop
	nop
	decfsz	PeriodCounter,F
	 goto $-3
	btfsc Power_On_Port	; Power still on?
	 goto	startcycle	; resume after Power lost and regained
	goto pwrlost


afterwdt 

pwrlost 	
	movlw	B'01001000'	; PIN wakeup en-able, weak pullup disabled
				; Timer0 internal clock, clock 1:1 , WDT 1:1 
	OPTION
	
	sleep				

	end
