;***********************************************************************
;*   This file is the firmware to implement a LEDlamp dimmer, based on *
;*   the PIC10F200.  The program will produce a 4 microsecond pulse on *
;*   followed by a 773 microsecond pause- a frequncy of1.29kHz with a  *
;*   duty cycle of 0.51%.                 If the power is lost for a   *
;*   shorter period than the capacitor can supply sleep energy, the    *
;*   timing will be toggled  to 4 microseconds on and 23 microsecnds   *
;*   off- a frequency of 37 kHz with a duty cycle of 14.8%             *
;*   After 1 hour the device will go to first  state and               *
;*   after another hour produce no more pulses                         *
;*   GPIO2 is used as MOSFET output driver                             *
;*   GPIO3 as power monitor input                                      *
;*                                                                     *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Filename:	    10F202HI-LED.asm                                   *
;*    Date:         March, 2007                                        *
;*    File Version: A.0                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:    macros.inc                                    *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes: program uses sleep modus and wake up on pin change        *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************

	#include p10f206.inc
	#include macros.inc
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC

	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS

	cblock 0x10
		AL,BtDownCount			;  user varables starting at location 0x10 for 10F200
		SystemStatus			;  flags
		PeriodReg
		DutyTime
		MaxTmr
		PeriodCounter
		TimeCounter:4
		
	endc
	IFDEF __10F202
	cblock 0x08
	 
	endc
	ENDIF

;******************************************************************************
;***** CONSTANT DEFINITIONS
 
#define Lo_Intensity	.254
#define Hi_Intensity	.3
#define But_Down	SystemStatus,0
#define	Bt_Down_Oflw	SystemStatus,1
#define	Tmr0_Bit7	SystemStatus,7

;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	; goto error
#define 	TRISGPIO 	6

#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111001'	; configure P+NFET_Gate_Port as output 
#define	NFET_Gate_Port	GPIO,1				; 
 
#define	C10N_Port	GPIO,0				;
#define iodirC10	b'11111000'	; configure C10Port output
 
#define Power_On_Port	GPIO,3				; 
#define Button_On_Port	GPIO,3	
undoreset			
 
	movlw	iodir		; configure FET_Gate_Port  as output GPIO0,1,3 are input
	TRIS 	TRISGPIO
	movlw	B'11000111'	; PIN wakeup disable, weak pullup disabled
				; Timer0 internal clock, clock 1:1 , WDT 1:1 ,
;				bit 3 PSA: Prescaler Assignment bit
;				1 = Prescaler assigned to the WDT
;				0 = Prescaler assigned to Timer0
;				bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				Bit Value	Timer0 Rate 	WDT Rate
;				000		1 : 2		1 : 1
;				001		1 : 4		1:2
;				010		1:8		1:4
;				011		1:16		1:8
;				100		1:32		1:16
;				101		1:64		1:32
;				110		1:128		1:64
;				111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set all Outputs to Low Voltage
	movwf	GPIO

	call	undoreset
		
	IFDEF __10F204	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	
	goto 	MAIN	



inclo	eq	PeriodReg, Lo_Intensity
	eeeeq	TimeCounter,  0x01080101
	eq	DutyTime,.1
	retlw	0

inchi	eq	PeriodReg, Hi_Intensity
	eeeeq	TimeCounter, 0x01000101
	eq	DutyTime,0
	retlw 0
us1impuls bsf	NFET_Gate_Port		; NFET or Transistor on
	bcf	NFET_Gate_Port		; NFET or Transistor off
	goto timouter
us2impuls bsf	NFET_Gate_Port		; NFET or Transistor on
	nop
	bcf	NFET_Gate_Port		; NFET or Transistor off
	goto timouter
us4impuls bsf	NFET_Gate_Port		; NFET or Transistor on
	nop
	nop
	nop
	bcf	NFET_Gate_Port		; NFET or Transistor off
	goto timouter
intervall 	btfss	TMR0,7
		 goto	$+5
		btfsc	Tmr0_Bit7
		 goto	noflip			; both set
		bsf	Tmr0_Bit7			;
		goto	noflip
		btfss	Tmr0_Bit7
		 goto	noflip			; both not set
		bcf	Tmr0_Bit7
		incf	MaxTmr,F		; change from high to low eg FF to 00
	

noflip	btfss	MaxTmr,5
	 goto timouter
	bsf	NFET_Gate_Port		; NFET or Transistor on
	nop
	nop
	nop
	nop
	bcf	NFET_Gate_Port		; NFET or Transistor off
	goto timouter

MAIN	clrf	SystemStatus
	clrf	BtDownCount
	call	inchi
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
startcycle	decfsz	PeriodCounter,F		;1
		 goto	$-1		;2,3 cycles

		mov	PeriodReg,PeriodCounter
		movfw	DutyTime
		addwf	PCL,F
		 goto	us1impuls
		 goto	us2impuls
		 goto	us4impuls
		 goto	intervall

					
timouter		decfsz	TimeCounter,F
		 goto	startcycle-9
	
		decfsz	TimeCounter+1,F		;1
		 goto	tstport
		decfsz	TimeCounter+2,F
		 goto	startcycle-5
		decfsz	TimeCounter+3,F
		 goto	startcycle
		goto	pwrlost

tstport		btfsc	Button_On_Port
		 goto	tstifup			; wait for button
		bsf	But_Down
		btfss	Bt_Down_Oflw		; wait for long button
	         goto	addpreg

		 goto	startcycle
	
tstifup		btfss	But_Down
		 goto	startcycle-1
		bcf	But_Down		; button was down
		clrf	BtDownCount
		btfsc	Bt_Down_Oflw
		 goto	longbut			
;***********************************************************************
				; short button
		
		incfsz	PeriodReg,W
		 incf	PeriodReg,F
		goto	startcycle
decduty		decf	DutyTime,F		
		goto	startcycle

;***********************************************************************
longbut		bcf	Bt_Down_Oflw
;		skpeql	PeriodReg,Hi_Intensity
;		 goto	decperiod		; long
;		incfsz	DutyTime,W
		incf	DutyTime,F
		movlw	.3
		andwf	DutyTime,F
		goto	startcycle
decperiod	;mov	Hi_Intensity,PeriodReg
		decf	PeriodReg,F	
		goto	startcycle


addpreg		movfw	PeriodReg	
		addwf	BtDownCount,F
		skpC
		 goto	startcycle
		bsf	Bt_Down_Oflw
		goto	startcycle

tstvoltage	bcf	C10N_Port
		movlw	iodirC10	; GPIO1 is output
		TRIS 	TRISGPIO	; discharge C
		clrf	AL
		goto	$+1		; 6 us
		clrwdt
		movlw	iodir		;  GPIO1 is input
		TRIS 	TRISGPIO	; charge C
	if C10N_Port ==	"GPIO,1"
		movlw	b'11111001'     ; configure comparator input=off
	endif
	if C10N_Port ==	GPIO,0
		movlw	b'11111011'     ; configure comparator input=off
	endif

		movwf	CMCON0	
loop		btfsc	CMCON0,7
		 goto	exitloop
		incfsz	AL,F
		 goto	loop		;timeout 1000us	
		decf	AL,F	
		;results on 100pF
exitloop	bcf	CMCON0,3	;comparator off
					;results on 10nF
					; <0x50	battery too high
		skplel	AL,0x60		; 0x50 <0x60 1us impuls
		 goto g70
		eq	DutyTime,.0
		goto startcycle
g70		skplel	AL,0x70		cs; 0x60 <0x70 2us
		 goto g80
		eq	DutyTime,.1
		goto startcycle
g80		skplel	AL,0x80
		 goto gr80
		eq	DutyTime,.2	; 0x70 <0x80 4us
		goto	startcycle		; >0x80	warning blinker
gr80		eq	DutyTime,.3
		goto	startcycle			

	
	

afterpin	 
	decfsz	PeriodCounter,F
	  goto $-1
	nop
	nop
	decfsz	PeriodCounter,F
	 goto $-3
	btfsc Power_On_Port	; Power still on?
	 goto	startcycle	; resume after Power lost and regained
	goto pwrlost


afterwdt 

pwrlost 	
	movlw	B'01001000'	; PIN wakeup en-able, weak pullup disabled
				; Timer0 internal clock, clock 1:1 , WDT 1:1 
	OPTION
	
	sleep				

	end
