;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 4 microseconds at                                       *
;*   GPIO 2 Transistor output driver                                   *
;*   from a 30 seconds pulse at                                        *
;*   GPIO3 Input                                                       *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Filename:	    pir_dimmer-led.asm                                 *
;*    Date:         Januar, 2007                                       *
;*    File Version: A.0                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros.inc                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:  on every pulse on GPIO3                                  *
;*            pause width will start with 620 microseconds             *
;*            and ramp down to 23 microseconds, wait for 7 minutes  *
;*            and ramp up to  620 microseconds to go off               *
;*                                                                     *
;*                                                                     *
;***********************************************************************
	list      p=10F206	; list directive to define processor
	#include <p10f206.inc>	; processor specific variable definitions

	#include macros.inc
;	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC	; with charger
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without charger
	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS

	cblock 0x10
		AL,AH,BL,IndeX			; variables starting at  0x10
		SystemStatus			; flags
		PeriodReg			; intensity
		TimeCounter:3			; 
		;LatenCy:3			; Time to wait for next PIR
		UprampTime:2
		
	endc

	IFDEF __10F202
	cblock 0x08				; var starting at  0x08
	 
	endc
	ENDIF

	IFDEF __10F206
	cblock 0x08				; var starting at  0x08
	 
	endc
	ENDIF
		

;******************************************************************************
;***** CONSTANT DEFINITIONS
#define TRISGPIO 	6		; well...
#define PFET_Gate_Port	GPIO,2		; 
#define	NFET_Gate_Port	GPIO,1		; 
#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111001'	; configure P+NFET_Gate_Port as output 
					;		     GPIO0,3 are input
#define PIR_On_Port	GPIO,3		; 

#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6

#define	Back_On		SystemStatus,5
#define Went_Off	SystemStatus,4	; 
#define	Up_Again	SystemStatus,3
#define Lo_Intensity	.200
#define Hi_Intensity	.4

;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	
	GOTO	PWRUP		; goto error



undoreset			
 
	movlw	iodir
	TRIS 	TRISGPIO
	movlw	B'01001000'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:1 , WDT 1:1 ,
;				;bit 3 PSA: Prescaler Assignment bit
;				;1 = Prescaler assigned to the WDT
;				;0 = Prescaler assigned to Timer0
;				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				;Bit Value	Timer0 Rate 	WDT Rate
;				;000		1 : 2		1 : 1
;				;001		1 : 4		1:2
;				;010		1:8		1:4
;				;011		1:16		1:8
;				;100		1:32		1:16
;				;101		1:64		1:32
;				;110		1:128		1:64
;				;111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set NFET to LOW , PFET  to HIGH Voltage 
	movwf	GPIO

	call	undoreset	; TRIS + OPTION

	IFDEF __10F204	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	
	
prepslp				; wait for PIR to go UP
	sleep			; at min consumption
					

;******************************************************************************
resetT	movlw	.1
	movwf	TimeCounter
	movwf	TimeCounter+1
	movwf	TimeCounter+2
	retlw	0

MAIN	eq	PeriodReg, Lo_Intensity	;start with intensity
	call 	resetT			; Timer := 0 (triple1)		
	eeq	UprampTime, .3000/.640	; delay before increase intensity = 3000 us = 3ms
	clrf	SystemStatus		; all flags down
	bsf	Ramp_Running		; 
	bcf	Down_Running		; ramp is running up
					; eeeq	LatenCy,(.1111111)+0x010101
	incc	TimeCounter, UprampTime

cycle  incf	PeriodReg,W 		; 5 .. 255=off
	skpnz
	 goto	prepslp			; goto sleep, wait for next PIR to go UP

	bsf	NFET_Gate_Port		; NFET or Transistor on
	movwf	IndeX
	nop
	nop				; 4 us
	bcf	NFET_Gate_Port		; and off

	decfsz	TimeCounter,F
	 goto	nil
	decfsz	TimeCounter+1,F
	 goto	tstport			; 7msec to 158ms check input
	decfsz	TimeCounter+2,F
	 goto	nil-2
	incf	TimeCounter+2,F		; TimeCounter stops at triple ONE 
	incf	TimeCounter+1,F		;
	incf	TimeCounter,F		; Timeout 256*256*256 cylces of 27us
	btfss	Ramp_Running		; Ramp_Running	  Down_Running 
	 goto	endlatency		;       1     		0				     
	btfsc	Down_Running		;					
	 goto	down			;
	skpeql	PeriodReg,Hi_Intensity	; end upramp
	 goto	decPR2			;
	bcf	Ramp_Running		; end ramp 
	clrf	TimeCounter+2 		; bsf	Latency_Running		;
	;movvv	LatenCy,TimeCounter	; 
	goto	nil-3			;

decPR2	decf	PeriodReg,F		; PR2 =-1 > brighter
	incll	UprampTime,.1		;
	incc	TimeCounter,UprampTime	; 
	goto	nil-4			;
 
down	skpeql	PeriodReg,Lo_Intensity	; 
	 goto	incPR2
	goto	prepslp			; goto sleep

incPR2	incf	PeriodReg,F		; PR2 +=1 >dimmer
	decll	UprampTime,.7
	incc	TimeCounter,UprampTime
	goto	nil-4
endlatency
	btfsc	Back_On
	 goto	latrunning
	bsf	Ramp_Running
	bsf	Down_Running
	eeq	UprampTime, .50000/.27	; delay before decrease intensity = 50000 us = 50ms
	goto	nil-4
tstport					;Went_Off  PIR_On_Port
	btfsc	PIR_On_Port		;   0          1         no action
	 goto	tstupagain		;              0         went_off = 1
	bsf	Went_Off		;   1          1         inc latency ,back_on=1
	goto	nil-2
tstupagain
	btfss	Went_Off
	 goto	nil-3
	bcf	Went_Off
				;inclll	LatenCy,.20000000/.27
	bsf 	Back_On
	btfss	Ramp_Running
	 goto	latrunning
	bcf	Down_Running
	goto	nil-4			;
latrunning
	clrf	TimeCounter+2 	;movvv	LatenCy,TimeCounter
	bcf	Back_On
	decf	IndeX,F
	decf	IndeX,F
	decf	IndeX,F
	decf	IndeX,F
nil	decfsz	IndeX,F			;1
	 goto	$-1			;2,3 cycles
	clrwdt
	goto	cycle

afterwdt
	bcf	PFET_Gate_Port
	decfsz	IndeX,F
	  goto $-1
	bsf	PFET_Gate_Port
	sleep
afterpin 	 
	decfsz	IndeX,F
	  goto $-1
	btfsc PIR_On_Port	; PIR still on?
	 goto	MAIN		; 
	sleep			; too small PIR-Signal, or Change to OFF
	

	end
