;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 4 microseconds at                                       *
;*   GPIO 2 Transistor output driver                                   *
;*   from a 30 seconds pulse at                                        *
;*   GPIO3 Input                                                       *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Filename:	    pir_dimmer-led.asm                                 *
;*    Date:         Januar, 2007                                       *
;*    File Version: A.0                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros.inc                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:  on every pulse on GPIO3                                  *
;*            pause width will start with 620 microseconds             *
;*            and ramp down to 23 microseconds, wait for 7 minutes  *
;*            and ramp up to  620 microseconds to go off               *
;*                                                                     *
;*                                                                     *
;***********************************************************************
	list      p=10F206	; list directive to define processor
	#include <p10f206.inc>	; processor specific variable definitions

	#include macros.inc
;	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC	; with charger
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without charger
	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS

	cblock 0x10
		AL_1,AL,AH,AH_1,BL,BH,IndeX			; variables starting at  0x10
		SystemStatus			; flags
		PeriodCounter
		PeriodReg			; intensity
		TimeCounter:3			; 
		BtDownCount			; time to wait for next button
		
		
	endc

	IFDEF __10F202
	cblock 0x08				; var starting at  0x08
	 
	endc
	ENDIF

	IFDEF __10F206
	cblock 0x08				; var starting at  0x08
	UR_1
	 UprampFrac
		UprampTime:3
	endc
	ENDIF
		

;******************************************************************************
;***** CONSTANT DEFINITIONS
#define TRISGPIO 	6		; well...
#define PFET_Gate_Port	GPIO,2		; 
#define	NFET_Gate_Port	GPIO,1		; 
#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111001'	; configure P+NFET_Gate_Port as output 
					;		     GPIO0,3 are input
#define Button_On_Port	GPIO,3		; 

#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6

#define	Bt_Down_Oflw		SystemStatus,5
#define But_Down	SystemStatus,4	; 
#define	Up_Again	SystemStatus,3
#define Lo_Intensity	.240
#define Hi_Intensity	.4

;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	
	GOTO	PWRUP		; goto error



undoreset			
 
	movlw	iodir
	TRIS 	TRISGPIO
	movlw	B'01001000'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:1 , WDT 1:1 ,
;				;bit 3 PSA: Prescaler Assignment bit
;				;1 = Prescaler assigned to the WDT
;				;0 = Prescaler assigned to Timer0
;				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				;Bit Value	Timer0 Rate 	WDT Rate
;				;000		1 : 2		1 : 1
;				;001		1 : 4		1:2
;				;010		1:8		1:4
;				;011		1:16		1:8
;				;100		1:32		1:16
;				;101		1:64		1:32
;				;110		1:128		1:64
;				;111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set GPIO Voltage 
	movwf	GPIO

	call	undoreset	; TRIS + OPTION

	IFDEF __10F204	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	
	
prepslp	goto MAIN			; wait for button to go UP
	sleep			; at min consumption
					

;******************************************************************************
resetT	movlw	.1
	movwf	TimeCounter
	movwf	TimeCounter+1

	clrf	TimeCounter+2		; 255*255*256*795us =1,07e10 =10770sec=179min=2h59min
	retlw	0

MAIN	eq	PeriodReg, Lo_Intensity	;start with intensity
	call 	resetT			; Timer := 0 (triple1)
	eeeq	UprampTime, (.20000/.795)	
					; delay before decrease intensity = 20000 us = 20ms
	clrff	UR_1
	clrf	BtDownCount	
	clrf	SystemStatus		; all flags down

cycle  incf	PeriodReg,W 		; 5 .. 255=off
	skpnz
	 goto	prepslp			; goto sleep, wait for next PIR to go UP

	bsf	NFET_Gate_Port		; NFET or Transistor on
	movwf	PeriodCounter
	nop
	nop				; 4 us
	bcf	NFET_Gate_Port		; and off

	decfsz	TimeCounter,F
	 goto	nil
	decfsz	TimeCounter+1,F
	 goto	tstport			; 7msec to 158ms check input
	decfsz	TimeCounter+2,F
	 goto	nil-2
					; Timeout 256*256*256 cylces of 27us 4,49 e8 us=449sec=7,5min
	btfss	Ramp_Running		; 
	 goto	endlatency		;      				     

	bcf	Ramp_Running
	incf	TimeCounter,F		; force tstport next cycle
	goto	nil-3			;

decPR2	decf	PeriodReg,F		; PR2 =-1 > brighter
	incll	UprampTime,.1		;
	incc	TimeCounter,UprampTime	; 
	goto	nil-4			;
 
;down	skpeql	PeriodReg,Lo_Intensity	; 
;	 goto	incPR2
;	goto	prepslp			; goto sleep
;
incPR2	incf	PeriodReg,F		; PR2 +=1 >dimmer
	decll	UprampTime,.7		; accelerate
	incc	TimeCounter,UprampTime
	goto	nil-4
;endlatency
;	btfsc	Back_On
;	 goto	latrunning
endlatency
	sleep
	bsf	Ramp_Running
	bsf	Down_Running
	eeeq	UprampTime, .50000/.27	; delay before decrease intensity = 50000 us = 50ms
	goto	nil-4

tstport	btfsc	Ramp_Running
	 goto	nil-1			; wait for timeout
	btfsc	Button_On_Port
	 goto	tstifup			; wait for button
	bsf	But_Down
	btfss	Bt_Down_Oflw		; wait for long button
         goto	addpreg
	skpneql	PeriodReg,Hi_Intensity	; stop at maximum
	 goto	nil-4
	decf	PeriodReg,F		; PR2 =-1 > brighter
	bsf	Ramp_Running
	btfsc	PeriodReg,7
	 goto	loinc
	mul16.8x8.8l UprampFrac, .1, .256  *  .1/.32 ; 
	goto	motime
loinc	btfss	PeriodReg,0
	 incf	UprampTime,F
motime	incf	UprampTime,W
	movwf	TimeCounter
	incf	UprampTime+1,W
	movwf	TimeCounter+1
	incf	UprampTime+2,W
	movwf	TimeCounter+2
	goto	nil-4

tstifup	btfss	But_Down
	 goto	nil -3
	bcf	But_Down		; button was down
	btfsc	Bt_Down_Oflw
	 goto	longbut			
	bsf	Ramp_Running		; short button
	bsf	Down_Running
longbut	bcf	Bt_Down_Oflw

	clrf	BtDownCount
	;call	resetT			; set maximum Timeout
	goto	nil-4

addpreg	movfw	PeriodReg	
	addwf	BtDownCount,F
	skpC
	 goto	nil-4
	bsf	Bt_Down_Oflw
	goto	nil-4
					; bdocount=0 , 
				; upramp button down, bdocount < 0,3   inc bdocount mit PR2
		; upramp button down, bdocount > 0,3  dec PR2
	bsf	Ramp_Running		; button up, bdocount < 0,3 inc PR2, downramp = true 
	bcf	Down_Running		; downramp true, button down   bdocount=0
	eeq	UprampTime, .3000/.640	; delay before increase intensity = 3000 us = 3ms
					; eeeq	LatenCy,(.1111111)+0x010101
	incc	TimeCounter, UprampTime

	decf	PeriodCounter,F
	decf	PeriodCounter,F
	decf	PeriodCounter,F
	decf	PeriodCounter,F
nil	decfsz	PeriodCounter,F			;1
	 goto	$-1			;2,3 cycles
	clrwdt
	goto	cycle

afterwdt
	bcf	PFET_Gate_Port
	decfsz	IndeX,F
	  goto $-1
	bsf	PFET_Gate_Port
	sleep
afterpin 	 
	decfsz	IndeX,F		;768 us
	  goto $-1
	btfss Button_On_Port	; button still on?
	 goto	MAIN		; 
	sleep			; too small Change to OFF
	

	end
