;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 4 microseconds at                                       *
;*   GPIO 2 Transistor output driver                                   *
;*   from a 30 seconds pulse at                                        *
;*   GPIO3 Input                                                       *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Filename:	    pir_dimmer-led.asm                                 *
;*    Date:         Januar, 2007                                       *
;*    File Version: A.0                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros.inc                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:  on every pulse on GPIO3                                  *
;*            pause width will start with 620 microseconds             *
;*            and ramp down to 23 microseconds, wait for 18 seconds    *
;*            and ramp up to  620 microseconds to go off               *
;*                                                                     *
;*                                                                     *
;***********************************************************************

	#include p10f204.inc
	#include macros.inc
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC

	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS

	cblock 0x10
		AL,AH,BL,IndeX			; Define all user varables starting at location 0x7
		SystemStatus			; byte that holds system flags
		PeriodReg
		TimeCounter:3			; all timings
		LatenCy:3			; Time to wait for next PIR
		UprampTime:2
		StartTimer0
	endc

	IFDEF __10F202
	cblock 0x08
	 
	endc
	ENDIF
		

;******************************************************************************
;***** CONSTANT DEFINITIONS

#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6

#define	Back_On		SystemStatus,5
#define Went_Off	SystemStatus,4		; 
#define	Up_Again	SystemStatus,3
#define Lo_Intensity	.200
#define Hi_Intensity	.4

;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	goto	PWRUP
	;btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 ;goto	afterwdt
	; goto error
#define 	TRISGPIO 	6

#define Up_Port		GPIO,0				; 
#define Down_Port	GPIO,1				; 
#define	FET_Gate_Port	GPIO,2				; 
#define PIR_On_Port	GPIO,3				; 

undoreset			
 
	movlw	b'11111011'	; configure FET_Gate_Port  as output GPIO0,1,3 are input
	TRIS 	TRISGPIO
	movlw	B'01001000'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:1 , WDT 1:1 ,
;				bit 3 PSA: Prescaler Assignment bit
;				1 = Prescaler assigned to the WDT
;				0 = Prescaler assigned to Timer0
;				bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				Bit Value	Timer0 Rate 	WDT Rate
;				000		1 : 2		1 : 1
;				001		1 : 4		1:2
;				010		1:8		1:4
;				011		1:16		1:8
;				100		1:32		1:16
;				101		1:64		1:32
;				110		1:128		1:64
;				111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	b'00000000'	; set all Outputs to Low Voltage
	
	movwf	GPIO

	call	undoreset


	
	IFDEF __10F204	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'11110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	
	
prepslp	;goto MAIN
	;movlw	B'01001000'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:1 , WDT 1:1 
	;OPTION
				; wait for PIR to go UP
	sleep			; at min consumption
					

;******************************************************************************
resetT	movlw	.1
	movwf	TimeCounter
	movwf	TimeCounter+1
	movwf	TimeCounter+2
	retlw	0

MAIN	eq	PeriodReg, Lo_Intensity
	call 	resetT
	eeq	UprampTime, .20000/.640
	clrf	SystemStatus				; 
	bsf	Ramp_Running
	bcf	Down_Running
	eeeq	LatenCy,(.1111111)+0x010101
	incc	TimeCounter, UprampTime

startcycle 
					;btfss	PIR_On_Port
	 				 ;goto	nil
	incf	PeriodReg,W 		;5 .. 255=off
	skpnz
	 goto	prepslp			; goto sleep, wait for next PIR to go UP

	bsf	FET_Gate_Port
	movwf	IndeX
	movfw	TMR0
	movwf	StartTimer0
	bcf	FET_Gate_Port

	decfsz	TimeCounter,F
	 goto	nil
	decfsz	TimeCounter+1,F
	 goto	tstport			; 7msec to 158ms check input
	decfsz	TimeCounter+2,F
	 goto	nil-2
	incf	TimeCounter+2,F		;TimeCounter stops at triple ONE 
	incf	TimeCounter+1,F
	incf	TimeCounter,F
	btfss	Ramp_Running		; Ramp_Running	  Down_Running Latency_Running	
	 goto	endlatency		;       1     		0				     
	btfsc	Down_Running		;					1
	 goto	down			;
	skpeql	PeriodReg,Hi_Intensity	;
	 goto	decPR2			;
endramp	bcf	Ramp_Running		;
;	bsf	Latency_Running		;
	movvv	LatenCy,TimeCounter	;  inc/dec p2
	goto	nil-3			;
decPR2	decf	PeriodReg,F		; gpio3 test
	incll	UprampTime,.7
	incc	TimeCounter,UprampTime	; 
	goto	nil-4		; 
down	skpeql	PeriodReg,Lo_Intensity		; 65k*p2
	 goto	incPR2
	goto	prepslp
incPR2	incf	PeriodReg,F		; gpio3 test
	decll	UprampTime,.7
	incc	TimeCounter,UprampTime
	goto	nil-4
endlatency
;	btfsc	Back_On
;	 goto	latrunning
	bsf	Ramp_Running
	bsf	Down_Running
;	bcf	Back_On
	goto	nil-4
tstport					;Went_Off Back_On PIR_On_Port
	btfsc	PIR_On_Port		;   0                 1         no action
	 goto	tstupagain		;                     0         went_off = 1
	bsf	Went_Off		;   1                 1         inc latency ,back_on=1
	goto	nil-2
tstupagain
	btfss	Went_Off
	 goto	nil-3
	bcf	Went_Off
	inclll	LatenCy,.20000000/.27

	btfss	Ramp_Running
	 goto	latrunning
	bcf	Down_Running
	goto	nil-4			;
latrunning
	movvv	LatenCy,TimeCounter
;	bcf	Back_On
	decf	IndeX,F
	decf	IndeX,F
	decf	IndeX,F
	decf	IndeX,F
nil	decfsz	IndeX,F		;1
	 goto	$-1		;2,3 cycles

	goto	startcycle





afterpin 	 
	decfsz	IndeX,F
	  goto $-1
	btfsc PIR_On_Port	; PIR still on?
	 goto	MAIN		; 
	sleep			; too small PIR-Signal, or Change to OFF
	

	end
