;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 4 microseconds at                                       *
;*   GPIO 2 Transistor output driver                                   *
;*   from a 30 seconds pulse at                                        *
;*   GPIO3 Input                                                       *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Filename:	    pir_dimmer-led.asm                                 *
;*    Date:         June, 2007                                       *
;*    File Version: A.0                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros.inc                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:  on every pulse on GPIO3                                  *
;*            pause width will start with 620 microseconds             *
;*            and ramp down to 23 microseconds, wait for 7 minutes  *
;*            and ramp up to  620 microseconds to go off               *
;*                                                                     *
;*                                                                     *
;***********************************************************************
	list      p=10F206	; list directive to define processor
	#include <p10f206.inc>	; processor specific variable definitions

	#include macros.inc
;	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC	; with charger
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without charger
;	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS
	IFDEF __10F206
	cblock 0x08				; var starting at  0x08
	 	UR_1
		UprampFrac
		UprampTime:3
		SecTimer
		BlinkFreq
	endc
	ENDIF
	
	cblock 0x10
		AL_1,AL,AH,AH_1,BL,BH
		PeriodCounter			; variables starting at  0x10
		SystemStatus			; flags
		PeriodReg			; intensity
		TimeCounter:3			; Time to wait for next PIR
		DutyCase,MaxTmr
	endc

	IFDEF __10F202
	cblock 0x08				; var starting at  0x08
	 
	endc
	ENDIF
		

;******************************************************************************
;***** CONSTANT DEFINITIONS
#define TRISGPIO 	6		; well...
					; 
#define	NFET_Gate_Port	GPIO,2		; 
#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111011'	; configure NFET_Gate_Port as output 
					;		     GPIO0,1,3 are input
#define PIR_On_Port	GPIO,3		; 

#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6

#define	Latency_Extend	SystemStatus,5
#define On_or_Off	SystemStatus,1
#define On_or_Offbit    0x01
#define Tmr0_Bit7	SystemStatus,0

#define Lo_Intensity	.240
#define Hi_Intensity	.1


;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	
	GOTO	PWRUP		; goto error



undoreset			
 
	movlw	iodir
	TRIS 	TRISGPIO
	movlw	B'01000111'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:256 , WDT 1:1 ,
;				;bit 3 PSA: Prescaler Assignment bit
;				;1 = Prescaler assigned to the WDT
;				;0 = Prescaler assigned to Timer0
;				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				;Bit Value	Timer0 Rate 	WDT Rate
;				;000		1 : 2		1 : 1
;				;001		1 : 4		1:2
;				;010		1:8		1:4
;				;011		1:16		1:8
;				;100		1:32		1:16
;				;101		1:64		1:32
;				;110		1:128		1:64
;				;111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set port to LOW  
	movwf	GPIO

	call	undoreset	; TRIS + OPTION

	IFDEF __10F204	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	

	eq	PeriodReg,Lo_Intensity	;test
	eq	DutyCase, 0x05		;test
	eq	BlinkFreq, 0x40		; 64*64ms
	eq SecTimer, 0xFF - .70		; come back in 5 seconds

	goto	MAIN			;test

prepslp				; wait for PIR to go UP
 	decfsz	PeriodCounter,F
	  goto $-1
;	incf	DutyTime,F	;test
;	movlw	0x03		;test
;	andwf	DutyTime,F	; test

	goto afterpin		; test
	sleep			; at min consumption
					

;******************************************************************************

us1impuls 	bsf	NFET_Gate_Port		; NFET or Transistor on
		bcf	NFET_Gate_Port		; NFET or Transistor off
		goto timouter

us2impuls 	bsf	NFET_Gate_Port		; NFET or Transistor on
		nop
		bcf	NFET_Gate_Port		; NFET or Transistor off
		goto timouter
us3impuls 	bsf	NFET_Gate_Port		; NFET or Transistor on
		GOTO $+1
		bcf	NFET_Gate_Port		; NFET or Transistor off
		goto timouter

us4impuls 	bsf	NFET_Gate_Port		; NFET or Transistor on
		GOTO $+1
		nop
		bcf	NFET_Gate_Port		; NFET or Transistor off
		goto timouter
us5impuls 	bsf	NFET_Gate_Port		; NFET or Transistor on
		GOTO $+1
		GOTO $+1
		bcf	NFET_Gate_Port		; NFET or Transistor off
		goto timouter

intervall 
istart		btfsc	Ramp_Running
		 goto	flip
		btfss	TMR0,7
		 goto	$+5
		btfsc	Tmr0_Bit7
		 goto	noflip			; both set
		bsf	Tmr0_Bit7			;
		goto	noflip			; change from lo to hi
		btfss	Tmr0_Bit7
		 goto	noflip			; both not set
		bcf	Tmr0_Bit7
		incfsz	SecTimer,F
		 goto 	$+2		; 256*256*70 = 5 sec
		 nop; goto	afterpin
noflip		btfss	On_or_Off		; 32*256
		 goto timouter
flip		bsf	NFET_Gate_Port		; NFET or Transistor on
;		nop
;		nop
;		nop
;		nop
		bcf	NFET_Gate_Port		; NFET or Transistor off
		goto timouter



MAIN	eeeq	UprampTime, 0xFF0000;   .1	
	clrf	SystemStatus				; 
	;bsf	Ramp_Running
	bcf	Down_Running
	
	goto	motime


		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
startcycle	;decfsz	PeriodCounter,F		;1 no test
		 ;goto	$-1		;2,3 cycles no test
		;mov	PeriodReg,PeriodCounter
		
		movfw	MaxTmr	
		subwf	TMR0,W		;w=TimerTick-timr0
		andlw	b'11111000'		;slack 7*256 cycles
		SKPZ
		 goto istart
		inc	MaxTmr,BlinkFreq
		decfsz	PeriodCounter
                 goto	istart
		mov	PeriodReg,PeriodCounter
		movlw	On_or_Offbit
		xorwf	SystemStatus,F
		
istart		btfss	On_or_Off
		 goto	timeouter
		movfw	DutyCase
		addwf	PCL,F
		 goto	us1impuls
		 goto	us2impuls
		 goto	us3impuls
		 goto	us4impuls
		 goto	us5impuls
		 goto	intervall

					
timouter	;	clrf	TMR0  Test
		decfsz	TimeCounter,F
		 goto	startcycle-9		;goto 	tstport
		decfsz	TimeCounter+1,F		;
		 goto 	startcycle-7	
		decfsz	TimeCounter+2,F
		 goto startcycle-5
		goto prepslp

	btfss	Ramp_Running		; Ramp_Running	  Down_Running 
	 goto	endlatency		;       1     		0				     
	btfsc	Down_Running		;					
	 goto	down			;


;********************************** ramp up
	skpeql	PeriodReg,Hi_Intensity	;
	 goto	decPR2			;
endramp		bcf	Ramp_Running		;
		eeeq	UprampTime,0x0B0000		;	bsf	Latency_Running		;
		goto	motime
decPR2	decf	PeriodReg,F		; PR2 -=1 brighter
	btfss	PeriodReg,7
	 goto	loinc
	goto	motime
loinc	inclll	UprampTime,.5;	mul16.8x8.8l UprampFrac, .1, .256  *  .1/.32 ;
	btfsc	PeriodReg,6
	 goto	motime
      inclll	UprampTime,.7

		goto motime
;***********************************************
down	skpeql	PeriodReg,Lo_Intensity	; 
	 goto	incPR2
	goto	prepslp
incPR2	incf	PeriodReg,F		; PR2 +=1 dimmer
	declll	UprampTime,.6		; decrease delta ramptime = accelerate
	goto	motime

;********************************************************************
		
tstport		nop;btfss	PIR_On_Port	;   0          1         no action
	 	 goto	startcycle-6
		bcf	Down_Running	; always upramp
		btfsc	Ramp_Running
		 goto	startcycle-4
		bsf	Latency_Extend
		goto	startcycle-1

	bcf	Latency_Extend
motime	incf	UprampTime,W
	movwf	TimeCounter
	incf	UprampTime+1,W
	movwf	TimeCounter+1
	incf	UprampTime+2,W
	movwf	TimeCounter+2
	; 
	goto	startcycle	; 

endlatency btfsc Latency_Extend
	    goto motime-1	
	bsf	Ramp_Running
	bsf	Down_Running
	eeeq	UprampTime, .50000/.27  ; delay before decrease intensity = 50000 us = 50ms	
	goto	motime		


afterwdt
;	bcf	PFET_Gate_Port
;	decfsz	PeriodCounter,F
;	  goto $-1
;	bsf	PFET_Gate_Port
	goto prepslp


#define	P100_Port	0				;
#define GP1_Porton	b'01110001'     ; configure comparator input=on
#define GP0_Porton	b'01110011'     ; configure comparator input=on, int ref, GP0


afterpin	goto	$+1
	decfsz	PeriodCounter,F
	  goto $-2
	btfss PIR_On_Port	; PIR still on?
	 nop;goto prepslp			; too small PIR-Signal, or Change to OFF
	nop
		if P100_Port
		movlw	GP1_Porton     ; configure comparator input
		else
		movlw	GP0_Porton
		endif
		movwf	CMCON0		; 
	
				;bit 7 bit 0
				;bit 7 CMPOUT: Comparator Output bit
				;1 = VIN+ > VIN-
				;0 = VIN+ < VINbit
				;6 COUTEN: Comparator Output Enable bit(1, 2)
				;1 = Output of comparator is NOT placed on the COUT pin
				;0 = Output of comparator is placed in the COUT pin
				;bit 5 POL: Comparator Output Polarity bit(2)
				;1 = Output of comparator not inverted
				;0 = Output of comparator inverted
				;bit 4 CMPT0CS: Comparator TMR0 Clock Source bit(2)
				;1 = TMR0 clock source selected by T0CS control bit
				;0 = Comparator output used as TMR0 clock source
				;bit 3 CMPON: Comparator Enable bit
				;1 = Comparator is on
				;0 = Comparator is off
				;bit 2 CNREF: Comparator Negative Reference Select bit(2)
				;1 = CIN- pin(3)
				;0 = Internal voltage reference
				;bit 1 CPREF: Comparator Positive Reference Select bit(2)
				;1 = CIN+ pin(3)
				;0 = CIN- pin(3)
				;bit 0 CWU: Comparator Wake-up on Change Enable bit(2)
				;1 = Wake-up on comparator change is disabled
				;0 = Wake-up on comparator change is enabled.
				;Note 1: Overrides T0CS bit for TRIS control of GP2.
		

		bcf	GPIO,P100_Port
		movlw	((1<< P100_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; discharge C
		eq	AL, .4		; 15 us
		decfsz	AL,F
		 goto	$-1		; 
		clrwdt
		movlw	iodir		;  GP,x is input
		TRIS 	TRISGPIO	; charge C
		bsf	CMCON0,3	; comparator on
		nop
loop100		btfsc	CMCON0,7
		 goto	exitp100
		eq	AH,.6		; 20 us steps
		decfsz  AH,F
		 goto	$-1
		incfsz	AL,F
		 goto	loop100		;timeout 5000us	
		decf	AL,F	
exitp100	bcf	CMCON0,3	;comparator off


		;skpgel	AL,0x50			; no test
		;  goto prepslp			; no test		; CDS too low, too bright
		movwf BlinkFreq	; 4-255		; test
		eq	PeriodReg,.20		; test 256 *255= 65ms *20 1300ms

#define	C10N_Port	1				;

tstvoltage	bcf	GPIO,C10N_Port
		if C10N_Port
		movlw	GP1_Porton     ; configure comparator input
		else
		movlw	GP0_Porton
		endif
		movwf	CMCON0	
		movlw	((1<< C10N_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; discharge C
		movlw	.4
		movwf	AL		; 15 us
		decfsz	AL,F
		 goto	$-1		; 
		clrwdt
		movlw	iodir		;  GP is input
		TRIS 	TRISGPIO	; charge C
		bsf	CMCON0,3	; comparator on
		nop
loop		btfsc	CMCON0,7
		 goto	exitloop
		incfsz	AL,F
		 goto	loop		;timeout 1000us	
		decf	AL,F	
		
exitloop	bcf	CMCON0,3	;comparator off
					;results on 100nF

		skplel	AL,0x58		; 0x50 <0x60 1us impuls
		 goto g70
		eq	DutyCase,.0
		goto MAIN
g70		skplel	AL,0x6E		; 0x60 <0x70 2us
		 goto g80
		eq	DutyCase,.1
		goto MAIN
g80		skplel	AL,0x78
		 goto	gr72
		eq	DutyCase,.2	; 0x70 <0x80 3us
		goto	MAIN		
gr72		skplel	AL,0x86
		 goto	gr76
		eq	DutyCase,.3	; 0x70 <0x80 4us
		goto	MAIN	
gr76		skplel	AL,0x90
		 goto	gr80
		eq	DutyCase,.4	; 0x70 <0x80 5us
		goto	MAIN		
	
gr80		eq	DutyCase,.5	; >0x80	warning blinker
		eq SecTimer, 0xFF - .70; come back in 5 seconds

		GOTO MAIN
	end
