;***********************************************************************
;*   This file is the firmware to implement a pause width modulated    *
;*   signal of 1..5 microseconds(depending on supply voltage 4.8-3V)   *
;*   at GPIO 2 Transistor output driver                                *
;*   from a 30 seconds pulse at  GPIO3                                 *
;*   GPIO1 Input needs 10nF to Vss and 220k (+2.7VZener) to Vdd        *
;*   Refer to the MPASM User's Guide for additional information on     *
;*   features of the assembler (Document DS33014).                     *
;*                                                                     *
;*   Refer to the respective PICmicro data sheet for additional        *
;*   information on the instruction set.                               *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    					                               *
;*                                                                     *
;*    File Version: A.1                                                *
;*                                                                     *
;*    Author:       g michael                                          *
;*                  Principal Applications Engineer                    *
;*    Company:      Michaels Prototype                                 *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Files required:   macros.inc                                     *
;*                                                                     *
;*                                                                     *
;*                                                                     *
;***********************************************************************
;*                                                                     *
;*    Notes:  on every pulse on GPIO3                                  *
;*            pause width will start with 620 microseconds             *
;*            and ramp down to 16 microseconds, wait for x minutes     *
;*            and ramp up to  620 microseconds to go off               *
;*                                                                     *
;*             
;  program consists of following elements
;  -initialize on power up, wake up on pin change (or wdt reset -not used)
;  -test battery voltage
;  -set upramp delay
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to decremented cycletime and desired ramp shape
;  -loop until maximum brightness
;  -set new (latency) delay
;  -check input, if on, set extend latency
;  -loop in pulse width modulation cycle until until latency expires
;  -set downramp delay
;  -check input, if on, goto 'set upramp delay'
;  -loop in pulse width modulation cycle until delay has expired
;  -adapt delay time to incremented cycletime and desired ramp shape
;  -loop until minimum brightness
;  -goto sleep, wait for wake up on pin change 	                       *
;***********************************************************************
	list      p=10F206	; list directive to define processor
	#include <p10f206.inc>	; processor specific variable definitions

	#include macros.inc
;	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _IntRC_OSC	; with charger
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC   ; without charger
;	ERRORLEVEL -306				; Get rid of banking messages...

;******************************************************************************
;***** VARIABLE DEFINITIONS
	IFDEF __10F206
	cblock 0x08				; var starting at  0x08
	 	UR_1
		UprampFrac
		UprampTime:3
		

	endc
	ENDIF
	
	cblock 0x10
		AL,AH,BL,BH
		PeriodCounter			; variables starting at  0x10
		SystemStatus			; flags
		PeriodReg			; intensity
		TimeCounter:3			; Time to wait for next PIR
		DutyCase,MaxTmr
	endc

	IFDEF __10F202
	cblock 0x08				; var starting at  0x08
	 
	endc
	ENDIF
		

;******************************************************************************
;***** CONSTANT DEFINITIONS
#define TRISGPIO 	6		; 10F200family speciality
					; 
#define	NFET_Gate_Port	GPIO,2		; 
#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111011'	; configure NFET_Gate_Port as output 
					;		     GPIO0,1,3 are input
#define PIR_On_Port	GPIO,3		; 

#define Ramp_Running	SystemStatus,7
#define Down_Running	SystemStatus,6

#define	Latency_Extend	SystemStatus,5
#define Tmr0_Bit7	SystemStatus,0
#define send_first	SystemStatus,0

#define Lo_Intensity	.240
#define Hi_Intensity	.1


;******************************************************************************
;***** RESET VECTOR AND START OF CODE
	;ORG     0xFF or 1xFF    ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	
	GOTO	PWRUP		; goto error



undoreset			
 
	movlw	iodir
	TRIS 	TRISGPIO
	movlw	B'01000111'	; PIN wakeup enable, weak pullup disabled
				; Timer0 internal clock, clock 1:256 , WDT 1:1 ,
;				;bit 3 PSA: Prescaler Assignment bit
;				;1 = Prescaler assigned to the WDT
;				;0 = Prescaler assigned to Timer0
;				;bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				;Bit Value	Timer0 Rate 	WDT Rate
;				;000		1 : 2		1 : 1
;				;001		1 : 4		1:2
;				;010		1:8		1:4
;				;011		1:16		1:8
;				;100		1:32		1:16
;				;101		1:64		1:32
;				;110		1:128		1:64
;				;111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set port to LOW  
	movwf	GPIO

	call	undoreset	; TRIS + OPTION

	IFDEF __10F204	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
	IFDEF __10F206	
	movlw	b'01110111'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	

;	eq	PeriodReg,Lo_Intensity	;test
;	eq	DutyCase, 0x00		;test
;	goto	MAIN			;test
;	goto	testcds			;test

	goto 	tstvoltage		; 1 ramp latency ramp cycle

prepslp				; wait for PIR to go UP
 	decfsz	PeriodCounter,F
	  goto $-1


	sleep			; at min consumption
					

;******************************************************************************

intervall 	btfsc	Ramp_Running
		 goto	timouter-2
		btfss	TMR0,7			; TMR0 overflow
		 goto	$+5			; replacement
		btfsc	Tmr0_Bit7
		 goto	noflip			; both set
		bsf	Tmr0_Bit7		;
		goto	noflip
		btfss	Tmr0_Bit7
		 goto	noflip			; both not set
		bcf	Tmr0_Bit7
		incf	MaxTmr,F		; overflow
	

noflip		btfss	MaxTmr,5
		 goto timouter

		goto timouter-2




decPR2	decf	PeriodReg,F		; PR2 -=1 brighter

	skpgel	PeriodReg,.13
	 goto	tblread
	eq	BL,.160		;128=18ms 255= 38ms
	movfw	PeriodReg
decsub	subwf	BL,F
	skpC	
	 goto	motime
	incfsz	UprampTime,F
	 goto	decsub
	incfsz	UprampTime+1,F
	 goto	decsub
	incf	UprampTime+2,F
	goto	decsub

tblread		call	readt
		addwf	UprampTime,F
		skpC
		 goto	motime
		incfsz	UprampTime+1,F
		 goto	motime
		incf	UprampTime+2,F
		goto	motime

readt		decf	PeriodReg,W
		addwf	PCL,F
		retlw	.255
		retlw	.210 /.1
		retlw	.210 /.2
		retlw	.210 /.3
		retlw	.210 /.4
		retlw	.210 /.5
		retlw	.210 /.6
		retlw	.210 /.7
		retlw	.210 /.8
		retlw	.210 /.9
		retlw	.210 /.10
		retlw	.210 /.11
		retlw	.210 /.12
		

	;	eq	AL,.1		; realtime division
	;	movfw	PeriodReg
	;	movwf	BH
	;	clrC
	;rotlef	btfsc	AL,7
	;	 goto	decsub
	;	movfw	AL		;works on first not zero byte
	;	subwf	PeriodReg,W
	;	skpC
	;	 goto	decsub
	;	rlf	BH,F		; and subsequent bytes
	;	rlf	AL,F		
	;	goto	rotlef
	;decsub	movfw	BH	
	;	subwf	BL,W		; and subsequent bytes
	;	skpC
	;         goto	rotrght
	;	movwf	BL
	;	movfw	AL
	;	addwf	UprampTime,F	;
	;	skpnC
	;	 incf	UprampTime+1,F
	;rotrght	clrc	
	;	rrf	AL,F
	;	movf	AL,F
	;	skpnz
	;	 goto motime
	;	rrf	BH,F
	;	goto	decsub	
	;;***********************************************
;	nop
;	nop
;	nop	
;	movfw	DutyCase
;startcycl	addwf	PCL,F
;		goto intervall
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port	
;		bsf	NFET_Gate_Port		
;		bsf	NFET_Gate_Port
;		bcf	NFET_Gate_Port
;					
;timoute		clrf	TMR0; test
;		decfsz	TimeCounter,F
;		 goto 	startcycl-3
;		decfsz	TimeCounter+1,F		;
;		 goto 	tstpor	
;		decfsz	TimeCounter+2,F
;		 goto startcycl-1
;		btfss	Latency_Extend
;		 goto	endlatency
;		bcf	Latency_Extend;
;		goto	startcycl
;tstpor		btfsc	PIR_On_Port	; 
;		 bsf	Latency_Extend
;		goto startcycl-1
;
;



MAIN	;eq	PeriodReg,Lo_Intensity
	clrfff	UprampTime	
	clrf	SystemStatus				; 
	bsf	Ramp_Running
	;bcf	Down_Running
	
	goto	motime


		nop
		nop
		nop
		nop
		nop
		nop
		nop
startcycle	movfw	PeriodReg
		movwf	PeriodCounter
		decfsz	PeriodCounter,F		;1
		 goto	$-1		;2,3 cycles

		movfw	DutyCase
		addwf	PCL,F
		 goto	intervall
		 bsf	NFET_Gate_Port		; NFET or Transistor on
		 bsf	NFET_Gate_Port		; NFET or Transistor on
		 bsf	NFET_Gate_Port		; NFET or Transistor on
		 bsf	NFET_Gate_Port		; NFET or Transistor on
		 bsf	NFET_Gate_Port		; NFET or Transistor on

		bcf	NFET_Gate_Port		; NFET or Transistor off
			
					
timouter	;clrf	TMR0			;  Test
		decfsz	TimeCounter,F
		 goto 	tstport
		decfsz	TimeCounter+1,F		;
		 goto 	startcycle-5	
		decfsz	TimeCounter+2,F
		 goto startcycle-3
						; timecounter expired
		btfss	Ramp_Running		; 
		 goto	endlatency		;      		     
		btfsc	Down_Running		; initialize downramp					
		 goto	down			;


;********************************** ramp up
		skpeql	PeriodReg,Hi_Intensity	;
		 goto	decPR2			;
						; ramp finished
						; 
endramp		bcf	Ramp_Running		; set latency time
		eeeq	UprampTime,0x400000	; 64*256*256*(PeriodReg*3+14) us
		goto	motime
;************************************************

down		skpneql	PeriodReg,Lo_Intensity	; 
		 goto	prepslp			; goto sleep
incPR2		incf	PeriodReg,F		; PR2 +=1 dimmer
		skpgel	PeriodReg,.13
		 goto	tbl
		movlw 	.6
		goto	tbl+1
tbl		call	readt
		subwf	UprampTime,F
		skpNC
		 goto	 motime
		movf	UprampTime+1,F
		skpnz
		 decf	UprampTime+2,F
		decf	UprampTime+1,F
		goto	motime
;************************************************	
;	eq	BL,.255			;128=18ms 255= 38ms
;	movfw	PeriodReg	
;incsub	subwf	BL,F
;	skpC
;	 goto	motime
;	dec	UprampTime,F
;	movf	UprampTime,F
;	skpnz
;	 decf	UprampTime+1,F
;	decf	UprampTime,F
;	goto	incsub
;	
;
;********************************************************************
endlatency 	btfsc Latency_Extend		; latency extended due to	
	    	 goto motime-1			; picked up PIR signal
		bsf	Ramp_Running
		bsf	Down_Running
		eeeq	UprampTime, .90000/.17  
		goto	motime			;
;********************************************************************
		
tstport		btfss	PIR_On_Port	; 
	 	 goto	startcycle-4
		btfsc	Down_Running	; 
		 goto	reverserun
		bsf	Latency_Extend	; latency running
		goto	startcycle

reverserun	bcf	Down_Running
		clrfff	UprampTime
		goto	decPR2


	bcf	Latency_Extend
motime	incf	UprampTime,W
	movwf	TimeCounter
	incf	UprampTime+1,W
	movwf	TimeCounter+1
	incf	UprampTime+2,W
	movwf	TimeCounter+2
	; 
	goto	startcycle	; 



afterwdt
;	bcf	PFET_Gate_Port
;	decfsz	PeriodCounter,F
;	  goto $-1
;	bsf	PFET_Gate_Port
	goto prepslp

;pause03		nop			;test
;		decfsz	BL,F		;test
;		 goto	$-2		;test
;		decfsz	BH,F		;test
;		goto	pause03		;test
;		retlw 0			;test
;

#define	P100_Port	0				;
#define GP1_Porton	b'01110001'     ; configure comparator input=on
#define GP0_Porton	b'01110011'     ; configure comparator input=on, int ref, GP0


afterpin	goto	$+1
		decfsz	PeriodCounter,F
	  	 goto $-2		;5*256 =1280us
		btfss PIR_On_Port	; notest PIR still on?
	 	 goto prepslp		; notest too small PIR-Signal, or Change to OFF


testcds		bcf	GPIO,P100_Port
		if P100_Port
		movlw	GP1_Porton     ; configure comparator input
		else
		movlw	GP0_Porton
		endif
		movwf	CMCON0		; 
	
				;bit 7 bit 0
				;bit 7 CMPOUT: Comparator Output bit
				;1 = VIN+ > VIN-
				;0 = VIN+ < VINbit
				;6 COUTEN: Comparator Output Enable bit(1, 2)
				;1 = Output of comparator is NOT placed on the COUT pin
				;0 = Output of comparator is placed in the COUT pin
				;bit 5 POL: Comparator Output Polarity bit(2)
				;1 = Output of comparator not inverted
				;0 = Output of comparator inverted
				;bit 4 CMPT0CS: Comparator TMR0 Clock Source bit(2)
				;1 = TMR0 clock source selected by T0CS control bit
				;0 = Comparator output used as TMR0 clock source
				;bit 3 CMPON: Comparator Enable bit
				;1 = Comparator is on
				;0 = Comparator is off
				;bit 2 CNREF: Comparator Negative Reference Select bit(2)
				;1 = CIN- pin(3)
				;0 = Internal voltage reference
				;bit 1 CPREF: Comparator Positive Reference Select bit(2)
				;1 = CIN+ pin(3)
				;0 = CIN- pin(3)
				;bit 0 CWU: Comparator Wake-up on Change Enable bit(2)
				;1 = Wake-up on comparator change is disabled
				;0 = Wake-up on comparator change is enabled.
				;Note 1: Overrides T0CS bit for TRIS control of GP2.
		


		movlw	((1<< P100_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; discharge C
		movlw	.4
		movwf	AL		; 15 us
		decfsz	AL,F
		 goto	$-1		; 
		clrwdt
		movlw	iodir		;  GP,x is input
		TRIS 	TRISGPIO	; charge C
		bsf	CMCON0,3	; comparator on
		clrf	AL		; 1 us
loop100		btfsc	CMCON0,7
		 goto	exitp100
		eq	AH,.6		;20us
		decfsz  AH,F
		 goto	$-1
		incfsz	AL,F
		 goto	loop100		;timeout 1000us	
		decf	AL,F	
exitp100	bcf	CMCON0,3	;comparator off

;		mov	AL,PeriodReg	;test
;		goto	tstvoltage	;test
;

		skpgel	AL,0x50
		  goto prepslp		; CDS too low, too bright
		movwf PeriodReg		; 0-176
		incl	PeriodReg,0x20	; 32-208
;		eq	AL,.10 	;test
;		decfsz	AL,F	;test
;		 goto	$-1	;test
;		Goto testcds	;test
;
#define	C10N_Port	1				;

tstvoltage	bcf	GPIO,C10N_Port
		if C10N_Port
		 movlw	GP1_Porton     ; configure comparator input
		else
		movlw	GP0_Porton
		 endif
		movwf	CMCON0	
		movlw	((1<< C10N_Port) ^ 0xFF) & iodir
		TRIS 	TRISGPIO	; discharge C
		eq	AL,.1		; 5 us delay
		decfsz	AL,F
		 goto	$-1		; 
		movlw	iodir		;  GP is input
		TRIS 	TRISGPIO	; charge C
		bsf	CMCON0,3	; comparator on
		clrf	AL
loop		btfsc	CMCON0,7
		 goto	exitloop
		incfsz	AL,F
		 goto	loop		;timeout 1000us	
		decf	AL,F	
		
exitloop	bcf	CMCON0,3	;comparator off
			
		eq	DutyCase,.5
		skpgel	AL,0x58		; .88		4.25V
   		 goto endvoltage
		decf	DutyCase,F
		skpgel	AL,0x58+0x16	;.88+.20 =108	3.7V
		 goto endvoltage
		decf 	DutyCase,F
		skpgel	AL,0x58+0x26	;.88.+.36= 124  3.35V
		 goto	endvoltage		
		decf	DutyCase,F
		skpgel	AL,0x58+0x30	;.88+.48 = 136  3.1V
 		 goto	endvoltage
		decf	DutyCase,F	
		skplel	AL,0x58+0x38	;.88+.56 = .144 3.0V
		decf	DutyCase,F	; warning blinker

endvoltage	
;;******************************************TEST TEST TEST
;		bsf	send_first		
;		skplesl	AL,.125
;		 goto	send125
;		skplesl	AL,.25
;		 goto	send25
;		skplesl	AL,.5
;		 goto	send5
;		eq	AL,.06
;		call	pause03
;		decfsz	AL,F
;		 goto	$-2
;		btfss	send_first
;		 goto	endsend
;		bcf	send_first
;		mov	PeriodReg,AL
;		goto	endvoltage+1
;endsend		eq	AL,.20
;		call pause03
;		decfsz	AL,F
;		 goto	$-2
;		goto	testcds		
;send5		decl	AL,.5	
;		eeq	BL,.4000
;		goto	send25cycles
;
;send25		decl	AL,.25	
;		eeq	BL,.20000
;		goto	send25cycles
;			
;		
;send125		decl	AL,.125	
;		eeq	BL,.40000
;		goto	send25cycles
;		
;
;
;send25cycles	eq	AH,.8
;		decfsz	AH,F
;		 goto	$-1
;		bsf	NFET_Gate_Port
;		bcf	NFET_Gate_Port
;		decfsz	BL,F
;		 goto	send25cycles
;		decfsz	BH,F
;		 goto	send25cycles
;		call	pause03
;		goto	endvoltage+1
;
;;;********************************TEST TEST TEST
;	eq	AL,.10 ;test
;		decfsz	AL,F;test
;		 goto	$-1;test
;		Goto testcds;test


		GOTO MAIN
	end
