; THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
; WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
; TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
; PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
; IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
; CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;
;==============================================================================
;File name: 10HSI_aka_morse.asm
;
;This program demonstrates how Human Serial Interface also known as 
;Morse Code with a buzzer and a pushbutton can be achieved. 
;
;
;
;==============================================================================
;author:	Gerhard Michael Drygas
;company:	Michaels Prototype
;date:		01-11-2006
;MPLAB version:	7.41
;
;==============================================================================        

	list      p=10F206	; list directive to define processor
	#include <p10f206.inc>	; processor specific variable definitions

	__CONFIG  _CP_OFF & _WDT_ON & _MCLRE_OFF 

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.
;list p=16F627
;16p627	__CONFIG  _BODEN_ON & _CP_OFF & _DATA_CP_OFF & _PWRTE_ON & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT


;*** register bank limits
#define ram0_start 	0x10
#define ram0_end 	0x1f			; 7f 16P627
#define ram0_length 	ram0_end - ram0_start + 1

;==========================================================================
;       Variable Definition
;==========================================================================
	cblock ram0_start

	AX,TimerTick, msTick, TimerFlag 	;Used in delay routine
	
	;Target,
	TextLetter
	NextEntry, PauseLen, BeepLen 
	IndxI, TempIndexI, TempOut
					;MORSE CODE VAR
	OutputString:4
	endc


#define		wrd_pause	.60	; 
#define		dot_time	.12	; 
#define		dash_time	.38	; 
#define		dash_thresh	.102	; 


#define 	repeat_morse	TimerFlag,0
#define 	beep_on		TimerFlag,1
#define 	beep_event	TimerFlag,2
#define 	buttondown	TimerFlag,3
#define 	pause_pending	TimerFlag,4
#define 	fin_Target	TimerFlag,5
#define 	msec_flag 	TimerFlag,6
#define 	sec_flag 	TimerFlag,7


#define 	Button_Port 	GPIO,3  ;PORTA,3	
#define 	Power_On_Port 	GPIO,3  ;PORTA,3	

#define		Beeper_Port	GPIO,2	;PORTB,7
#define initport	b'00000000'	; all io initiate as LOW
#define iodir		b'11111011'	; configure Beeper_Port as output 
					;		     GPIO0,1,3 are input


;***** RESET VECTOR AND START OF CODE
	ORG     0xFF            ; processor reset vector
	ORG     0x000           ; start coding 
	btfsc	STATUS,NOT_PD	; Test for the first power up
	 goto	PWRUP
	call	undoreset
	btfsc	STATUS,GPWUF	; a Wakeup on PinChange occurred
	 goto	afterpin

	btfss	STATUS,NOT_TO	; a WDT-Timeout occurred
	 goto	afterwdt
	; goto error
#define 	TRISGPIO 	6

undoreset			
 
	movlw	iodir		; configure IO
	TRIS 	TRISGPIO
	
	movlw	B'11000100'	; PIN wakeup disable, weak pullup disabled
				; Timer0 internal clock, clock 32:1 , WDT 1:1 ,
;				bit 3 PSA: Prescaler Assignment bit
;				1 = Prescaler assigned to the WDT
;				0 = Prescaler assigned to Timer0
;				bit 2-0 PS<2:0>: Prescaler Rate Select bits
;				Bit Value	Timer0 Rate 	WDT Rate
;				000		1 : 2		1 : 1
;				001		1 : 4		1:2
;				010		1:8		1:4
;				011		1:16		1:8
;				100		1:32		1:16
;				101		1:64		1:32
;				110		1:128		1:64
;				111		1:256		1:128
				
	OPTION	
	retlw	0


PWRUP	andlw	b'11111110'	;  GPIO2 is I/O
	;iorlw	b'00000001'	;  FOSC4:INTOSC/4 Output to GPIO2 Enable 
	movwf   OSCCAL          ; update register with factory cal value 

	movlw	initport	; set all Outputs Voltage
	movwf	GPIO

	call	undoreset
		
	IFDEF __10F204	
	movlw	b'11110011'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F204
	endif	
				;bit 7 bit 0
				;bit 7 CMPOUT: Comparator Output bit
				;1 = VIN+ > VIN-
				;0 = VIN+ < VINbit
				;6 COUTEN: Comparator Output Enable bit(1, 2)
				;1 = Output of comparator is NOT placed on the COUT pin
				;0 = Output of comparator is placed in the COUT pin
				;bit 5 POL: Comparator Output Polarity bit(2)
				;1 = Output of comparator not inverted
				;0 = Output of comparator inverted
				;bit 4 CMPT0CS: Comparator TMR0 Clock Source bit(2)
				;1 = TMR0 clock source selected by T0CS control bit
				;0 = Comparator output used as TMR0 clock source
				;bit 3 CMPON: Comparator Enable bit
				;1 = Comparator is on
				;0 = Comparator is off
				;bit 2 CNREF: Comparator Negative Reference Select bit(2)
				;1 = CIN- pin(3)
				;0 = Internal voltage reference
				;bit 1 CPREF: Comparator Positive Reference Select bit(2)
				;1 = CIN+ pin(3)
				;0 = CIN- pin(3)
				;bit 0 CWU: Comparator Wake-up on Change Enable bit(2)
				;1 = Wake-up on comparator change is disabled
				;0 = Wake-up on comparator change is enabled.
				;Note 1: Overrides T0CS bit for TRIS control of GP2.
	IFDEF __10F206	
	movlw	b'11110011'     ; configure comparator inputs as digital I/O
	movwf	CMCON0		; for PIC10F206
	endif	
	goto 		RESET		;GOTO RESET routine when boot.

;******************************************************************************
;MACRO
;******************************************************************************
;******************************************************************************
;Subroutines & Functions
;******************************************************************************

;******************************************************************************
;tables to call
;******************************************************************************
zeroAF		addwf 	PCL,F
		dt 	"0123456789ABCDEF",0	;textstring to output, 0 for endstring

if_greater 	macro REG comp_value
		movlw	0xFF-comp_value
		addwf	REG,w
		skpnC		
		endm		;carry set if > 

text macro	
		clrf 	AX
msg3		movlw	OutputString		; run time defined string
		addwf	TextLetter,w
		movwf	FSR
;		if_greater FSR ram0_end 
;		 goto $+4		; *
		movfw	INDF		; !
		movwf	AX		; !
;		goto	$+2		; ! *
;	       clrf	AX		; * !
		endm			;   *

;******************************************************************************
;MORSE CODE
;******************************************************************************

GETCODE	       			;w:= morsecode[w] for w in [0..9,A..Z,".",",","?"]
		movlw "9"+1
		subwf 	AX,W
		skpnc
		 GOTO larger9
numeric	       	movlw "0"- .26		;PCLoffset in TemP
		subwf AX,W
		goto	aln_bin
		
larger9        movlw "A"
		subwf AX,w
	
	
aln_bin	addwf PCL,F		; coding : 0= dot 1=dash  5 dot/dash + 3bytes length
alpha	retlw b'01000001'  ; A .-
	retlw b'10000011'  ; B -...
	retlw b'10100011'  ; C -.-.
	retlw b'10000010'  ; D -..
	retlw b'00000000'  ; E .
	retlw b'00100011'  ; F ..-.
	retlw b'11000010'  ; G --.
	retlw b'00000011'  ; H ....
	retlw b'00000001'  ; I ..
	retlw b'01110011'  ; J .---
	retlw b'10100010'  ; K -.-
	retlw b'01000011'  ; L .-..
	retlw b'11000001'  ; M --
	retlw b'10000001'  ; N -.
	retlw b'11100010'  ; O ---
	retlw b'01100011'  ; P .--.
	retlw b'11010011'  ; Q --.-
	retlw b'01000010'  ; R .-.
	retlw b'00000010'  ; S ...
	retlw b'10000000'  ; T -
	retlw b'00100010'  ; U ..-
	retlw b'00010011'  ; V ...-
	retlw b'01100010'  ; W .--
	retlw b'10010011'  ; X -..-
	retlw b'10110011'  ; Y -.--
	retlw b'11000011'  ; Z --..

numset	retlw b'11111100'  ; 0 -----
	retlw b'01111100'  ; 1 .----
	retlw b'00111100'  ; 2 ..---
	retlw b'00011100'  ; 3 ...--
	retlw b'00001100'  ; 4 ....-
	retlw b'00000100'  ; 5 .....
	retlw b'10000100'  ; 6 -....
	retlw b'11000100'  ; 7 --...
	retlw b'11100100'  ; 8 ---..
	retlw b'11110100'  ; 9 ----.


;**********************************************************************
#define 	startsending 	0x01	; 
	
MORSE_OUTPUT	movf	NextEntry,F
		skpNZ
		 RETLW 0
		bsf	beep_event
		movfw	NextEntry

m_o		addwf	PCL,F
		GOTO	nomorebeep
		GOTO	start_sending		;entry = 1
		GOTO	nextlet			;2
		GOTO	here			;3
		GOTO	morbits			;4
		GOTO	nextchar		; entry=5

nomorebeep 	bcf 	beep_event
		
		clrf	NextEntry
		RETLW 0

start_sending				; start events	
		clrf	TextLetter			; next_ entry = nextlet

nextlet		text
		movlw	0xFF			; zero
		andwf	AX,W
		skpNZ
		 GOTO 	loopend			; RETLW 0 no event; next entry = RETLW 0
		
numlet		
		call	GETCODE				;morse code in W
		movwf	TempOut
		andlw	b'00000111'
		movwf	TempIndexI			;  
		clrf	IndxI			; IndxI:=0  =7th bit
noshift		movlw	0x03	
		movwf	NextEntry	; next entry = here
		btfsC	TempOut,7
		 GOTO	dash		; 
dot		movlw	dot_time	; RETLW 0 event = dot/dash +pause
		movwf	PauseLen
		movwf	BeepLen
		RETLW 0			
dash		movlw	dot_time	; RETLW 0 event = dot/dash +pause
		movwf	PauseLen
		movlw	dash_time
		movwf	BeepLen
		RETLW 0
	
here		movfw	TempIndexI			; 
		subwf	IndxI,w
		skpNZ			; IndxI=bits to do?
		 GOTO	nextchar
		movlw	0xFF-.4
		addwf	IndxI,w		; IndxI=4?
		skpz	
		 GOTO	morbits		; produce nextevent
	
		movlw	0x05
		movwf	NextEntry	; next entry = nextchar
		movfw	TempIndexI
	
morbits		incf	IndxI,F
		rlf	TempOut,F	; make next bit visible
		GOTO 	noshift
	
nextchar	movlw	0x02	
		movwf	NextEntry
		incf	TextLetter,F
		movlw	dot_time	; RETURN event = dot pause
		movwf	PauseLen
		clrf    BeepLen
		RETLW 0  		; NextEntry = nextlet

loopend 	movlw	wrd_pause
		movwf	PauseLen
		clrf	BeepLen	; NextEntry = 0 nomore
		clrf	NextEntry
		movlw	.5
		movwf	TempOut
		RETLW 0
;**********************************************************************

RESET		clrf	NextEntry
		clrf	PauseLen
		clrf	BeepLen
		clrf	TimerFlag	; reset all flags
		movlw	"S"
		movwf	OutputString
		movlw	"9"
		movwf	OutputString+1
		clrf	OutputString +2
		clrf	TempOut
		incf	TempOut,F	; No Delay
		movlw	.60		; 60 * 18ms = 1sec
		movwf	msTick
			
;		clrf	Target
;		decf	Target,F
;		movlw	.07
;		clrwdt			; show reset
;		decfsz	AX,F
;		 goto	$-2
;		xorwf	GPIO,F
;		decfsz	PauseLen
;		 goto	$-5
		sleep
	
		RETLW 0
;******************************************************************************
;MAIN PROGRAM
;******************************************************************************


		

	
		

;**********************************************************************
MSEC_EVENT	movlw	.125		; 125* 32us = 4msec
		addwf	TimerTick,F
;		decfsz	msTick,F
;		 RETLW 0
		
		btfss	beep_event		; if not beep_event
		 goto	nobeep
		movf	BeepLen,F
		skpnz
		 goto	bedone
		btfss	beep_on
		 bsf	Beeper_Port
		bsf	beep_on
		decfsz	BeepLen,F
		 goto	nobeep
		bcf	Beeper_Port
		bcf	beep_on
bedone		movf	PauseLen,F
		skpnz
		 goto	clrbeep	
		decfsz	PauseLen,F
		 goto	nobeep
clrbeep		bcf	beep_event


nobeep		decfsz	msTick,F
		 RETLW	0
		movlw	.60		; 60 * 18ms = 1sec
		movwf	msTick
		bsf 	sec_flag
		RETLW	0


;**********************************************************************
onesecjob			
		bcf	sec_flag
		btfsc	beep_event
		 RETLW 0
		decfsz	TempOut,F
		 RETLW 0



		bcf	GPIO,0
		movlw	iodir
		andlw	b'11111110'	; GPIO0 is output
		TRIS 	TRISGPIO	; discharge C
		movlw	.8
		decfsz	TempOut
		goto	$-1		; 8 us
		clrwdt
		movlw	iodir
		iorlw	b'11111011'	;  GPIO0 is input
		TRIS 	TRISGPIO	; charge C
		
	movlw	b'11111011'     ; configure comparator input
	movwf	CMCON0		; 
	
				;bit 7 bit 0
				;bit 7 CMPOUT: Comparator Output bit
				;1 = VIN+ > VIN-
				;0 = VIN+ < VINbit
				;6 COUTEN: Comparator Output Enable bit(1, 2)
				;1 = Output of comparator is NOT placed on the COUT pin
				;0 = Output of comparator is placed in the COUT pin
				;bit 5 POL: Comparator Output Polarity bit(2)
				;1 = Output of comparator not inverted
				;0 = Output of comparator inverted
				;bit 4 CMPT0CS: Comparator TMR0 Clock Source bit(2)
				;1 = TMR0 clock source selected by T0CS control bit
				;0 = Comparator output used as TMR0 clock source
				;bit 3 CMPON: Comparator Enable bit
				;1 = Comparator is on
				;0 = Comparator is off
				;bit 2 CNREF: Comparator Negative Reference Select bit(2)
				;1 = CIN- pin(3)
				;0 = Internal voltage reference
				;bit 1 CPREF: Comparator Positive Reference Select bit(2)
				;1 = CIN+ pin(3)
				;0 = CIN- pin(3)
				;bit 0 CWU: Comparator Wake-up on Change Enable bit(2)
				;1 = Wake-up on comparator change is disabled
				;0 = Wake-up on comparator change is enabled.
				;Note 1: Overrides T0CS bit for TRIS control of GP2.
	
loop		btfsc	CMCON0,7
		 goto	exitloop
		nop			;20us
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		incfsz	TempOut,F
		 goto	loop		;timeout 1000us	
		decf	TempOut,F	
;results on 1nF
;100k		0x16
;120k		0x2C
;150k		0x37
;220k           0x53
;470k		0xAC
;560k		0xCF
;680k		0xFD
;on 1nF 220k
;3V		0x74
;3.11		0x6E
;3.24		0x6A
;3.35		0x66
;3.4
;3.97		0x54
;4.14		0x51
;4.36		0x4C
;4.5		
;4,63		0x47
;5.15		0x35
;5.4		0x2C
exitloop	movfw	TempOut
		movwf	AX
		movlw	b'11110011'     ; configure comparator off
		movwf	CMCON0		; for PIC10F204/6
	

		swapf	AX,F
		movlw	0x0F
		andwf	AX,W
		call	zeroAF
		movwf	OutputString
		movfw	TempOut
		movwf	AX
		movlw	0x0F
		andwf	AX,W
		call	zeroAF
		movwf	OutputString+1
		clrf	OutputString+2
		movlw	.1
		movwf	NextEntry
		RETLW	0

normal_loop	
;		movfw	TimerTick	
;		subwf	TMR0,w		;w=TimerTick-timr0
;		andlw	0C0H		;slack 63*32 cycles
;		SKPZ
;		 goto	normal_loop
	
		sleep			;18ms

afterwdt	btfss	beep_event
		 call	MORSE_OUTPUT
		call	MSEC_EVENT	
		BTFSC	sec_flag
		 call	onesecjob	;occasional jobs to be done
		GOTO	normal_loop


afterpin	 
		decfsz	AX,F
		  goto $-1
		nop
		nop
		decfsz	AX,F
		 goto $-3
		btfsc Power_On_Port	; Power still on?
		 goto	normal_loop	; resume after Power lost and regained
		goto pwrlost
	



pwrlost 	
		movlw	B'01001000'	; PIN wakeup en-able, weak pullup disabled
					; Timer0 internal clock, clock 1:1 , WDT 1:1 
		OPTION
		
		sleep				
	
		END
